/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-10-28 21:07:46 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `itwp_ahm_asset_links` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `asset_ID` bigint(20) NOT NULL,
  `asset_key` varchar(255) NOT NULL,
  `access` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `asset_key` (`asset_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_assets` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `owner` int(11) NOT NULL,
  `activities` text NOT NULL,
  `comments` text NOT NULL,
  `access` text NOT NULL,
  `metadata` text NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_download_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `oid` varchar(100) NOT NULL,
  `year` int(4) NOT NULL,
  `month` int(2) NOT NULL,
  `day` int(2) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `version` varchar(255) NOT NULL,
  `agent` text,
  `filename` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `pid` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `custom_data` text NOT NULL,
  `request_status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_sessions` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceID` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `lastAccess` int(11) NOT NULL,
  `expire` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_social_conns` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `name` varchar(200) NOT NULL,
  `user_data` text NOT NULL,
  `access_token` text NOT NULL,
  `refresh_token` text NOT NULL,
  `source` varchar(200) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `processed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_ahm_user_download_counts` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) NOT NULL,
  `package_id` int(11) NOT NULL,
  `download_count` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_blog_versions` (
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `db_version` varchar(20) NOT NULL DEFAULT '',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`blog_id`),
  KEY `db_version` (`db_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_blogs` (
  `blog_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `domain` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(100) NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `public` tinyint(2) NOT NULL DEFAULT '1',
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `mature` tinyint(2) NOT NULL DEFAULT '0',
  `spam` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` tinyint(2) NOT NULL DEFAULT '0',
  `lang_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`blog_id`),
  KEY `domain` (`domain`(50),`path`(5)),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_bookings` (
  `booking_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `booking_user_id` int(11) NOT NULL,
  `booking_service_id` int(11) NOT NULL,
  `booking_staff_id` int(11) NOT NULL,
  `booking_cart_id` int(11) NOT NULL DEFAULT '0',
  `booking_template_id` int(1) NOT NULL DEFAULT '0',
  `booking_date` date NOT NULL,
  `booking_time_from` datetime NOT NULL,
  `booking_time_to` datetime NOT NULL,
  `booking_time_offset` int(11) NOT NULL DEFAULT '0',
  `booking_status` int(1) NOT NULL DEFAULT '0',
  `booking_qty` int(11) NOT NULL DEFAULT '1',
  `booking_qty_2` int(11) NOT NULL DEFAULT '0',
  `booking_amount` decimal(11,2) NOT NULL,
  `booking_key` varchar(250) NOT NULL,
  PRIMARY KEY (`booking_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_bookings_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `meta_booking_id` int(11) NOT NULL,
  `meta_booking_name` varchar(300) NOT NULL,
  `meta_booking_value` longtext,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_carts` (
  `cart_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cart_key` varchar(250) NOT NULL,
  `cart_date` date NOT NULL,
  `cart_amount` decimal(11,2) NOT NULL,
  `cart_status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cart_id`),
  UNIQUE KEY `cart_key` (`cart_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_categories` (
  `cate_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cate_template_id` int(11) NOT NULL DEFAULT '0',
  `cate_name` varchar(300) NOT NULL,
  `cate_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cate_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_filter_staff` (
  `fstaff_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fstaff_staff_id` int(11) NOT NULL,
  `fstaff_location_id` int(11) NOT NULL,
  PRIMARY KEY (`fstaff_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(300) NOT NULL,
  `filter_email` varchar(300) NOT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_orders` (
  `order_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_booking_id` int(11) NOT NULL,
  `order_method_name` varchar(60) NOT NULL,
  `order_key` varchar(250) NOT NULL,
  `order_txt_id` varchar(60) NOT NULL,
  `order_status` varchar(60) NOT NULL,
  `order_amount` decimal(11,2) NOT NULL,
  `order_qty` int(11) NOT NULL DEFAULT '1',
  `order_date` date NOT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_service_rates` (
  `rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `rate_service_id` int(11) NOT NULL,
  `rate_staff_id` int(11) NOT NULL,
  `rate_price` decimal(11,2) NOT NULL,
  `rate_capacity` int(11) NOT NULL,
  PRIMARY KEY (`rate_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_service_variable_pricing` (
  `rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `rate_service_id` int(11) NOT NULL,
  `rate_price` decimal(11,2) NOT NULL,
  `rate_person` int(11) NOT NULL,
  PRIMARY KEY (`rate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_services` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_title` varchar(300) NOT NULL,
  `service_color` varchar(10) DEFAULT NULL,
  `service_font_color` varchar(10) DEFAULT NULL,
  `service_duration` int(11) NOT NULL,
  `service_padding_before` int(11) NOT NULL DEFAULT '0',
  `service_padding_after` int(11) NOT NULL DEFAULT '0',
  `service_capacity` int(11) NOT NULL DEFAULT '1',
  `service_allow_multiple` int(1) DEFAULT NULL,
  `service_pricing_calculation_type` int(1) DEFAULT '1',
  `service_category_id` int(11) NOT NULL,
  `service_icon` varchar(50) NOT NULL,
  `service_price` decimal(11,2) NOT NULL,
  `service_price_2` decimal(11,2) DEFAULT '0.00',
  `service_type` int(1) NOT NULL DEFAULT '0',
  `service_private` int(1) NOT NULL DEFAULT '0',
  `service_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_staff_availability` (
  `avail_id` int(11) NOT NULL AUTO_INCREMENT,
  `avail_staff_id` int(11) NOT NULL,
  `avail_day` int(11) NOT NULL,
  `avail_from` time NOT NULL,
  `avail_to` time NOT NULL,
  PRIMARY KEY (`avail_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_bup_staff_availability_breaks` (
  `break_id` int(11) NOT NULL AUTO_INCREMENT,
  `break_staff_id` int(11) NOT NULL,
  `break_staff_day` int(11) NOT NULL,
  `break_time_from` time NOT NULL,
  `break_time_to` time NOT NULL,
  PRIMARY KEY (`break_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cf_form_entries` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL,
  `datestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `user_id` (`user_id`),
  KEY `date_time` (`datestamp`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3966 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_form_entry_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `process_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_form_entry_values` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(11) NOT NULL,
  `field_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`entry_id`),
  KEY `field_id` (`field_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=41298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=515 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_pro_messages` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cfp_id` bigint(20) unsigned DEFAULT NULL,
  `entry_id` bigint(20) unsigned DEFAULT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_queue_failures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text COLLATE utf8mb4_unicode_520_ci,
  `failed_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_cf_queue_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attempts` tinyint(3) NOT NULL DEFAULT '0',
  `reserved_at` datetime DEFAULT NULL,
  `available_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_cf_tracking` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `process_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cf_tracking_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `event_id` (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cjtoolbox_authors` (
  `name` varchar(80) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `attributes` int(4) NOT NULL DEFAULT '0',
  `guid` varchar(16) DEFAULT NULL,
  `id` int(10) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid` (`guid`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_backups` (
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'blocks',
  `owner` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_block_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blockId` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('css','javascript','php','html') DEFAULT NULL,
  `description` varchar(400) DEFAULT NULL,
  `code` text,
  `order` smallint(6) DEFAULT '0',
  `tag` text,
  PRIMARY KEY (`id`,`blockId`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_block_pins` (
  `blockId` int(11) NOT NULL,
  `pin` varchar(20) NOT NULL,
  `value` int(11) NOT NULL,
  `attributes` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`blockId`,`pin`,`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_block_templates` (
  `blockId` int(11) NOT NULL,
  `templateId` int(11) NOT NULL,
  PRIMARY KEY (`blockId`,`templateId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_blocks` (
  `name` varchar(50) DEFAULT NULL,
  `description` varchar(300) DEFAULT NULL,
  `owner` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `lastModified` datetime NOT NULL,
  `pinPoint` int(4) NOT NULL DEFAULT '0',
  `state` enum('active','inactive') DEFAULT 'inactive',
  `location` varchar(70) NOT NULL DEFAULT 'header',
  `links` text,
  `expressions` text,
  `type` enum('block','revision','metabox') DEFAULT 'block',
  `backupId` int(11) DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `flag` int(4) NOT NULL DEFAULT '0',
  `masterFile` int(4) NOT NULL DEFAULT '1',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`backupId`),
  KEY `pinPoint` (`pinPoint`,`state`,`location`,`type`,`parent`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_form_group_parameters` (
  `groupId` int(11) NOT NULL AUTO_INCREMENT,
  `parameterId` int(11) NOT NULL COMMENT 'block to be associated with the form',
  `renderer` varchar(30) DEFAULT NULL,
  `description` text,
  `helpText` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`parameterId`),
  KEY `Index 2` (`groupId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_form_group_xfields` (
  `groupId` int(11) NOT NULL,
  `text` text,
  UNIQUE KEY `groupId` (`groupId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_form_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL COMMENT 'block to be associated with the form',
  `name` varchar(100) NOT NULL COMMENT 'group name/title',
  `description` text COMMENT 'Parameters group description',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index 3` (`formId`,`name`),
  KEY `formId` (`formId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_forms` (
  `blockId` int(11) NOT NULL COMMENT 'block to be associated with the form',
  `name` varchar(100) NOT NULL COMMENT 'Form name/title',
  `groupType` varchar(20) NOT NULL COMMENT 'parameters gooup type (tab, accordion, etc...)',
  PRIMARY KEY (`blockId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_package_objects` (
  `packageId` int(10) unsigned NOT NULL,
  `objectId` int(10) unsigned NOT NULL,
  `objectType` enum('block','template') NOT NULL,
  `relType` enum('add','link') NOT NULL DEFAULT 'add',
  PRIMARY KEY (`packageId`,`objectId`,`objectType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_packages` (
  `name` varchar(100) NOT NULL,
  `author` varchar(150) NOT NULL,
  `webSite` varchar(300) NOT NULL,
  `description` text NOT NULL,
  `license` text NOT NULL,
  `readme` text NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_parameter_typedef` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameterId` int(11) NOT NULL,
  `text` text NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parameterId` (`parameterId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_parameter_typeparams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameterId` int(11) NOT NULL,
  `name` text NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parameterId` (`parameterId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_parameters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'paramter unique identifier',
  `blockId` int(11) unsigned NOT NULL,
  `parent` int(11) unsigned DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `type` varchar(20) NOT NULL,
  `defaultValue` text,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `contentParam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`parent`,`blockId`),
  KEY `parent` (`parent`),
  KEY `blockId` (`blockId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_template_revisions` (
  `templateId` int(11) NOT NULL,
  `revisionNo` int(11) NOT NULL DEFAULT '0',
  `version` varchar(15) DEFAULT NULL,
  `changeLog` varchar(600) DEFAULT NULL,
  `state` enum('release','beta','release-candidate','alpha','revision') NOT NULL,
  `attributes` int(4) unsigned NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `file` varchar(400) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `templateid-revisionNo` (`revisionNo`,`templateId`)
) ENGINE=MyISAM AUTO_INCREMENT=195 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_cjtoolbox_templates` (
  `name` varchar(80) NOT NULL,
  `queueName` varchar(80) NOT NULL,
  `description` text,
  `keywords` varchar(300) DEFAULT NULL,
  `license` text,
  `type` enum('css','javascript','php','html') NOT NULL,
  `email` varchar(90) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `creationDate` datetime NOT NULL,
  `ownerId` int(11) NOT NULL,
  `authorId` int(11) NOT NULL,
  `state` enum('published','draft','trash') NOT NULL DEFAULT 'published',
  `attributes` int(4) NOT NULL DEFAULT '0',
  `guid` varchar(16) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`type`),
  UNIQUE KEY `guid` (`guid`),
  KEY `keywords` (`keywords`),
  KEY `owner` (`ownerId`),
  KEY `author` (`authorId`),
  KEY `type` (`type`),
  KEY `attributes` (`attributes`)
) ENGINE=MyISAM AUTO_INCREMENT=195 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cp_calculated_fields_form_discount_codes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(9) NOT NULL DEFAULT '1',
  `code` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `discount` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `availability` int(10) unsigned NOT NULL DEFAULT '0',
  `used` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cp_calculated_fields_form_posts` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `formid` int(11) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ipaddr` varchar(41) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `notifyto` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `paypal_post` mediumtext COLLATE utf8mb4_unicode_ci,
  `paid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cp_calculated_fields_form_revision` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `formid` mediumint(9) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `revision` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cp_calculated_fields_form_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `form_structure` mediumtext COLLATE utf8mb4_unicode_ci,
  `fp_from_email` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fp_destination_emails` text COLLATE utf8mb4_unicode_ci,
  `fp_subject` text COLLATE utf8mb4_unicode_ci,
  `fp_inc_additional_info` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fp_return_page` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fp_message` mediumtext COLLATE utf8mb4_unicode_ci,
  `fp_emailformat` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cu_enable_copy_to_user` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cu_user_email_field` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cu_subject` text COLLATE utf8mb4_unicode_ci,
  `cu_message` mediumtext COLLATE utf8mb4_unicode_ci,
  `cu_emailformat` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fp_emailfrommethod` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enable_paypal_option_yes` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enable_paypal_option_no` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_use_validation` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_is_required` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_is_email` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_datemmddyyyy` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_dateddmmyyyy` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_number` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_digits` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_max` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_min` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_submitbtn` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_previousbtn` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_text_nextbtn` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vs_all_texts` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_paypal` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enable_submit` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_notiemails` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `request_cost` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_mode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_recurrent` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_recurrent_setup` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_recurrent_setup_days` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_identify_prices` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_zero_payment` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_base_amount` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cv_enable_captcha` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_width` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_height` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_chars` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_font` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_min_font_size` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_max_font_size` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_noise` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_noise_length` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_background` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_border` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cv_text_enter_valid_captcha` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cache` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `paypal_address` tinyint(4) NOT NULL DEFAULT '1',
  `paypal_recurrent_times` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `paypal_recurrent_times_field` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_cpappbk_forms` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `form_structure` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `calendar_language` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_format` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `product_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `pay_later_label` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `defaultstatus` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `defaultpaidstatus` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_from_email` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_destination_emails` text COLLATE utf8mb4_unicode_520_ci,
  `fp_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_inc_additional_info` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_return_page` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_message` text COLLATE utf8mb4_unicode_520_ci,
  `fp_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_emailtomethod` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_destination_emails_field` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_enable_copy_to_user` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_user_email_field` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_message` text COLLATE utf8mb4_unicode_520_ci,
  `cu_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_emailfrommethod` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_maxapp` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_is_required` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_is_email` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_datemmddyyyy` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_dateddmmyyyy` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_number` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_digits` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_max` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_min` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_pageof` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_submitbtn` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_previousbtn` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_nextbtn` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cp_user_access` text COLLATE utf8mb4_unicode_520_ci,
  `cp_user_access_settings` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `display_emails_endtime` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_enable` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_days` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_hour` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_emails` text COLLATE utf8mb4_unicode_520_ci,
  `rep_subject` text COLLATE utf8mb4_unicode_520_ci,
  `rep_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_message` text COLLATE utf8mb4_unicode_520_ci,
  `cv_enable_captcha` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_width` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_height` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_chars` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_font` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_min_font_size` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_max_font_size` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_noise` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_noise_length` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_background` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_border` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_text_enter_valid_captcha` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_cpappbk_messages` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `formid` int(11) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ipaddr` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `notifyto` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `posted_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `whoadded` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_ddownload_statistics` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(10) NOT NULL DEFAULT 'success',
  `date` datetime NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_ip` varbinary(16) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

CREATE TABLE `itwp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_gg_offer_calculator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `value` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_mailpress_mailmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mp_mail_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `mp_mail_id` (`mp_mail_id`,`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_mailpress_mails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('draft','unsent','sending','sent','') NOT NULL DEFAULT 'draft',
  `theme` varchar(255) NOT NULL DEFAULT '',
  `themedir` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(255) NOT NULL DEFAULT '',
  `fromemail` varchar(255) NOT NULL DEFAULT '',
  `fromname` varchar(255) NOT NULL DEFAULT '',
  `toname` varchar(255) NOT NULL DEFAULT '',
  `charset` varchar(255) NOT NULL DEFAULT '',
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `child` bigint(20) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sent` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sent_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `toemail` longtext NOT NULL,
  `plaintext` longtext NOT NULL,
  `html` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_mailpress_stats` (
  `sdate` date NOT NULL DEFAULT '0000-00-00',
  `stype` char(1) NOT NULL DEFAULT '',
  `slib` varchar(45) NOT NULL DEFAULT '',
  `scount` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stype`,`sdate`,`slib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_mailpress_usermeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mp_user_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `mp_user_id` (`mp_user_id`,`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_mailpress_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `status` enum('waiting','active','bounced','unsubscribed') NOT NULL DEFAULT 'waiting',
  `confkey` varchar(100) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_IP` varchar(100) NOT NULL DEFAULT '',
  `created_agent` varchar(255) NOT NULL DEFAULT '',
  `created_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `created_country` varchar(2) NOT NULL DEFAULT 'ZZ',
  `created_US_state` varchar(2) NOT NULL DEFAULT 'ZZ',
  `laststatus` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `laststatus_IP` varchar(100) NOT NULL DEFAULT '',
  `laststatus_agent` varchar(255) NOT NULL DEFAULT '',
  `laststatus_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_ninja_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext NOT NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_ninja_forms_fav_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `row_type` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  `data` longtext NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_ninja_forms_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  `data` longtext NOT NULL,
  `fav_id` int(11) DEFAULT NULL,
  `def_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_ninja_forms_subs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=206772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_participants_database` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `private_id` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` tinytext COLLATE utf8_unicode_ci,
  `last_name` tinytext COLLATE utf8_unicode_ci,
  `address` tinytext COLLATE utf8_unicode_ci,
  `city` tinytext COLLATE utf8_unicode_ci,
  `state` tinytext COLLATE utf8_unicode_ci,
  `country` tinytext COLLATE utf8_unicode_ci,
  `zip` tinytext COLLATE utf8_unicode_ci,
  `phone` tinytext COLLATE utf8_unicode_ci,
  `email` tinytext COLLATE utf8_unicode_ci,
  `mailing_list` text COLLATE utf8_unicode_ci,
  `photo` text COLLATE utf8_unicode_ci,
  `website` text COLLATE utf8_unicode_ci,
  `interests` text COLLATE utf8_unicode_ci,
  `approved` text COLLATE utf8_unicode_ci,
  `date_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_updated` timestamp NULL DEFAULT NULL,
  `last_accessed` timestamp NULL DEFAULT NULL,
  `vipre_key` tinytext COLLATE utf8_unicode_ci,
  `date_installed` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `itwp_participants_database_fields` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `order` int(3) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` tinytext COLLATE utf8_unicode_ci,
  `default` tinytext COLLATE utf8_unicode_ci,
  `group` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_text` text COLLATE utf8_unicode_ci,
  `form_element` tinytext COLLATE utf8_unicode_ci,
  `values` longtext COLLATE utf8_unicode_ci,
  `validation` tinytext COLLATE utf8_unicode_ci,
  `display_column` int(3) DEFAULT '0',
  `admin_column` int(3) DEFAULT '0',
  `sortable` tinyint(1) DEFAULT '0',
  `CSV` tinyint(1) DEFAULT '0',
  `persistent` tinyint(1) DEFAULT '0',
  `signup` tinyint(1) DEFAULT '0',
  `readonly` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`order`),
  KEY `group` (`group`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `itwp_participants_database_groups` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `order` int(3) NOT NULL DEFAULT '0',
  `display` tinyint(1) DEFAULT '1',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `title` tinytext COLLATE utf8_unicode_ci,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `itwp_pmpro_discount_codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `starts` date NOT NULL,
  `expires` date NOT NULL,
  `uses` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `starts` (`starts`),
  KEY `expires` (`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_discount_codes_levels` (
  `code_id` bigint(20) unsigned NOT NULL,
  `level_id` int(11) unsigned NOT NULL,
  `initial_payment` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `billing_amount` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `cycle_number` int(11) NOT NULL DEFAULT '0',
  `cycle_period` enum('Day','Week','Month','Year') DEFAULT 'Month',
  `billing_limit` int(11) NOT NULL COMMENT 'After how many cycles should billing stop?',
  `trial_amount` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `trial_limit` int(11) NOT NULL DEFAULT '0',
  `expiration_number` int(10) unsigned NOT NULL,
  `expiration_period` enum('Hour','Day','Week','Month','Year') NOT NULL,
  PRIMARY KEY (`code_id`,`level_id`),
  KEY `initial_payment` (`initial_payment`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_discount_codes_uses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_membership_levelmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pmpro_membership_level_id` int(11) unsigned NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `pmpro_membership_level_id` (`pmpro_membership_level_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_membership_levels` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` longtext NOT NULL,
  `confirmation` longtext NOT NULL,
  `initial_payment` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `billing_amount` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `cycle_number` int(11) NOT NULL DEFAULT '0',
  `cycle_period` enum('Day','Week','Month','Year') DEFAULT 'Month',
  `billing_limit` int(11) NOT NULL COMMENT 'After how many cycles should billing stop?',
  `trial_amount` decimal(18,8) NOT NULL DEFAULT '0.00000000',
  `trial_limit` int(11) NOT NULL DEFAULT '0',
  `allow_signups` tinyint(4) NOT NULL DEFAULT '1',
  `expiration_number` int(10) unsigned NOT NULL,
  `expiration_period` enum('Hour','Day','Week','Month','Year') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `allow_signups` (`allow_signups`),
  KEY `initial_payment` (`initial_payment`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_membership_ordermeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pmpro_membership_order_id` int(11) unsigned NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `pmpro_membership_order_id` (`pmpro_membership_order_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_membership_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `session_id` varchar(64) NOT NULL DEFAULT '',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `membership_id` int(11) unsigned NOT NULL DEFAULT '0',
  `paypal_token` varchar(64) NOT NULL DEFAULT '',
  `billing_name` varchar(128) NOT NULL DEFAULT '',
  `billing_street` varchar(128) NOT NULL DEFAULT '',
  `billing_city` varchar(128) NOT NULL DEFAULT '',
  `billing_state` varchar(32) NOT NULL DEFAULT '',
  `billing_zip` varchar(16) NOT NULL DEFAULT '',
  `billing_country` varchar(128) NOT NULL,
  `billing_phone` varchar(32) NOT NULL,
  `subtotal` varchar(16) NOT NULL DEFAULT '',
  `tax` varchar(16) NOT NULL DEFAULT '',
  `couponamount` varchar(16) NOT NULL DEFAULT '',
  `checkout_id` bigint(20) NOT NULL DEFAULT '0',
  `certificate_id` int(11) NOT NULL DEFAULT '0',
  `certificateamount` varchar(16) NOT NULL DEFAULT '',
  `total` varchar(16) NOT NULL DEFAULT '',
  `payment_type` varchar(64) NOT NULL DEFAULT '',
  `cardtype` varchar(32) NOT NULL DEFAULT '',
  `accountnumber` varchar(32) NOT NULL DEFAULT '',
  `expirationmonth` char(2) NOT NULL DEFAULT '',
  `expirationyear` varchar(4) NOT NULL DEFAULT '',
  `status` varchar(32) NOT NULL DEFAULT '',
  `gateway` varchar(64) NOT NULL,
  `gateway_environment` varchar(64) NOT NULL,
  `payment_transaction_id` varchar(64) NOT NULL,
  `subscription_transaction_id` varchar(32) NOT NULL,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `affiliate_id` varchar(32) NOT NULL,
  `affiliate_subid` varchar(32) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `session_id` (`session_id`),
  KEY `user_id` (`user_id`),
  KEY `membership_id` (`membership_id`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`),
  KEY `gateway` (`gateway`),
  KEY `gateway_environment` (`gateway_environment`),
  KEY `payment_transaction_id` (`payment_transaction_id`),
  KEY `subscription_transaction_id` (`subscription_transaction_id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `affiliate_subid` (`affiliate_subid`),
  KEY `checkout_id` (`checkout_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_memberships_categories` (
  `membership_id` int(11) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `membership_category` (`membership_id`,`category_id`),
  UNIQUE KEY `category_membership` (`category_id`,`membership_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_memberships_pages` (
  `membership_id` int(11) unsigned NOT NULL,
  `page_id` bigint(20) unsigned NOT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `category_membership` (`page_id`,`membership_id`),
  UNIQUE KEY `membership_page` (`membership_id`,`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pmpro_memberships_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `membership_id` int(11) unsigned NOT NULL,
  `code_id` bigint(20) unsigned NOT NULL,
  `initial_payment` decimal(18,8) NOT NULL,
  `billing_amount` decimal(18,8) NOT NULL,
  `cycle_number` int(11) NOT NULL,
  `cycle_period` enum('Day','Week','Month','Year') NOT NULL DEFAULT 'Month',
  `billing_limit` int(11) NOT NULL,
  `trial_amount` decimal(18,8) NOT NULL,
  `trial_limit` int(11) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `startdate` datetime NOT NULL,
  `enddate` datetime DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `membership_id` (`membership_id`),
  KEY `modified` (`modified`),
  KEY `code_id` (`code_id`),
  KEY `enddate` (`enddate`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_pms_member_subscriptionmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `member_subscription_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `member_subscription_id` (`member_subscription_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_pms_member_subscriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `subscription_plan_id` bigint(20) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `expiration_date` datetime DEFAULT NULL,
  `status` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payment_profile_id` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payment_gateway` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_amount` float NOT NULL,
  `billing_duration` int(10) NOT NULL,
  `billing_duration_unit` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_cycles` int(10) NOT NULL,
  `billing_next_payment` datetime DEFAULT NULL,
  `billing_last_payment` datetime DEFAULT NULL,
  `trial_end` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `subscription_plan_id` (`subscription_plan_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_pms_paymentmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_pms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `subscription_plan_id` bigint(20) NOT NULL,
  `status` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime DEFAULT NULL,
  `amount` float NOT NULL,
  `payment_gateway` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `currency` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `transaction_id` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `profile_id` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `logs` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_address` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `discount_code` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_post_notification_cats` (
  `id` int(11) NOT NULL DEFAULT '0',
  `cat_id` bigint(20) NOT NULL DEFAULT '0',
  KEY `id` (`id`),
  KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_post_notification_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_addr` varchar(255) DEFAULT NULL,
  `gets_mail` int(11) DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_subscribed` datetime DEFAULT NULL,
  `act_code` varchar(32) DEFAULT NULL,
  `subscribe_ip` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`gets_mail`),
  KEY `email_addr` (`email_addr`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_post_notification_posts` (
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `notification_sent` int(11) NOT NULL DEFAULT '-1',
  `date_saved` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`post_id`),
  KEY `notification_sent` (`notification_sent`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2774 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_registration_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '',
  `IP` varchar(30) NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `date_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ID`),
  KEY `IP` (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_signups` (
  `domain` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` longtext NOT NULL,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `activation_key` varchar(50) NOT NULL DEFAULT '',
  `meta` longtext,
  KEY `activation_key` (`activation_key`),
  KEY `domain` (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_site` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`,`path`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_sitemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `site_id` (`site_id`)
) ENGINE=MyISAM AUTO_INCREMENT=774 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1274 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `spam` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `itwp_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=5789 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_wfFileChanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=90580 DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=6544 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9258 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=11249 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `itwp_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6479 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=91066 DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfTrafficRates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wpsbc_calendar_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `calendar_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpsbc_calendars` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `status` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ical_hash` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpsbc_event_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `event_id` (`event_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpsbc_events` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `date_year` smallint(4) NOT NULL,
  `date_month` smallint(2) NOT NULL,
  `date_day` smallint(2) NOT NULL,
  `calendar_id` bigint(10) NOT NULL,
  `legend_item_id` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tooltip` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpsbc_legend_item_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `legend_item_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `legend_item_id` (`legend_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpsbc_legend_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `color` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `color_text` text COLLATE utf8mb4_unicode_520_ci,
  `is_default` tinyint(1) NOT NULL,
  `is_visible` tinyint(1) NOT NULL,
  `calendar_id` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `itwp_wpuf_customfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(30) NOT NULL,
  `type` varchar(20) NOT NULL,
  `values` text NOT NULL,
  `label` varchar(200) NOT NULL,
  `desc` varchar(200) NOT NULL,
  `required` varchar(5) NOT NULL,
  `region` varchar(20) NOT NULL DEFAULT 'top',
  `order` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wpuf_subscription` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `count` int(5) DEFAULT '0',
  `duration` int(5) NOT NULL DEFAULT '0',
  `cost` float NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `itwp_wpuf_transaction` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'pending_payment',
  `cost` varchar(255) DEFAULT '',
  `post_id` bigint(20) DEFAULT NULL,
  `pack_id` bigint(20) DEFAULT NULL,
  `payer_first_name` longtext,
  `payer_last_name` longtext,
  `payer_email` longtext,
  `payment_type` longtext,
  `payer_address` longtext,
  `transaction_id` longtext,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: itwp_ahm_download_stats */
INSERT INTO `itwp_ahm_download_stats` VALUES("1", "1930", "13", "", "2018", "5", "2", "1525284350", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("2", "1987", "13", "", "2018", "5", "2", "1525285132", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("3", "1989", "13", "", "2018", "5", "2", "1525285194", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("4", "1975", "13", "", "2018", "5", "2", "1525285203", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("5", "1989", "13", "", "2018", "5", "2", "1525285214", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("6", "1966", "13", "", "2018", "5", "2", "1525285222", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("7", "1989", "13", "", "2018", "5", "2", "1525285234", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("8", "1989", "13", "", "2018", "5", "2", "1525285364", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("9", "1917", "13", "", "2018", "6", "4", "1528131746", "172.68.34.68", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("10", "1917", "0", "", "2018", "10", "19", "1539984080", "172.68.132.21", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("11", "1912", "0", "", "2018", "10", "19", "1539984092", "172.68.141.230", "", NULL, NULL);
INSERT INTO `itwp_ahm_download_stats` VALUES("12", "1996", "13", "", "2019", "11", "22", "1574444835", "75.151.91.10", "", NULL, NULL);

/* INSERT TABLE DATA: itwp_blog_versions */
INSERT INTO `itwp_blog_versions` VALUES("1", "24448", "2013-08-02 17:19:17");

/* INSERT TABLE DATA: itwp_blogs */
INSERT INTO `itwp_blogs` VALUES("1", "1", "it.milpond.com", "/", "2013-04-24 21:59:34", "2014-09-04 20:48:24", "0", "0", "0", "0", "0", "0");

/* INSERT TABLE DATA: itwp_bup_bookings */
INSERT INTO `itwp_bup_bookings` VALUES("1", "18", "2", "17", "0", "0", "2020-01-06", "2020-01-06 16:45:00", "2020-01-06 20:45:00", "0", "1", "0", "0", "150.00", "fe5823068ff0fa693d68a40c487ce896_1578350566");
INSERT INTO `itwp_bup_bookings` VALUES("2", "18", "2", "17", "0", "0", "2020-01-06", "2020-01-06 16:45:00", "2020-01-06 20:45:00", "0", "1", "0", "0", "150.00", "fe5823068ff0fa693d68a40c487ce896_1578350636");

/* INSERT TABLE DATA: itwp_bup_categories */
INSERT INTO `itwp_bup_categories` VALUES("1", "0", "MG Services", "0");

/* INSERT TABLE DATA: itwp_bup_orders */
INSERT INTO `itwp_bup_orders` VALUES("1", "1", "", "fe5823068ff0fa693d68a40c487ce896_1578350566", "", "pending", "150.00", "0", "2020-01-06");
INSERT INTO `itwp_bup_orders` VALUES("2", "2", "", "fe5823068ff0fa693d68a40c487ce896_1578350636", "", "pending", "150.00", "0", "2020-01-06");

/* INSERT TABLE DATA: itwp_bup_service_rates */
INSERT INTO `itwp_bup_service_rates` VALUES("1", "1", "17", "0.00", "0");
INSERT INTO `itwp_bup_service_rates` VALUES("2", "2", "17", "150.00", "50");

/* INSERT TABLE DATA: itwp_bup_services */
INSERT INTO `itwp_bup_services` VALUES("1", "Basic Service", "#1e73be", "#ffffff", "14400", "0", "0", "50", "0", "1", "0", "", "150.00", NULL, "0", "0", "0");
INSERT INTO `itwp_bup_services` VALUES("2", "Basic Service", "#1e73be", "#ffffff", "14400", "0", "0", "4", "0", "1", "1", "", "150.00", "0.00", "0", "0", "0");

/* INSERT TABLE DATA: itwp_bup_staff_availability */
INSERT INTO `itwp_bup_staff_availability` VALUES("15", "17", "5", "07:00:00", "19:00:00");
INSERT INTO `itwp_bup_staff_availability` VALUES("14", "17", "4", "07:00:00", "19:00:00");
INSERT INTO `itwp_bup_staff_availability` VALUES("13", "17", "3", "07:00:00", "19:00:00");
INSERT INTO `itwp_bup_staff_availability` VALUES("12", "17", "2", "07:00:00", "19:00:00");
INSERT INTO `itwp_bup_staff_availability` VALUES("11", "17", "1", "07:00:00", "19:00:00");

/* INSERT TABLE DATA: itwp_cf_form_entries */
INSERT INTO `itwp_cf_form_entries` VALUES("326", "CF5a32ce3994920", "13", "2017-12-14 19:29:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("330", "CF5a32ce3994920", "0", "2017-12-18 15:53:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("332", "CF5a32ce3994920", "0", "2017-12-19 14:57:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("333", "CF5a32ce3994920", "0", "2017-12-19 17:05:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("334", "CF5a32ce3994920", "0", "2017-12-19 22:33:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("335", "CF5a32ce3994920", "0", "2017-12-19 22:38:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("336", "CF5a32ce3994920", "0", "2017-12-19 22:40:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("358", "CF5a32ce3994920", "0", "2017-12-29 16:04:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("370", "CF5a32ce3994920", "0", "2018-01-05 17:30:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("391", "CF5a32ce3994920", "0", "2018-01-10 22:22:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("403", "CF5a32ce3994920", "0", "2018-01-15 04:58:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("410", "CF5a32ce3994920", "13", "2018-01-18 19:03:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("413", "CF5a6118d151188", "13", "2018-01-18 21:56:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("414", "CF5a6118d151188", "13", "2018-01-18 21:57:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("415", "CF5a6118d151188", "13", "2018-01-18 21:58:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("421", "CF5a32ce3994920", "0", "2018-01-25 21:00:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("429", "CF5a32ce3994920", "0", "2018-01-26 22:17:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("441", "CF5a32ce3994920", "0", "2018-01-30 21:24:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("447", "CF5a32ce3994920", "0", "2018-02-01 16:58:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("448", "CF5a32ce3994920", "0", "2018-02-01 17:35:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("449", "CF5a32ce3994920", "0", "2018-02-01 18:43:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("450", "CF5a32ce3994920", "0", "2018-02-01 19:03:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("451", "CF5a32ce3994920", "0", "2018-02-01 19:26:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("458", "CF5a32ce3994920", "0", "2018-02-02 17:30:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("464", "CF5a32ce3994920", "0", "2018-02-09 17:26:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("465", "CF5a32ce3994920", "0", "2018-02-09 17:52:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("466", "CF5a32ce3994920", "0", "2018-02-09 19:36:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("467", "CF5a32ce3994920", "13", "2018-02-09 21:42:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("468", "CF5a32ce3994920", "0", "2018-02-10 17:30:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("469", "CF5a32ce3994920", "0", "2018-02-10 17:59:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("470", "CF5a32ce3994920", "0", "2018-02-10 17:59:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("471", "CF5a32ce3994920", "0", "2018-02-10 18:02:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("472", "CF5a32ce3994920", "0", "2018-02-10 18:08:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("473", "CF5a32ce3994920", "0", "2018-02-10 18:08:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("474", "CF5a32ce3994920", "0", "2018-02-10 18:09:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("475", "CF5a32ce3994920", "0", "2018-02-10 18:12:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("476", "CF5a32ce3994920", "0", "2018-02-10 19:46:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("478", "CF5a32ce3994920", "0", "2018-02-14 18:16:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("479", "CF5a32ce3994920", "0", "2018-02-14 22:39:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("489", "CF5a32ce3994920", "0", "2018-03-01 19:41:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("490", "CF5a32ce3994920", "0", "2018-03-02 17:49:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("498", "CF5a32ce3994920", "0", "2018-03-06 19:59:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("499", "CF5a32ce3994920", "0", "2018-03-06 23:58:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("501", "CF5a945659cdb94", "13", "2018-03-08 20:50:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("503", "CF5a32ce3994920", "0", "2018-03-09 15:22:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("511", "CF5a32ce3994920", "0", "2018-03-15 20:34:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("528", "CF5a32ce3994920", "0", "2018-03-22 15:14:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("529", "CF5a32ce3994920", "0", "2018-03-23 15:21:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("538", "CF5a32ce3994920", "0", "2018-03-27 15:26:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("539", "CF5a32ce3994920", "0", "2018-03-27 18:50:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("540", "CF5a32ce3994920", "0", "2018-03-27 18:57:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("554", "CF5a945659cdb94", "0", "2018-03-29 15:02:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("556", "CF5a32ce3994920", "0", "2018-03-30 14:28:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("557", "CF5a32ce3994920", "0", "2018-03-30 17:31:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("558", "CF5a32ce3994920", "0", "2018-03-30 19:56:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("582", "CF5a32ce3994920", "0", "2018-04-09 19:27:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("583", "CF5a32ce3994920", "0", "2018-04-09 20:09:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("593", "CF5a32ce3994920", "0", "2018-04-12 20:24:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("605", "CF5a945659cdb94", "0", "2018-04-19 18:21:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("606", "CF5a32ce3994920", "0", "2018-04-19 18:30:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("607", "CF5a32ce3994920", "13", "2018-04-20 18:49:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("611", "CF5a32ce3994920", "0", "2018-04-23 16:04:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("631", "CF5a32ce3994920", "0", "2018-05-01 23:05:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("632", "CF5a32ce3994920", "13", "2018-05-01 23:11:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("638", "CF5a945659cdb94", "13", "2018-05-03 15:53:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("647", "CF5a32ce3994920", "0", "2018-05-07 00:07:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("703", "CF5a32ce3994920", "0", "2018-05-21 14:40:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("747", "CF5a32ce3994920", "0", "2018-06-04 17:26:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("759", "CF5a32ce3994920", "0", "2018-06-08 18:30:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("790", "CF5a32ce3994920", "0", "2018-06-21 21:43:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("802", "CF5a32ce3994920", "0", "2018-06-26 18:14:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("815", "CF5a32ce3994920", "0", "2018-06-28 22:22:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("816", "CF5a32ce3994920", "0", "2018-06-28 22:24:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("821", "CF5a32ce3994920", "0", "2018-07-03 21:47:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("837", "CF5a32ce3994920", "0", "2018-07-11 15:34:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("871", "CF5a32ce3994920", "0", "2018-07-30 15:04:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("872", "CF5a32ce3994920", "0", "2018-07-30 15:06:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("948", "CF5a32ce3994920", "0", "2018-09-06 15:59:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("950", "CF5a945659cdb94", "0", "2018-09-07 16:48:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("967", "CF5a945659cdb94", "0", "2018-09-13 22:00:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("979", "CF5a945659cdb94", "0", "2018-09-19 21:05:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("985", "CF5a945659cdb94", "0", "2018-09-21 21:03:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("989", "CF5a945659cdb94", "0", "2018-09-25 18:46:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("992", "CF5a945659cdb94", "0", "2018-09-27 14:33:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1003", "CF5a945659cdb94", "0", "2018-10-02 15:09:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1007", "CF5a945659cdb94", "0", "2018-10-04 20:47:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1011", "CF5a945659cdb94", "0", "2018-10-08 16:32:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1016", "CF5a32ce3994920", "0", "2018-10-10 22:34:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1019", "CF5a32ce3994920", "0", "2018-10-12 15:15:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1020", "CF5a32ce3994920", "0", "2018-10-12 15:36:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1023", "CF5a945659cdb94", "0", "2018-10-12 21:06:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1025", "CF5a32ce3994920", "0", "2018-10-12 22:27:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1041", "CF5a945659cdb94", "0", "2018-10-25 16:51:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1055", "CF5a945659cdb94", "0", "2018-11-01 14:18:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1056", "CF5a945659cdb94", "0", "2018-11-01 14:19:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1057", "CF5a945659cdb94", "0", "2018-11-01 14:20:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1061", "CF5a32ce3994920", "0", "2018-11-02 14:05:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1082", "CF5a32ce3994920", "0", "2018-11-14 22:14:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1083", "CF5a945659cdb94", "0", "2018-11-14 22:15:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1098", "CF5a32ce3994920", "13", "2018-11-15 16:58:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1099", "CF5a32ce3994920", "0", "2018-11-15 18:38:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1105", "CF5a32ce3994920", "0", "2018-11-17 21:40:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1156", "CF5a32ce3994920", "0", "2018-12-18 01:26:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1157", "CF5a32ce3994920", "0", "2018-12-18 21:37:52", "trash");
INSERT INTO `itwp_cf_form_entries` VALUES("1158", "CF5a32ce3994920", "0", "2018-12-18 21:41:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1265", "CF5a32ce3994920", "0", "2019-01-20 02:26:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1267", "CF5a945659cdb94", "13", "2019-01-21 20:02:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1268", "CF5a945659cdb94", "13", "2019-01-21 20:02:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1276", "CF5a32ce3994920", "13", "2019-01-22 23:27:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1289", "CF5a32ce3994920", "0", "2019-01-28 17:23:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1315", "CF5a945659cdb94", "0", "2019-02-01 22:11:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1330", "CF5a32ce3994920", "13", "2019-02-11 15:56:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1332", "CF5a32ce3994920", "13", "2019-02-11 22:08:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1398", "CF5a32ce3994920", "13", "2019-03-04 19:23:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1417", "CF5a32ce3994920", "0", "2019-03-08 00:33:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1431", "CF5a32ce3994920", "0", "2019-03-20 17:38:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1432", "CF5a32ce3994920", "0", "2019-03-20 17:40:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1435", "CF5a32ce3994920", "0", "2019-03-20 18:03:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1522", "CF5a32ce3994920", "0", "2019-04-10 15:56:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1523", "CF5a32ce3994920", "0", "2019-04-10 15:59:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1525", "CF5a32ce3994920", "0", "2019-04-12 19:03:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1526", "CF5a32ce3994920", "0", "2019-04-12 19:19:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1527", "CF5a32ce3994920", "13", "2019-04-12 19:30:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1528", "CF5a945659cdb94", "13", "2019-04-12 19:31:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1529", "CF5a32ce3994920", "13", "2019-04-12 19:33:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1547", "CF5a32ce3994920", "13", "2019-04-17 15:30:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1553", "CF5a32ce3994920", "13", "2019-04-18 15:19:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1572", "CF5a32ce3994920", "13", "2019-04-26 14:42:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1588", "CF5a32ce3994920", "13", "2019-04-30 15:20:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1604", "CF5a32ce3994920", "0", "2019-05-03 21:58:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1611", "CF5a32ce3994920", "0", "2019-05-08 18:58:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1614", "CF5a945659cdb94", "13", "2019-05-09 16:25:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1615", "CF5a32ce3994920", "13", "2019-05-09 16:47:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1616", "CF5a945659cdb94", "13", "2019-05-09 20:21:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1630", "CF5a945659cdb94", "13", "2019-05-13 21:48:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1636", "CF5a945659cdb94", "13", "2019-05-14 18:22:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1637", "CF5a32ce3994920", "13", "2019-05-14 18:59:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1683", "CF5a945659cdb94", "13", "2019-06-10 19:05:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1685", "CF5a32ce3994920", "0", "2019-06-12 14:06:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("1847", "CF5d6beb7bef9c3", "0", "2019-09-01 17:04:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2169", "CF5e133268c67e9", "13", "2020-01-07 21:20:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2180", "CF5e133268c67e9", "0", "2020-01-10 16:30:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2827", "CF5a32ce3994920", "0", "2020-08-19 21:17:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2912", "CF5a32ce3994920", "0", "2020-09-25 17:17:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2913", "CF5a32ce3994920", "0", "2020-09-25 17:18:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3296", "CF58d2e36240afb", "13", "2021-02-26 19:01:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3295", "CF58d2e36240afb", "13", "2021-02-26 17:27:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3294", "CF58d2e36240afb", "13", "2021-02-26 17:24:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3293", "CF58d2e36240afb", "13", "2021-02-25 20:33:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3292", "CF58d2e36240afb", "13", "2021-02-25 19:15:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3291", "CF58d2e36240afb", "13", "2021-02-25 16:29:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3290", "CF58d2e36240afb", "13", "2021-02-25 16:27:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3289", "CF58d2e36240afb", "13", "2021-02-24 21:11:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2939", "CF5a32ce3994920", "0", "2020-10-09 21:52:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2940", "CF5a32ce3994920", "0", "2020-10-09 21:53:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("2941", "CF5a32ce3994920", "0", "2020-10-09 21:59:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3288", "CF58d2e36240afb", "13", "2021-02-24 18:15:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3287", "CF58d2e36240afb", "13", "2021-02-23 18:43:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3286", "CF58d2e36240afb", "13", "2021-02-23 18:41:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3285", "CF58d2e36240afb", "13", "2021-02-23 15:32:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3284", "CF58d2e36240afb", "13", "2021-02-22 20:41:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3283", "CF58d2e36240afb", "0", "2021-02-22 19:55:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3282", "CF58d2e36240afb", "0", "2021-02-22 18:02:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3281", "CF58d2e36240afb", "13", "2021-02-19 23:35:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3280", "CF58d2e36240afb", "13", "2021-02-19 23:31:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3279", "CF58d2e36240afb", "13", "2021-02-19 23:25:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3278", "CF58d2e36240afb", "13", "2021-02-19 23:20:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3277", "CF58d2e36240afb", "13", "2021-02-19 22:22:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3276", "CF58d2e36240afb", "13", "2021-02-19 21:44:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3275", "CF58d2e36240afb", "13", "2021-02-19 20:25:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3274", "CF58d2e36240afb", "13", "2021-02-19 18:20:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3273", "CF58d2e36240afb", "13", "2021-02-19 17:41:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3272", "CF58d2e36240afb", "13", "2021-02-18 23:45:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3271", "CF58d2e36240afb", "13", "2021-02-18 22:34:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3270", "CF58d2e36240afb", "0", "2021-02-18 20:13:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3269", "CF58d2e36240afb", "13", "2021-02-18 19:11:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3268", "CF58d2e36240afb", "13", "2021-02-18 17:42:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3267", "CF58d2e36240afb", "13", "2021-02-18 15:29:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3266", "CF58d2e36240afb", "0", "2021-02-17 23:47:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3265", "CF58d2e36240afb", "0", "2021-02-17 23:44:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3264", "CF58d2e36240afb", "0", "2021-02-17 23:19:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3263", "CF58d2e36240afb", "0", "2021-02-17 23:15:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3262", "CF58d2e36240afb", "0", "2021-02-17 23:13:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3261", "CF58d2e36240afb", "0", "2021-02-15 22:46:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3260", "CF58d2e36240afb", "13", "2021-02-15 16:19:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3259", "CF58d2e36240afb", "13", "2021-02-15 16:17:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3258", "CF58d2e36240afb", "13", "2021-02-15 16:03:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3257", "CF58d2e36240afb", "13", "2021-02-15 16:01:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3256", "CF58d2e36240afb", "13", "2021-02-15 15:33:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3255", "CF58d2e36240afb", "13", "2021-02-15 15:30:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3254", "CF58d2e36240afb", "13", "2021-02-15 15:27:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3253", "CF58d2e36240afb", "13", "2021-02-15 15:21:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3252", "CF58d2e36240afb", "13", "2021-02-12 23:26:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3251", "CF58d2e36240afb", "13", "2021-02-12 22:42:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3250", "CF58d2e36240afb", "0", "2021-02-12 21:07:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3249", "CF58d2e36240afb", "0", "2021-02-12 19:10:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3248", "CF58d2e36240afb", "0", "2021-02-12 18:05:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3247", "CF58d2e36240afb", "13", "2021-02-11 23:42:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3246", "CF58d2e36240afb", "13", "2021-02-11 23:35:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3245", "CF58d2e36240afb", "13", "2021-02-11 17:09:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3244", "CF58d2e36240afb", "0", "2021-02-10 16:26:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3243", "CF58d2e36240afb", "0", "2021-02-10 00:00:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3242", "CF58d2e36240afb", "0", "2021-02-09 23:55:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3241", "CF58d2e36240afb", "13", "2021-02-09 15:57:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3240", "CF58d2e36240afb", "13", "2021-02-05 23:27:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3239", "CF58d2e36240afb", "13", "2021-02-05 23:25:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3238", "CF58d2e36240afb", "13", "2021-02-05 23:18:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3237", "CF58d2e36240afb", "13", "2021-02-05 23:15:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3236", "CF58d2e36240afb", "13", "2021-02-05 23:13:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3235", "CF58d2e36240afb", "13", "2021-02-05 23:10:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3234", "CF58d2e36240afb", "13", "2021-02-05 23:07:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3233", "CF58d2e36240afb", "13", "2021-02-05 23:05:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3232", "CF58d2e36240afb", "13", "2021-02-05 22:59:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3231", "CF58d2e36240afb", "0", "2021-02-05 20:28:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3230", "CF58d2e36240afb", "0", "2021-02-05 20:27:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3229", "CF58d2e36240afb", "0", "2021-02-04 19:58:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3228", "CF58d2e36240afb", "13", "2021-02-04 17:18:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3227", "CF58d2e36240afb", "0", "2021-02-03 23:09:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3226", "CF58d2e36240afb", "13", "2021-02-03 17:22:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3225", "CF58d2e36240afb", "0", "2021-02-02 18:58:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3224", "CF58d2e36240afb", "13", "2021-02-02 15:37:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3223", "CF58d2e36240afb", "0", "2021-02-02 15:09:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3222", "CF58d2e36240afb", "0", "2021-02-01 19:08:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3221", "CF58d2e36240afb", "0", "2021-02-01 17:56:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3220", "CF58d2e36240afb", "0", "2021-02-01 17:55:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3219", "CF58d2e36240afb", "0", "2021-02-01 15:51:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3218", "CF58d2e36240afb", "0", "2021-02-01 15:50:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3217", "CF58d2e36240afb", "0", "2021-02-01 13:58:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3216", "CF58d2e36240afb", "13", "2021-01-30 22:30:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3215", "CF58d2e36240afb", "0", "2021-01-29 22:36:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3214", "CF58d2e36240afb", "0", "2021-01-29 19:28:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3213", "CF58d2e36240afb", "13", "2021-01-29 00:05:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3212", "CF58d2e36240afb", "13", "2021-01-29 00:03:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3211", "CF58d2e36240afb", "13", "2021-01-29 00:01:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3210", "CF58d2e36240afb", "13", "2021-01-28 23:58:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3209", "CF58d2e36240afb", "13", "2021-01-28 23:55:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3208", "CF58d2e36240afb", "13", "2021-01-28 23:49:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3207", "CF58d2e36240afb", "13", "2021-01-28 23:46:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3206", "CF58d2e36240afb", "13", "2021-01-28 23:45:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3205", "CF58d2e36240afb", "13", "2021-01-28 23:43:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3204", "CF58d2e36240afb", "13", "2021-01-28 23:40:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3203", "CF58d2e36240afb", "0", "2021-01-28 23:12:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3202", "CF58d2e36240afb", "0", "2021-01-28 23:06:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3201", "CF58d2e36240afb", "0", "2021-01-27 19:24:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3200", "CF58d2e36240afb", "13", "2021-01-27 18:07:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3199", "CF58d2e36240afb", "13", "2021-01-27 17:25:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3198", "CF58d2e36240afb", "13", "2021-01-27 16:44:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3197", "CF58d2e36240afb", "13", "2021-01-27 00:02:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3196", "CF58d2e36240afb", "13", "2021-01-26 18:27:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3195", "CF58d2e36240afb", "13", "2021-01-25 23:44:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3194", "CF58d2e36240afb", "13", "2021-01-25 23:36:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3193", "CF58d2e36240afb", "13", "2021-01-25 21:17:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3192", "CF58d2e36240afb", "13", "2021-01-25 21:14:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3191", "CF58d2e36240afb", "13", "2021-01-25 21:11:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3190", "CF58d2e36240afb", "13", "2021-01-25 21:09:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3189", "CF58d2e36240afb", "0", "2021-01-25 16:41:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3188", "CF58d2e36240afb", "13", "2021-01-25 15:34:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3187", "CF58d2e36240afb", "13", "2021-01-25 15:29:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3186", "CF58d2e36240afb", "13", "2021-01-25 15:27:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3185", "CF58d2e36240afb", "13", "2021-01-25 15:23:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3184", "CF58d2e36240afb", "13", "2021-01-25 15:20:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3183", "CF58d2e36240afb", "13", "2021-01-21 23:35:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3182", "CF58d2e36240afb", "13", "2021-01-21 17:53:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3181", "CF58d2e36240afb", "13", "2021-01-21 17:46:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3180", "CF58d2e36240afb", "13", "2021-01-21 17:07:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3179", "CF58d2e36240afb", "13", "2021-01-21 17:05:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3178", "CF58d2e36240afb", "13", "2021-01-21 17:01:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3177", "CF58d2e36240afb", "13", "2021-01-20 23:53:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3176", "CF58d2e36240afb", "13", "2021-01-20 23:41:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3175", "CF58d2e36240afb", "13", "2021-01-20 23:30:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3174", "CF58d2e36240afb", "13", "2021-01-20 23:23:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3173", "CF58d2e36240afb", "13", "2021-01-20 23:20:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3172", "CF58d2e36240afb", "13", "2021-01-20 23:13:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3171", "CF58d2e36240afb", "0", "2021-01-20 21:42:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3170", "CF58d2e36240afb", "0", "2021-01-20 19:36:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3169", "CF58d2e36240afb", "0", "2021-01-20 17:18:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3168", "CF58d2e36240afb", "13", "2021-01-19 22:40:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3167", "CF58d2e36240afb", "13", "2021-01-19 20:45:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3166", "CF58d2e36240afb", "13", "2021-01-19 18:54:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3165", "CF58d2e36240afb", "13", "2021-01-19 18:41:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3164", "CF58d2e36240afb", "13", "2021-01-19 18:20:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3297", "CF58d2e36240afb", "13", "2021-03-01 16:50:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3298", "CF58d2e36240afb", "13", "2021-03-01 19:00:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3299", "CF58d2e36240afb", "13", "2021-03-01 21:07:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3300", "CF58d2e36240afb", "13", "2021-03-02 15:07:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3301", "CF58d2e36240afb", "13", "2021-03-02 20:15:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3302", "CF58d2e36240afb", "13", "2021-03-02 20:47:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3303", "CF58d2e36240afb", "0", "2021-03-03 15:53:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3304", "CF58d2e36240afb", "13", "2021-03-03 18:39:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3305", "CF58d2e36240afb", "13", "2021-03-03 18:48:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3306", "CF58d2e36240afb", "13", "2021-03-03 22:51:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3307", "CF58d2e36240afb", "13", "2021-03-03 22:55:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3308", "CF58d2e36240afb", "13", "2021-03-04 00:03:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3309", "CF58d2e36240afb", "13", "2021-03-04 20:58:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3310", "CF58d2e36240afb", "13", "2021-03-04 22:41:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3311", "CF58d2e36240afb", "0", "2021-03-05 19:04:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3312", "CF58d2e36240afb", "13", "2021-03-05 21:29:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3313", "CF58d2e36240afb", "13", "2021-03-08 15:59:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3314", "CF58d2e36240afb", "13", "2021-03-08 19:50:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3315", "CF58d2e36240afb", "13", "2021-03-08 20:55:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3316", "CF58d2e36240afb", "13", "2021-03-08 20:58:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3317", "CF58d2e36240afb", "13", "2021-03-08 21:04:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3318", "CF58d2e36240afb", "13", "2021-03-08 21:39:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3319", "CF58d2e36240afb", "13", "2021-03-08 22:02:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3320", "CF58d2e36240afb", "13", "2021-03-08 22:29:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3321", "CF58d2e36240afb", "13", "2021-03-09 22:51:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3322", "CF58d2e36240afb", "13", "2021-03-10 19:00:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3323", "CF58d2e36240afb", "0", "2021-03-10 22:49:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3324", "CF58d2e36240afb", "13", "2021-03-10 22:54:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3325", "CF58d2e36240afb", "13", "2021-03-11 15:31:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3326", "CF58d2e36240afb", "13", "2021-03-11 15:50:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3327", "CF58d2e36240afb", "13", "2021-03-11 18:28:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3328", "CF58d2e36240afb", "13", "2021-03-11 18:31:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3329", "CF58d2e36240afb", "13", "2021-03-11 20:31:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3330", "CF58d2e36240afb", "0", "2021-03-12 15:32:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3331", "CF58d2e36240afb", "13", "2021-03-12 21:34:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3332", "CF58d2e36240afb", "13", "2021-03-12 21:38:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3333", "CF58d2e36240afb", "13", "2021-03-12 21:41:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3334", "CF58d2e36240afb", "0", "2021-03-16 13:21:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3335", "CF58d2e36240afb", "0", "2021-03-17 15:47:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3336", "CF58d2e36240afb", "0", "2021-03-17 15:51:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3337", "CF58d2e36240afb", "0", "2021-03-17 18:52:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3338", "CF58d2e36240afb", "0", "2021-03-17 18:54:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3339", "CF58d2e36240afb", "0", "2021-03-19 14:56:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3340", "CF58d2e36240afb", "0", "2021-03-19 21:18:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3341", "CF58d2e36240afb", "0", "2021-03-22 14:14:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3342", "CF58d2e36240afb", "0", "2021-03-22 15:03:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3343", "CF58d2e36240afb", "0", "2021-03-23 16:04:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3344", "CF58d2e36240afb", "0", "2021-03-23 16:07:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3345", "CF58d2e36240afb", "0", "2021-03-23 16:12:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3346", "CF58d2e36240afb", "13", "2021-03-23 16:21:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3347", "CF58d2e36240afb", "13", "2021-03-23 18:18:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3348", "CF58d2e36240afb", "13", "2021-03-23 19:01:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3349", "CF58d2e36240afb", "13", "2021-03-23 20:44:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3350", "CF58d2e36240afb", "13", "2021-03-25 15:36:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3351", "CF58d2e36240afb", "0", "2021-03-25 16:15:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3352", "CF58d2e36240afb", "0", "2021-03-25 16:39:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3353", "CF58d2e36240afb", "0", "2021-03-25 16:46:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3354", "CF58d2e36240afb", "0", "2021-03-25 16:49:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3355", "CF58d2e36240afb", "13", "2021-03-25 18:55:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3356", "CF58d2e36240afb", "13", "2021-03-25 21:17:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3357", "CF58d2e36240afb", "13", "2021-03-25 22:05:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3358", "CF58d2e36240afb", "13", "2021-03-26 15:41:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3359", "CF58d2e36240afb", "0", "2021-03-29 14:07:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3360", "CF58d2e36240afb", "0", "2021-03-29 18:52:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3361", "CF58d2e36240afb", "0", "2021-03-29 18:58:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3362", "CF58d2e36240afb", "0", "2021-03-29 19:19:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3363", "CF58d2e36240afb", "0", "2021-03-30 20:49:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3364", "CF58d2e36240afb", "0", "2021-03-31 13:37:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3365", "CF58d2e36240afb", "0", "2021-03-31 13:37:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3366", "CF58d2e36240afb", "0", "2021-03-31 18:06:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3367", "CF58d2e36240afb", "0", "2021-03-31 18:29:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3368", "CF58d2e36240afb", "0", "2021-04-01 18:52:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3369", "CF58d2e36240afb", "0", "2021-04-01 19:56:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3370", "CF58d2e36240afb", "13", "2021-04-02 22:33:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3371", "CF58d2e36240afb", "13", "2021-04-02 22:40:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3372", "CF58d2e36240afb", "13", "2021-04-02 22:42:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3373", "CF58d2e36240afb", "13", "2021-04-02 22:44:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3374", "CF58d2e36240afb", "13", "2021-04-02 22:49:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3375", "CF58d2e36240afb", "13", "2021-04-02 22:51:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3376", "CF58d2e36240afb", "13", "2021-04-02 23:02:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3377", "CF58d2e36240afb", "13", "2021-04-02 23:06:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3378", "CF58d2e36240afb", "13", "2021-04-02 23:08:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3379", "CF58d2e36240afb", "13", "2021-04-02 23:10:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3380", "CF58d2e36240afb", "13", "2021-04-02 23:14:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3381", "CF58d2e36240afb", "13", "2021-04-02 23:17:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3382", "CF58d2e36240afb", "13", "2021-04-02 23:20:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3383", "CF58d2e36240afb", "0", "2021-04-05 16:49:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3384", "CF58d2e36240afb", "0", "2021-04-05 18:23:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3385", "CF58d2e36240afb", "0", "2021-04-05 19:33:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3386", "CF58d2e36240afb", "0", "2021-04-05 20:07:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3387", "CF58d2e36240afb", "0", "2021-04-06 18:24:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3388", "CF58d2e36240afb", "0", "2021-04-06 20:38:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3389", "CF58d2e36240afb", "0", "2021-04-07 21:38:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3390", "CF58d2e36240afb", "13", "2021-04-08 14:16:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3391", "CF58d2e36240afb", "13", "2021-04-08 14:20:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3392", "CF58d2e36240afb", "13", "2021-04-08 14:22:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3393", "CF58d2e36240afb", "13", "2021-04-08 14:25:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3394", "CF58d2e36240afb", "13", "2021-04-08 14:27:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3395", "CF58d2e36240afb", "13", "2021-04-08 14:31:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3396", "CF58d2e36240afb", "0", "2021-04-08 21:33:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3397", "CF58d2e36240afb", "0", "2021-04-09 16:30:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3398", "CF58d2e36240afb", "0", "2021-04-09 16:45:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3399", "CF58d2e36240afb", "13", "2021-04-12 14:22:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3400", "CF58d2e36240afb", "13", "2021-04-12 14:29:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3401", "CF58d2e36240afb", "13", "2021-04-12 21:27:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3402", "CF58d2e36240afb", "0", "2021-04-12 22:40:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3403", "CF58d2e36240afb", "0", "2021-04-12 22:42:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3404", "CF58d2e36240afb", "0", "2021-04-12 22:59:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3405", "CF58d2e36240afb", "13", "2021-04-13 15:35:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3406", "CF58d2e36240afb", "13", "2021-04-13 16:47:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3407", "CF58d2e36240afb", "13", "2021-04-13 17:03:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3408", "CF58d2e36240afb", "0", "2021-04-13 21:48:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3409", "CF58d2e36240afb", "0", "2021-04-13 21:55:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3410", "CF58d2e36240afb", "13", "2021-04-14 14:54:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3411", "CF58d2e36240afb", "13", "2021-04-14 22:50:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3412", "CF58d2e36240afb", "13", "2021-04-14 22:52:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3413", "CF58d2e36240afb", "13", "2021-04-14 22:54:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3414", "CF58d2e36240afb", "13", "2021-04-14 22:57:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3415", "CF58d2e36240afb", "0", "2021-04-15 13:31:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3416", "CF58d2e36240afb", "0", "2021-04-15 17:13:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3417", "CF58d2e36240afb", "0", "2021-04-15 17:17:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3418", "CF58d2e36240afb", "13", "2021-04-15 19:50:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3419", "CF58d2e36240afb", "13", "2021-04-15 20:50:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3420", "CF58d2e36240afb", "13", "2021-04-15 21:48:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3421", "CF58d2e36240afb", "0", "2021-04-19 15:07:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3422", "CF58d2e36240afb", "0", "2021-04-19 15:27:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3423", "CF58d2e36240afb", "0", "2021-04-19 18:43:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3424", "CF58d2e36240afb", "0", "2021-04-19 18:50:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3425", "CF58d2e36240afb", "0", "2021-04-19 18:58:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3426", "CF58d2e36240afb", "0", "2021-04-20 17:02:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3427", "CF58d2e36240afb", "13", "2021-04-20 17:26:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3428", "CF58d2e36240afb", "13", "2021-04-20 18:49:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3429", "CF58d2e36240afb", "13", "2021-04-20 20:45:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3430", "CF58d2e36240afb", "13", "2021-04-21 15:03:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3431", "CF58d2e36240afb", "13", "2021-04-21 19:23:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3432", "CF58d2e36240afb", "13", "2021-04-21 21:29:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3433", "CF58d2e36240afb", "0", "2021-04-22 14:54:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3434", "CF58d2e36240afb", "13", "2021-04-22 15:43:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3435", "CF58d2e36240afb", "0", "2021-04-22 22:58:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3436", "CF58d2e36240afb", "0", "2021-04-22 23:04:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3437", "CF58d2e36240afb", "0", "2021-04-23 17:04:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3438", "CF58d2e36240afb", "0", "2021-04-23 17:46:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3439", "CF58d2e36240afb", "0", "2021-04-26 19:45:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3440", "CF58d2e36240afb", "0", "2021-04-27 19:38:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3441", "CF58d2e36240afb", "13", "2021-04-29 21:17:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3442", "CF58d2e36240afb", "13", "2021-04-29 21:23:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3443", "CF58d2e36240afb", "13", "2021-04-29 22:08:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3444", "CF58d2e36240afb", "0", "2021-04-30 14:50:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3445", "CF58d2e36240afb", "13", "2021-04-30 20:08:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3446", "CF58d2e36240afb", "13", "2021-04-30 21:27:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3447", "CF58d2e36240afb", "13", "2021-04-30 21:30:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3448", "CF58d2e36240afb", "13", "2021-04-30 21:32:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3449", "CF58d2e36240afb", "13", "2021-04-30 21:34:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3450", "CF58d2e36240afb", "13", "2021-04-30 21:36:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3451", "CF58d2e36240afb", "13", "2021-04-30 21:41:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3452", "CF58d2e36240afb", "13", "2021-04-30 21:46:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3453", "CF58d2e36240afb", "13", "2021-04-30 21:48:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3454", "CF58d2e36240afb", "13", "2021-04-30 21:53:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3455", "CF58d2e36240afb", "13", "2021-04-30 21:55:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3456", "CF58d2e36240afb", "13", "2021-04-30 21:58:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3457", "CF58d2e36240afb", "13", "2021-04-30 21:59:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3458", "CF58d2e36240afb", "13", "2021-04-30 22:02:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3459", "CF58d2e36240afb", "13", "2021-04-30 22:05:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3460", "CF58d2e36240afb", "13", "2021-04-30 22:07:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3461", "CF58d2e36240afb", "0", "2021-05-03 20:12:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3462", "CF58d2e36240afb", "13", "2021-05-04 19:04:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3463", "CF58d2e36240afb", "0", "2021-05-04 20:50:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3464", "CF58d2e36240afb", "13", "2021-05-04 21:37:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3465", "CF58d2e36240afb", "13", "2021-05-04 21:38:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3466", "CF58d2e36240afb", "13", "2021-05-05 16:33:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3467", "CF58d2e36240afb", "13", "2021-05-05 22:00:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3468", "CF58d2e36240afb", "13", "2021-05-07 16:45:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3469", "CF58d2e36240afb", "13", "2021-05-07 22:18:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3470", "CF58d2e36240afb", "13", "2021-05-07 22:22:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3471", "CF58d2e36240afb", "13", "2021-05-07 22:25:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3472", "CF58d2e36240afb", "13", "2021-05-07 22:27:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3473", "CF58d2e36240afb", "13", "2021-05-07 22:29:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3474", "CF58d2e36240afb", "13", "2021-05-07 22:31:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3475", "CF58d2e36240afb", "13", "2021-05-07 22:52:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3476", "CF58d2e36240afb", "13", "2021-05-09 18:03:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3477", "CF58d2e36240afb", "13", "2021-05-09 18:08:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3478", "CF58d2e36240afb", "13", "2021-05-10 14:35:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3479", "CF58d2e36240afb", "13", "2021-05-10 15:24:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3480", "CF58d2e36240afb", "13", "2021-05-10 16:31:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3481", "CF58d2e36240afb", "13", "2021-05-10 17:13:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3482", "CF58d2e36240afb", "13", "2021-05-10 18:30:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3483", "CF58d2e36240afb", "13", "2021-05-11 16:45:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3484", "CF58d2e36240afb", "13", "2021-05-11 19:07:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3485", "CF58d2e36240afb", "13", "2021-05-11 19:35:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3486", "CF58d2e36240afb", "0", "2021-05-12 14:03:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3487", "CF58d2e36240afb", "0", "2021-05-12 18:30:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3488", "CF58d2e36240afb", "0", "2021-05-12 19:31:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3489", "CF58d2e36240afb", "0", "2021-05-12 22:49:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3490", "CF58d2e36240afb", "0", "2021-05-13 19:08:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3491", "CF58d2e36240afb", "13", "2021-05-13 22:18:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3492", "CF58d2e36240afb", "0", "2021-05-14 17:51:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3493", "CF58d2e36240afb", "0", "2021-05-16 02:11:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3494", "CF58d2e36240afb", "0", "2021-05-17 16:25:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3495", "CF58d2e36240afb", "0", "2021-05-17 16:26:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3496", "CF58d2e36240afb", "13", "2021-05-17 19:38:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3497", "CF58d2e36240afb", "13", "2021-05-17 19:39:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3498", "CF58d2e36240afb", "0", "2021-05-17 20:52:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3499", "CF58d2e36240afb", "0", "2021-05-17 21:37:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3500", "CF58d2e36240afb", "13", "2021-05-17 22:22:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3501", "CF58d2e36240afb", "0", "2021-05-17 22:24:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3502", "CF58d2e36240afb", "0", "2021-05-17 22:45:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3503", "CF58d2e36240afb", "13", "2021-05-17 23:15:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3504", "CF58d2e36240afb", "13", "2021-05-18 14:01:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3505", "CF58d2e36240afb", "13", "2021-05-18 16:24:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3506", "CF58d2e36240afb", "13", "2021-05-18 19:03:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3507", "CF58d2e36240afb", "13", "2021-05-18 19:59:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3508", "CF58d2e36240afb", "13", "2021-05-18 20:17:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3509", "CF58d2e36240afb", "13", "2021-05-18 22:01:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3510", "CF58d2e36240afb", "0", "2021-05-18 22:21:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3511", "CF58d2e36240afb", "13", "2021-05-19 00:34:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3512", "CF58d2e36240afb", "13", "2021-05-19 15:40:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3513", "CF58d2e36240afb", "13", "2021-05-19 16:14:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3514", "CF58d2e36240afb", "13", "2021-05-19 21:55:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3515", "CF58d2e36240afb", "13", "2021-05-19 23:58:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3516", "CF58d2e36240afb", "13", "2021-05-20 00:03:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3517", "CF58d2e36240afb", "13", "2021-05-20 00:12:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3518", "CF58d2e36240afb", "13", "2021-05-20 00:15:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3519", "CF58d2e36240afb", "13", "2021-05-20 00:19:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3520", "CF58d2e36240afb", "13", "2021-05-20 16:33:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3521", "CF58d2e36240afb", "13", "2021-05-20 18:22:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3522", "CF58d2e36240afb", "13", "2021-05-20 21:33:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3523", "CF58d2e36240afb", "0", "2021-05-21 15:17:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3524", "CF58d2e36240afb", "13", "2021-05-21 15:30:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3525", "CF58d2e36240afb", "13", "2021-05-21 15:55:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3526", "CF58d2e36240afb", "13", "2021-05-21 16:09:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3527", "CF58d2e36240afb", "13", "2021-05-21 16:31:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3528", "CF58d2e36240afb", "13", "2021-05-21 17:32:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3529", "CF58d2e36240afb", "13", "2021-05-24 15:36:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3530", "CF58d2e36240afb", "13", "2021-05-24 17:28:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3531", "CF58d2e36240afb", "0", "2021-05-24 18:18:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3532", "CF58d2e36240afb", "13", "2021-05-24 18:30:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3533", "CF58d2e36240afb", "13", "2021-05-24 18:46:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3534", "CF58d2e36240afb", "13", "2021-05-24 18:51:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3535", "CF58d2e36240afb", "13", "2021-05-24 18:54:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3536", "CF58d2e36240afb", "13", "2021-05-24 18:58:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3537", "CF58d2e36240afb", "0", "2021-05-24 21:40:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3538", "CF58d2e36240afb", "13", "2021-05-25 17:46:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3539", "CF58d2e36240afb", "13", "2021-05-25 17:47:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3540", "CF58d2e36240afb", "0", "2021-05-25 20:51:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3541", "CF58d2e36240afb", "13", "2021-05-25 22:34:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3542", "CF58d2e36240afb", "0", "2021-05-26 21:39:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3543", "CF58d2e36240afb", "13", "2021-05-27 14:20:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3544", "CF58d2e36240afb", "0", "2021-05-27 16:50:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3545", "CF58d2e36240afb", "13", "2021-05-27 18:24:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3546", "CF58d2e36240afb", "0", "2021-05-28 16:23:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3547", "CF58d2e36240afb", "0", "2021-05-28 17:07:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3548", "CF58d2e36240afb", "0", "2021-06-01 15:47:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3549", "CF58d2e36240afb", "13", "2021-06-01 16:30:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3550", "CF58d2e36240afb", "0", "2021-06-01 17:03:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3551", "CF58d2e36240afb", "0", "2021-06-01 22:31:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3552", "CF58d2e36240afb", "0", "2021-06-01 22:36:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3553", "CF58d2e36240afb", "0", "2021-06-01 22:54:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3554", "CF58d2e36240afb", "13", "2021-06-01 22:56:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3555", "CF58d2e36240afb", "13", "2021-06-01 23:00:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3556", "CF58d2e36240afb", "13", "2021-06-01 23:01:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3557", "CF58d2e36240afb", "13", "2021-06-01 23:05:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3558", "CF58d2e36240afb", "0", "2021-06-02 14:16:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3559", "CF58d2e36240afb", "0", "2021-06-02 18:52:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3560", "CF58d2e36240afb", "13", "2021-06-02 21:42:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3561", "CF58d2e36240afb", "13", "2021-06-02 21:44:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3562", "CF58d2e36240afb", "13", "2021-06-03 15:48:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3563", "CF58d2e36240afb", "0", "2021-06-03 17:16:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3564", "CF58d2e36240afb", "13", "2021-06-03 17:28:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3565", "CF58d2e36240afb", "13", "2021-06-03 19:09:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3566", "CF58d2e36240afb", "0", "2021-06-07 14:54:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3567", "CF58d2e36240afb", "0", "2021-06-07 15:43:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3568", "CF58d2e36240afb", "0", "2021-06-07 15:54:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3569", "CF58d2e36240afb", "13", "2021-06-07 21:11:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3570", "CF58d2e36240afb", "13", "2021-06-08 16:19:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3571", "CF58d2e36240afb", "13", "2021-06-08 16:24:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3572", "CF58d2e36240afb", "13", "2021-06-08 16:40:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3573", "CF58d2e36240afb", "13", "2021-06-08 16:50:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3574", "CF58d2e36240afb", "13", "2021-06-08 16:55:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3575", "CF58d2e36240afb", "13", "2021-06-08 17:58:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3576", "CF58d2e36240afb", "13", "2021-06-08 21:06:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3577", "CF58d2e36240afb", "13", "2021-06-08 21:47:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3578", "CF58d2e36240afb", "13", "2021-06-08 22:05:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3579", "CF58d2e36240afb", "13", "2021-06-09 14:42:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3580", "CF58d2e36240afb", "0", "2021-06-09 19:32:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3581", "CF58d2e36240afb", "13", "2021-06-09 20:25:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3582", "CF58d2e36240afb", "13", "2021-06-09 20:27:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3583", "CF58d2e36240afb", "13", "2021-06-09 20:29:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3584", "CF58d2e36240afb", "13", "2021-06-10 22:55:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3585", "CF58d2e36240afb", "13", "2021-06-10 22:57:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3586", "CF58d2e36240afb", "13", "2021-06-10 23:02:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3587", "CF58d2e36240afb", "13", "2021-06-10 23:05:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3588", "CF58d2e36240afb", "13", "2021-06-10 23:10:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3589", "CF58d2e36240afb", "13", "2021-06-10 23:12:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3590", "CF58d2e36240afb", "13", "2021-06-11 15:47:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3591", "CF58d2e36240afb", "13", "2021-06-11 16:43:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3592", "CF58d2e36240afb", "0", "2021-06-11 17:28:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3593", "CF58d2e36240afb", "0", "2021-06-11 17:47:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3594", "CF58d2e36240afb", "0", "2021-06-11 17:51:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3595", "CF58d2e36240afb", "0", "2021-06-11 17:53:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3596", "CF58d2e36240afb", "13", "2021-06-11 18:23:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3597", "CF58d2e36240afb", "13", "2021-06-11 18:27:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3598", "CF58d2e36240afb", "13", "2021-06-14 17:49:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3599", "CF58d2e36240afb", "13", "2021-06-14 18:06:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3600", "CF58d2e36240afb", "13", "2021-06-14 18:13:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3601", "CF58d2e36240afb", "13", "2021-06-14 22:01:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3602", "CF58d2e36240afb", "13", "2021-06-14 22:50:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3603", "CF58d2e36240afb", "13", "2021-06-15 15:30:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3604", "CF58d2e36240afb", "13", "2021-06-15 15:41:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3605", "CF58d2e36240afb", "13", "2021-06-15 17:15:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3606", "CF58d2e36240afb", "13", "2021-06-15 17:51:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3607", "CF58d2e36240afb", "13", "2021-06-15 21:38:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3608", "CF58d2e36240afb", "13", "2021-06-15 21:42:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3609", "CF58d2e36240afb", "13", "2021-06-16 21:11:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3610", "CF58d2e36240afb", "13", "2021-06-16 22:17:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3611", "CF58d2e36240afb", "0", "2021-06-17 05:47:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3612", "CF58d2e36240afb", "0", "2021-06-17 05:52:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3613", "CF58d2e36240afb", "13", "2021-06-21 16:54:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3614", "CF58d2e36240afb", "0", "2021-06-21 17:22:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3615", "CF58d2e36240afb", "13", "2021-06-21 19:01:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3616", "CF58d2e36240afb", "13", "2021-06-21 19:26:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3617", "CF58d2e36240afb", "0", "2021-06-21 22:56:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3618", "CF58d2e36240afb", "13", "2021-06-22 15:04:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3619", "CF58d2e36240afb", "13", "2021-06-22 17:13:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3620", "CF58d2e36240afb", "13", "2021-06-22 17:20:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3621", "CF58d2e36240afb", "13", "2021-06-23 19:23:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3622", "CF58d2e36240afb", "0", "2021-06-24 20:01:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3623", "CF58d2e36240afb", "0", "2021-06-24 21:10:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3624", "CF58d2e36240afb", "13", "2021-06-25 14:55:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3625", "CF58d2e36240afb", "0", "2021-06-28 14:58:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3626", "CF58d2e36240afb", "0", "2021-06-28 17:39:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3627", "CF58d2e36240afb", "13", "2021-06-28 22:33:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3628", "CF58d2e36240afb", "13", "2021-06-29 18:15:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3629", "CF58d2e36240afb", "13", "2021-06-29 23:03:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3630", "CF58d2e36240afb", "13", "2021-06-30 17:42:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3631", "CF58d2e36240afb", "0", "2021-07-01 19:56:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3632", "CF58d2e36240afb", "0", "2021-07-01 20:04:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3633", "CF58d2e36240afb", "0", "2021-07-01 21:51:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3634", "CF58d2e36240afb", "0", "2021-07-02 15:17:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3635", "CF58d2e36240afb", "0", "2021-07-02 15:57:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3636", "CF58d2e36240afb", "13", "2021-07-02 19:12:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3637", "CF58d2e36240afb", "0", "2021-07-06 20:34:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3638", "CF58d2e36240afb", "0", "2021-07-07 18:07:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3639", "CF58d2e36240afb", "0", "2021-07-08 15:47:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3640", "CF58d2e36240afb", "0", "2021-07-08 15:53:27", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3641", "CF58d2e36240afb", "0", "2021-07-08 17:02:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3642", "CF58d2e36240afb", "0", "2021-07-13 14:43:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3643", "CF58d2e36240afb", "13", "2021-07-14 17:07:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3644", "CF58d2e36240afb", "0", "2021-07-15 14:23:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3645", "CF58d2e36240afb", "13", "2021-07-15 15:30:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3646", "CF58d2e36240afb", "13", "2021-07-15 22:30:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3647", "CF58d2e36240afb", "13", "2021-07-15 22:33:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3648", "CF58d2e36240afb", "0", "2021-07-16 14:44:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3649", "CF58d2e36240afb", "0", "2021-07-16 17:53:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3650", "CF58d2e36240afb", "0", "2021-07-16 22:58:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3651", "CF58d2e36240afb", "0", "2021-07-19 15:31:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3652", "CF58d2e36240afb", "0", "2021-07-19 17:21:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3653", "CF58d2e36240afb", "0", "2021-07-19 17:22:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3654", "CF58d2e36240afb", "0", "2021-07-19 17:31:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3655", "CF58d2e36240afb", "0", "2021-07-19 20:35:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3656", "CF58d2e36240afb", "0", "2021-07-20 15:45:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3657", "CF58d2e36240afb", "13", "2021-07-20 21:27:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3658", "CF58d2e36240afb", "13", "2021-07-21 14:39:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3659", "CF58d2e36240afb", "13", "2021-07-21 17:55:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3660", "CF58d2e36240afb", "0", "2021-07-21 18:04:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3661", "CF58d2e36240afb", "0", "2021-07-21 18:08:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3662", "CF58d2e36240afb", "13", "2021-07-21 18:23:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3663", "CF58d2e36240afb", "13", "2021-07-21 18:23:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3664", "CF58d2e36240afb", "13", "2021-07-21 18:27:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3665", "CF58d2e36240afb", "13", "2021-07-22 14:43:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3666", "CF58d2e36240afb", "13", "2021-07-22 16:45:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3667", "CF58d2e36240afb", "13", "2021-07-22 23:29:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3668", "CF58d2e36240afb", "13", "2021-07-23 15:01:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3669", "CF58d2e36240afb", "13", "2021-07-23 15:05:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3670", "CF58d2e36240afb", "13", "2021-07-23 16:55:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3671", "CF58d2e36240afb", "0", "2021-07-23 20:24:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3672", "CF58d2e36240afb", "0", "2021-07-23 20:25:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3673", "CF58d2e36240afb", "13", "2021-07-26 15:41:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3674", "CF58d2e36240afb", "13", "2021-07-26 15:43:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3675", "CF58d2e36240afb", "13", "2021-07-26 15:45:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3676", "CF58d2e36240afb", "13", "2021-07-26 15:47:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3677", "CF58d2e36240afb", "13", "2021-07-26 15:51:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3678", "CF58d2e36240afb", "0", "2021-07-26 16:07:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3679", "CF58d2e36240afb", "0", "2021-07-26 18:21:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3680", "CF58d2e36240afb", "13", "2021-07-26 18:45:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3681", "CF58d2e36240afb", "13", "2021-07-26 18:47:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3682", "CF58d2e36240afb", "0", "2021-07-26 19:29:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3683", "CF58d2e36240afb", "0", "2021-07-26 20:00:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3684", "CF58d2e36240afb", "13", "2021-07-26 20:48:25", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3685", "CF58d2e36240afb", "13", "2021-07-26 21:58:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3686", "CF58d2e36240afb", "0", "2021-07-27 14:26:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3687", "CF58d2e36240afb", "13", "2021-07-27 22:19:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3688", "CF58d2e36240afb", "13", "2021-07-27 22:21:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3689", "CF58d2e36240afb", "13", "2021-07-27 22:23:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3690", "CF58d2e36240afb", "13", "2021-07-27 22:40:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3691", "CF58d2e36240afb", "13", "2021-07-28 15:11:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3692", "CF58d2e36240afb", "13", "2021-07-28 17:04:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3693", "CF58d2e36240afb", "13", "2021-07-28 19:04:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3694", "CF58d2e36240afb", "0", "2021-07-28 21:31:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3695", "CF58d2e36240afb", "0", "2021-07-28 21:31:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3696", "CF58d2e36240afb", "0", "2021-07-28 21:32:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3697", "CF58d2e36240afb", "13", "2021-07-30 17:15:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3698", "CF58d2e36240afb", "13", "2021-07-30 17:16:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3699", "CF58d2e36240afb", "13", "2021-07-30 20:49:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3700", "CF58d2e36240afb", "13", "2021-07-30 20:50:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3701", "CF58d2e36240afb", "13", "2021-07-30 21:37:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3702", "CF58d2e36240afb", "13", "2021-07-30 22:08:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3703", "CF58d2e36240afb", "13", "2021-07-30 22:12:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3704", "CF58d2e36240afb", "13", "2021-07-30 22:18:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3705", "CF58d2e36240afb", "13", "2021-07-30 22:22:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3706", "CF58d2e36240afb", "13", "2021-07-30 22:24:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3707", "CF58d2e36240afb", "13", "2021-07-30 22:26:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3708", "CF58d2e36240afb", "13", "2021-07-30 22:29:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3709", "CF58d2e36240afb", "13", "2021-07-30 22:34:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3710", "CF58d2e36240afb", "13", "2021-07-30 22:53:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3711", "CF58d2e36240afb", "0", "2021-07-31 00:38:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3712", "CF58d2e36240afb", "13", "2021-08-02 15:59:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3713", "CF58d2e36240afb", "13", "2021-08-02 16:04:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3714", "CF58d2e36240afb", "13", "2021-08-02 17:16:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3715", "CF58d2e36240afb", "0", "2021-08-02 20:22:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3716", "CF58d2e36240afb", "0", "2021-08-02 20:25:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3717", "CF58d2e36240afb", "0", "2021-08-02 20:27:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3718", "CF58d2e36240afb", "0", "2021-08-02 20:29:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3719", "CF58d2e36240afb", "13", "2021-08-02 22:09:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3720", "CF58d2e36240afb", "0", "2021-08-03 19:20:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3721", "CF58d2e36240afb", "0", "2021-08-03 19:33:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3722", "CF58d2e36240afb", "13", "2021-08-03 22:56:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3723", "CF58d2e36240afb", "13", "2021-08-03 22:58:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3724", "CF58d2e36240afb", "0", "2021-08-04 22:39:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3725", "CF58d2e36240afb", "13", "2021-08-05 14:31:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3726", "CF58d2e36240afb", "0", "2021-08-05 15:47:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3727", "CF58d2e36240afb", "13", "2021-08-05 16:22:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3728", "CF58d2e36240afb", "13", "2021-08-05 21:11:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3729", "CF58d2e36240afb", "13", "2021-08-05 22:39:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3730", "CF58d2e36240afb", "13", "2021-08-05 23:07:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3731", "CF58d2e36240afb", "0", "2021-08-06 22:51:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3732", "CF58d2e36240afb", "0", "2021-08-06 22:52:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3733", "CF58d2e36240afb", "0", "2021-08-06 22:53:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3734", "CF58d2e36240afb", "0", "2021-08-09 22:02:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3735", "CF58d2e36240afb", "0", "2021-08-09 22:02:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3736", "CF58d2e36240afb", "0", "2021-08-09 22:09:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3737", "CF58d2e36240afb", "0", "2021-08-09 22:09:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3738", "CF58d2e36240afb", "13", "2021-08-10 22:59:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3739", "CF58d2e36240afb", "0", "2021-08-11 19:02:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3740", "CF58d2e36240afb", "13", "2021-08-11 22:50:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3741", "CF58d2e36240afb", "13", "2021-08-11 22:51:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3742", "CF58d2e36240afb", "0", "2021-08-12 15:38:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3743", "CF58d2e36240afb", "13", "2021-08-12 23:09:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3744", "CF58d2e36240afb", "13", "2021-08-13 17:02:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3745", "CF58d2e36240afb", "13", "2021-08-13 18:20:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3746", "CF58d2e36240afb", "13", "2021-08-13 18:45:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3747", "CF58d2e36240afb", "13", "2021-08-13 22:01:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3748", "CF58d2e36240afb", "13", "2021-08-13 22:45:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3749", "CF58d2e36240afb", "13", "2021-08-16 17:37:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3750", "CF58d2e36240afb", "13", "2021-08-16 17:41:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3751", "CF58d2e36240afb", "13", "2021-08-16 17:49:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3752", "CF58d2e36240afb", "13", "2021-08-16 23:00:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3753", "CF58d2e36240afb", "13", "2021-08-16 23:01:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3754", "CF58d2e36240afb", "13", "2021-08-16 23:02:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3755", "CF58d2e36240afb", "13", "2021-08-17 22:05:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3756", "CF58d2e36240afb", "13", "2021-08-17 22:32:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3757", "CF58d2e36240afb", "13", "2021-08-17 22:35:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3758", "CF58d2e36240afb", "0", "2021-08-18 17:06:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3759", "CF58d2e36240afb", "0", "2021-08-18 19:40:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3760", "CF58d2e36240afb", "0", "2021-08-18 22:53:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3761", "CF58d2e36240afb", "0", "2021-08-18 22:55:33", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3762", "CF58d2e36240afb", "13", "2021-08-19 20:15:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3763", "CF58d2e36240afb", "0", "2021-08-19 22:59:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3764", "CF58d2e36240afb", "13", "2021-08-20 17:07:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3765", "CF58d2e36240afb", "0", "2021-08-20 18:17:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3766", "CF58d2e36240afb", "13", "2021-08-20 18:20:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3767", "CF58d2e36240afb", "13", "2021-08-23 19:37:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3768", "CF58d2e36240afb", "13", "2021-08-23 19:46:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3769", "CF58d2e36240afb", "13", "2021-08-23 22:28:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3770", "CF58d2e36240afb", "13", "2021-08-24 14:48:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3771", "CF58d2e36240afb", "13", "2021-08-24 15:46:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3772", "CF58d2e36240afb", "0", "2021-08-24 16:34:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3773", "CF58d2e36240afb", "13", "2021-08-24 18:03:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3774", "CF58d2e36240afb", "13", "2021-08-24 18:11:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3775", "CF58d2e36240afb", "13", "2021-08-24 18:25:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3776", "CF58d2e36240afb", "13", "2021-08-24 18:28:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3777", "CF58d2e36240afb", "13", "2021-08-24 21:58:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3778", "CF58d2e36240afb", "13", "2021-08-24 21:59:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3779", "CF58d2e36240afb", "13", "2021-08-24 22:00:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3780", "CF58d2e36240afb", "13", "2021-08-24 22:01:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3781", "CF58d2e36240afb", "13", "2021-08-26 16:55:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3782", "CF58d2e36240afb", "13", "2021-08-26 17:14:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3783", "CF58d2e36240afb", "13", "2021-08-26 18:26:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3784", "CF58d2e36240afb", "13", "2021-08-26 18:30:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3785", "CF58d2e36240afb", "13", "2021-08-26 18:56:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3786", "CF58d2e36240afb", "13", "2021-08-26 19:05:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3787", "CF58d2e36240afb", "13", "2021-08-26 19:45:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3788", "CF58d2e36240afb", "13", "2021-08-26 19:59:31", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3789", "CF58d2e36240afb", "13", "2021-08-26 20:44:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3790", "CF58d2e36240afb", "13", "2021-08-26 22:48:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3791", "CF58d2e36240afb", "13", "2021-08-26 22:49:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3792", "CF58d2e36240afb", "13", "2021-08-26 22:50:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3793", "CF58d2e36240afb", "13", "2021-08-26 22:51:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3794", "CF58d2e36240afb", "13", "2021-08-26 23:11:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3795", "CF58d2e36240afb", "13", "2021-08-27 22:51:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3796", "CF58d2e36240afb", "13", "2021-08-27 22:52:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3797", "CF58d2e36240afb", "0", "2021-08-30 14:56:56", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3798", "CF58d2e36240afb", "0", "2021-08-30 15:27:06", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3799", "CF58d2e36240afb", "13", "2021-08-30 15:39:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3800", "CF58d2e36240afb", "0", "2021-08-30 19:40:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3801", "CF58d2e36240afb", "0", "2021-08-31 15:28:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3802", "CF58d2e36240afb", "0", "2021-08-31 17:04:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3803", "CF58d2e36240afb", "13", "2021-08-31 21:32:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3804", "CF58d2e36240afb", "0", "2021-08-31 22:34:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3805", "CF58d2e36240afb", "13", "2021-08-31 22:36:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3806", "CF58d2e36240afb", "13", "2021-08-31 22:37:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3807", "CF58d2e36240afb", "0", "2021-09-01 17:09:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3808", "CF58d2e36240afb", "0", "2021-09-01 17:34:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3809", "CF58d2e36240afb", "13", "2021-09-01 20:36:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3810", "CF58d2e36240afb", "13", "2021-09-01 22:25:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3811", "CF58d2e36240afb", "13", "2021-09-01 22:33:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3812", "CF58d2e36240afb", "0", "2021-09-01 22:34:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3813", "CF58d2e36240afb", "13", "2021-09-02 14:37:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3814", "CF58d2e36240afb", "13", "2021-09-02 14:39:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3815", "CF58d2e36240afb", "0", "2021-09-02 14:49:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3816", "CF58d2e36240afb", "0", "2021-09-02 14:51:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3817", "CF58d2e36240afb", "0", "2021-09-02 14:51:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3818", "CF58d2e36240afb", "13", "2021-09-02 17:25:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3819", "CF58d2e36240afb", "13", "2021-09-02 19:18:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3820", "CF58d2e36240afb", "13", "2021-09-02 19:21:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3821", "CF58d2e36240afb", "13", "2021-09-02 19:24:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3822", "CF58d2e36240afb", "13", "2021-09-02 19:26:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3823", "CF58d2e36240afb", "13", "2021-09-02 20:21:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3824", "CF58d2e36240afb", "13", "2021-09-02 22:31:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3825", "CF58d2e36240afb", "13", "2021-09-03 14:22:04", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3826", "CF58d2e36240afb", "13", "2021-09-03 14:22:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3827", "CF58d2e36240afb", "13", "2021-09-03 14:24:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3828", "CF58d2e36240afb", "13", "2021-09-03 16:00:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3829", "CF58d2e36240afb", "0", "2021-09-07 17:35:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3830", "CF58d2e36240afb", "13", "2021-09-08 16:40:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3831", "CF58d2e36240afb", "13", "2021-09-08 16:42:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3832", "CF58d2e36240afb", "13", "2021-09-08 16:43:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3833", "CF58d2e36240afb", "0", "2021-09-08 17:07:23", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3834", "CF58d2e36240afb", "13", "2021-09-08 20:59:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3835", "CF58d2e36240afb", "13", "2021-09-08 21:35:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3836", "CF58d2e36240afb", "13", "2021-09-08 22:38:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3837", "CF58d2e36240afb", "13", "2021-09-08 22:47:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3838", "CF58d2e36240afb", "0", "2021-09-09 14:14:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3839", "CF58d2e36240afb", "0", "2021-09-09 15:57:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3840", "CF58d2e36240afb", "13", "2021-09-09 19:47:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3841", "CF58d2e36240afb", "13", "2021-09-09 22:45:12", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3842", "CF58d2e36240afb", "13", "2021-09-09 22:46:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3843", "CF58d2e36240afb", "13", "2021-09-09 22:46:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3844", "CF58d2e36240afb", "13", "2021-09-09 22:47:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3845", "CF58d2e36240afb", "13", "2021-09-09 22:48:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3846", "CF58d2e36240afb", "13", "2021-09-10 15:14:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3847", "CF58d2e36240afb", "0", "2021-09-10 17:24:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3848", "CF58d2e36240afb", "0", "2021-09-10 19:34:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3849", "CF58d2e36240afb", "0", "2021-09-10 21:25:09", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3850", "CF58d2e36240afb", "0", "2021-09-10 21:40:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3851", "CF58d2e36240afb", "0", "2021-09-13 15:10:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3852", "CF58d2e36240afb", "13", "2021-09-13 15:33:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3853", "CF58d2e36240afb", "13", "2021-09-13 15:48:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3854", "CF58d2e36240afb", "13", "2021-09-13 20:02:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3855", "CF58d2e36240afb", "0", "2021-09-13 22:51:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3856", "CF58d2e36240afb", "13", "2021-09-14 16:01:22", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3857", "CF58d2e36240afb", "13", "2021-09-14 17:05:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3858", "CF58d2e36240afb", "13", "2021-09-14 22:05:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3859", "CF58d2e36240afb", "13", "2021-09-15 17:57:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3860", "CF58d2e36240afb", "0", "2021-09-16 22:11:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3861", "CF58d2e36240afb", "0", "2021-09-17 15:15:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3862", "CF58d2e36240afb", "0", "2021-09-17 15:22:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3863", "CF58d2e36240afb", "0", "2021-09-17 19:37:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3864", "CF58d2e36240afb", "0", "2021-09-20 16:11:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3865", "CF58d2e36240afb", "0", "2021-09-20 17:36:08", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3866", "CF58d2e36240afb", "0", "2021-09-20 17:38:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3867", "CF58d2e36240afb", "0", "2021-09-20 17:40:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3868", "CF58d2e36240afb", "13", "2021-09-20 20:56:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3869", "CF58d2e36240afb", "0", "2021-09-20 22:33:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3870", "CF58d2e36240afb", "13", "2021-09-21 16:46:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3871", "CF58d2e36240afb", "13", "2021-09-21 18:55:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3872", "CF58d2e36240afb", "0", "2021-09-22 16:35:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3873", "CF58d2e36240afb", "0", "2021-09-22 22:44:51", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3874", "CF58d2e36240afb", "0", "2021-09-23 16:17:03", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3875", "CF58d2e36240afb", "0", "2021-09-23 16:42:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3876", "CF58d2e36240afb", "0", "2021-09-23 19:33:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3877", "CF58d2e36240afb", "0", "2021-09-24 15:47:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3878", "CF58d2e36240afb", "0", "2021-09-24 15:50:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3879", "CF58d2e36240afb", "0", "2021-09-24 17:59:01", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3880", "CF58d2e36240afb", "0", "2021-09-27 18:45:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3881", "CF58d2e36240afb", "13", "2021-09-27 23:50:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3882", "CF58d2e36240afb", "13", "2021-09-28 14:45:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3883", "CF58d2e36240afb", "13", "2021-09-28 19:15:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3884", "CF58d2e36240afb", "13", "2021-09-29 14:46:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3885", "CF58d2e36240afb", "13", "2021-09-29 21:25:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3886", "CF58d2e36240afb", "0", "2021-09-30 22:32:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3887", "CF58d2e36240afb", "13", "2021-10-01 17:45:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3888", "CF58d2e36240afb", "0", "2021-10-01 18:11:20", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3889", "CF58d2e36240afb", "13", "2021-10-01 18:22:35", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3890", "CF58d2e36240afb", "13", "2021-10-01 20:13:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3891", "CF58d2e36240afb", "13", "2021-10-01 20:50:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3892", "CF58d2e36240afb", "13", "2021-10-01 22:13:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3893", "CF58d2e36240afb", "13", "2021-10-01 22:16:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3894", "CF58d2e36240afb", "13", "2021-10-01 22:17:00", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3895", "CF58d2e36240afb", "13", "2021-10-04 17:21:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3896", "CF58d2e36240afb", "0", "2021-10-04 18:33:30", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3897", "CF58d2e36240afb", "0", "2021-10-05 14:22:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3898", "CF58d2e36240afb", "0", "2021-10-05 15:27:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3899", "CF58d2e36240afb", "0", "2021-10-05 16:15:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3900", "CF58d2e36240afb", "13", "2021-10-05 23:22:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3901", "CF58d2e36240afb", "13", "2021-10-08 15:54:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3902", "CF58d2e36240afb", "13", "2021-10-08 15:59:47", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3903", "CF58d2e36240afb", "13", "2021-10-08 16:02:53", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3904", "CF58d2e36240afb", "13", "2021-10-08 16:07:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3905", "CF58d2e36240afb", "13", "2021-10-08 16:13:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3906", "CF58d2e36240afb", "13", "2021-10-08 16:16:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3907", "CF58d2e36240afb", "13", "2021-10-08 16:17:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3908", "CF58d2e36240afb", "13", "2021-10-08 16:19:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3909", "CF58d2e36240afb", "13", "2021-10-08 16:23:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3910", "CF58d2e36240afb", "13", "2021-10-08 16:25:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3911", "CF58d2e36240afb", "13", "2021-10-08 22:10:32", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3912", "CF58d2e36240afb", "13", "2021-10-11 17:56:26", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3913", "CF58d2e36240afb", "13", "2021-10-11 20:49:52", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3914", "CF58d2e36240afb", "13", "2021-10-11 22:28:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3915", "CF58d2e36240afb", "13", "2021-10-12 14:09:34", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3916", "CF58d2e36240afb", "13", "2021-10-12 17:07:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3917", "CF58d2e36240afb", "13", "2021-10-12 19:28:15", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3918", "CF58d2e36240afb", "13", "2021-10-13 15:18:14", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3919", "CF58d2e36240afb", "13", "2021-10-13 16:06:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3920", "CF58d2e36240afb", "13", "2021-10-13 16:08:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3921", "CF58d2e36240afb", "13", "2021-10-13 16:12:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3922", "CF58d2e36240afb", "13", "2021-10-14 20:46:41", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3923", "CF58d2e36240afb", "13", "2021-10-14 20:54:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3924", "CF58d2e36240afb", "13", "2021-10-14 22:30:55", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3925", "CF58d2e36240afb", "13", "2021-10-15 15:36:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3926", "CF58d2e36240afb", "13", "2021-10-15 15:41:57", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3927", "CF58d2e36240afb", "13", "2021-10-15 15:44:05", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3928", "CF58d2e36240afb", "13", "2021-10-15 15:45:44", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3929", "CF58d2e36240afb", "13", "2021-10-15 15:47:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3930", "CF58d2e36240afb", "13", "2021-10-15 19:48:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3931", "CF58d2e36240afb", "0", "2021-10-18 14:54:19", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3932", "CF58d2e36240afb", "13", "2021-10-18 18:17:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3933", "CF58d2e36240afb", "13", "2021-10-18 18:24:29", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3934", "CF58d2e36240afb", "13", "2021-10-18 18:27:49", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3935", "CF58d2e36240afb", "13", "2021-10-18 18:44:11", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3936", "CF58d2e36240afb", "13", "2021-10-18 21:39:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3937", "CF58d2e36240afb", "13", "2021-10-18 22:19:43", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3938", "CF58d2e36240afb", "13", "2021-10-19 15:44:45", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3939", "CF58d2e36240afb", "13", "2021-10-19 15:48:54", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3940", "CF58d2e36240afb", "13", "2021-10-19 15:51:21", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3941", "CF58d2e36240afb", "13", "2021-10-19 15:53:02", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3942", "CF58d2e36240afb", "13", "2021-10-19 15:57:59", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3943", "CF58d2e36240afb", "13", "2021-10-19 17:50:24", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3944", "CF58d2e36240afb", "13", "2021-10-19 17:56:36", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3945", "CF58d2e36240afb", "13", "2021-10-19 19:14:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3946", "CF58d2e36240afb", "13", "2021-10-20 16:35:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3947", "CF58d2e36240afb", "13", "2021-10-20 16:38:58", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3948", "CF58d2e36240afb", "13", "2021-10-20 16:41:40", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3949", "CF58d2e36240afb", "13", "2021-10-20 20:36:10", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3950", "CF58d2e36240afb", "0", "2021-10-20 21:19:38", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3951", "CF58d2e36240afb", "0", "2021-10-20 21:22:50", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3952", "CF58d2e36240afb", "13", "2021-10-20 22:59:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3953", "CF58d2e36240afb", "13", "2021-10-21 15:55:48", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3954", "CF58d2e36240afb", "13", "2021-10-21 19:13:18", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3955", "CF58d2e36240afb", "13", "2021-10-21 22:23:17", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3956", "CF58d2e36240afb", "13", "2021-10-21 22:51:39", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3957", "CF58d2e36240afb", "13", "2021-10-21 22:54:07", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3958", "CF58d2e36240afb", "13", "2021-10-22 15:29:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3959", "CF58d2e36240afb", "0", "2021-10-25 17:48:46", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3960", "CF58d2e36240afb", "0", "2021-10-25 17:55:28", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3961", "CF58d2e36240afb", "13", "2021-10-25 17:56:13", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3962", "CF58d2e36240afb", "0", "2021-10-25 18:01:37", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3963", "CF58d2e36240afb", "0", "2021-10-27 16:24:42", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3964", "CF58d2e36240afb", "13", "2021-10-27 22:37:16", "active");
INSERT INTO `itwp_cf_form_entries` VALUES("3965", "CF58d2e36240afb", "13", "2021-10-28 20:55:46", "active");

/* INSERT TABLE DATA: itwp_cf_form_entry_values */
INSERT INTO `itwp_cf_form_entry_values` VALUES("3166", "326", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3167", "326", "fld_9970286", "user", "Test Jane Doe");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3168", "326", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3169", "326", "fld_7683514", "computer", "Test Computer from Marina - Can disregard ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3170", "326", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3201", "330", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3202", "330", "fld_9970286", "user", "Jeff Wenzel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3203", "330", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3204", "330", "fld_1632208", "business_name", "RPT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3205", "330", "fld_7683514", "computer", "RPT147");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3206", "330", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3218", "332", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3219", "332", "fld_9970286", "user", "Linda Strauss");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3220", "332", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3221", "332", "fld_7683514", "computer", "Linda Strauss Macbook");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3222", "332", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3223", "333", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3224", "333", "fld_9970286", "user", "Trula Berg");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3225", "333", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3226", "333", "fld_7683514", "computer", "bookkeeping");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3227", "333", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3228", "334", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3229", "334", "fld_9970286", "user", "Administrator");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3230", "334", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3231", "334", "fld_1632208", "business_name", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3232", "334", "fld_7683514", "computer", "UCC Server01-RDS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3233", "334", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3234", "335", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3235", "335", "fld_9970286", "user", "Administrator");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3236", "335", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3237", "335", "fld_1632208", "business_name", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3238", "335", "fld_7683514", "computer", "UCC Server03 SQL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3239", "335", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3240", "336", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3241", "336", "fld_9970286", "user", "Administrator");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3242", "336", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3243", "336", "fld_1632208", "business_name", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3244", "336", "fld_7683514", "computer", "UCC Server 01 DC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3245", "336", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3455", "358", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3456", "358", "fld_9970286", "user", "Cindy O\\\'Neill");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3457", "358", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3458", "358", "fld_7683514", "computer", "ONEILL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3459", "358", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3557", "370", "fld_8768091", "tech", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3558", "370", "fld_9970286", "user", "Don Darling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3559", "370", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3560", "370", "fld_1632208", "business_name", "Darling Enterprise");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3561", "370", "fld_7683514", "computer", "Don-Darling-lpt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3562", "370", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3741", "391", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3742", "391", "fld_9970286", "user", "Don Darling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3743", "391", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3744", "391", "fld_1632208", "business_name", "Darling Enterprise");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3745", "391", "fld_7683514", "computer", "Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3746", "391", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3842", "403", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3843", "403", "fld_9970286", "user", "Don Darling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3844", "403", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3845", "403", "fld_1632208", "business_name", "Darling Ent");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3846", "403", "fld_7683514", "computer", "Server / Re-Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3847", "403", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3899", "410", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3900", "410", "fld_9970286", "user", "Kevin Koustik");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3901", "410", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3902", "410", "fld_1632208", "business_name", "Rapid Pro Tooling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3903", "410", "fld_7683514", "computer", "RPT 140");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3904", "410", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3921", "413", "fld_8151635", "technician.opt1293349", "Jack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3922", "413", "fld_8151635", "technician", "{\"opt1293349\":\"Jack\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3923", "413", "fld_165241", "date_of_work", "2018-01-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3924", "413", "fld_7309777", "hours_spent", "2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3925", "413", "fld_42616", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3926", "413", "fld_8427909", "client_or_company", "Internal");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3927", "413", "fld_2572136", "description_of_work_completed", "testing");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3928", "413", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3929", "414", "fld_8151635", "technician.opt1579209", "Theodis");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3930", "414", "fld_8151635", "technician", "{\"opt1579209\":\"Theodis\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3931", "414", "fld_165241", "date_of_work", "2018-01-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3932", "414", "fld_7309777", "hours_spent", "6");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3933", "414", "fld_42616", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3934", "414", "fld_8427909", "client_or_company", "Internal");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3935", "414", "fld_2572136", "description_of_work_completed", "test 2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3936", "414", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3937", "415", "fld_8151635", "technician.opt1315837", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3938", "415", "fld_8151635", "technician", "{\"opt1315837\":\"Brad\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3939", "415", "fld_165241", "date_of_work", "2018-01-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3940", "415", "fld_7309777", "hours_spent", "6");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3941", "415", "fld_42616", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3942", "415", "fld_8427909", "client_or_company", "Internal");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3943", "415", "fld_2572136", "description_of_work_completed", "test");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3944", "415", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3990", "421", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3991", "421", "fld_9970286", "user", "Terry Rizzuti");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3992", "421", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3993", "421", "fld_7683514", "computer", "DESKTOP-U4J5S07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("3994", "421", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4058", "429", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4059", "429", "fld_9970286", "user", "Jerry Baer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4060", "429", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4061", "429", "fld_7683514", "computer", "Jerry-Baer-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4062", "429", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4154", "441", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4155", "441", "fld_9970286", "user", "Jim Bolskar");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4156", "441", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4157", "441", "fld_7683514", "computer", "loft");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4158", "441", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4207", "447", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4208", "447", "fld_9970286", "user", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4209", "447", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4210", "447", "fld_1632208", "business_name", "High Plains Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4211", "447", "fld_7683514", "computer", "Jim-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4212", "447", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4213", "448", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4214", "448", "fld_9970286", "user", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4215", "448", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4216", "448", "fld_1632208", "business_name", "High Plains Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4217", "448", "fld_7683514", "computer", "Front-LTP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4218", "448", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4219", "449", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4220", "449", "fld_9970286", "user", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4221", "449", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4222", "449", "fld_1632208", "business_name", "High Plains Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4223", "449", "fld_7683514", "computer", "Intern-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4224", "449", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4225", "450", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4226", "450", "fld_9970286", "user", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4227", "450", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4228", "450", "fld_1632208", "business_name", "High Plains Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4229", "450", "fld_7683514", "computer", "Evan-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4230", "450", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4231", "451", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4232", "451", "fld_9970286", "user", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4233", "451", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4234", "451", "fld_1632208", "business_name", "High Plains Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4235", "451", "fld_7683514", "computer", "Classroom-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4236", "451", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4303", "458", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4304", "458", "fld_9970286", "user", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4305", "458", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4306", "458", "fld_1632208", "business_name", "Colorado Youth Outdoors");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4307", "458", "fld_7683514", "computer", "CYO-LTP-1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4308", "458", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4350", "464", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4351", "464", "fld_9970286", "user", "Rodeway Front 1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4352", "464", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4353", "464", "fld_1632208", "business_name", "RWI");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4354", "464", "fld_7683514", "computer", "rodewayevans-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4355", "464", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4356", "465", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4357", "465", "fld_9970286", "user", "Mike GM");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4358", "465", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4359", "465", "fld_1632208", "business_name", "RWI");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4360", "465", "fld_7683514", "computer", "EVANS-GM");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4361", "465", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4362", "466", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4363", "466", "fld_9970286", "user", "RWI Front 2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4364", "466", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4365", "466", "fld_1632208", "business_name", "RWI");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4366", "466", "fld_7683514", "computer", "co303-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4367", "466", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4368", "467", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4369", "467", "fld_9970286", "user", "Cheryl Cottrell");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4370", "467", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4371", "467", "fld_7683514", "computer", "Laptop-S517");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4372", "467", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4373", "468", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4374", "468", "fld_9970286", "user", "E&T Assistant HR");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4375", "468", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4376", "468", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4377", "468", "fld_7683514", "computer", "Desktop-NTSQH");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4378", "468", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4379", "469", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4380", "469", "fld_9970286", "user", "E&T Mario");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4381", "469", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4382", "469", "fld_1632208", "business_name", "E &T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4383", "469", "fld_7683514", "computer", "etdell2-pc");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4384", "469", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4385", "470", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4386", "470", "fld_9970286", "user", "Tony PC2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4387", "470", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4388", "470", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4389", "470", "fld_7683514", "computer", "tony-pc02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4390", "470", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4391", "471", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4392", "471", "fld_9970286", "user", "Amanda");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4393", "471", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4394", "471", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4395", "471", "fld_7683514", "computer", "RECEP1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4396", "471", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4397", "472", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4398", "472", "fld_9970286", "user", "Melissa");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4399", "472", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4400", "472", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4401", "472", "fld_7683514", "computer", "ACCOUNTING-DESK");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4402", "472", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4403", "473", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4404", "473", "fld_9970286", "user", "Angel Guzman");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4405", "473", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4406", "473", "fld_1632208", "business_name", "E & T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4407", "473", "fld_7683514", "computer", "geo-pc");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4408", "473", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4409", "474", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4410", "474", "fld_9970286", "user", "Roxanne");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4411", "474", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4412", "474", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4413", "474", "fld_7683514", "computer", "ETELECTRIC1-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4414", "474", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4415", "475", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4416", "475", "fld_9970286", "user", "HR");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4417", "475", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4418", "475", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4419", "475", "fld_7683514", "computer", "DESKTOP-36NTSQH");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4420", "475", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4421", "476", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4422", "476", "fld_9970286", "user", "ET Tony Regalado");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4423", "476", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4424", "476", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4425", "476", "fld_7683514", "computer", "Jose-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4426", "476", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4436", "478", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4437", "478", "fld_9970286", "user", "Tony Regalado");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4438", "478", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4439", "478", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4440", "478", "fld_7683514", "computer", "Tony-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4441", "478", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4442", "479", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4443", "479", "fld_9970286", "user", "Luisa Cruz");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4444", "479", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4445", "479", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4446", "479", "fld_7683514", "computer", "Luisa-TX");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4447", "479", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4527", "489", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4528", "489", "fld_9970286", "user", "AndyPeterson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4529", "489", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4530", "489", "fld_1632208", "business_name", "Peterson Energy Mngt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4531", "489", "fld_7683514", "computer", "AndyPeterson-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4532", "489", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4533", "490", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4534", "490", "fld_9970286", "user", "Jim Bolskar");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4535", "490", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4536", "490", "fld_7683514", "computer", "Jimbolskar");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4537", "490", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4596", "498", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4597", "498", "fld_9970286", "user", "Vincent Towers");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4598", "498", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4599", "498", "fld_7683514", "computer", "vincenttowerspc");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4600", "498", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4601", "499", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4602", "499", "fld_9970286", "user", "Susan Albern");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4603", "499", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4604", "499", "fld_7683514", "computer", "SUSANALBERNLPT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4605", "499", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4614", "501", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4615", "501", "fld_9970286", "user", "Test");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4616", "501", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4617", "501", "fld_7683514", "computer", "test");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4618", "501", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4627", "503", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4628", "503", "fld_9970286", "user", "Dena Simmons");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4629", "503", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4630", "503", "fld_1632208", "business_name", "Vitality Chiropractic");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4631", "503", "fld_7683514", "computer", "User");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4632", "503", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4701", "511", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4702", "511", "fld_9970286", "user", "Mary Banken");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4703", "511", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4704", "511", "fld_7683514", "computer", "Mary-HP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4705", "511", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4847", "528", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4848", "528", "fld_9970286", "user", "VIC NW Lpt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4849", "528", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4850", "528", "fld_1632208", "business_name", "Vic Southwest");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4851", "528", "fld_7683514", "computer", "Vic-laptop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4852", "528", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4853", "528", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4854", "529", "fld_8768091", "tech", "Marina");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4855", "529", "fld_9970286", "user", "Paul Opler");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4856", "529", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4857", "529", "fld_7683514", "computer", "POpler-Lpt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4858", "529", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4859", "529", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4946", "538", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4947", "538", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4948", "538", "fld_9970286", "user", "Ben Cleay");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4949", "538", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4950", "538", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4951", "538", "fld_7683514", "computer", "Ben-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4952", "538", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4953", "539", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4954", "539", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4955", "539", "fld_9970286", "user", "Debbie Bakel Dell Laptop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4956", "539", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4957", "539", "fld_7683514", "computer", "ncec-support");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4958", "539", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4959", "540", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4960", "540", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4961", "540", "fld_9970286", "user", "SMWP Server RDS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4962", "540", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4963", "540", "fld_1632208", "business_name", "SMWP Texas");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4964", "540", "fld_7683514", "computer", "Server-02 RDS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("4965", "540", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5094", "554", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5095", "554", "fld_9970286", "user", "Megan Duncan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5096", "554", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5097", "554", "fld_7683514", "computer", "Megan-Laptop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5098", "554", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5108", "556", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5109", "556", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5110", "556", "fld_9970286", "user", "Lynn Harris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5111", "556", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5112", "556", "fld_1632208", "business_name", "Lynn Harris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5113", "556", "fld_7683514", "computer", "LynnHarris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5114", "556", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5115", "557", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5116", "557", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5117", "557", "fld_9970286", "user", "Debbie Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5118", "557", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5119", "557", "fld_1632208", "business_name", "Debbie Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5120", "557", "fld_7683514", "computer", "MG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5121", "557", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5122", "558", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5123", "558", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5124", "558", "fld_9970286", "user", "VIC Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5125", "558", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5126", "558", "fld_1632208", "business_name", "VIC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5127", "558", "fld_7683514", "computer", "VI-HP800");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5128", "558", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5354", "582", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5355", "582", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5356", "582", "fld_9970286", "user", "Jerry Gates");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5357", "582", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5358", "582", "fld_1632208", "business_name", "Egg n I, Windsor");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5359", "582", "fld_7683514", "computer", "EGG10MGRWK");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5360", "582", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5361", "583", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5362", "583", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5363", "583", "fld_9970286", "user", "Jerry Gates");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5364", "583", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5365", "583", "fld_1632208", "business_name", "E&I");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5366", "583", "fld_7683514", "computer", "SAME");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5367", "583", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5452", "593", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5453", "593", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5454", "593", "fld_9970286", "user", "Juan Mohr");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5455", "593", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5456", "593", "fld_7683514", "computer", "JuanMohr-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5457", "593", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5563", "605", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5564", "605", "fld_9970286", "user", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5565", "605", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5566", "605", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5567", "605", "fld_7683514", "computer", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5568", "605", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5569", "606", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5570", "606", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5571", "606", "fld_9970286", "user", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5572", "606", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5573", "606", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5574", "606", "fld_7683514", "computer", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5575", "606", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5576", "607", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5577", "607", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5578", "607", "fld_9970286", "user", "Bob Hewson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5579", "607", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5580", "607", "fld_1632208", "business_name", "Colorado Youth Outdoors");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5581", "607", "fld_7683514", "computer", "BobHewson-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5582", "607", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5611", "611", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5612", "611", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5613", "611", "fld_9970286", "user", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5614", "611", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5615", "611", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5616", "611", "fld_7683514", "computer", "Bench-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5617", "611", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5801", "631", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5802", "631", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5803", "631", "fld_9970286", "user", "Thomas Beck New Graviton");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5804", "631", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5805", "631", "fld_1632208", "business_name", "TW Beck");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5806", "631", "fld_7683514", "computer", "TWBeck2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5807", "631", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5808", "632", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5809", "632", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5810", "632", "fld_9970286", "user", "Thomas Beck Ion");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5811", "632", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5812", "632", "fld_1632208", "business_name", "TW Beck");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5813", "632", "fld_7683514", "computer", "Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5814", "632", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5862", "638", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5863", "638", "fld_9970286", "user", "Philip Colson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5864", "638", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5865", "638", "fld_7683514", "computer", "MYPERSONALPC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5866", "638", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5946", "647", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5947", "647", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5948", "647", "fld_9970286", "user", "Dennis & becky Knoop EP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5949", "647", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5950", "647", "fld_7683514", "computer", "Knoop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("5951", "647", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6497", "703", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6498", "703", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6499", "703", "fld_9970286", "user", "EVLT Mary Banken");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6500", "703", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6501", "703", "fld_1632208", "business_name", "EVLT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6502", "703", "fld_7683514", "computer", "MaryBanken-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6503", "703", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6925", "747", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6926", "747", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6927", "747", "fld_9970286", "user", "Stephen Kaspar");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6928", "747", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6929", "747", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6930", "747", "fld_7683514", "computer", "StephenKaspar-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("6931", "747", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7049", "759", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7050", "759", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7051", "759", "fld_9970286", "user", "Brandon");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7052", "759", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7053", "759", "fld_1632208", "business_name", "RPT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7054", "759", "fld_7683514", "computer", "RPT119");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7055", "759", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7363", "790", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7364", "790", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7365", "790", "fld_9970286", "user", "Robert Drage");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7366", "790", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7367", "790", "fld_7683514", "computer", "RobertDrage-LTP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7368", "790", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7476", "802", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7477", "802", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7478", "802", "fld_9970286", "user", "Lois Giordano");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7479", "802", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7480", "802", "fld_7683514", "computer", "LoisGiordano-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7481", "802", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7596", "815", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7597", "815", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7598", "815", "fld_9970286", "user", "Tom Giordano");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7599", "815", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7600", "815", "fld_7683514", "computer", "TomGiordano-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7601", "815", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7602", "816", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7603", "816", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7604", "816", "fld_9970286", "user", "Lois Giordano");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7605", "816", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7606", "816", "fld_7683514", "computer", "LoisGiordano-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7607", "816", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7648", "821", "fld_8768091", "tech", "Ben");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7649", "821", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7650", "821", "fld_9970286", "user", "MRL Front 1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7651", "821", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7652", "821", "fld_1632208", "business_name", "MRL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7653", "821", "fld_7683514", "computer", "MRL-FRONT1-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7654", "821", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7801", "837", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7802", "837", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7803", "837", "fld_9970286", "user", "Mike Veeman");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7804", "837", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7805", "837", "fld_7683514", "computer", "Veeman-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("7806", "837", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8129", "871", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8130", "871", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8131", "871", "fld_9970286", "user", "Andy Peterson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8132", "871", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8133", "871", "fld_1632208", "business_name", "Peterson Energy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8134", "871", "fld_7683514", "computer", "IPT0209");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8135", "871", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8136", "872", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8137", "872", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8138", "872", "fld_9970286", "user", "Andy Peterson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8139", "872", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8140", "872", "fld_1632208", "business_name", "Peterson ENergy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8141", "872", "fld_7683514", "computer", "Andy-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8142", "872", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8889", "948", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8890", "948", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8891", "948", "fld_9970286", "user", "Jim Linden");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8892", "948", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8893", "948", "fld_7683514", "computer", "JIM-LINDEN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8894", "948", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8905", "950", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8906", "950", "fld_9970286", "user", "Franco Guerri");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8907", "950", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8908", "950", "fld_7683514", "computer", "FRANCO-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("8909", "950", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9061", "967", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9062", "967", "fld_9970286", "user", "Lauren Anderson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9063", "967", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9064", "967", "fld_7683514", "computer", "LaurenA-LPT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9065", "967", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9175", "979", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9176", "979", "fld_9970286", "user", "Tony");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9177", "979", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9178", "979", "fld_7683514", "computer", "DESKTOP-ST9NKBP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9179", "979", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9228", "985", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9229", "985", "fld_9970286", "user", "Russ Zoetewey");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9230", "985", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9231", "985", "fld_7683514", "computer", "RussZoetewey-LTP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9232", "985", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9261", "989", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9262", "989", "fld_9970286", "user", "VerNett Timko");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9263", "989", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9264", "989", "fld_7683514", "computer", "VerNettTimko-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9265", "989", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9286", "992", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9287", "992", "fld_9970286", "user", "Andrea Hall ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9288", "992", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9289", "992", "fld_7683514", "computer", "AndreaHall-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9290", "992", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9392", "1003", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9393", "1003", "fld_9970286", "user", "Brian Steyaert");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9394", "1003", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9395", "1003", "fld_7683514", "computer", "bsteyaert-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9396", "1003", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9426", "1007", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9427", "1007", "fld_9970286", "user", "Jose Aguire");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9428", "1007", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9429", "1007", "fld_7683514", "computer", "JoseAguire-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9430", "1007", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9462", "1011", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9463", "1011", "fld_9970286", "user", "Shelby Kahl");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9464", "1011", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9465", "1011", "fld_1632208", "business_name", "Shelby Kahl Dentistry ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9466", "1011", "fld_7683514", "computer", "FrontDesk-DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9467", "1011", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9506", "1016", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9507", "1016", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9508", "1016", "fld_9970286", "user", "Jeff Davis");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9509", "1016", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9510", "1016", "fld_7683514", "computer", "JeffDavis-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9511", "1016", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9531", "1019", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9532", "1019", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9533", "1019", "fld_9970286", "user", "Nancy & Don Skaggs");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9534", "1019", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9535", "1019", "fld_7683514", "computer", "Skaggs-DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9536", "1019", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9537", "1020", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9538", "1020", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9539", "1020", "fld_9970286", "user", "Server-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9540", "1020", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9541", "1020", "fld_1632208", "business_name", "Village Optical");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9542", "1020", "fld_7683514", "computer", "Server-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9543", "1020", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9562", "1023", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9563", "1023", "fld_9970286", "user", "Sara EP Auto");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9564", "1023", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9565", "1023", "fld_7683514", "computer", "EPAutoSara-DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9566", "1023", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9576", "1025", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9577", "1025", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9578", "1025", "fld_9970286", "user", "Joe Wilson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9579", "1025", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9580", "1025", "fld_1632208", "business_name", "CES Industrial");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9581", "1025", "fld_7683514", "computer", "JOE");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9582", "1025", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9736", "1041", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9737", "1041", "fld_9970286", "user", "Helen Helfrich");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9738", "1041", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9739", "1041", "fld_7683514", "computer", "Helfrich-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9740", "1041", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9869", "1055", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9870", "1055", "fld_9970286", "user_first", "Front ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9871", "1055", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9872", "1055", "fld_1632208", "business_name", "ABVI ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9873", "1055", "fld_7683514", "computer", "ABVI Front 1 DTC ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9874", "1055", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9875", "1055", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9876", "1055", "fld_105264", "user_last", "Computer 1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9877", "1055", "fld_9881575", "phone", "970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9878", "1056", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9879", "1056", "fld_9970286", "user_first", "Front");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9880", "1056", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9881", "1056", "fld_1632208", "business_name", "ABVI ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9882", "1056", "fld_7683514", "computer", "ABVI Front 2 DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9883", "1056", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9884", "1056", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9885", "1056", "fld_105264", "user_last", "Computer 2 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9886", "1056", "fld_9881575", "phone", "970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9887", "1057", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9888", "1057", "fld_9970286", "user_first", "Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9889", "1057", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9890", "1057", "fld_1632208", "business_name", "ABVI ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9891", "1057", "fld_7683514", "computer", "ABVI Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9892", "1057", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9893", "1057", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9894", "1057", "fld_105264", "user_last", "Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9895", "1057", "fld_9881575", "phone", "970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9925", "1061", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9926", "1061", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9927", "1061", "fld_9970286", "user_first", "Rosemary");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9928", "1061", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9929", "1061", "fld_7683514", "computer", "RosemaryBaer-DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9930", "1061", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9931", "1061", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9932", "1061", "fld_4368227", "users_last", "Baer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("9933", "1061", "fld_5435180", "phone", "970-231-1568");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10124", "1082", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10125", "1082", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10126", "1082", "fld_9970286", "user_first", "Mario");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10127", "1082", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10128", "1082", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10129", "1082", "fld_7683514", "computer", "Desktop-8C8LMHT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10130", "1082", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10131", "1082", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10132", "1082", "fld_4368227", "users_last", "Alfaro");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10133", "1082", "fld_5435180", "phone", "818-259-1702");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10134", "1083", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10135", "1083", "fld_9970286", "user_first", "Mario");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10136", "1083", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10137", "1083", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10138", "1083", "fld_7683514", "computer", "Desktop-8C8LMHT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10139", "1083", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10140", "1083", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10141", "1083", "fld_105264", "user_last", "Alfaro");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10142", "1083", "fld_9881575", "phone", "818-259-1702");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10275", "1098", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10276", "1098", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10277", "1098", "fld_9970286", "user_first", "TESY");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10278", "1098", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10279", "1098", "fld_1632208", "business_name", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10280", "1098", "fld_7683514", "computer", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10281", "1098", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10282", "1098", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10283", "1098", "fld_4368227", "users_last", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10284", "1098", "fld_5435180", "phone", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10285", "1099", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10286", "1099", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10287", "1099", "fld_9970286", "user_first", "Rapid");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10288", "1099", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10289", "1099", "fld_1632208", "business_name", "Rapid Pro Tooling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10290", "1099", "fld_7683514", "computer", "RPT151");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10291", "1099", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10292", "1099", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10293", "1099", "fld_4368227", "users_last", "Rapid");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10294", "1099", "fld_5435180", "phone", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10343", "1105", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10344", "1105", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10345", "1105", "fld_9970286", "user_first", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10346", "1105", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10347", "1105", "fld_7683514", "computer", "Kevin-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10348", "1105", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10349", "1105", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10350", "1105", "fld_4368227", "users_last", "Bridgman");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10351", "1105", "fld_5435180", "phone", "9706631200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10855", "1156", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10856", "1156", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10857", "1156", "fld_9970286", "user_first", "Mike");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10858", "1156", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10859", "1156", "fld_1632208", "business_name", "Green Earth Enviromental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10860", "1156", "fld_7683514", "computer", "1GXJFZ1-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10861", "1156", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10862", "1156", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10863", "1156", "fld_4368227", "users_last", "Cook");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10864", "1156", "fld_5435180", "phone", "9705879853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10865", "1157", "fld_8768091", "tech", "Will");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10866", "1157", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10867", "1157", "fld_9970286", "user_first", "Debbie");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10868", "1157", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10869", "1157", "fld_7683514", "computer", "Debbie Bakel DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10870", "1157", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10871", "1157", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10872", "1157", "fld_4368227", "users_last", "Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10873", "1157", "fld_5435180", "phone", "9706312021");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10874", "1158", "fld_8768091", "tech", "Will");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10875", "1158", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10876", "1158", "fld_9970286", "user_first", "Debbie");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10877", "1158", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10878", "1158", "fld_7683514", "computer", "Debbie Bakel DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10879", "1158", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10880", "1158", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10881", "1158", "fld_4368227", "users_last", "Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("10882", "1158", "fld_5435180", "phone", "9706312021");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11901", "1265", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11902", "1265", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11903", "1265", "fld_9970286", "user_first", "Cindy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11904", "1265", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11905", "1265", "fld_7683514", "computer", "CIndyO\\\'Neill HP DTC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11906", "1265", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11907", "1265", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11908", "1265", "fld_4368227", "users_last", "O\\\'Neill");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11909", "1265", "fld_5435180", "phone", "970-218-1885");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11920", "1267", "fld_8768091", "tech", "Chuck");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11921", "1267", "fld_9970286", "user_first", "Cathy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11922", "1267", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11923", "1267", "fld_7683514", "computer", "Unknown / user install #1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11924", "1267", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11925", "1267", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11926", "1267", "fld_105264", "user_last", "Bain");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11927", "1267", "fld_9881575", "phone", "970-231-9021");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11928", "1268", "fld_8768091", "tech", "Chuck");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11929", "1268", "fld_9970286", "user_first", "Cathy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11930", "1268", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11931", "1268", "fld_7683514", "computer", "Unknown / user install #2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11932", "1268", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11933", "1268", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11934", "1268", "fld_105264", "user_last", "Bain");
INSERT INTO `itwp_cf_form_entry_values` VALUES("11935", "1268", "fld_9881575", "phone", "970-231-9021");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12006", "1276", "fld_8768091", "tech", "Dan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12007", "1276", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12008", "1276", "fld_9970286", "user_first", "Georgette");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12009", "1276", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12010", "1276", "fld_7683514", "computer", "Georgette Rose LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12011", "1276", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12012", "1276", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12013", "1276", "fld_4368227", "users_last", "Rose");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12014", "1276", "fld_5435180", "phone", "970-817-0523");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12134", "1289", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12135", "1289", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12136", "1289", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12137", "1289", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12138", "1289", "fld_9970286", "user_first", "Melissa");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12139", "1289", "fld_5435180", "phone", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12140", "1289", "fld_4368227", "users_last", "richardson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12141", "1289", "fld_1632208", "business_name", "Advance Tank and Construction");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12142", "1289", "fld_7683514", "computer", "AT-MRICHARDSON");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12143", "1289", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12396", "1315", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12397", "1315", "fld_9766490", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12398", "1315", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12399", "1315", "fld_9970286", "user_first", "Lisa");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12400", "1315", "fld_9881575", "phone", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12401", "1315", "fld_105264", "user_last", "Clay");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12402", "1315", "fld_1632208", "business_name", "Advance Tank and Construction");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12403", "1315", "fld_7683514", "computer", "AT-LCLAY");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12404", "1315", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12542", "1330", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12543", "1330", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12544", "1330", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12545", "1330", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12546", "1330", "fld_9970286", "user_first", "John");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12547", "1330", "fld_5435180", "phone", "205-338-4483");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12548", "1330", "fld_4368227", "users_last", "Clark");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12549", "1330", "fld_1632208", "business_name", "Advanced Tank & Co.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12550", "1330", "fld_7683514", "computer", "PELL ATC JOHNC PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12551", "1330", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12562", "1332", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12563", "1332", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12564", "1332", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12565", "1332", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12566", "1332", "fld_9970286", "user_first", "MIKE");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12567", "1332", "fld_5435180", "phone", "205-227-7666");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12568", "1332", "fld_4368227", "users_last", "Friend");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12569", "1332", "fld_1632208", "business_name", "Advanced Tank & Co.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12570", "1332", "fld_7683514", "computer", "PELL ATC MIKEF DT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("12571", "1332", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13208", "1398", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13209", "1398", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13210", "1398", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13211", "1398", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13212", "1398", "fld_9970286", "user_first", "Dawn");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13213", "1398", "fld_5435180", "phone", "970-532-4243");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13214", "1398", "fld_4368227", "users_last", "Strong");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13215", "1398", "fld_1632208", "business_name", "Abbey Mortgage & Investments");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13216", "1398", "fld_7683514", "computer", "Abbey Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13217", "1398", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13399", "1417", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13400", "1417", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13401", "1417", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13402", "1417", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13403", "1417", "fld_9970286", "user_first", "Dawn");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13404", "1417", "fld_5435180", "phone", "9705324243");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13405", "1417", "fld_4368227", "users_last", "Strong");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13406", "1417", "fld_1632208", "business_name", "Abbey Mortgage & Investments");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13407", "1417", "fld_7683514", "computer", "Accountant");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13408", "1417", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13535", "1431", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13536", "1431", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13537", "1431", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13538", "1431", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13539", "1431", "fld_9970286", "user_first", "Steve");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13540", "1431", "fld_5435180", "phone", "9709805685");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13541", "1431", "fld_4368227", "users_last", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13542", "1431", "fld_1632208", "business_name", "Speedy Sparkle - Louisville");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13543", "1431", "fld_7683514", "computer", "TW-1RK");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13544", "1431", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13545", "1432", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13546", "1432", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13547", "1432", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13548", "1432", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13549", "1432", "fld_9970286", "user_first", "Steve");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13550", "1432", "fld_5435180", "phone", "9709805685");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13551", "1432", "fld_4368227", "users_last", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13552", "1432", "fld_1632208", "business_name", "Speedy Sparkle - Louisville");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13553", "1432", "fld_7683514", "computer", "SERVER");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13554", "1432", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13573", "1435", "fld_8768091", "tech", "Brad");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13574", "1435", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13575", "1435", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13576", "1435", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13577", "1435", "fld_9970286", "user_first", "Steve");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13578", "1435", "fld_5435180", "phone", "9709805685");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13579", "1435", "fld_4368227", "users_last", "NA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13580", "1435", "fld_1632208", "business_name", "Speedy Sparkle - Louisville");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13581", "1435", "fld_7683514", "computer", "LobbyPC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("13582", "1435", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14425", "1522", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14426", "1522", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14427", "1522", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14428", "1522", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14429", "1522", "fld_9970286", "user_first", "Aaron");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14430", "1522", "fld_5435180", "phone", "(970) 587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14431", "1522", "fld_4368227", "users_last", "Pelto");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14432", "1522", "fld_1632208", "business_name", "Green Earth Enviormental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14433", "1522", "fld_7683514", "computer", "GEE JORGE-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14434", "1522", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14435", "1523", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14436", "1523", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14437", "1523", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14438", "1523", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14439", "1523", "fld_9970286", "user_first", "Aaron");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14440", "1523", "fld_5435180", "phone", "(970) 587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14441", "1523", "fld_4368227", "users_last", "Pelto");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14442", "1523", "fld_1632208", "business_name", "Green Earth Enviormental");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14443", "1523", "fld_7683514", "computer", "GEE JORGE-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14444", "1523", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14457", "1525", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14458", "1525", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14459", "1525", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14460", "1525", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14461", "1525", "fld_9970286", "user_first", "Augusto");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14462", "1525", "fld_5435180", "phone", "303-5135887");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14463", "1525", "fld_4368227", "users_last", "Kunrath");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14464", "1525", "fld_1632208", "business_name", "MVS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14465", "1525", "fld_7683514", "computer", "Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14466", "1525", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14467", "1526", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14468", "1526", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14469", "1526", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14470", "1526", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14471", "1526", "fld_9970286", "user_first", "Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14472", "1526", "fld_5435180", "phone", "3232323232323");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14473", "1526", "fld_4368227", "users_last", "q");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14474", "1526", "fld_7683514", "computer", "joe");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14475", "1526", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14476", "1527", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14477", "1527", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14478", "1527", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14479", "1527", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14480", "1527", "fld_9970286", "user_first", "Patrick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14481", "1527", "fld_5435180", "phone", "111-222-3333");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14482", "1527", "fld_4368227", "users_last", "Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14483", "1527", "fld_1632208", "business_name", "No Of Your Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14484", "1527", "fld_7683514", "computer", "Floyd");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14485", "1527", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14486", "1528", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14487", "1528", "fld_9766490", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14488", "1528", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14489", "1528", "fld_9970286", "user_first", "Patrick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14490", "1528", "fld_9881575", "phone", "111-222-3333");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14491", "1528", "fld_105264", "user_last", "Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14492", "1528", "fld_7683514", "computer", "Hal");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14493", "1528", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14494", "1529", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14495", "1529", "fld_7404234", "type_of_work", "Onsite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14496", "1529", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14497", "1529", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14498", "1529", "fld_9970286", "user_first", "Patrick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14499", "1529", "fld_5435180", "phone", "111-222-3333");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14500", "1529", "fld_4368227", "users_last", "Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14501", "1529", "fld_1632208", "business_name", "None Of Your Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14502", "1529", "fld_7683514", "computer", "Hal");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14503", "1529", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14677", "1547", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14678", "1547", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14679", "1547", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14680", "1547", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14681", "1547", "fld_9970286", "user_first", "Melissa");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14682", "1547", "fld_5435180", "phone", "970.304.9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14683", "1547", "fld_4368227", "users_last", "Artega");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14684", "1547", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14685", "1547", "fld_7683514", "computer", "E&T New LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14686", "1547", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14734", "1553", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14735", "1553", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14736", "1553", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14737", "1553", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14738", "1553", "fld_9970286", "user_first", "Roofing");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14739", "1553", "fld_5435180", "phone", "(970) 617-2008");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14740", "1553", "fld_4368227", "users_last", "Restoration");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14741", "1553", "fld_1632208", "business_name", "Roofing Restoration");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14742", "1553", "fld_7683514", "computer", "RR Rose-DT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14743", "1553", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14924", "1572", "fld_8768091", "tech", "Chuck");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14925", "1572", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14926", "1572", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14927", "1572", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14928", "1572", "fld_9970286", "user_first", "Rick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14929", "1572", "fld_5435180", "phone", "970 532 3169");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14930", "1572", "fld_4368227", "users_last", "Estus");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14931", "1572", "fld_1632208", "business_name", "Rapid Pro Tool");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14932", "1572", "fld_7683514", "computer", "RPT152");
INSERT INTO `itwp_cf_form_entry_values` VALUES("14933", "1572", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15095", "1588", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15096", "1588", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15097", "1588", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15098", "1588", "fld_8211233", "type_of_install", "\\\"Transfer\\\"");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15099", "1588", "fld_9970286", "user_first", "Joe");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15100", "1588", "fld_5435180", "phone", "7065730802");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15101", "1588", "fld_4368227", "users_last", "Hyder");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15102", "1588", "fld_1632208", "business_name", "Rapid Production Tooling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15103", "1588", "fld_7683514", "computer", "RPT 153");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15104", "1588", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15251", "1604", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15252", "1604", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15253", "1604", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15254", "1604", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15255", "1604", "fld_9970286", "user_first", "Stow");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15256", "1604", "fld_5435180", "phone", "(970) 352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15257", "1604", "fld_4368227", "users_last", "Witwer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15258", "1604", "fld_1632208", "business_name", "Witwer Law");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15259", "1604", "fld_7683514", "computer", "All Witwer pc\\\'s");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15260", "1604", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15325", "1611", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15326", "1611", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15327", "1611", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15328", "1611", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15329", "1611", "fld_9970286", "user_first", "Jim");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15330", "1611", "fld_5435180", "phone", "(970) 587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15331", "1611", "fld_4368227", "users_last", "Meining");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15332", "1611", "fld_1632208", "business_name", "Green Earth Environmental, Inc.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15333", "1611", "fld_7683514", "computer", "JIMM-PC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15334", "1611", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15359", "1614", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15360", "1614", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15361", "1614", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15362", "1614", "fld_9970286", "user_first", "Mario");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15363", "1614", "fld_9881575", "phone", "818-259-1702");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15364", "1614", "fld_105264", "user_last", "Alfard");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15365", "1614", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15366", "1614", "fld_7683514", "computer", "ET-Mario-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15367", "1614", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15368", "1615", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15369", "1615", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15370", "1615", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15371", "1615", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15372", "1615", "fld_9970286", "user_first", "Mario");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15373", "1615", "fld_5435180", "phone", "818-259-1702");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15374", "1615", "fld_4368227", "users_last", "Alfard");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15375", "1615", "fld_1632208", "business_name", "E&T Electric");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15376", "1615", "fld_7683514", "computer", "ET-Mario-LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15377", "1615", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15378", "1616", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15379", "1616", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15380", "1616", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15381", "1616", "fld_9970286", "user_first", "Rich");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15382", "1616", "fld_9881575", "phone", "9706693679");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15383", "1616", "fld_105264", "user_last", "Mortenson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15384", "1616", "fld_7683514", "computer", "Laptop-0S96LERA");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15385", "1616", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15513", "1630", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15514", "1630", "fld_9766490", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15515", "1630", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15516", "1630", "fld_9970286", "user_first", "Ron");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15517", "1630", "fld_9881575", "phone", "6202761779");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15518", "1630", "fld_105264", "user_last", "Petty");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15519", "1630", "fld_7683514", "computer", "Petty-Laptop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15520", "1630", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15567", "1636", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15568", "1636", "fld_9766490", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15569", "1636", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15570", "1636", "fld_9970286", "user_first", "Madison");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15571", "1636", "fld_9881575", "phone", "9705932028");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15572", "1636", "fld_105264", "user_last", "Casey");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15573", "1636", "fld_7683514", "computer", "Madison Casey LT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15574", "1636", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15575", "1637", "fld_8768091", "tech", "Kevin");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15576", "1637", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15577", "1637", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15578", "1637", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15579", "1637", "fld_9970286", "user_first", "Lisa");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15580", "1637", "fld_5435180", "phone", "(970) 568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15581", "1637", "fld_4368227", "users_last", "Clay");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15582", "1637", "fld_1632208", "business_name", "Advanced Tank & Co.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15583", "1637", "fld_7683514", "computer", "ATC 3CX Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("15584", "1637", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16022", "1683", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16023", "1683", "fld_9766490", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16024", "1683", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16025", "1683", "fld_9970286", "user_first", "Cindy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16026", "1683", "fld_9881575", "phone", "9706695714");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16027", "1683", "fld_105264", "user_last", "Bublitz");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16028", "1683", "fld_1632208", "business_name", "Ed\\\'s Auto Paint");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16029", "1683", "fld_7683514", "computer", "ED\\\'s-Office");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16030", "1683", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16040", "1685", "fld_8768091", "tech", "Cliff");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16041", "1685", "fld_7404234", "type_of_work", "Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16042", "1685", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16043", "1685", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16044", "1685", "fld_9970286", "user_first", "Kyle");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16045", "1685", "fld_5435180", "phone", "(970) 663-1200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16046", "1685", "fld_4368227", "users_last", "White");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16047", "1685", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16048", "1685", "fld_7683514", "computer", "User");
INSERT INTO `itwp_cf_form_entry_values` VALUES("16049", "1685", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17603", "1847", "fld_9779654", "date", "2019-09-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17604", "1847", "fld_5764555", "service.opt1964966", "Diagnostic ($40.00)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17605", "1847", "fld_5764555", "service", "{\"opt1964966\":\"Diagnostic ($40.00)\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17606", "1847", "fld_6203774", "computer_issues", "Basic issues");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17607", "1847", "fld_3443239", "computer_password", "Password");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17608", "1847", "fld_7197041", "accessories", "None");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17609", "1847", "fld_774041", "phone_number", "(303)842-4534");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17610", "1847", "fld_928339", "full_name", "Brad Roths");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17611", "1847", "fld_5469734", "address", "2002 battle creek drive ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17612", "1847", "fld_3699033", "state", "CO");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17613", "1847", "fld_3131088", "email_address", "brad@milpond.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17614", "1847", "fld_3667800", "agree_to_terms_and_conditions", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("17615", "1847", "fld_6153669", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20758", "2169", "fld_382593", "date", "01-07-2020");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20759", "2169", "fld_6021545", "customer_name", "Brad Roths");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20760", "2169", "fld_758323", "billing_address", "1724 Topaz Drive");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20761", "2169", "fld_1501532", "email_address", "brad@milpond.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20762", "2169", "fld_2364554", "phone_number", "(970)663-1200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20763", "2169", "fld_213893", "deposit_required.opt1388372", "50% Deposit");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20764", "2169", "fld_213893", "deposit_required", "{\"opt1388372\":\"50% Deposit\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20765", "2169", "fld_4140028", "item_selection", "1249.990");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20766", "2169", "fld_9962589", "item_selection_1", "150.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20767", "2169", "fld_7027952", "item_selection_2", "299.95 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20768", "2169", "fld_4165931", "estimated_total", "1699.94");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20769", "2169", "fld_8107404", "person_requesting", "Brad Roths");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20770", "2169", "fld_1564290", "request_invoice", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20868", "2180", "fld_382593", "date", "01-10-2020");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20869", "2180", "fld_6021545", "customer_name", "Thompson Valley Liquor");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20870", "2180", "fld_758323", "billing_address", "1195 Eagle Dr, Loveland, CO 80537");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20871", "2180", "fld_1501532", "email_address", "m.anthony.romero11@gmail.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20872", "2180", "fld_2364554", "phone_number", "(970)663-1766");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20873", "2180", "fld_213893", "deposit_required.opt1553387", "Unknown");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20874", "2180", "fld_213893", "deposit_required", "{\"opt1553387\":\"Unknown\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20875", "2180", "fld_4140028", "item_selection", "299.95 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20876", "2180", "fld_4165931", "estimated_total", "299.95");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20877", "2180", "fld_8107404", "person_requesting", "Brad Roths");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20878", "2180", "fld_6777650", "notes", "- Change order for Invoice #: 121983-2584 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("20879", "2180", "fld_1564290", "request_invoice", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27071", "2827", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27072", "2827", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27073", "2827", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27074", "2827", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27075", "2827", "fld_9970286", "user_first", "Brandon");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27076", "2827", "fld_5435180", "phone", "520-827-0668 Beth");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27077", "2827", "fld_4368227", "users_last", "Granger");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27078", "2827", "fld_1632208", "business_name", "ATC TX");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27079", "2827", "fld_7683514", "computer", "ATC-BGranger");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27080", "2827", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32600", "3296", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32599", "3296", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32598", "3296", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32597", "3296", "fld_2572136", "description_of_work_completed", "Spoke with Darlene over the phone about making her printer work with her computer again.\r\nInstructed Darlene to plug in via USB, but still unable to see printer.\r\nRemoved printer from computer and tried to re-add. Still unable to add printer. Requires on site.\r\n\r\nOn site, discovered USB cable plugged into fax line as opposed to USB plug.\r\nOnce printer was plugged into computer, turned on, and software reinstalled; everything works properly.\r\nSent test print to ensure printer functioned. Set as default printer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32596", "3296", "fld_291750", "date_completed", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32595", "3296", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32594", "3296", "fld_20888", "name_of_client", "Darlene Hahn");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32593", "3296", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32591", "3296", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32592", "3296", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32590", "3296", "fld_165241", "date_of_work", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32589", "3296", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32588", "3296", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32587", "3295", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32586", "3295", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32585", "3295", "fld_5994139", "billing_notes", "Did not create a blanket invoice rule due to phishing attempts using \\\"invoices\\\".");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32584", "3295", "fld_2572136", "description_of_work_completed", "Bill called about invoices going to his junk mail.\r\nReturned his phone call but did not see any invoices in junk mail at the time.\r\nCreated rule to prevent QuickBooks invoices from going to junk mail.\r\nInstructed Bill to call us if it happens again but to leave the example in the junk mail for us to see.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32583", "3295", "fld_291750", "date_completed", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32582", "3295", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32581", "3295", "fld_20888", "name_of_client", "Bill Gurski");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32577", "3295", "fld_165241", "date_of_work", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32578", "3295", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32579", "3295", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32580", "3295", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32576", "3295", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32575", "3295", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32574", "3294", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32573", "3294", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32572", "3294", "fld_39256", "subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32571", "3294", "fld_7842020", "cylance_installed", "{\"opt1358823\":\"Cylance Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32570", "3294", "fld_7842020", "cylance_installed.opt1358823", "Cylance Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32567", "3294", "fld_291750", "date_completed", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32568", "3294", "fld_2572136", "description_of_work_completed", "Installed Cylance on Debbie\\\'s ION DT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32569", "3294", "fld_5994139", "billing_notes", "Debbie is going to check her shop computer to see if it needs Cylance as well.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32566", "3294", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32565", "3294", "fld_20888", "name_of_client", "Debbie Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32564", "3294", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32563", "3294", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32562", "3294", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32561", "3294", "fld_165241", "date_of_work", "2021-02-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32560", "3294", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32558", "3293", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32559", "3294", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32557", "3293", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32556", "3293", "fld_5994139", "billing_notes", "Resolved. Wendi\\\'s computer is not presently in use, I did recommend that we do a basic service on it before it goes back into use.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32555", "3293", "fld_2572136", "description_of_work_completed", "Reinstalled Raegan\\\'s computer, ensured computer was no longer touching plastic or carpet directly.\r\nChuck removed Sage timeslips license from Wendi\\\'s old computer, reactivated on Raegan\\\'s computer.\r\nConfirmed everything was working properly.\r\nRan HDD scan on Wendi\\\'s computer as Raegan mentioned it was slow.\r\nNo issue detected on Wendi\\\'s computer, ran SFC & DISM with no issues.\r\nComputer hardware on Wendi\\\'s computer is aging but likely just needs a thorough cleaning to bring performance back.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32554", "3293", "fld_291750", "date_completed", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32553", "3293", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32552", "3293", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32550", "3293", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32551", "3293", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32548", "3293", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32549", "3293", "fld_165241", "date_of_work", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32547", "3293", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32546", "3292", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32545", "3292", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32544", "3292", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32538", "3292", "fld_7309777", "minutes_spent", "21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32539", "3292", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32540", "3292", "fld_20888", "name_of_client", "marry lou wiggins");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32541", "3292", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32542", "3292", "fld_291750", "date_completed", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32543", "3292", "fld_2572136", "description_of_work_completed", "updated outlook email pw\r\nsetup outlook on kindle\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32537", "3292", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32536", "3292", "fld_165241", "date_of_work", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32535", "3292", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32534", "3292", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32533", "3291", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32532", "3291", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32531", "3291", "fld_5994139", "billing_notes", "Computer brought back to office for diagnoses regarding issue with crashing.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32524", "3291", "fld_165241", "date_of_work", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32525", "3291", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32526", "3291", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32527", "3291", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32528", "3291", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32529", "3291", "fld_291750", "date_completed", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32530", "3291", "fld_2572136", "description_of_work_completed", "Removed Raegan\\\'s computer to be brought back to office for in depth diagnostics.\r\nInstalled Wendi\\\'s old computer in place of Raegen\\\'s for temp use.\r\nConfigured Outlook 2010 on Wendi\\\'s computer for temp use by Raegan.\r\nChuck updated Sage license for temp use on Wendi\\\'s computer.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32523", "3291", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32522", "3291", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32521", "3290", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32520", "3290", "fld_8478853", "cost_of_part_1", "$127.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32519", "3290", "fld_2864175", "part1_description", "Dell USB 3.0 Ultra HD/4K Triple Display Docking Station (D3100), Black");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32518", "3290", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32517", "3290", "fld_5994139", "billing_notes", "Accubid requires two installations. Program itself and the local security server for sentinel license USB drive.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32516", "3290", "fld_2572136", "description_of_work_completed", "Brought new port replicator out to Angel for his new laptop.\r\nInstalled Accubid program on Angel\\\'s new laptop.\r\nTried installed Accubid local security server but HASP HL drivers kept failing to properly install.\r\nLaptop would BSOD anytime sentinel license USB drive was inserted into computer.\r\nFully removed HASP drivers, cleaned out registry entries, removed Accubid, removed Accubid registry entries.\r\nReinstalled Accubid, manually installed HASP drivers, reinstalled Accubid security server.\r\nConfirmed program started up properly.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32514", "3290", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32515", "3290", "fld_291750", "date_completed", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32513", "3290", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32512", "3290", "fld_7309777", "minutes_spent", "180");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32511", "3290", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32510", "3290", "fld_165241", "date_of_work", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32509", "3290", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32505", "3289", "fld_5994139", "billing_notes", "She called back after speaking with Greg about being hacked. i looks like there are no emails in the inbox or her archive folder where she stores her emails.\r\n\r\n504219502");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32506", "3289", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32507", "3289", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32508", "3290", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32504", "3289", "fld_2572136", "description_of_work_completed", "troubleshooting MSN Email outlook email\r\nattempted to recover outlook online emails");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32503", "3289", "fld_291750", "date_completed", "2021-02-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32502", "3289", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32501", "3289", "fld_20888", "name_of_client", "marry lou wiggins");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32500", "3289", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32498", "3289", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32499", "3289", "fld_7309777", "minutes_spent", "31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32497", "3289", "fld_165241", "date_of_work", "2021-02-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32496", "3289", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32495", "3289", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32494", "3288", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32493", "3288", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32492", "3288", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32490", "3288", "fld_291750", "date_completed", "2021-02-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32491", "3288", "fld_2572136", "description_of_work_completed", "Helped Mary changed her MSN email password.\r\nRan SAS scan, no concerns detected.\r\nUpdated Vipre, set Vipre to automatically patch without user input.\r\nChecked Task Scheduler for suspicious entries, none found.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32489", "3288", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32488", "3288", "fld_20888", "name_of_client", "Mary Lou Wiggins  970-744-0960");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32487", "3288", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32486", "3288", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32485", "3288", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32484", "3288", "fld_165241", "date_of_work", "2021-02-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32479", "3287", "fld_5994139", "billing_notes", "Domain transfer Godaddy to Wix\r\nprovide transfer code to JAmschwand\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32480", "3287", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32481", "3287", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32482", "3288", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32483", "3288", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32478", "3287", "fld_2572136", "description_of_work_completed", "Domain transfer ceindustrial.com to Wix\r\nunlock domain on Godaddy and provide transfer code to Jeremy\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32477", "3287", "fld_291750", "date_completed", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32476", "3287", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32475", "3287", "fld_8427909", "client_or_company", "CES Industrial / 970-663-9121");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32474", "3287", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32473", "3287", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32472", "3287", "fld_165241", "date_of_work", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32469", "3286", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32470", "3287", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32471", "3287", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32468", "3286", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32467", "3286", "fld_5994139", "billing_notes", "Remove 3 emails(and 2 Office 365 licenses)\r\n\r\nCurrent License count is \r\n    16 Exchange Only licenses\r\n    1 Office 365 Business Premium License\r\n\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32465", "3286", "fld_291750", "date_completed", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32466", "3286", "fld_2572136", "description_of_work_completed", "Remove 3 email accounts (per Staci)\r\nremove Drew Elser, Jordan Gaboian and Rob Barros emails\r\nremove unused licenses (2x exchange only)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32464", "3286", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32463", "3286", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32462", "3286", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32461", "3286", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32460", "3286", "fld_165241", "date_of_work", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32459", "3286", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32458", "3286", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32457", "3285", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32455", "3285", "fld_5994139", "billing_notes", "April has a 120GB System drive, so she has very limited space.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32456", "3285", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32454", "3285", "fld_2572136", "description_of_work_completed", "April was unable to open or print PDF attachments from Outlook.\r\nC: drive was completely full\r\nRan CCleaner, cleaned out 1.5GB\r\nCreated restore point\r\nDeleted Windows.old installation\r\nDeleted old Outlook profile\r\nFree space now above 25%");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32453", "3285", "fld_291750", "date_completed", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32452", "3285", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32451", "3285", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32450", "3285", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32449", "3285", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32444", "3284", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32445", "3284", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32446", "3285", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32447", "3285", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32448", "3285", "fld_165241", "date_of_work", "2021-02-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32443", "3284", "fld_8555975", "license___", "422DP-HT8G5-3MW9K-3S5FX-ZJ7VW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32442", "3284", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32441", "3284", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32440", "3284", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32439", "3284", "fld_5994139", "billing_notes", "Vipre Key: 422DP-HT8G5-3MW9K-3S5FX-ZJ7VW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32437", "3284", "fld_291750", "date_completed", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32438", "3284", "fld_2572136", "description_of_work_completed", "Renewed Vipre on Christine\\\'s laptop.\r\nPerformed light cleanup and updated Vipre.\r\nVipre Key: 422DP-HT8G5-3MW9K-3S5FX-ZJ7VW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32435", "3284", "fld_20888", "name_of_client", "Christine Rock");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32436", "3284", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32434", "3284", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32433", "3284", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32432", "3284", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32431", "3284", "fld_165241", "date_of_work", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32430", "3284", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32425", "3283", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32426", "3283", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32427", "3283", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32428", "3283", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32429", "3284", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32424", "3283", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32422", "3283", "fld_291750", "date_completed", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32423", "3283", "fld_2572136", "description_of_work_completed", "Cloned and replaced John\\\'s HDD with a 500GB SSD.\r\nRan SFC and DISM with no errors detected.\r\nConfirmed that Office programs were up to date and open properly.\r\nRan CCleaner, confirmed that Vipre was up to date, confirmed that Windows was up to date.\r\nCreated restore point.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32420", "3283", "fld_8427909", "client_or_company", "Freeman Architects / 970-667-3939");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32421", "3283", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32419", "3283", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32418", "3283", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32417", "3283", "fld_165241", "date_of_work", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32416", "3283", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32415", "3283", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32413", "3282", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32414", "3282", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32412", "3282", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32411", "3282", "fld_2572136", "description_of_work_completed", "Confirmed that Konica minolta printer test print works from Rick\\\'s new surface.\r\nShared Konica printer and Brother printer from Hawk-Server.\r\nAdded Brother printer to surface and confirmed that test print worked.\r\nSet primary DNS to 192.168.1.5 due to causing issue with domain access.\r\nInstalled Sage paperless program. Confirmed with Rick that everything appeared to be working properly.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32410", "3282", "fld_291750", "date_completed", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32409", "3282", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32408", "3282", "fld_8427909", "client_or_company", "Hawkstone Builders / 970-460-0497");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32407", "3282", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32406", "3282", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32402", "3281", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32403", "3282", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32404", "3282", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32405", "3282", "fld_165241", "date_of_work", "2021-02-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32400", "3281", "fld_3664993", "office_subs", "2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32401", "3281", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32399", "3281", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32398", "3281", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32397", "3281", "fld_5994139", "billing_notes", "2 Office 365 upgrades\r\n(per Gina)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32396", "3281", "fld_2572136", "description_of_work_completed", "Upgrade Office to 365 Standard license for 2 users/PCs\r\nTristan Cantu and Darrell Bingham PC\r\n(Per request from Gina - New Office 365 Excel features required)\r\n+ remove old Office installs\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32395", "3281", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32394", "3281", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32393", "3281", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32392", "3281", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32391", "3281", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32390", "3281", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32387", "3280", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32388", "3281", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32389", "3281", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32386", "3280", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32385", "3280", "fld_5994139", "billing_notes", "VO still had RDS in use. (was acessed by hacker)\r\nclosed all RDS ports, scanned IP from outside to verify and advised KEvin to chnge all passwords used on compromised PC.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32384", "3280", "fld_2572136", "description_of_work_completed", "1 hour 2-15 and 2-16 Firewall lockdown / audit\r\nKevin still had RDP forwarded through firewall (and was still using from denver office)\r\nsomeone exploited RDS to gain access to PC in FC office\r\nturned off all RDS and unknown port forwards and perform external scan/audit of VO external IP\r\n2-16 set up LAN rds via VPN for denver PC, remove external RDS IPs\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32383", "3280", "fld_291750", "date_completed", "2021-02-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32382", "3280", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32381", "3280", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32380", "3280", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32376", "3280", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32377", "3280", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32378", "3280", "fld_165241", "date_of_work", "2021-02-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32379", "3280", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32375", "3279", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32374", "3279", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32373", "3279", "fld_5994139", "billing_notes", "Email forwarding changes  from Staci\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32369", "3279", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32370", "3279", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32371", "3279", "fld_291750", "date_completed", "2021-02-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32372", "3279", "fld_2572136", "description_of_work_completed", "Adjust emil forwards (per Staci)\r\nforward following users emails to bsndau@greenearthcolo.com - \r\nDrew Elser\r\nEstimating\r\nLandscape Super\r\nMcKay Davis\r\nDarby Davis\r\nTrisha Clark\r\nMike Cook\r\n\r\n+ reset mcook password");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32368", "3279", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32367", "3279", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32366", "3279", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32365", "3279", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32364", "3279", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32363", "3278", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32362", "3278", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32361", "3278", "fld_5994139", "billing_notes", "VPN setup Jerry Hildreth\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32360", "3278", "fld_2572136", "description_of_work_completed", "VPN Setup Jerry Hildreth - 1 hour\r\nsetup Jerry for VPN access on Sonicwall + setup home PC for VPN access\r\n(working from home week of 2-22 to 2-26\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32359", "3278", "fld_291750", "date_completed", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32358", "3278", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32357", "3278", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32356", "3278", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32355", "3278", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32354", "3278", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32353", "3278", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32350", "3277", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32351", "3277", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32352", "3278", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32348", "3277", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32349", "3277", "fld_8555975", "license___", "422DP-HT8G5-3MW9K-3S5FX-ZJ7VW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32347", "3277", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32346", "3277", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32345", "3277", "fld_5994139", "billing_notes", "She requested that I only do vipre and no cleanup\r\nPhone: 970-381-1239");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32336", "3277", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32337", "3277", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32338", "3277", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32339", "3277", "fld_7309777", "minutes_spent", "8");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32340", "3277", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32341", "3277", "fld_20888", "name_of_client", "Stacy Blank");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32342", "3277", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32343", "3277", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32344", "3277", "fld_2572136", "description_of_work_completed", "Vipre Renewal ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32335", "3277", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32334", "3276", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32333", "3276", "fld_8478853", "cost_of_part_1", "69.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32332", "3276", "fld_2864175", "part1_description", "Wd External 2TB");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32331", "3276", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32326", "3276", "fld_20888", "name_of_client", "Tom/Lois Giordano");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32327", "3276", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32328", "3276", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32329", "3276", "fld_2572136", "description_of_work_completed", "Basic Service on Tom\\\'s Computer\r\n-Installed VLC for playing DVD\\\'s\r\nBasic Service on Lois Computer\r\n-Installed VLC for playing DVD\\\'s");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32330", "3276", "fld_5994139", "billing_notes", "Cell: 262-825-8033 Tom\r\n\r\nEmail: TGIO@FRII.COM lois.giordano627@gmail.com \r\n\r\ntoms cobain backup drive is dyeing and a replacement has been ordered form amazon.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32325", "3276", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32324", "3276", "fld_7309777", "minutes_spent", "238");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32323", "3276", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32322", "3276", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32321", "3276", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32320", "3276", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32310", "3275", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32311", "3275", "fld_7309777", "minutes_spent", "46");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32312", "3275", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32313", "3275", "fld_20888", "name_of_client", "Don Albern");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32314", "3275", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32315", "3275", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32316", "3275", "fld_2572136", "description_of_work_completed", "setup google bookmarks\r\nSetup printer to laptop\r\nupdated printer drivers\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32317", "3275", "fld_5994139", "billing_notes", "9706694495");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32318", "3275", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32319", "3275", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32309", "3275", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32308", "3275", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32307", "3275", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32306", "3274", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32305", "3274", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32304", "3274", "fld_8555975", "license___", "422DQ-HA4ZX-8PEZY-6UGET-9JKVZ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32303", "3274", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32301", "3274", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32302", "3274", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32300", "3274", "fld_5994139", "billing_notes", "Vipre Key: 422DQ-HA4ZX-8PEZY-6UGET-9JKVZ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32299", "3274", "fld_2572136", "description_of_work_completed", "Renewed Vipre subscription on BJ\\\'s desktop.\r\nTried to update Vipre, update failed.\r\nTried to repair Vipre, repair succeeded but update still failed.\r\nUninstalled and reinstalled Vipre, re-added Vipre key, updated Vipre, reconfigured Vipre for MG scans.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32294", "3274", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32295", "3274", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32296", "3274", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32297", "3274", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32298", "3274", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32293", "3274", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32292", "3274", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32291", "3274", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32290", "3273", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32289", "3273", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32278", "3272", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32279", "3273", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32280", "3273", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32281", "3273", "fld_165241", "date_of_work", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32282", "3273", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32283", "3273", "fld_7309777", "minutes_spent", "34");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32284", "3273", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32285", "3273", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32286", "3273", "fld_291750", "date_completed", "2021-02-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32287", "3273", "fld_2572136", "description_of_work_completed", "reinstalled office 2016 on Tom Pitts ION\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32288", "3273", "fld_5994139", "billing_notes", "office files where missing and he couldn\\\'t open any office programs without it trying to automatically repair office and failing.\r\n\r\nResolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32276", "3272", "fld_5994139", "billing_notes", "phone: 970-669-4495");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32277", "3272", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27894", "2912", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27895", "2912", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27896", "2912", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27897", "2912", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27898", "2912", "fld_9970286", "user_first", "Liga");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27899", "2912", "fld_5435180", "phone", "9706631200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27900", "2912", "fld_4368227", "users_last", "Germova");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27901", "2912", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27902", "2912", "fld_7683514", "computer", "Liga Germova");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27903", "2912", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27904", "2913", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27905", "2913", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27906", "2913", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27907", "2913", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27908", "2913", "fld_9970286", "user_first", "Liga");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27909", "2913", "fld_5435180", "phone", "9706631200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27910", "2913", "fld_4368227", "users_last", "Germova");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27911", "2913", "fld_1632208", "business_name", "Millennium Group");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27912", "2913", "fld_7683514", "computer", "Liga Germova");
INSERT INTO `itwp_cf_form_entry_values` VALUES("27913", "2913", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32275", "3272", "fld_2572136", "description_of_work_completed", "Installed google and added Gmail account");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32274", "3272", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32273", "3272", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32272", "3272", "fld_20888", "name_of_client", "Don Albern");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32271", "3272", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32270", "3272", "fld_7309777", "minutes_spent", "11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32266", "3272", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32267", "3272", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32268", "3272", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32269", "3272", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32264", "3271", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32265", "3271", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32263", "3271", "fld_5994139", "billing_notes", "phone 970-214-8825\r\n\r\nEmail PW 10+3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32262", "3271", "fld_2572136", "description_of_work_completed", "updated server outlook email PW (dm@rvmobilerepair.com) ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32261", "3271", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32260", "3271", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32259", "3271", "fld_20888", "name_of_client", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32258", "3271", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32254", "3271", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32255", "3271", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32256", "3271", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32257", "3271", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32252", "3270", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32253", "3271", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32251", "3270", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32250", "3270", "fld_5994139", "billing_notes", "phone 970-214-8825");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32249", "3270", "fld_2572136", "description_of_work_completed", "Reset email info in cpanel\r\n-updated setup info with email PW\r\nsetup email on laptop and desktop computer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32248", "3270", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32247", "3270", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32242", "3270", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32243", "3270", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32244", "3270", "fld_7309777", "minutes_spent", "32");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32245", "3270", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32246", "3270", "fld_20888", "name_of_client", "DM RV Repair");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32241", "3270", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32240", "3270", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32239", "3269", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32238", "3269", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32237", "3269", "fld_626923", "license_3", "422DQ-HA4ZX-8PEZY-6UGET-9JKVZ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32236", "3269", "fld_7199494", "license_2", "422DQ-UF2T8-UNLBC-YU45S-9AY6X");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32234", "3269", "fld_2945103", "vipre_subs", "3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32235", "3269", "fld_9098585", "license_1", "422DS-7X52M-E6C9M-3DHYS-LPYN2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32233", "3269", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32232", "3269", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32231", "3269", "fld_5994139", "billing_notes", "Frank\\\'s, David\\\'s, John\\\'s: 422DQ-UF2T8-UNLBC-YU45S-9AY6X\r\n\r\nMonica: 422DQ-HA4ZX-8PEZY-6UGET-9JKVZ\r\n\r\nZach: 422DS-7X52M-E6C9M-3DHYS-LPYN2\r\n\r\nJohn has a failing HDD. Recommended we replace with SSD.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32230", "3269", "fld_2572136", "description_of_work_completed", "Updated Vipre Subscriptions on: Frank\\\'s DT, David\\\'s DT, John\\\'s Dell DT, Monica\\\'s ION, Zach\\\'s DT\r\n\r\nCompleted light cleaning on all 5 computers.\r\n\r\nJohn\\\'s computer has a failing HDD but all other hardware is solid. Recommended we replace with a SSD.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32229", "3269", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32228", "3269", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32223", "3269", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32224", "3269", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32225", "3269", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32226", "3269", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32227", "3269", "fld_8427909", "client_or_company", "Freeman Architects / 970-667-3939");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32222", "3269", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32221", "3268", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32220", "3268", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32219", "3268", "fld_8555975", "license___", "422DS-7X52M-E6C9M-3DHYS-LPYN2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32218", "3268", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32217", "3268", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32216", "3268", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32211", "3268", "fld_20888", "name_of_client", "Jeff Sorenson Pest Control / 970-980-3102");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32212", "3268", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32213", "3268", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32214", "3268", "fld_2572136", "description_of_work_completed", "Vipre new key install\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32215", "3268", "fld_5994139", "billing_notes", "Vipre new key install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32210", "3268", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32209", "3268", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32208", "3268", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32207", "3268", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32206", "3268", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32204", "3267", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32205", "3268", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32199", "3267", "fld_5994139", "billing_notes", "Vipre key Tara & Phil Moenning PC\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32200", "3267", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32201", "3267", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32202", "3267", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32203", "3267", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32198", "3267", "fld_2572136", "description_of_work_completed", "Install Vipre Key (had trial versions from recent service)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32197", "3267", "fld_291750", "date_completed", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32196", "3267", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32195", "3267", "fld_20888", "name_of_client", "Tara Moenning / 970-577-0186");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32194", "3267", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32193", "3267", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32190", "3267", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32191", "3267", "fld_165241", "date_of_work", "2021-02-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32192", "3267", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32189", "3267", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32188", "3266", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32187", "3266", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32186", "3266", "fld_5994139", "billing_notes", "Need to order a new replicator for Angel\\\'s laptop.\r\nHe has two monitors, 1 HDMI, 1 Displayport");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32183", "3266", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32184", "3266", "fld_291750", "date_completed", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32185", "3266", "fld_2572136", "description_of_work_completed", "Brought out new port replicator with USB A connection for Angel, to replace his current port replicator.\r\nNew replicator does not pass through video data, unable to resolve situation with Angel, will order new replicator.\r\n\r\nInstalled new Xerox VersaLink c405 All in One printer/scanner.\r\nConfigured scan to folder, pointed to Scanned Docs folder on Server.\r\nConfigured fax, tested and confirmed that they can send and receive.\r\nReplaced monitor on employees desk.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32181", "3266", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32182", "3266", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32179", "3266", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32180", "3266", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32178", "3266", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32177", "3266", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32176", "3265", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32175", "3265", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32174", "3265", "fld_5994139", "billing_notes", "Unsure what fax service tech received a reverse polarity error. Possible that new modem installed in fax machine was configured differently then previous modem, resulting in a necessary change in 3CX");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32173", "3265", "fld_2572136", "description_of_work_completed", "Repaired fax line connectivity.\r\nTried reversing polarity of phone cable, but it did not resolve the issue.\r\nConfirmed that phone line had dial tone with lineman\\\'s kit.\r\nConfirmed that polarity did not affect ability to call out.\r\nSwapped out phone line cable for new cable, did not resolve issue.\r\nSwitched fax settings in 3CX from t38 to audio faxing, confirmed able to send and receive fax at this time.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32172", "3265", "fld_291750", "date_completed", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32171", "3265", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32170", "3265", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32169", "3265", "fld_7309777", "minutes_spent", "180");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32168", "3265", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32167", "3265", "fld_165241", "date_of_work", "2021-02-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32166", "3265", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32165", "3265", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32164", "3264", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32163", "3264", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32162", "3264", "fld_5994139", "billing_notes", "Michelle had to leave for meeting so RDP connection oir VPN didn\\\'t get setup but  she will call back later after her meting. QuickBooks was setup and drives where mapped");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32161", "3264", "fld_2572136", "description_of_work_completed", "Setup new computer\r\nVPN\r\nRDP connection to front desk server\r\nMap Scan folder to network drive\r\nConfigure printer software\r\nInstall and configure QuickBooks\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32160", "3264", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32159", "3264", "fld_8427909", "client_or_company", "MAC Electric / 970-669-2464");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32158", "3264", "fld_7309777", "minutes_spent", "43");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32157", "3264", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32156", "3264", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32155", "3264", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32154", "3264", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32153", "3263", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32152", "3263", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32151", "3263", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32150", "3263", "fld_2572136", "description_of_work_completed", "moved 3cx SBC to managers office");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32149", "3263", "fld_291750", "date_completed", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32148", "3263", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32147", "3263", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32145", "3263", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32146", "3263", "fld_7309777", "minutes_spent", "37");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32144", "3263", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32143", "3263", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32142", "3263", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32141", "3262", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32140", "3262", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32139", "3262", "fld_5994139", "billing_notes", "My little Help client\r\n\r\n 303-322-9533.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32138", "3262", "fld_2572136", "description_of_work_completed", "Answered computer questions \r\ninterested in preon\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32137", "3262", "fld_291750", "date_completed", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32134", "3262", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32135", "3262", "fld_20888", "name_of_client", "Anniece Johnson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32136", "3262", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32133", "3262", "fld_7309777", "minutes_spent", "34");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32132", "3262", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32131", "3262", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32130", "3262", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32128", "3261", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32129", "3262", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32110", "3260", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32111", "3260", "fld_291750", "date_completed", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32112", "3260", "fld_2572136", "description_of_work_completed", "Assist Kevin Anderson with Outlook and Time Clock app issues\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32113", "3260", "fld_5994139", "billing_notes", "Kevin Anderson - Outlook assistance +\r\ninstall TimeClock software\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32114", "3260", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32115", "3260", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32116", "3261", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32117", "3261", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32118", "3261", "fld_165241", "date_of_work", "2021-02-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32119", "3261", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32120", "3261", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32121", "3261", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32122", "3261", "fld_20888", "name_of_client", "Madison Casey / 970-593-2028");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32123", "3261", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32124", "3261", "fld_291750", "date_completed", "2021-02-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32125", "3261", "fld_2572136", "description_of_work_completed", "Remote Basic Service completed.\r\nNo issues detected, no concerns with computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32126", "3261", "fld_5994139", "billing_notes", "Customer mentioned the $40 off basic service special that we\\\'re running.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32127", "3261", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32104", "3260", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32105", "3260", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32106", "3260", "fld_165241", "date_of_work", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32107", "3260", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32108", "3260", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32109", "3260", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32103", "3259", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32102", "3259", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32101", "3259", "fld_5994139", "billing_notes", "Audio conferencing 17 users\r\nNote - this is an Office 365 addon. It costs $4 per user / per month. \r\n\r\n(So it will add $68 per month to their Office 365 bill)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32100", "3259", "fld_2572136", "description_of_work_completed", "Set Up Office 365 / Teams Audio conferencing 17 users\r\nAdd \\\'Audio conferencing\\\' license for 16 users\r\n(allows telephone bridge dial-in on Teams meetings)\r\nconfigure 17 users for audio bridge\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32099", "3259", "fld_291750", "date_completed", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32098", "3259", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32097", "3259", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32096", "3259", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32095", "3259", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32094", "3259", "fld_165241", "date_of_work", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32093", "3259", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32092", "3259", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32091", "3258", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32090", "3258", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32089", "3258", "fld_5994139", "billing_notes", "Create dev site - theotherroadcounseling.com\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32088", "3258", "fld_2572136", "description_of_work_completed", "Create development  wordpress for - theotherroadcounseling.com on daydreamit.com\r\nprovide Anthony / Patrick with creds.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32084", "3258", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32085", "3258", "fld_20888", "name_of_client", "The Other Road Counseling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32086", "3258", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32087", "3258", "fld_291750", "date_completed", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32083", "3258", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32082", "3258", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32081", "3258", "fld_165241", "date_of_work", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32080", "3258", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32079", "3258", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32078", "3257", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32077", "3257", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32076", "3257", "fld_5994139", "billing_notes", "3CX issues - Ashcroft\r\nmostly caused by server / SBC changes\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32075", "3257", "fld_2572136", "description_of_work_completed", "Resolve multiple issues interfering with 3CX setup-\r\n/etc/hosts entries on 2x workstations preventing 3CX connection (leftover from SBC on PC)\r\n3cx web extensions looking for 3CX server on LAN\r\ngo through entire setup and check phone and app provisioning for all extensions\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32074", "3257", "fld_291750", "date_completed", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32072", "3257", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32073", "3257", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32071", "3257", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32070", "3257", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32069", "3257", "fld_165241", "date_of_work", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32068", "3257", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32067", "3257", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32066", "3256", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32065", "3256", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32064", "3256", "fld_5994139", "billing_notes", "printer issue - Kathy Lambros\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32061", "3256", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32062", "3256", "fld_291750", "date_completed", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32063", "3256", "fld_2572136", "description_of_work_completed", "E&T PRinter issue Kathy Lambros\r\ndriver mismatch, reinstall printer driver on client\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32058", "3256", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32059", "3256", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32060", "3256", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32057", "3256", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32056", "3256", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32055", "3256", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32054", "3255", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32053", "3255", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32052", "3255", "fld_5994139", "billing_notes", "EMC 3CX setup troubleshooting (assist Greg)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32049", "3255", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32050", "3255", "fld_291750", "date_completed", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32051", "3255", "fld_2572136", "description_of_work_completed", "Troubleshoot EMC 3CX issues (assist Greg)\r\nDECT phones routing messed up + voicemil + other minor issues\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32048", "3255", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32047", "3255", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32046", "3255", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32045", "3255", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32044", "3255", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32041", "3254", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32042", "3254", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32043", "3255", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32040", "3254", "fld_5994139", "billing_notes", "Troy Sauvageu move user profile to different PC \r\n(and install needed apps Vista + FastTrack...)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32039", "3254", "fld_2572136", "description_of_work_completed", "2 hours - Troy Sauvageau move profile and data to different laptop\r\n(50 GB data + settings and apps)\r\nVista upgrade + Fasttrack 10 install \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32038", "3254", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32037", "3254", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28175", "2939", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28176", "2939", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28177", "2939", "fld_4322203", "client_type", "Business");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28178", "2939", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28179", "2939", "fld_9970286", "user_first", "John");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28180", "2939", "fld_5435180", "phone", "9706631200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28181", "2939", "fld_4368227", "users_last", "Wart");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28182", "2939", "fld_1632208", "business_name", "RPT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28183", "2939", "fld_7683514", "computer", "RPT 121");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28184", "2939", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28185", "2940", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28186", "2940", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28187", "2940", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28188", "2940", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28189", "2940", "fld_9970286", "user_first", "John");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28190", "2940", "fld_5435180", "phone", "9706631200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28191", "2940", "fld_4368227", "users_last", "Wart");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28192", "2940", "fld_7683514", "computer", "RPT 121");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28193", "2940", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28194", "2941", "fld_8768091", "tech", "Andy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28195", "2941", "fld_7404234", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28196", "2941", "fld_4322203", "client_type", "Individual");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28197", "2941", "fld_8211233", "type_of_install", "New Install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28198", "2941", "fld_9970286", "user_first", "fyf");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28199", "2941", "fld_5435180", "phone", "fhfh");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28200", "2941", "fld_4368227", "users_last", "gjyg");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28201", "2941", "fld_7683514", "computer", "hgfyf");
INSERT INTO `itwp_cf_form_entry_values` VALUES("28202", "2941", "fld_7908577", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32036", "3254", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32035", "3254", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32034", "3254", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32033", "3254", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32032", "3254", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32031", "3254", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32030", "3253", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32029", "3253", "fld_8478853", "cost_of_part_1", "$57");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32028", "3253", "fld_2864175", "part1_description", "512 GB 2.5\\\" SSD (SK-Hynix)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32027", "3253", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32026", "3253", "fld_5994139", "billing_notes", "BENCH - Failed SSD clone for McWebb Truss\r\n(legacy Windows 7 box)\r\nclone successful\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32025", "3253", "fld_2572136", "description_of_work_completed", "5 hours 2-12 - McWebb Tachyon Windows 7 legacy - clone bad HDD and fix filesystem / OS \r\nData recovery / clone ssd with bad sectors that crash host.\r\n(Note - this took a long time because every time I hit a bad spot on the drive I had to reboot the PC)\r\n8 bad spots on drive (13 sectors total)\r\ncloned piecewise around badd spots, chkdsk + sfc \r\nand verify system boots and runs without error\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32024", "3253", "fld_291750", "date_completed", "2021-02-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32023", "3253", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32022", "3253", "fld_20888", "name_of_client", "Jim McCreery / McWebb Truss");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32020", "3253", "fld_7309777", "minutes_spent", "300");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32021", "3253", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32019", "3253", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32018", "3253", "fld_165241", "date_of_work", "2021-02-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32017", "3253", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32016", "3253", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32015", "3252", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32014", "3252", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32013", "3252", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32012", "3252", "fld_2572136", "description_of_work_completed", "Walked Herb through the TeamViewer QS installation process.\r\nHerb was calling about text being difficult to read in Chrome.\r\nHigh contrast Windows themes were overly excessive.\r\nInstalled high contrast Chrome extension and showed Herb how to turn it on and off as is needed.\r\nConfirmed that text was now easy to read and then offered Herb some information on our new computers, given the age of his current one.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32011", "3252", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32010", "3252", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32009", "3252", "fld_20888", "name_of_client", "Herb Baldernston / 970-203-1521");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32008", "3252", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32007", "3252", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32006", "3252", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32005", "3252", "fld_165241", "date_of_work", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32004", "3252", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32003", "3252", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32002", "3251", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32001", "3251", "fld_592520", "cost_of_part_2", "8.49");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32000", "3251", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31997", "3251", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31998", "3251", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31999", "3251", "fld_9190675", "part_2_description", "Amazon Basics One-Port USB Wall Charger (2)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31996", "3251", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31993", "3251", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31994", "3251", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31995", "3251", "fld_2572136", "description_of_work_completed", "Cloned and replaced HDD with 500GB SSD on Front Desk 1.\r\nConfirmed that changes made to wireless handsets had resolved issue with Wireless handset 3 not ringing and unable to make or receive calls.\r\nInstructed EMC employees on how to reach main Voicemail on Ext. 2000 from any extension.\r\nRan SFC and DISM on Front Desk 1 to ensure no lingering issues from clone operation.\r\nRan Stress test to test memory, l1, l2, l3 caches and processor for 30 minutes. No issues with crashing.\r\nSpoke with John about potential expansion in garage area of 2-3 computers.\r\nTidied up cable management under front desk computers.\r\nChanged front desk phones to be plugged into power strip using USB port charger adapter as opposed to being plugged directly into front desk computers.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31991", "3251", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31992", "3251", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31990", "3251", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31989", "3251", "fld_165241", "date_of_work", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31988", "3251", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31987", "3251", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31986", "3250", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31985", "3250", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31984", "3250", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31982", "3250", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31983", "3250", "fld_2572136", "description_of_work_completed", "Scan to folder function was broken after switching to new ISP.\r\nPrinter had bad DNS settings, specifically the secondary setting.\r\nSet primary DNS to 192.168.1.1 and secondary to 8.8.8.8\r\nTested scan to network folder and everything worked again.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31981", "3250", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31980", "3250", "fld_20888", "name_of_client", "Beck Architects / 970-586-3913");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31979", "3250", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31978", "3250", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31977", "3250", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31973", "3249", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31974", "3250", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31975", "3250", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31976", "3250", "fld_165241", "date_of_work", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31971", "3249", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31972", "3249", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31970", "3249", "fld_2572136", "description_of_work_completed", "Jacob\\\'s outlook would no longer open. Diagnosed a corrupted OST file.\r\nCreated new profile for Jacob and Outlook was able to function again.\r\nConfirmed that emails, contacts, calender all synced up properly.\r\nConfigured standard Outlook settings due to new profile.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31966", "3249", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31967", "3249", "fld_20888", "name_of_client", "Money Concepts / Jacob");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31968", "3249", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31969", "3249", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31965", "3249", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31964", "3249", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31963", "3249", "fld_165241", "date_of_work", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31962", "3249", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31961", "3249", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31959", "3248", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31960", "3248", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31958", "3248", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31957", "3248", "fld_2572136", "description_of_work_completed", "Configured Outlook on Dave Jackson\\\'s LT for smtp2go milpond account.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31956", "3248", "fld_291750", "date_completed", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31955", "3248", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31954", "3248", "fld_8427909", "client_or_company", "Dave Jackson / 970-231-5528");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31953", "3248", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31952", "3248", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31951", "3248", "fld_165241", "date_of_work", "2021-02-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31950", "3248", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31948", "3247", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31949", "3248", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31947", "3247", "fld_592520", "cost_of_part_2", "53.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31946", "3247", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31945", "3247", "fld_9190675", "part_2_description", "16GB RAM 1600Mhz (2x8GB)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31944", "3247", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31943", "3247", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31942", "3247", "fld_5994139", "billing_notes", "Unable to fix Front Desk 1 due to working hours, rescheduled clone operation for that.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31940", "3247", "fld_291750", "date_completed", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31941", "3247", "fld_2572136", "description_of_work_completed", "Front Desk computers 1 and 2 both keep hard crashing, not even a blue screen just straight power off.\r\nCould not identify any concerning issues in event viewer but HDD in Front Desk 2 is failing.\r\nCloned and replaced Front Desk 2 HDD with 500GB SSD. Changed SATA mode from IDE to ACHI and switched to UEFI boot as opposed to legacy.\r\nRan prime95 full stress test for 30 minutes with no issues.\r\nInstalled 2 x 8GB RAM in Office Desktop, reconfigured BIOS due to reset to default caused by new RAM addition.\r\nShop Preon had no ethernet connectivity. Tested ethernet cable with full pass. Checked ethernet and found it had come loose from Netgear switch. Fixed snap-in ethernet coupler and reattached. Confirmed Preon network connectivity.\r\nReinstalled Brother Printer drivers on Preon due to lack of connection to Preon.\r\nTested transfer of phone call from Office desk phone to wireless phone, success.\r\nUnable to resolved issue with extension 2003, cannot call out or receive calls on that line.\r\nScheduled visit for 2.12.21 at 8am to clone and replace HDD on Front Desk 1.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31939", "3247", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31938", "3247", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31937", "3247", "fld_7309777", "minutes_spent", "180");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31936", "3247", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31935", "3247", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31934", "3247", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31930", "3246", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31931", "3246", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31932", "3246", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31929", "3246", "fld_2572136", "description_of_work_completed", "Main Office AP became disconnected.\r\nUnable to readopt remotely, requires on site visit to fix. Disassociated AP from HPEC Unifi Controller.\r\nUnplugged AP and tested out on different POE port. AP device is still functional.\r\nRemounted AP on wall and confirmed connectivity.\r\nAdopted AP and renamed to Main Office.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31933", "3247", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31928", "3246", "fld_291750", "date_completed", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31927", "3246", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31923", "3246", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31924", "3246", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31925", "3246", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31926", "3246", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31921", "3246", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31922", "3246", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31920", "3245", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31919", "3245", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31917", "3245", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31918", "3245", "fld_8555975", "license___", "422DT-YKTY2-N5VRM-LKW4R-7KSYS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31916", "3245", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31915", "3245", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31914", "3245", "fld_5994139", "billing_notes", "Vipre Key: 422DT-YKTY2-N5VRM-LKW4R-7KSYS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31913", "3245", "fld_2572136", "description_of_work_completed", "Reinstalled Vipre on Debbie Grace Mac due to corrupted installation.\r\nConfigured Vipre to have full disk permissions, setup daily Quick scan and Weekly Full scan.\r\nRan CCleaner for light cleanup, cleaned out 1.2GB of temp files.\r\nTried to get Teamviewer installation on other Mac but download could not complete. Will follow up once Teamviewer successfully downloads.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31912", "3245", "fld_291750", "date_completed", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31911", "3245", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31910", "3245", "fld_20888", "name_of_client", "Debbie Grace");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31901", "3244", "fld_5994139", "billing_notes", "Resolved. Issue due to email account being deactivated as per Staci.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31897", "3244", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31909", "3245", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31905", "3245", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31906", "3245", "fld_165241", "date_of_work", "2021-02-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31907", "3245", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31908", "3245", "fld_7309777", "minutes_spent", "35");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31904", "3245", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31903", "3244", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31902", "3244", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31900", "3244", "fld_2572136", "description_of_work_completed", "Disassociated Microsoft Office 2016 from sperez@greenearthcolo.com\r\nDisconnected sperez@greenearthcolo.com from GEE Sergio Perez computer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31899", "3244", "fld_291750", "date_completed", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31898", "3244", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31896", "3244", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31895", "3244", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31894", "3244", "fld_165241", "date_of_work", "2021-02-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31893", "3244", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31890", "3243", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31891", "3243", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31892", "3244", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31889", "3243", "fld_5994139", "billing_notes", "Total Time (hh:mm) = 01:50\r\n\r\nTotal Time (hours) = 1.83 hours\r\n\r\nTotal Time (minutes) = 110 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31888", "3243", "fld_2572136", "description_of_work_completed", "Angel\\\'s laptop delivery to E&T");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31887", "3243", "fld_291750", "date_completed", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31886", "3243", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31884", "3243", "fld_7309777", "minutes_spent", "110");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31885", "3243", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31882", "3243", "fld_165241", "date_of_work", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31883", "3243", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31881", "3243", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31879", "3242", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31880", "3243", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31878", "3242", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31877", "3242", "fld_5994139", "billing_notes", "Kent Adnet wanted to print from word he doesn\\\'t have a 365 license for office so he cannot print or export in word or any other office program. Kent said he had access to the GoDaddy admin but he doesn\\\'t nor is he the owner of the company I recommended that he talked to his superuser about upgraded to office 365 with Office add ons or for him to purchase a personal office 365 account / get office 2016 or 2019.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31876", "3242", "fld_2572136", "description_of_work_completed", "Couldn\\\'t Print updated Printer drivers\r\n\r\nTroubleshooting GoDaddy account login\r\n\r\nGroup Call with go daddy to upgrade office 365 \r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31875", "3242", "fld_291750", "date_completed", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31873", "3242", "fld_20888", "name_of_client", "Ken Adent");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31874", "3242", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31865", "3241", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31866", "3241", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31867", "3242", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31868", "3242", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31869", "3242", "fld_165241", "date_of_work", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31870", "3242", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31871", "3242", "fld_7309777", "minutes_spent", "78");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31872", "3242", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31864", "3241", "fld_5994139", "billing_notes", "Employee turnover\r\n(restrict old, set up new)\r\n+ timeclock app install\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31859", "3241", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31860", "3241", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31861", "3241", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31862", "3241", "fld_291750", "date_completed", "2021-02-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31863", "3241", "fld_2572136", "description_of_work_completed", "90 - minutes 2-08 and 2-09 Employee setup / turnover + timeclock install Kevin PC\r\nnew employee Bette Delourey let go, Sara Janssen rehired\r\ndisable edlourey account on AD and Office 365\r\nreactivate Sara Janssen and set up workstation (mcorliss old)\r\ninstall Timeclock MTS client app on Kevin desktop and configure\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31858", "3241", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31857", "3241", "fld_165241", "date_of_work", "2021-02-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31856", "3241", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31855", "3241", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31854", "3240", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31853", "3240", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31852", "3240", "fld_5994139", "billing_notes", "nework drive access request\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31851", "3240", "fld_2572136", "description_of_work_completed", "Access request  (Kathy) for Banking and Confidential drives\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31850", "3240", "fld_291750", "date_completed", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31849", "3240", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31848", "3240", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31847", "3240", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31845", "3240", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31846", "3240", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31844", "3240", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31843", "3240", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31842", "3239", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31841", "3239", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31840", "3239", "fld_5994139", "billing_notes", "Remove 18 Office 365 licenses\r\n\r\nNew Totals for GEE Office 365:\r\n\r\nExchange Online Plan 1             18 Licenses\r\nOffice 365 Premium                    1 License\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31838", "3239", "fld_291750", "date_completed", "2021-02-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31839", "3239", "fld_2572136", "description_of_work_completed", "Delete 18 email accounts from Office 365 (per request from Staci)\r\nset up forwards to tsandau@greenearthcolo.com from 4 licensed addresses \r\n(estimating@, delser@, landsupt@, mckaydavis@)\r\nclean up all unlicensed accounts\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31833", "3239", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31834", "3239", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31835", "3239", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31836", "3239", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31837", "3239", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31832", "3239", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31829", "3238", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31830", "3238", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31831", "3239", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31828", "3238", "fld_5994139", "billing_notes", "Office 365 Excel issues\r\n(Windows 7 to 10 upgrade + Office quirk)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31826", "3238", "fld_291750", "date_completed", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31827", "3238", "fld_2572136", "description_of_work_completed", "RPT113 John Bellinghausen Excel issues\r\n(Cannot open files on network)\r\nsfc + dism + repair office + update office\r\n+ set design drive as trusted location for Excel\r\nxls files now open normally\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31821", "3238", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31822", "3238", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31823", "3238", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31824", "3238", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31825", "3238", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31820", "3238", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31818", "3237", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31819", "3238", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31817", "3237", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31816", "3237", "fld_5994139", "billing_notes", "Vista 64-bit vs 32-bit issues on 3x workstations \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31813", "3237", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31814", "3237", "fld_291750", "date_completed", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31815", "3237", "fld_2572136", "description_of_work_completed", "64 bit Vista issues\r\nVista 64 bit is not compatible with some printer drivers and programs\r\nreplace 64-bit Vista with 32-bit on 3 workstations\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31812", "3237", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31809", "3237", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31810", "3237", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31811", "3237", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31808", "3237", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31805", "3236", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31806", "3236", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31807", "3237", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31804", "3236", "fld_5994139", "billing_notes", "2 workstations trust issue with WOBG domain\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31803", "3236", "fld_2572136", "description_of_work_completed", "2 workstations lost trust with network\r\nAssist Greg in fixing trust relationship with 2 WOBG PCs\r\n(Raegan Welte and Wendi Ward PCs)\r\nremove and re-add to AD domain\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31800", "3236", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31802", "3236", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31801", "3236", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31799", "3236", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31797", "3236", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31798", "3236", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31796", "3236", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31795", "3236", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31794", "3235", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31793", "3235", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31792", "3235", "fld_5994139", "billing_notes", "Assist Andy with unifi issue\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31791", "3235", "fld_2572136", "description_of_work_completed", "Assist Andy (onsite) with troubleshooting Unifi / Dairycomp\r\n(Both programs use port 8080 http/tcp)\r\nUnifi not compatible with dairycomp\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31789", "3235", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31790", "3235", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31788", "3235", "fld_20888", "name_of_client", "Morwai Dairy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31787", "3235", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31785", "3235", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31786", "3235", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31784", "3235", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31780", "3234", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31781", "3234", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31782", "3235", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31783", "3235", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31779", "3234", "fld_5994139", "billing_notes", "SPAM filtering adjustment\r\n(to block mlicious emails)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31778", "3234", "fld_2572136", "description_of_work_completed", "SPAM filtering investigate malicious emails\r\nand adjust Barracuda filtering to block.\r\n(fake invoice links getting through SPAM block)\r\nblock by message contect\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31777", "3234", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31776", "3234", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31766", "3233", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31767", "3233", "fld_2864175", "part1_description", "Raspberry Pi + case + Power Supply + microSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31768", "3233", "fld_8478853", "cost_of_part_1", "$80");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31769", "3233", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31770", "3234", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31771", "3234", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31772", "3234", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31773", "3234", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31774", "3234", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31775", "3234", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31765", "3233", "fld_5994139", "billing_notes", "3CX Raspi SBC rush build\r\n(Ashcroft phone server now remote)\r\nresolved\r\n\r\nNote - onsite install Dylan \r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31764", "3233", "fld_2572136", "description_of_work_completed", "2.5 hours Ashcroft 3CX - Build and configure Raspi 3CX SBC\r\n3CX server removed from Ashcroft broke phones\r\n(STUN only good for one phone, SBC necessary)\r\nbuild Raspi SBC to allow for remote 3CX hosting\r\nassist Dylan with install and provision phones for new setup\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31762", "3233", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31763", "3233", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31761", "3233", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31758", "3233", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31759", "3233", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31760", "3233", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31753", "3232", "fld_5994139", "billing_notes", "SSL cert re-sign and install\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31754", "3232", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31755", "3232", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31756", "3233", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31757", "3233", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31752", "3232", "fld_2572136", "description_of_work_completed", "New Godaddy SSL cert \r\nprove domain ownership, re-sign cert from CSR and install on Exchange 2010(SBS2011)\r\n+ remove old expired godaddy SSL certs\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31751", "3232", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31750", "3232", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31744", "3232", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31745", "3232", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31746", "3232", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31747", "3232", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31748", "3232", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31749", "3232", "fld_20888", "name_of_client", "Artisan / Brandon Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31740", "3231", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31741", "3231", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31742", "3231", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31743", "3232", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31738", "3231", "fld_291750", "date_completed", "2021-02-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31739", "3231", "fld_2572136", "description_of_work_completed", "Reinstalled FastTrack 10 on Tucker Clay\\\'s computer due to conflicting license with Sam Stetina.\r\n\r\nUnable to update license due to program being on on Sam\\\'s computer.\r\nClosed FastTrack on Sam\\\'s computer, reinstalled FastTrack 10 on Tucker\\\'s computer, updated license, and confirmed conflict was eliminated.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31737", "3231", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31736", "3231", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31735", "3231", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31734", "3231", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31733", "3231", "fld_165241", "date_of_work", "2021-02-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31732", "3231", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31731", "3231", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31729", "3230", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31726", "3230", "fld_5994139", "billing_notes", "This was all done on the Bench");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31730", "3230", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31727", "3230", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31728", "3230", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31724", "3230", "fld_291750", "date_completed", "2021-02-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31725", "3230", "fld_2572136", "description_of_work_completed", "Performed light cleaning of Edwin\\\'s ATC laptop after it was sent back to us due to login issues.\r\n\r\nRan HDD scan on Russell\\\'s laptop, which failed.\r\nCloned and replaced HDD with 500GB SSD on Russell\\\'s laptop.\r\n\r\nFrancisco\\\'s laptop will not boot, return to Gina, no further work requested.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31723", "3230", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31722", "3230", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31719", "3230", "fld_165241", "date_of_work", "2021-02-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31720", "3230", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31721", "3230", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31717", "3230", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31718", "3230", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31716", "3229", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31715", "3229", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31712", "3229", "fld_291750", "date_completed", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31713", "3229", "fld_2572136", "description_of_work_completed", "Removing saved Gmail password from office computers to prevent staff from getting access to her Gmail account.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31714", "3229", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31709", "3229", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31710", "3229", "fld_20888", "name_of_client", "Trish Leaner ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31711", "3229", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31708", "3229", "fld_7309777", "minutes_spent", "11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31707", "3229", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31706", "3229", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31704", "3229", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31705", "3229", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31701", "3228", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31703", "3228", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31702", "3228", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31700", "3228", "fld_2572136", "description_of_work_completed", "The user AbarrLake_Server\\\'s password on the server had expired, breaking mapped drive connections.\r\nCreated a new password and set it to not expire.\r\nReconnected Doctor\\\'s Office, Front Desk 1, and Front Desk 3 computers to mapped network drives on server.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31695", "3228", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31696", "3228", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31697", "3228", "fld_20888", "name_of_client", "Abarr Chiropractic");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31698", "3228", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31699", "3228", "fld_291750", "date_completed", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31694", "3228", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31693", "3228", "fld_165241", "date_of_work", "2021-02-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31690", "3227", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31691", "3228", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31692", "3228", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31686", "3227", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31687", "3227", "fld_2864175", "part1_description", "Raspberry Pie Supply\\\'s");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31688", "3227", "fld_9190675", "part_2_description", "6ft ethernet cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31689", "3227", "fld_8478853", "cost_of_part_1", "110.89");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31685", "3227", "fld_5994139", "billing_notes", "Total Time (hh:mm) = 02:27\r\n\r\nTotal Time (hours) = 2.45 hours\r\n\r\nTotal Time (minutes) = 147 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31683", "3227", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31684", "3227", "fld_2572136", "description_of_work_completed", "deployed 3CX SCB on a PIe\r\nReset all phones to default and setup to SBC IP\r\nChuck did all the remote configuration");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31682", "3227", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31681", "3227", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31679", "3227", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31680", "3227", "fld_7309777", "minutes_spent", "147");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31669", "3226", "fld_20888", "name_of_client", "Merritt Pitcher");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31670", "3226", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31671", "3226", "fld_291750", "date_completed", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31672", "3226", "fld_2572136", "description_of_work_completed", "Merrit called due to his speakers not working. \r\nUnable to see normal realtek speaker option.\r\nUninstalled and reinstalled realtek audio drivers.\r\n\r\nMerritt had the speakers plugged into the wrong slot but it was likely a combination of both bad drivers and an improper speaker audio cable connection.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31673", "3226", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31674", "3226", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31675", "3226", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31676", "3227", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31677", "3227", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31678", "3227", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31665", "3226", "fld_165241", "date_of_work", "2021-02-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31666", "3226", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31667", "3226", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31668", "3226", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31664", "3226", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31663", "3226", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31661", "3225", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31662", "3225", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31659", "3225", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31660", "3225", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31658", "3225", "fld_5994139", "billing_notes", "Ron Hencey\r\nronhencey@gmail.com\r\n703-231-4132\r\n\r\n957 Logan Ct.\r\nLoveland, CO\r\n80538");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31656", "3225", "fld_291750", "date_completed", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31657", "3225", "fld_2572136", "description_of_work_completed", "Client\\\'s computer would not properly boot, only a black screen.\r\nTried booting computer and it began to boot successfully, but stopped due to Windows updates.\r\nCompleted Windows updates and computer successfully booted up but really slowly.\r\nRan HDD scan (15+ orange, 4 red) / results indicate failing HDD.\r\nCloned and replaced 1 TB HDD with 500 GB SSD. Unstrapped old HDD but left inside computer for any future use.\r\nCompleted light cleanup of computer after clone operation completed successfully.\r\nInstalled remaining Windows updates, and ensured computer rebooted properly.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31651", "3225", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31652", "3225", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31653", "3225", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31654", "3225", "fld_20888", "name_of_client", "Ron Hencey / 703-231-4132");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31649", "3225", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31655", "3225", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31650", "3225", "fld_165241", "date_of_work", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31648", "3225", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31647", "3224", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31646", "3224", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31645", "3224", "fld_5994139", "billing_notes", "New laptop. Can print but not scan\r\n(utility / driver not installed)\r\n+ Zoom test call (successful)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31641", "3224", "fld_20888", "name_of_client", "Susan Pond / 970-532-4570");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31642", "3224", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31643", "3224", "fld_291750", "date_completed", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31644", "3224", "fld_2572136", "description_of_work_completed", "Assist Susan with new laptop -Zoom test + scanner setup\r\nSet up Brother MFC scanner (network) drivers & app + test\r\nrun Zoom test call to ensure video/mic/speakers working for upcoming Zoom meeting\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31639", "3224", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31640", "3224", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31638", "3224", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31637", "3224", "fld_165241", "date_of_work", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31624", "3223", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31625", "3223", "fld_165241", "date_of_work", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31626", "3223", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31627", "3223", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31628", "3223", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31629", "3223", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31630", "3223", "fld_291750", "date_completed", "2021-02-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31631", "3223", "fld_2572136", "description_of_work_completed", "Upgraded Vista on Geoff\\\'s laptop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31632", "3223", "fld_5994139", "billing_notes", "Slow connection. Recommend to Gina that Geoff needs a new laptop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31633", "3223", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31634", "3223", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31635", "3224", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31636", "3224", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31623", "3223", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31621", "3222", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31622", "3222", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31620", "3222", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31619", "3222", "fld_2572136", "description_of_work_completed", "Updated Vista on Stephen Boyd\\\'s computer and confirmed that Outlook and Vista both still work.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31618", "3222", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31617", "3222", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31616", "3222", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31615", "3222", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31604", "3221", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31605", "3221", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31606", "3221", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31607", "3221", "fld_2572136", "description_of_work_completed", "Setup VPN on Marek\\\'s desktop, now to be Dan C\\\'s remote desktop.\r\nConfigured remote desktop app to connect to Dan C\\\'s office desktop.\r\nSet static IP on Dan C\\\'s office desktop.\r\nConfirmed remote desktop connection works, unable to test VPN as both computers are still located at ATC CO office.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31608", "3221", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31609", "3221", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31610", "3221", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31611", "3222", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31612", "3222", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31613", "3222", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31614", "3222", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31601", "3221", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31602", "3221", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31603", "3221", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31600", "3221", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31599", "3221", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31596", "3220", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31597", "3220", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31598", "3220", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31594", "3220", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31595", "3220", "fld_2572136", "description_of_work_completed", "Turbotax updated kept crashes without successfully updating program.\r\nRestarted computer and manually started intuit update service, then started update process.\r\nUpdated succeeded and Turbotax is functioning.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31587", "3220", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31588", "3220", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31589", "3220", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31590", "3220", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31591", "3220", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31592", "3220", "fld_20888", "name_of_client", "Kirk Wiggins / 970-7441258");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31593", "3220", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31585", "3219", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31586", "3220", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31583", "3219", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31584", "3219", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31581", "3219", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31582", "3219", "fld_2572136", "description_of_work_completed", "Mapped the network drive on Mike Cook\\\'s laptop and remapped the network drive on Andrea Bustamante\\\'s desktop after connection failed the first time.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31580", "3219", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31579", "3219", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31577", "3219", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31578", "3219", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31576", "3219", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31575", "3219", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31574", "3219", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31573", "3218", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31572", "3218", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31571", "3218", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31568", "3218", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31569", "3218", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31570", "3218", "fld_2572136", "description_of_work_completed", "Updated Mickey Gowins and Jason Alldridge\\\'s Vista clients.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31567", "3218", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31566", "3218", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31564", "3218", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31565", "3218", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31559", "3217", "fld_2864175", "part1_description", "Mini Small Wireless Mouse for Travel Optical Portable Mini Cordless Mice with USB Receiver for PC Laptop Computer (Blue)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31563", "3218", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31560", "3217", "fld_8478853", "cost_of_part_1", "10.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31561", "3217", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31562", "3218", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31556", "3217", "fld_2572136", "description_of_work_completed", "computer cleanup on travel LT\r\nupgraded vipre definitions \r\nUpdated Java\r\nOrder Tiny Blue wireless mouse");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31558", "3217", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31557", "3217", "fld_5994139", "billing_notes", "2040 bushnell ave\r\nsan antonio texas 78212 \r\napartment 703\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31555", "3217", "fld_291750", "date_completed", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31554", "3217", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31553", "3217", "fld_20888", "name_of_client", "Flo Guido");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31552", "3217", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31546", "3216", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31547", "3217", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31548", "3217", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31549", "3217", "fld_165241", "date_of_work", "2021-02-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31550", "3217", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31551", "3217", "fld_7309777", "minutes_spent", "32");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31545", "3216", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31544", "3216", "fld_5994139", "billing_notes", "NOTE -   !!!AFTER HOURS WORK!!!\r\nViewpoint Vista Upgrade 8.25 hours \r\nAll performed friday night 01-29 and saturday 01-30 to prevent employee downtime and meet e-file deadlines\r\n\r\nURGENT request from Mindi (can\\\'t e-file taxes without upgrade)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31543", "3216", "fld_2572136", "description_of_work_completed", "8.25 Hours TOTAL 01-29 & 01-30 Viewpoint Vista Upgrade Server & 12 workstations:\r\nWindows Updates on AT-VISTA + Create checkpoint for fallback/reversion\r\nBackup Viewpoint repository backup SQL databases\r\nremove duplicate and test Viewpoint datases from instance (not allowed)\r\nUpgrade from Vista 6.19 to Vista 2020R2 and apply all database updates, app updates and service packs\r\n\r\nRemove old client apps and install new on workatations-\r\nMindi Walker\r\nApril W\r\nJohn Clark\r\nLanny Fievet\r\nMike Friend\r\nRussel Fuqua\r\nCandy Beitz\r\nClayton Maxey\r\nMelissa Richardson\r\nPam Heroux\r\nTS1\r\nTS2\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31542", "3216", "fld_291750", "date_completed", "2021-01-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31541", "3216", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31540", "3216", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31539", "3216", "fld_7309777", "minutes_spent", "495");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31538", "3216", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31537", "3216", "fld_165241", "date_of_work", "2021-01-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31536", "3216", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31535", "3216", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31534", "3215", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31533", "3215", "fld_8478853", "cost_of_part_1", "10.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31532", "3215", "fld_2864175", "part1_description", "Tiny Blue Mouse");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31531", "3215", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31530", "3215", "fld_5994139", "billing_notes", "2040 bushnell ave\r\nsan antonio texas 78212 \r\napt 703\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31529", "3215", "fld_2572136", "description_of_work_completed", "computer cleanup on travel LT\r\nupgraded vipre definitions \r\nUpdated Java\r\nOrder Tiny Blue wireless mouse");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31528", "3215", "fld_291750", "date_completed", "2021-01-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31527", "3215", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31523", "3215", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31524", "3215", "fld_7309777", "minutes_spent", "32");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31525", "3215", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31526", "3215", "fld_20888", "name_of_client", "Flo Guido");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31521", "3215", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31522", "3215", "fld_165241", "date_of_work", "2021-01-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31520", "3215", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31519", "3214", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31517", "3214", "fld_2864175", "part1_description", "4 Port Wall Plate");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31518", "3214", "fld_8478853", "cost_of_part_1", "4.26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31516", "3214", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31515", "3214", "fld_5994139", "billing_notes", "Collected ladders from location and brought back to office.\r\n\r\nThis visit was a total bust, really only installed a 4 port wall plate.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31512", "3214", "fld_20888", "name_of_client", "DanHydra");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31513", "3214", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31514", "3214", "fld_2572136", "description_of_work_completed", "Installed S video cable but discovered that it\\\'s not compatible with the logitech camera that Winston wishes to use.\r\n\r\nDrilled hole at bottom of table and ran ethernet, hdmi, and what will be the camera video game through.\r\nAdded 4 hole wall plate to bottom section, connected HDMI cable but ethernet cable keystone is not compatible. Need new ethernet keystone jack.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31511", "3214", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31509", "3214", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31510", "3214", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31508", "3214", "fld_165241", "date_of_work", "2021-01-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31507", "3214", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31506", "3214", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31504", "3213", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31505", "3213", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31503", "3213", "fld_5994139", "billing_notes", "IVR / VM setup \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31502", "3213", "fld_2572136", "description_of_work_completed", "Set up IVR and voicemail per customer spec and test\r\n(audio files sent from Andy)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31499", "3213", "fld_20888", "name_of_client", "EMC European motor Car");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31500", "3213", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31501", "3213", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31496", "3213", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31497", "3213", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31498", "3213", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31495", "3213", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31494", "3213", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31493", "3213", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31492", "3212", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31488", "3212", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31489", "3212", "fld_2572136", "description_of_work_completed", "Moved PC and now 2nd monitor does not work.\r\n(plugged into wrong HDMI has nvidia graphics but was plugged into MB)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31491", "3212", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31490", "3212", "fld_5994139", "billing_notes", "HDMI issue (plugged in wrong\r\nresolved\r\n\r\nNote - requested estimate for server build/install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31479", "3211", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31480", "3212", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31481", "3212", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31482", "3212", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31483", "3212", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31484", "3212", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31485", "3212", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31486", "3212", "fld_20888", "name_of_client", "Asher Architecture / David");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31487", "3212", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31478", "3211", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31477", "3211", "fld_5994139", "billing_notes", "spibr.org emails being blocked\r\n(SMTP2GO issue)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31476", "3211", "fld_2572136", "description_of_work_completed", "Joe reports outbound mail is being rejected. (mostly by servers in Europe)\r\nbounce message shows reverse DNS is required by SPAM filter\r\n(not present for SMTP2GO)\r\nswitch outbound mail in his Outlook to mail.daydreamit.com\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31474", "3211", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31475", "3211", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31465", "3210", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31466", "3210", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31467", "3211", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31468", "3211", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31469", "3211", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31470", "3211", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31471", "3211", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31472", "3211", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31473", "3211", "fld_20888", "name_of_client", "Joe Kittel / SPIBR");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31464", "3210", "fld_5994139", "billing_notes", "Network file in use / track down user\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31463", "3210", "fld_2572136", "description_of_work_completed", "Audit network drive (file in use)\r\nBrian R reports O:RPT4Matts FilesSampe SChedule2021.xlsx is busy\r\naudit shows in use by Jason Valentine, contacted \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31461", "3210", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31462", "3210", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31453", "3209", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31454", "3209", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31455", "3210", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31456", "3210", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31457", "3210", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31458", "3210", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31459", "3210", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31460", "3210", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31452", "3209", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31451", "3209", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31450", "3209", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31449", "3209", "fld_5994139", "billing_notes", "New user setup for E&T on Office 365, LAN and existing PC\r\n+1 Office 365 standard subscription\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31448", "3209", "fld_2572136", "description_of_work_completed", "New User - Kathy Lambros on E&T LAN/domain and Office 365\r\n+ set up Lisa Crandall old PC as E&T KATHY LAMBROS new PC\r\n+ system updates and basic service on PC (had been off for 75 days, required windows updates pending)\r\nnew email address - klambros@eandtelectric.com\r\nDomain user klambros\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31447", "3209", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31444", "3209", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31445", "3209", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31446", "3209", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31443", "3209", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31442", "3209", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31440", "3209", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31441", "3209", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31438", "3208", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31439", "3208", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31437", "3208", "fld_5994139", "billing_notes", "Email delivery audit rberry@advancetank.com to jsoprano@fpcusa.com\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31436", "3208", "fld_2572136", "description_of_work_completed", "Investigate blocked emails (Ryan Berry)\r\nemails from Ryan re being bounced when sent to fpcusa.com domain\r\nupon investigation only one user at domain is blocking him (jsoprano@fpcusa.com)\r\nRequest her to contact IT on her end and try to whitelist.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31435", "3208", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31434", "3208", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31432", "3208", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31433", "3208", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31431", "3208", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31429", "3208", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31430", "3208", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31428", "3208", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31427", "3207", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31426", "3207", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31425", "3207", "fld_5994139", "billing_notes", "SPAM filter mgmt.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31424", "3207", "fld_2572136", "description_of_work_completed", "Investigate mail phishing attempt and tighten SPAM filter\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31423", "3207", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31422", "3207", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31421", "3207", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31419", "3207", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31420", "3207", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31417", "3207", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31418", "3207", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31416", "3207", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31415", "3206", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31414", "3206", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31413", "3206", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31412", "3206", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31411", "3206", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31410", "3206", "fld_5994139", "billing_notes", "Office license upgrade\r\n- 1 Office 365 Basic\r\n+ 1 Office 365 Standard\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31409", "3206", "fld_2572136", "description_of_work_completed", "License upgrde BGranger (request from Greg)\r\nupgrade from Office Basic to Office Standard\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31407", "3206", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31408", "3206", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31402", "3206", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31403", "3206", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31404", "3206", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31405", "3206", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31406", "3206", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31401", "3206", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31400", "3205", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31399", "3205", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31398", "3205", "fld_5994139", "billing_notes", "Callcentric failover setup\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31397", "3205", "fld_2572136", "description_of_work_completed", "Adjust Village Optical Callcentric/3CX setup so voice calls failover \r\nset up graceful failover of Callcentric to Kevin cell on voice calls\r\n(disable forwards in favor of Call Treatments on voice linces)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31396", "3205", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31395", "3205", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31392", "3205", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31393", "3205", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31394", "3205", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31386", "3204", "fld_5994139", "billing_notes", "Minor QB issue (program hung)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31387", "3204", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31388", "3204", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31389", "3205", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31390", "3205", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31391", "3205", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31384", "3204", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31385", "3204", "fld_2572136", "description_of_work_completed", "Trish cannot open Quickbooks on RDS PC.\r\n(Multiple copies of QB running and program is frozen.\r\nKill all running instances and restart\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31383", "3204", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31382", "3204", "fld_20888", "name_of_client", "Trish Lerner / EMC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31380", "3204", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31381", "3204", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31371", "3203", "fld_8951874", "part_3_description", "2x");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31372", "3203", "fld_8478853", "cost_of_part_1", "98.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31373", "3203", "fld_592520", "cost_of_part_2", "15.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31374", "3203", "fld_5448517", "cost_of_part_3", "6ft. CAT 5e ethernet cable ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31375", "3203", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31376", "3204", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31377", "3204", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31378", "3204", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31379", "3204", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31370", "3203", "fld_9190675", "part_2_description", "5 Port Switch ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31369", "3203", "fld_2864175", "part1_description", "Unifi Cloudkey ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31368", "3203", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31367", "3203", "fld_5994139", "billing_notes", "2021-01-28\r\nResolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31365", "3203", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31366", "3203", "fld_2572136", "description_of_work_completed", "Dylan / Greg\r\n\r\n\r\nDisconnected GEE server from original location and installed at new location (Clearwater building).\r\nInstalled new Cloudkey v1 due to old Cloudkey v1 breaking.\r\nCleaned up network cabling in attic location.\r\nReset Trish, Mike, Darby, and McKay laptops due to GEE giving them away back to factory configuration.\r\nDisabled their accounts on domain controller.\r\nAdded accounting and ap e-mail accounts to Katie\\\'s DT\r\nRemapped server to Katie\\\'s laptop and desktop.\r\nSetup Andrea\\\'s desktop computer, added switch to give ethernet connection\r\nResolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31364", "3203", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31363", "3203", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31361", "3203", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31362", "3203", "fld_7309777", "minutes_spent", "390");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31360", "3203", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31358", "3203", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31359", "3203", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31357", "3202", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31356", "3202", "fld_592520", "cost_of_part_2", "15.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31352", "3202", "fld_2864175", "part1_description", "Unifi Cloudkey V1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31353", "3202", "fld_9190675", "part_2_description", "5 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31354", "3202", "fld_8951874", "part_3_description", "2 x 6ft. CAT 5e ethernet cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31355", "3202", "fld_8478853", "cost_of_part_1", "98.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31351", "3202", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31350", "3202", "fld_5994139", "billing_notes", "N/A");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31349", "3202", "fld_2572136", "description_of_work_completed", "Disconnected GEE server from original location and installed at new location (Clearwater building).\r\nInstalled new Cloudkey v1 due to old Cloudkey v1 breaking.\r\nCleaned up network cabling in attic location.\r\nReset Trish, Mike, Darby, and McKay laptops due to GEE giving them away back to factory configuration.\r\nDisabled their accounts on domain controller.\r\nAdded accounting and ap e-mail accounts to Katie\\\'s DT\r\nRemapped server to Katie\\\'s laptop and desktop.\r\nSetup Andrea\\\'s desktop computer, added switch to give ethernet connection\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31348", "3202", "fld_291750", "date_completed", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31347", "3202", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31346", "3202", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31345", "3202", "fld_7309777", "minutes_spent", "390");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31344", "3202", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31343", "3202", "fld_165241", "date_of_work", "2021-01-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31342", "3202", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31341", "3202", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31340", "3201", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31339", "3201", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31338", "3201", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31337", "3201", "fld_2572136", "description_of_work_completed", "Installed and configured software for HP Officejet 8600.\r\nPrinted test page to confirm everything is in working order.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31336", "3201", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31335", "3201", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31331", "3201", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31332", "3201", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31333", "3201", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31334", "3201", "fld_20888", "name_of_client", "Jeanna Cavanagh / 970-556-2588");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31330", "3201", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31329", "3201", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31328", "3201", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31326", "3200", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31327", "3200", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31325", "3200", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31324", "3200", "fld_2572136", "description_of_work_completed", "Michael Balluch could not connect to server.\r\nConfirmed he was working remotely but did not have VPN activated.\r\nEnabled VPN connection and connectivity to server was restored.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31322", "3200", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31323", "3200", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31320", "3200", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31321", "3200", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31319", "3200", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31318", "3200", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31317", "3200", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31316", "3200", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31315", "3199", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31314", "3199", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31313", "3199", "fld_5994139", "billing_notes", "Request came from Jeff Parziale. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31311", "3199", "fld_291750", "date_completed", "2021-01-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31312", "3199", "fld_2572136", "description_of_work_completed", "Updated plugins & themes, and changed updated contact information. Recreated two pages due to cache issues - the wrong address was showing.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31310", "3199", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31308", "3199", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31309", "3199", "fld_8427909", "client_or_company", "InStep Ministries / 970-775-4836");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31307", "3199", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31306", "3199", "fld_165241", "date_of_work", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31305", "3199", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31303", "3198", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31304", "3199", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31301", "3198", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31302", "3198", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31300", "3198", "fld_2572136", "description_of_work_completed", "Installed and configured software for HP Officejet 8600.\r\n\r\nConfirmed that printer produced test page.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31299", "3198", "fld_291750", "date_completed", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31294", "3198", "fld_165241", "date_of_work", "2021-01-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31295", "3198", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31296", "3198", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31297", "3198", "fld_8427909", "client_or_company", "Jan Barnett / 970-556-3131");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31298", "3198", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31293", "3198", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31292", "3198", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31291", "3197", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31290", "3197", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31289", "3197", "fld_5994139", "billing_notes", "Sage Version Upgrade 22.4 (to fix broken e-file and get new 2021 tax tables) Server + 2 workstations\r\ncomplete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31283", "3197", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31284", "3197", "fld_7309777", "minutes_spent", "240");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31285", "3197", "fld_8427909", "client_or_company", "Hawkstone Builders / 970-460-0497");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31286", "3197", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31287", "3197", "fld_291750", "date_completed", "2021-01-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31288", "3197", "fld_2572136", "description_of_work_completed", "01-26 4 hours - Sage Contractor 100 Update server & app to latest version for e-file and new tax tables\r\nback up SQL / image VM\r\nUpdate Server (Windows Updates) + reboot\r\nUpgrade Sage 100 Contractor to version 22.4 on server + 2 workstation\r\nUpgrade ll company files\r\ncomplete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31282", "3197", "fld_165241", "date_of_work", "2021-01-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31280", "3197", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31281", "3197", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31278", "3196", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31279", "3196", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31277", "3196", "fld_5994139", "billing_notes", "Larry Little\r\n970-344-5575\r\nlarry.little@comcast.net\r\n2425 Barela Dr.\r\nBerthoud, CO 80513");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31276", "3196", "fld_2572136", "description_of_work_completed", "Larry called in with a few complaints, chief complaint was that his computer no longer had sound.\r\nOther complaints: computer runs very slow, webcam working?, check for viruses?\r\n\r\nRan HDD scan and it came back with 5 red results and 16 orange, failing HDD.\r\nUninstalled Realtek HD Audio Driver and reverted to dell driver, restored audio.\r\nDiagnosed computer slowness cause due to failing HDD and minimal RAM (4gb only)\r\n\r\nDell All-in-One computer, 6 years old, recommended time to look at new computer. We could replace HDD and add in more RAM but long term, probably not worth the effort.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31275", "3196", "fld_291750", "date_completed", "2021-01-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31274", "3196", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31272", "3196", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31273", "3196", "fld_20888", "name_of_client", "Larry Little");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31271", "3196", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31269", "3196", "fld_165241", "date_of_work", "2021-01-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31270", "3196", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31268", "3196", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31267", "3196", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31264", "3195", "fld_8555975", "license___", "422DV-64S4X-TWA32-MSC2X-68FZS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31265", "3195", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31266", "3195", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31263", "3195", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31262", "3195", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31261", "3195", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31260", "3195", "fld_5994139", "billing_notes", "Vipre Key: 422DV-64S4X-TWA32-MSC2X-68FZS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31259", "3195", "fld_2572136", "description_of_work_completed", "Courtney was unable to connect to server.\r\nRestarted server, still no connection. Server had no internet connection and could not diagnose remotely.\r\nDiscovered switch had come unplugged, restored power to switch and server connectivity was restored to all computers except Courtney\\\'s.\r\nTurned network sharing on for Courtney\\\'s computer\r\nset network to private\r\nturned Vipre firewall off\r\nrestored connectivity to Server from Courtney\\\'s computer\r\nRenewed Vipre subscription on Courtney\\\'s computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31258", "3195", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31257", "3195", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31256", "3195", "fld_20888", "name_of_client", "NORCO Volleyball");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31254", "3195", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31255", "3195", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31251", "3195", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31253", "3195", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31252", "3195", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31249", "3194", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31250", "3195", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31248", "3194", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31247", "3194", "fld_5994139", "billing_notes", "Teams Audioconferencing setup\r\nadd 2 users & licenses\r\nresolved\r\n\r\nNote **RapidPro pays their own Office 365 bill we only manage**");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31244", "3194", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31245", "3194", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31246", "3194", "fld_2572136", "description_of_work_completed", "Teams add audioconferencing 2 more licenses and set up pperrotto and jvalentine\r\nto host meetings with dial in #s (for participants with no internet)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31243", "3194", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31242", "3194", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31241", "3194", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31240", "3194", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31239", "3194", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31238", "3194", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31237", "3193", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31236", "3193", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31235", "3193", "fld_5994139", "billing_notes", "Stephen Boyd - AL Vista reinstall\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31234", "3193", "fld_2572136", "description_of_work_completed", "Stephen Boyd AL Vista pp reinstall (to get around Crystal reports version error)\r\nVista conflicts with Sage (different Crystal Reports versions)\r\nStephen Boyd has both installed. Fix is to install VIsta last as it needs the later Crystal Reports version\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31233", "3193", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31232", "3193", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31231", "3193", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31230", "3193", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31229", "3193", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31224", "3192", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31225", "3192", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31226", "3193", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31228", "3193", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31227", "3193", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31223", "3192", "fld_5994139", "billing_notes", "Set up outbound DKIM on Office 365 email\r\n(sign all outbound email)\r\nclient request but also increases security\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31221", "3192", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31222", "3192", "fld_2572136", "description_of_work_completed", "Set up DKIM to sign ALL outbound messages (to correct blockage of outbound email by client)\r\nset up DKIM to enabled for outbound mail on Office 365 (advancetank.com)\r\ncreate selector1 and selector2 entries in Office365 Exchange mgmt\r\nset up CNAME pointers for selector1 and selector2 on Godaddy\r\ntest outbound mail and DKIM configuration\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31219", "3192", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31220", "3192", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31218", "3192", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31217", "3192", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31216", "3192", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31215", "3192", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31214", "3192", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31213", "3191", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31212", "3191", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31211", "3191", "fld_5994139", "billing_notes", "server reboot / Quickbooks\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31210", "3191", "fld_2572136", "description_of_work_completed", "Server reboot request (QB locked in single user, accountant not answering phone)\r\ntool shows kwalters in QB but they cannot get a hold of her\r\nmonitor until server back up\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31209", "3191", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31205", "3191", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31206", "3191", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31207", "3191", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31203", "3191", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31208", "3191", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31204", "3191", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31199", "3190", "fld_5994139", "billing_notes", "ext 2000 3CX phone (Yealink T22) provision\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31200", "3190", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31201", "3190", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31202", "3191", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31198", "3190", "fld_2572136", "description_of_work_completed", "reprovision phone for extension 2000 for Robin\r\n(pointed at different 3CX/broken provision)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31197", "3190", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31196", "3190", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31195", "3190", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31194", "3190", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31193", "3190", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31192", "3190", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31191", "3190", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31189", "3189", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31190", "3190", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31188", "3189", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31187", "3189", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31185", "3189", "fld_291750", "date_completed", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31186", "3189", "fld_2572136", "description_of_work_completed", "Configured Dave\\\'s e-mail on iPhone.\r\nWould not accept username and password combination.\r\nDeleted old account, reset password, re-added e-mail account with success.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31184", "3189", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31183", "3189", "fld_20888", "name_of_client", "Dave Jackson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31182", "3189", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31181", "3189", "fld_7309777", "minutes_spent", "50");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31180", "3189", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31178", "3189", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31179", "3189", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31165", "3188", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31166", "3188", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31167", "3188", "fld_165241", "date_of_work", "2021-01-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31168", "3188", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31169", "3188", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31170", "3188", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31171", "3188", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31172", "3188", "fld_291750", "date_completed", "2021-01-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31173", "3188", "fld_2572136", "description_of_work_completed", "Investigate repeted HDD alerts coming from RPT127\r\nRPT127 check operating system (SFC/Dism) no issue\r\nCheck SMART errors and HDD performance  - no issue\r\n(NO CHKDSK run because of Win 10 Chkdsk SSD crash issue)\r\nCheck system logs - no HDD issue BUT\r\nRPT127 going to sleep and waking up at same time as HDD alerts\r\nadjust power settings to prevent hybrid sleep & only sleep if locked\r\nwait to see if errors recur \r\nresolved\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31174", "3188", "fld_5994139", "billing_notes", "RPT127 issue showing as HDD alert, actual issue is hybrid sleep causing problems - corrupting running programs on return from sleep\r\nadjust power settings to resolve\r\n(so far error is gone)\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31175", "3188", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31176", "3188", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31177", "3189", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31164", "3187", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31163", "3187", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31162", "3187", "fld_5994139", "billing_notes", "unlock domain for transfer\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31161", "3187", "fld_2572136", "description_of_work_completed", "Unlock domain cesindustrial.com for transfer (Godaddy)  per Jeremy\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31156", "3187", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31157", "3187", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31158", "3187", "fld_8427909", "client_or_company", "CES Industrial / 970-663-9121");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31159", "3187", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31160", "3187", "fld_291750", "date_completed", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31151", "3186", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31152", "3186", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31153", "3187", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31154", "3187", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31155", "3187", "fld_165241", "date_of_work", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31150", "3186", "fld_5994139", "billing_notes", "1 hour Sage -AATRIX firewall issue (e-file)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31149", "3186", "fld_2572136", "description_of_work_completed", "Assist Jan with AATRIX setup (antivirus / firewall exception) Sage e-file\r\nAATRIX e-file does not succeed (blocked) - Check program documentation, \r\ncreate exceptions for A-V and firewall for AATRIX Sage add-ons\r\nWlk-through e-file form with Jan and verify error resolved\r\nresolved ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31147", "3186", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31148", "3186", "fld_291750", "date_completed", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31145", "3186", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31146", "3186", "fld_8427909", "client_or_company", "Hawkstone Builders / 970-460-0497");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31138", "3185", "fld_5994139", "billing_notes", "Advance Tank Access issue AprilW DT\r\nissue with access database\r\n(forward error to author)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31144", "3186", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31143", "3186", "fld_165241", "date_of_work", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31142", "3186", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31141", "3186", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31139", "3185", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31140", "3185", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31137", "3185", "fld_2572136", "description_of_work_completed", "Troubleshoot Access error April W PC\r\nher PC is throwing n MS Access dtabase error trying to close Access DB.\r\nCheck Access install and OS on her PC - Fine\r\nInvestigate error message - looks like a design issue with the Database\r\n(linked table query permission issue)\r\nforward to Access author for investigation (GIna)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31135", "3185", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31136", "3185", "fld_291750", "date_completed", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31133", "3185", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31134", "3185", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31132", "3185", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31130", "3185", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31131", "3185", "fld_165241", "date_of_work", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31128", "3184", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31129", "3185", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31127", "3184", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31126", "3184", "fld_5994139", "billing_notes", "SMB disconect assistance \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31124", "3184", "fld_291750", "date_completed", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31125", "3184", "fld_2572136", "description_of_work_completed", "5 minutes assist machine connection Bryan\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31123", "3184", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31121", "3184", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31122", "3184", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31113", "3183", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31114", "3183", "fld_2864175", "part1_description", "500gb ssd");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31115", "3183", "fld_8478853", "cost_of_part_1", "52.42");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31116", "3183", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31117", "3184", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31118", "3184", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31119", "3184", "fld_165241", "date_of_work", "2021-01-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31120", "3184", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31112", "3183", "fld_5994139", "billing_notes", "Total Time (hh:mm) = 02:26\r\n\r\nTotal Time (hours) = 2.43 hours\r\n\r\nTotal Time (minutes) = 146 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31111", "3183", "fld_2572136", "description_of_work_completed", "Replaced Hard drive with 500GB SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31109", "3183", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31108", "3183", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31110", "3183", "fld_291750", "date_completed", "2021-01-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31106", "3183", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31107", "3183", "fld_7309777", "minutes_spent", "146");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31105", "3183", "fld_165241", "date_of_work", "2021-01-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31104", "3183", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31100", "3182", "fld_5994139", "billing_notes", "3CX incoming call issues TX + DID setup\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31101", "3182", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31103", "3183", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31102", "3182", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31097", "3182", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31098", "3182", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31099", "3182", "fld_2572136", "description_of_work_completed", "ATC TX Phones reported issue incoming calls issue + Jeff Caudill DID setup (on Callcentric ext 104)\r\nSet up Jeff Caudill on DID for CC ext 104 (DID 281-402-6635)\r\n\r\nUsers report external incoming calls only ring once or twice then go to random voicemail...\r\n\r\nissue is several users have \\\'simultaneously ring mobile\\\' set (while in ring group). \r\nSo the calls are going to cell phone voice mails instead of ringing until answered..\r\n\r\ndisable \\\'simultaneous in favor of - ring 10 seconds then forward to mobile. + update firmwares on phones\r\n\r\nresolved\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31096", "3182", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31095", "3182", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31093", "3182", "fld_165241", "date_of_work", "2021-01-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31094", "3182", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31092", "3182", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31091", "3182", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31090", "3181", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31089", "3181", "fld_8478853", "cost_of_part_1", "132.95");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31088", "3181", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31087", "3181", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31086", "3181", "fld_5994139", "billing_notes", "Possibility now exists to do a P2P VPN connection but it is advised that Carrieann get a Static IP for her house.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31083", "3181", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31084", "3181", "fld_291750", "date_completed", "2021-01-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31085", "3181", "fld_2572136", "description_of_work_completed", "Install and configure new USG to replace old netgear router.\r\nConfirm that existing VPN connection still works properly and that RDP connection works as well.\r\nUpdated Unifi controller and firmware on both existing access point and new USG.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31082", "3181", "fld_20888", "name_of_client", "CMP Carrieann");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31080", "3181", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31081", "3181", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31078", "3181", "fld_165241", "date_of_work", "2021-01-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31079", "3181", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31077", "3181", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31076", "3181", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31074", "3180", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31075", "3180", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31073", "3180", "fld_5994139", "billing_notes", "Need to disable update without uninstalling as JAVA license has changed and new versions do not allow comercial use.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31072", "3180", "fld_2572136", "description_of_work_completed", "Disable java update popup Angela Shepard RPT110\r\nresolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31070", "3180", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31071", "3180", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31068", "3180", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31069", "3180", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31067", "3180", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31066", "3180", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31065", "3180", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31063", "3179", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31064", "3180", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31062", "3179", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31061", "3179", "fld_5994139", "billing_notes", "VPN issues denver office to FC\r\n(multiple PCs one VPN account confusing router)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31060", "3179", "fld_2572136", "description_of_work_completed", "Kevin unable to connect VPN from denver office laptop.\r\nupon investigation he is connecting to his FC office from multiple PCs in denver\r\n(same VPN creds) which seems to be confusing the VPN router.\r\nset up separate VPN creds for denver-laptop and denver-desktop\r\nso they can connect simultaneuosly from the same location\r\ntested and working");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31054", "3179", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31055", "3179", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31056", "3179", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31057", "3179", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31058", "3179", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31059", "3179", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31049", "3178", "fld_5994139", "billing_notes", "VPN troubleshooting + Server updates + maint. 2.25 hours total\r\n(pending updates/reboots messing up RDS)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31050", "3178", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31051", "3178", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31052", "3179", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31053", "3179", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31048", "3178", "fld_2572136", "description_of_work_completed", "01-12 2.25 hours total remote connection issues-\r\n1.25 hour VPN/RDS troubleshooting \r\n(pending updates + RDS cert expired) generate new sel-signed cert)\r\nreet RDS to allow connection by Patrick & scedule updates/erboot for evening.\r\n\r\n1 hour evening of 01-20-2021,  updates/maintenance/reboot 3 servers \r\n+ reboot all to resolve RDS issues\r\nSERVER01, SERVER01, AV1\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31044", "3178", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31045", "3178", "fld_20888", "name_of_client", "Avalon Gaming");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31046", "3178", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31047", "3178", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31043", "3178", "fld_7309777", "minutes_spent", "135");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31042", "3178", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31041", "3178", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31040", "3178", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31039", "3178", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31033", "3177", "fld_8478853", "cost_of_part_1", "15.99 per switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31034", "3177", "fld_592520", "cost_of_part_2", "79.99 (4 pack)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31035", "3177", "fld_5448517", "cost_of_part_3", "59.99 per UPS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31036", "3177", "fld_9182980", "cost_of_part_4", "0.50 per foot");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31030", "3177", "fld_8951874", "part_3_description", "2x cyberpower UPS ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31031", "3177", "fld_1621742", "part_4_description", "2x 0.5ft cat5e patch cables");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31037", "3177", "fld_8336117", "cost_of_part_5", "0.50 per foot");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31038", "3177", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31032", "3177", "fld_5404555", "part_5_description", "4x 6ft cat5e patch cables");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31029", "3177", "fld_9190675", "part_2_description", "4x Ubiquiti POE ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31028", "3177", "fld_2864175", "part1_description", "2x 5 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31027", "3177", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31026", "3177", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31022", "3177", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31023", "3177", "fld_2572136", "description_of_work_completed", "installed new 3cx server\r\nmoved 8 port 150w unifi switch from building 2 to office board \r\nadded ups to building 1 and 2 to power 2 unifi access points via POE injectors per building \r\ninstalled dedicated UPS for 3cx Server\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31025", "3177", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31024", "3177", "fld_5994139", "billing_notes", "Total Time (hh:mm) = 04:33\r\n\r\nTotal Time (hours) = 4.55 hours\r\n\r\nTotal Time (minutes) = 273 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31021", "3177", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31020", "3177", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31018", "3177", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31019", "3177", "fld_7309777", "minutes_spent", "273");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31016", "3177", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31017", "3177", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31015", "3177", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31013", "3176", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31014", "3176", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31012", "3176", "fld_5994139", "billing_notes", "Total Time (hh:mm) = 01:40\r\n\r\nTotal Time (hours) = 1.67 hours\r\n\r\nTotal Time (minutes) = 100 minutes\r\n\r\nNew Address\r\n23595  county road 62 80631");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31006", "3176", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31007", "3176", "fld_7309777", "minutes_spent", "100");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31008", "3176", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31009", "3176", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31010", "3176", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31011", "3176", "fld_2572136", "description_of_work_completed", "On site evaluation\r\n\r\nThey want the server moved on Jan 28th\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31005", "3176", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31004", "3176", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31002", "3175", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31003", "3176", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31001", "3175", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("31000", "3175", "fld_5994139", "billing_notes", "\r\nTotal Time (hh:mm) = 02:16\r\n\r\nTotal Time (hours) = 2.27 hours\r\n\r\nTotal Time (minutes) = 136 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30999", "3175", "fld_2572136", "description_of_work_completed", "Dylan and Andy Onsite visit to Ashcroft\r\n\r\nelectrical overview and diagnostic");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30998", "3175", "fld_291750", "date_completed", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30997", "3175", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30996", "3175", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30995", "3175", "fld_7309777", "minutes_spent", "136");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30994", "3175", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30993", "3175", "fld_165241", "date_of_work", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30992", "3175", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30991", "3175", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30990", "3174", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30989", "3174", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30988", "3174", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30987", "3174", "fld_2572136", "description_of_work_completed", "Pickup keyboard and mouse and delivery to Millennium Group Office.\r\nDelivery computer back to Lakeside mechanical.\r\npair Logitech keyboard to usb dongle to use on computer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30986", "3174", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30985", "3174", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30984", "3174", "fld_20888", "name_of_client", "Lakeside mechanical");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30981", "3174", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30982", "3174", "fld_7309777", "minutes_spent", "34");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30983", "3174", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30980", "3174", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30979", "3174", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30977", "3173", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30978", "3174", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30976", "3173", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30975", "3173", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30969", "3173", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30970", "3173", "fld_7309777", "minutes_spent", "12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30971", "3173", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30974", "3173", "fld_2572136", "description_of_work_completed", "Fix Remote IP Phone and provisioned to 3cx server.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30973", "3173", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30972", "3173", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30968", "3173", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30967", "3173", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30966", "3173", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30965", "3172", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30963", "3172", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30964", "3172", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30962", "3172", "fld_2572136", "description_of_work_completed", "Connected Printer to Laptop\r\nSet photo program settings\r\nmade the windows taskbar auto Hide");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30960", "3172", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30961", "3172", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30959", "3172", "fld_20888", "name_of_client", "Bonnie Liddle");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30958", "3172", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30956", "3172", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30957", "3172", "fld_7309777", "minutes_spent", "28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30955", "3172", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30954", "3172", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30952", "3171", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30953", "3172", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30951", "3171", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30950", "3171", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30947", "3171", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30949", "3171", "fld_2572136", "description_of_work_completed", "April was unable to connect to Wifi.\r\n\r\nWifi connection was manually turned off. Turned Wifi back on manually and set to not turn off automatically at any time.\r\nUnable to reconnect to belkin network. Rebooted Belkin router and connectivity was restored.\r\nTested internet connection to ensure that network connectivity was totally restored.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30948", "3171", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30944", "3171", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30945", "3171", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30946", "3171", "fld_20888", "name_of_client", "April Adams");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30942", "3171", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30943", "3171", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30941", "3171", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30938", "3170", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30939", "3170", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30940", "3171", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30937", "3170", "fld_5994139", "billing_notes", "PAID in FULL\r\n\r\nResolved\r\n\r\nPAID in FULL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30936", "3170", "fld_2572136", "description_of_work_completed", "Install and configure new Epson XP4100 all-in-one printer/scanner.\r\n\r\nTested and confirmed that print and scan functionalities worked as expected.\r\n\r\nConfigured scan to print function for artist program. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30934", "3170", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30935", "3170", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30933", "3170", "fld_20888", "name_of_client", "Larry Carroll");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30932", "3170", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30930", "3170", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30931", "3170", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30929", "3170", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30928", "3170", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30926", "3169", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30927", "3170", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30925", "3169", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30924", "3169", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30923", "3169", "fld_2572136", "description_of_work_completed", "Created an initial restore point.\r\nRan SAS, cleaned up cookies but no viruses or malware.\r\nChecked Vipre logs but nothing was detected.\r\nChecked Task scheduler but no suspicious tasks found.\r\nChecked history of Chrome and found that Jan had been redirected to a scam website that tries to initiate a download. Checked download history as well as intended download location, found no suspicious files.\r\nUninstalled SAS and ran CCleaner.\r\nCreated a final restore point.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30922", "3169", "fld_291750", "date_completed", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30921", "3169", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30920", "3169", "fld_20888", "name_of_client", "Jan Barnett");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30919", "3169", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30917", "3169", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30918", "3169", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30916", "3169", "fld_165241", "date_of_work", "2021-01-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30915", "3169", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30913", "3168", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30914", "3169", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30911", "3168", "fld_5994139", "billing_notes", "Cobian Installation Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30912", "3168", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30910", "3168", "fld_2572136", "description_of_work_completed", "Diagnosed an issue with her USB mouse and keyboard not functioning.\r\nInstructed Nancy to plug mouse and keyboard dongle into top USB slot and leave the other USB slot on top open.\r\n\r\nConfigured Cobian backup for three drive rotation using (3) 2TB external drives that Nancy purchased herself.\r\nEnsured that all three drives have proper Cobian folder format and proper drive lettering.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30908", "3168", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30909", "3168", "fld_291750", "date_completed", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30907", "3168", "fld_20888", "name_of_client", "Nancy Henry");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30906", "3168", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30905", "3168", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30903", "3168", "fld_165241", "date_of_work", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30904", "3168", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30902", "3168", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30900", "3167", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30901", "3168", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30899", "3167", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30898", "3167", "fld_5994139", "billing_notes", "In the office still ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30897", "3167", "fld_2572136", "description_of_work_completed", "Trip 1\r\nPicked up computer and returned to office\r\nTrip 2\r\nPicked up keyboard a mouse");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30896", "3167", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30895", "3167", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30894", "3167", "fld_7309777", "minutes_spent", "35");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30892", "3167", "fld_165241", "date_of_work", "2021-01-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30893", "3167", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30890", "3167", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30891", "3167", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30888", "3166", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30889", "3166", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30887", "3166", "fld_3346908", "email_account_3", "ptsully@me.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30886", "3166", "fld_5282413", "email_account_2", "ptsully123@gmail.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30885", "3166", "fld_7884222", "email_account_1", "patrick@milpond.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30884", "3166", "fld_4069791", "office_pro_subs", "3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30883", "3166", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30882", "3166", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30881", "3166", "fld_5994139", "billing_notes", "This is a test for office pro subscription fields. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30875", "3166", "fld_165241", "date_of_work", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30876", "3166", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30877", "3166", "fld_7309777", "minutes_spent", "6");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30878", "3166", "fld_8427909", "client_or_company", "24 Hour Sign Language / 888-811-2424 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30879", "3166", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30880", "3166", "fld_2572136", "description_of_work_completed", "This is a test for office pro subscription fields");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30870", "3165", "fld_3346908", "email_account_3", "ptssully@me.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30871", "3165", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30872", "3165", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30873", "3166", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30874", "3166", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30869", "3165", "fld_5282413", "email_account_2", "ptsully123@gmail.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30868", "3165", "fld_7884222", "email_account_1", "patrick@milpond.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30867", "3165", "fld_4069791", "office_pro_subs", "3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30866", "3165", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30865", "3165", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30864", "3165", "fld_5994139", "billing_notes", "This is a test for the Office Pro subscription fields");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30863", "3165", "fld_2572136", "description_of_work_completed", "This is a test for the Office Pro subscription fields");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30860", "3165", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30861", "3165", "fld_20888", "name_of_client", "test client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30862", "3165", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30859", "3165", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30858", "3165", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30857", "3165", "fld_165241", "date_of_work", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30856", "3165", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30855", "3165", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30854", "3164", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30853", "3164", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30851", "3164", "fld_2572136", "description_of_work_completed", "Trish was unable to remotely connect to EMC Office DT.\r\nSpoke with John and had computer go through a hard reboot. Computer finished installing Windows updates.\r\nSet updates to occur only during off hours. Set business hours to 5am to Midnight.\r\nSetup PPTP VPN on Trish Lerner\\\'s LTP FL.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30852", "3164", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30850", "3164", "fld_291750", "date_completed", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30849", "3164", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30847", "3164", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30848", "3164", "fld_20888", "name_of_client", "EMC / Trish Lerner");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30846", "3164", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30845", "3164", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30844", "3164", "fld_165241", "date_of_work", "2021-01-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30843", "3164", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("30842", "3164", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32601", "3297", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32602", "3297", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32603", "3297", "fld_165241", "date_of_work", "2021-03-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32604", "3297", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32605", "3297", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32606", "3297", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32607", "3297", "fld_20888", "name_of_client", "D&M Mobile RV Repair");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32608", "3297", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32609", "3297", "fld_291750", "date_completed", "2021-03-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32610", "3297", "fld_2572136", "description_of_work_completed", "Installed TeamViewer QS on Office and Parts computers.\r\nUpdated Outlook server settings from daydream to rvmobile domain.\r\nChanged on Office computer, Parts computer, and Don\\\'s home office computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32611", "3297", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32612", "3297", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32613", "3297", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32614", "3298", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32615", "3298", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32616", "3298", "fld_165241", "date_of_work", "2021-02-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32617", "3298", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32618", "3298", "fld_7309777", "minutes_spent", "2430");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32619", "3298", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32620", "3298", "fld_20888", "name_of_client", "Millennium Group - 970-663-1200");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32621", "3298", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32622", "3298", "fld_291750", "date_completed", "2021-03-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32623", "3298", "fld_2572136", "description_of_work_completed", "Server move daydreamit.com to daydreamit1.com - 40.5 hours total \r\n\r\n7.5 hours, 2-16 to 2-19 prep new virtual server set-up profiles and PHP,\r\n	backup sites not using our mail server, disable sites not active,\r\n\r\n6.5 hours (OVERTIME) 2-20 saturday evening move sites not using our mail server-\r\n	thehalllawoffice.com, villageopt.com, rainesproperties.com, suburbitat.org, \r\n	evlandtrust.org, etc. + troubleshoot DNS issues with godaddy support\r\n\r\n11 hours 2-24 to 2-26 - check DNS on all domains to verify we can move (one -fail allwaterllc.com customer contacted)\r\n	back up ALL remaining CPANEL accounts (80 total) to MG network, Verify correct settings in Godaddy and Bluehost,\r\n	set up and test server to server connection (old to new) for migration of large (over 10GB) sites. set up sftp to MG\r\n	backup server.\r\n\r\n8 hours (OVERTIME) Friday night 2-26 11:00PM to to 07:00AM Saturday morning -pause email service & move 35 sites from \r\n	old server to new + verify DNS, website and email\r\n\r\n4.5 hours (OVERTIME) Saturday night 10:00PM to 3:30M Sunday morning - stop email service on DDIT and move all remaining sites. \r\n	verify DNS, website and email working\r\n1 hour (OVERTIME) - user assistance spibr Joe Kittel and Henrys Pub (email connectivity)\r\n\r\n2 hours (OVERTIME) Sunday night - verify archival copies of all sites and spin down daydreamit.com \r\n	(remove all data from host and prepare for server to be shut down.)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32624", "3298", "fld_5994139", "billing_notes", "Server migration daydreamit to daydreamit1.com - Bluehost EOL migration for CentOS 6\r\n18.5 hours - Office time\r\n22.0 hours - Overtime\r\n40.5 hours - TOTAL\r\n\r\nWill send email separately re. Overtime as reminder\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32625", "3298", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32626", "3298", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32627", "3299", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32628", "3299", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32629", "3299", "fld_165241", "date_of_work", "2021-03-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32630", "3299", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32631", "3299", "fld_7309777", "minutes_spent", "43");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32632", "3299", "fld_8427909", "client_or_company", "MAC Electric / 970-669-2464");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32633", "3299", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32634", "3299", "fld_291750", "date_completed", "2021-03-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32635", "3299", "fld_2572136", "description_of_work_completed", "Set up VPN on Michelle McLaughlin new LT\r\nadded QuickBooks files on network drive \r\n\r\nJareds  LT\r\nmapped network drives to new LT\r\nadded scans folder to desktop \r\nSetup VPN/Wifi\r\nadded admin printer\r\nInstalled Drivers for admin printer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32636", "3299", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32637", "3299", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32638", "3299", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32639", "3300", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32640", "3300", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32641", "3300", "fld_165241", "date_of_work", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32642", "3300", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32643", "3300", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32644", "3300", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32645", "3300", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32646", "3300", "fld_291750", "date_completed", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32647", "3300", "fld_2572136", "description_of_work_completed", "Updated Outlook mail settings on Tom\\\'s laptop.\r\nChecked that home desktop and office desktop had already been updated, confirmed this to Tom.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32648", "3300", "fld_5994139", "billing_notes", "Chuck did the desktops.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32649", "3300", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32650", "3300", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32651", "3301", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32652", "3301", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32653", "3301", "fld_165241", "date_of_work", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32654", "3301", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32655", "3301", "fld_7309777", "minutes_spent", "68");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32656", "3301", "fld_8427909", "client_or_company", "Peak To Peak / 970-622-8056");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32657", "3301", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32658", "3301", "fld_291750", "date_completed", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32659", "3301", "fld_2572136", "description_of_work_completed", "Her email got hacked\r\n\r\nsetup 2FA to cell phone\r\nchange outlook pw\r\nchange Gmail password\r\nran SAS and Vipre\r\nanswered computer questions about\r\n-keystroke virus \r\n-spyware \r\n-ransomware \r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32660", "3301", "fld_5994139", "billing_notes", "Name:  Peggy Edwards\r\nPhone:  970-217-0559\r\nMy Little Help");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32661", "3301", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32662", "3301", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32663", "3302", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32664", "3302", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32665", "3302", "fld_165241", "date_of_work", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32666", "3302", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32667", "3302", "fld_7309777", "minutes_spent", "510");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32668", "3302", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32669", "3302", "fld_20888", "name_of_client", "Interior Design Concepts");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32670", "3302", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32671", "3302", "fld_291750", "date_completed", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32672", "3302", "fld_2572136", "description_of_work_completed", "Setup and install Graviton for Lori and Ion for Danielle.\r\nTransfer data from Lori\\\'s computer to new Graviton.\r\nTransfer data from Danielle\\\'s computer to new Ion.\r\nInstall new UPS units, ensured that computer and monitors are plugged into battery side for both Lori and Danielle.\r\nInstall and setup software for Brother and Canon printer on both Lori\\\'s and Danielle\\\'s new computers.\r\nInstall and setup software for Elite check reader device on Danielle\\\'s computer.\r\nSetup shared Scans folder on Lori\\\'s computer and configured Canon scanner/printer to scan to folder.\r\nSetup shared Scans folder on Danielle\\\'s computer and configured Canon scanner/printer to scan to folder.\r\nSetup new 32\\\" and 23\\\" monitors, one for each desk per request.\r\nRemoved old Sophos networking device, switched wall LAN port 4 back to Linksys router device.\r\nSetup and configured JungleDisk Workgroup on both Lori\\\'s and Danielle\\\'s computers.\r\nTidied up cabling underneath desks.\r\nRemoved old computers, monitors, and cabling.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32673", "3302", "fld_5994139", "billing_notes", "Installed new Graviton and new Ion.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32674", "3302", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32675", "3302", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32676", "3303", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32677", "3303", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32678", "3303", "fld_165241", "date_of_work", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32679", "3303", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32680", "3303", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32681", "3303", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32682", "3303", "fld_20888", "name_of_client", "Joe Tarantino");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32683", "3303", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32684", "3303", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32685", "3303", "fld_2572136", "description_of_work_completed", "Installed TeamViewer on Joe\\\'s android phone.\r\nReset Joe\\\'s email password per request.\r\nConfigured Joe\\\'s phone for new mail settings (mail.taranco.com) (smtp2go).\r\nConfirmed that settings worked and new emails could be seen.\r\nUpdated Joe\\\'s laptop with new password and set outgoing mail server settings to smtp2go.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32686", "3303", "fld_5994139", "billing_notes", "Joe\\\'s email settings are now under client setup in a folder of his own.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32687", "3303", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32688", "3303", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32689", "3304", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32690", "3304", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32691", "3304", "fld_165241", "date_of_work", "2021-03-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32692", "3304", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32693", "3304", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32694", "3304", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32695", "3304", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32696", "3304", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32697", "3304", "fld_2572136", "description_of_work_completed", "Village Optical Timeclock MTS corruption - send Timeclock database + server updates\r\nbackup timeclock database then zip and send to support\r\nreceive fixed database and re-install\r\nInstall Microsoft Patch Tuesday updates on server & reboot\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32698", "3304", "fld_5994139", "billing_notes", "Timeclock MTS fix + server OS updates\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32699", "3304", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32700", "3304", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32701", "3305", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32702", "3305", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32703", "3305", "fld_165241", "date_of_work", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32704", "3305", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32705", "3305", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32706", "3305", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32707", "3305", "fld_20888", "name_of_client", "Trish Phetteplace");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32708", "3305", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32709", "3305", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32710", "3305", "fld_2572136", "description_of_work_completed", "Taught Trish how to download a file as opposed to use in Google docs.\r\nTaught Trish how to maximize and minimize a Chrome browser window.\r\nTaught Trish how to attach a file to her email for sending, after having saved the file locally to her computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32711", "3305", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32712", "3305", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32713", "3305", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32714", "3306", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32715", "3306", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32716", "3306", "fld_165241", "date_of_work", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32717", "3306", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32718", "3306", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32719", "3306", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32720", "3306", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32721", "3306", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32722", "3306", "fld_2572136", "description_of_work_completed", "Installed 3 port wall plate to run PS2 video cable through for webcam.\r\nMounted webcam and connected to PS2 cable.\r\nInstalled cable floor plates and ran: power, ethernet, PS2 cable, and HDMI cables through.\r\nTidied up cable management underneath table, connected webcam device, tested for power.\r\n\r\nTried to locate ethernet cable connection going to break room, unsuccessful.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32723", "3306", "fld_5994139", "billing_notes", "Winston is trying to install one printer by breakroom and one printer by southern entrance of Warehouse 1, which is their shipping and receiving area.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32724", "3306", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32725", "3306", "fld_2864175", "part1_description", "25ft PS2 cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32726", "3306", "fld_9190675", "part_2_description", "Floor Cord Cable Cover (2 pack)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32727", "3306", "fld_8478853", "cost_of_part_1", "$6.86");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32728", "3306", "fld_592520", "cost_of_part_2", "$29.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32729", "3306", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32730", "3307", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32731", "3307", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32732", "3307", "fld_165241", "date_of_work", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32733", "3307", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32734", "3307", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32735", "3307", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32736", "3307", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32737", "3307", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32738", "3307", "fld_2572136", "description_of_work_completed", "Unable to send email to specific hotmail account.\r\nTom is using Webmail cpanel, unable to configure for SMTP2Go settings.\r\nTried sending email from Outlook but email still bounced.\r\nTom\\\'s subnet was listed on UCEProtect, possibly emails being blocked due to this, will automatically unlist itself after set period of time.\r\nTom was sending email with entire message in subject line, but nothing in actual message. Likely to cause blacklisting due to suspicious email behavior. Encouraged Tom to send emails with minimal Subject lines, and to send from Outlook.\r\n\r\nRecommended that Shirley (sp?) get separate email account due to added complexity of using the same email account tpitts@waterconsult.com\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32739", "3307", "fld_5994139", "billing_notes", "Situation is very confusing and unnecessarily complicated.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32740", "3307", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32741", "3307", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32742", "3308", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32743", "3308", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32744", "3308", "fld_165241", "date_of_work", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32745", "3308", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32746", "3308", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32747", "3308", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32748", "3308", "fld_20888", "name_of_client", "Speedy Sparkle Carwash Loveland");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32749", "3308", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32750", "3308", "fld_291750", "date_completed", "2021-03-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32751", "3308", "fld_2572136", "description_of_work_completed", "Assist setting up port forwards for new DVR camera system\r\nforward ports 80, 8000, 8554 TCP and UDP to 192.168.175.28\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32752", "3308", "fld_5994139", "billing_notes", "New DVR port forwards (Sonicwall)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32753", "3308", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32754", "3308", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32755", "3309", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32756", "3309", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32757", "3309", "fld_165241", "date_of_work", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32758", "3309", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32759", "3309", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32760", "3309", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32761", "3309", "fld_20888", "name_of_client", "EVLT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32762", "3309", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32763", "3309", "fld_291750", "date_completed", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32764", "3309", "fld_2572136", "description_of_work_completed", "Walked Jeffrey through initial computer setup, as well as installation of Teamviewer QS\r\nPerformed new computer setup with MG performance tweaks\r\nInstalled normal MG programs\r\nSetup VPN to connect remotely, unable to test due to laptop being at office during setup\r\nMapped network drive from server to Z:\r\nInstalled Office 2016 Pro Plus\r\nInstalled Cylance (EVLT-JBoring)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32765", "3309", "fld_5994139", "billing_notes", "Office 2016 Pro Plus Key: J9BNY-XWWMH-YGMHB-QMTPV-PWGK2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32766", "3309", "fld_7842020", "cylance_installed.opt1358823", "Cylance Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32767", "3309", "fld_7842020", "cylance_installed", "{\"opt1358823\":\"Cylance Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32768", "3309", "fld_39256", "subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32769", "3309", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32770", "3309", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32771", "3309", "fld_4069791", "office_pro_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32772", "3309", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32773", "3309", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32774", "3310", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32775", "3310", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32776", "3310", "fld_165241", "date_of_work", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32777", "3310", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32778", "3310", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32779", "3310", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32780", "3310", "fld_20888", "name_of_client", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32781", "3310", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32782", "3310", "fld_291750", "date_completed", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32783", "3310", "fld_2572136", "description_of_work_completed", "Elaine called saying that she could not connect to the server.\r\nUnable to remotely connect to server, requires on site visit.\r\nWent to CorKat and found that server had no internet access but was fully functional.\r\nTried setting all network adapters to DHCP, no successful connection to internet.\r\nEnabled secondary ethernet adapter, set to DHCP, set to static, still no internet connectivity.\r\nAble to connect to Sonicwall but nothing beyond.\r\nSonicwall WAN port was not lit up, followed the cable to patch panel and beyond but no issues detected.\r\nDiscovered server randomly had re-established internet connectivity.\r\n\r\nIssue was likely a loose ethernet cable, going from Sonicwall to patch panel. Replugged ethernet into patch panel and confirmed that internet connectivity was restored to both main server and phone server.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32784", "3310", "fld_5994139", "billing_notes", "Resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32785", "3310", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32786", "3310", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32787", "3311", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32788", "3311", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32789", "3311", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32790", "3311", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32791", "3311", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32792", "3311", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32793", "3311", "fld_20888", "name_of_client", "EVLT");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32794", "3311", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32795", "3311", "fld_291750", "date_completed", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32796", "3311", "fld_2572136", "description_of_work_completed", "Recreated L2TP VPN and created PPTP VPN options on Jeffrey\\\'s new laptop.\r\nRemapped server data folder as well as server scans folder to network drives.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32797", "3311", "fld_5994139", "billing_notes", "Unable to map network drive by computer name, only able via IP address.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32798", "3311", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32799", "3311", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32800", "3312", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32801", "3312", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32802", "3312", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32803", "3312", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32804", "3312", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32805", "3312", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32806", "3312", "fld_20888", "name_of_client", "Jennifer ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32807", "3312", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32808", "3312", "fld_291750", "date_completed", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32809", "3312", "fld_2572136", "description_of_work_completed", "Remapped network drive with company files\r\ngave database admin access\r\nsync QuickBooks to database \r\ncreated a QuickBooks backup");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32810", "3312", "fld_5994139", "billing_notes", "Jennifer \r\nnomades collection LLC\r\n\r\nPhone Number: 9702147878\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32811", "3312", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32812", "3312", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32813", "3313", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32814", "3313", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32815", "3313", "fld_165241", "date_of_work", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32816", "3313", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32817", "3313", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32818", "3313", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32819", "3313", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32820", "3313", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32821", "3313", "fld_2572136", "description_of_work_completed", "Kennia (Human Resources) called as she has to work remote.\r\nSetup SSL VPN account on Sophos device.\r\nTransferred SSL VPN installer with configuration files for HRadmin account.\r\nInstalled SSL VPN client, instructed Kennia in it\\\'s use.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32822", "3313", "fld_5994139", "billing_notes", "Sophos VPN Account Created\r\nuser: HRadmin\r\nPW: 9+3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32823", "3313", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32824", "3313", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32825", "3314", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32826", "3314", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32827", "3314", "fld_165241", "date_of_work", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32828", "3314", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32829", "3314", "fld_7309777", "minutes_spent", "21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32830", "3314", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32831", "3314", "fld_20888", "name_of_client", "Cindy Boyatt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32832", "3314", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32833", "3314", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32834", "3314", "fld_2572136", "description_of_work_completed", "Updated email IMAP/SMTP server on Cindy\\\'s iPhone");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32835", "3314", "fld_5994139", "billing_notes", "Completed\r\n9702150932\r\ncindy@boyattglass.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32836", "3314", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32837", "3314", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32838", "3315", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32839", "3315", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32840", "3315", "fld_165241", "date_of_work", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32841", "3315", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32842", "3315", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32843", "3315", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32844", "3315", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32845", "3315", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32846", "3315", "fld_2572136", "description_of_work_completed", "Village Optical VPN issues- 1 hour 15 minutes 3-4 through 3-8\r\n(They have multiple VPN protocols in parallel. It took some effort to get thme to play nicely together)\r\nPPTP VPN on Windows Server (Service passed through firewall)\r\nSonicwall VPN hosts L2TP and Sonicwall SSLVPN services\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32847", "3315", "fld_5994139", "billing_notes", "VPN issues VO\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32848", "3315", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32849", "3315", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32850", "3316", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32851", "3316", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32852", "3316", "fld_165241", "date_of_work", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32853", "3316", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32854", "3316", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32855", "3316", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32856", "3316", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32857", "3316", "fld_291750", "date_completed", "2021-03-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32858", "3316", "fld_2572136", "description_of_work_completed", "SPAM filter maintenance (to block new PHISHING campaign)\r\n+ user assistance 3CX (April)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32859", "3316", "fld_5994139", "billing_notes", "SPAM filter maint + 3CX support\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32860", "3316", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32861", "3316", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32862", "3317", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32863", "3317", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32864", "3317", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32865", "3317", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32866", "3317", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32867", "3317", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32868", "3317", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32869", "3317", "fld_291750", "date_completed", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32870", "3317", "fld_2572136", "description_of_work_completed", "Set up user account and PC for new HR Supervisor\r\n(use - Angel Guzman LT) DO Wndows Updates + set up profile & Outlook\r\nresolved \r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32871", "3317", "fld_5994139", "billing_notes", "laptop setup E&T HR Rep\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32872", "3317", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32873", "3317", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32874", "3318", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32875", "3318", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32876", "3318", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32877", "3318", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32878", "3318", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32879", "3318", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32880", "3318", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32881", "3318", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32882", "3318", "fld_2572136", "description_of_work_completed", "Archive Brad Devore to below 50GB on inbox for Teams + Audio conf. licensing\r\nswitch to Microsoft Office Basic + Audio Add-on (from Exchange Plan 2)\r\nadd Jonathan Loya Add-on license for Audio conferencing\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32883", "3318", "fld_5994139", "billing_notes", "Teams and Audio Conferencing setup & troubleshooting 2 users B Devore & J Loya\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32884", "3318", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32885", "3318", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32886", "3319", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32887", "3319", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32888", "3319", "fld_165241", "date_of_work", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32889", "3319", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32890", "3319", "fld_7309777", "minutes_spent", "270");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32891", "3319", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32892", "3319", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32893", "3319", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32894", "3319", "fld_2572136", "description_of_work_completed", "Installed new Preon for Mario.\r\nInstalled and configured Quickbooks for Mario, ensured he could login to company files.\r\nInstalled and configured Office 365 for Mario.\r\nInstalled and configured printer software for HP laserjet. Verified scan and print functionality work.\r\nAdded 4 port USB 3.0 hub to expand USB options for Preon.\r\n\r\nSetup three drive rotation backup on E&T server with (3) 4TB WD drives.\r\nInstalled and configured Cobian for, Daily, Weekly, and Monthly backups from the DATA folder on the C: drive.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32895", "3319", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32896", "3319", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32897", "3319", "fld_2864175", "part1_description", "Sabrent 4 Port USB 3.0 Hub");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32898", "3319", "fld_9190675", "part_2_description", "Western Digital 4TB External Drive (x3)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32899", "3319", "fld_8478853", "cost_of_part_1", "$9.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32900", "3319", "fld_592520", "cost_of_part_2", "$89.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32901", "3319", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32902", "3320", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32903", "3320", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32904", "3320", "fld_165241", "date_of_work", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32905", "3320", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32906", "3320", "fld_7309777", "minutes_spent", "32");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32907", "3320", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32908", "3320", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32909", "3320", "fld_291750", "date_completed", "2021-03-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32910", "3320", "fld_2572136", "description_of_work_completed", "Install office 365 on Tristan Cantu\\\'s computer ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32911", "3320", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32912", "3320", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32913", "3320", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32914", "3320", "fld_3664993", "office_subs", "0");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32915", "3320", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32916", "3320", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32917", "3321", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32918", "3321", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32919", "3321", "fld_165241", "date_of_work", "2021-03-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32920", "3321", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32921", "3321", "fld_7309777", "minutes_spent", "390");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32922", "3321", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32923", "3321", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32924", "3321", "fld_291750", "date_completed", "2021-03-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32925", "3321", "fld_2572136", "description_of_work_completed", "Installed and configured USG along with Cloud Key v1 and wireless access point.\r\nInstalled 16 Port switch and 8 port switch.\r\nConfigured DHCP on USG to pass out IPs from 192.168.4.100 to .240\r\nConfigured Guest network to 192.168.5.x\r\nConfigured VPN network to 192.168.6.x\r\nSetup VPN account for Eric and David, unable to setup for Sam as his laptop was in use.\r\nInstalled and configured teamviewer on all computers at Asher.\r\nSetup DATA drive and shared out folder along with sub-folders.\r\nMapped network drive Z on each computer to DATA folder on server.\r\nSetup Cobian with 3 drive rotation to backup DATA folder on server.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32926", "3321", "fld_5994139", "billing_notes", "Sam will need a VPN created for him. Instructed customer to call us when ready.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32927", "3321", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32928", "3321", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32929", "3321", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32930", "3321", "fld_2864175", "part1_description", "16 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32931", "3321", "fld_9190675", "part_2_description", "8 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32932", "3321", "fld_8951874", "part_3_description", "USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32933", "3321", "fld_1621742", "part_4_description", "UAP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32934", "3321", "fld_5404555", "part_5_description", "Cloud Key v1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32935", "3321", "fld_8478853", "cost_of_part_1", "$69.34");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32936", "3321", "fld_592520", "cost_of_part_2", "$17.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32937", "3321", "fld_5448517", "cost_of_part_3", "$131.06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32938", "3321", "fld_9182980", "cost_of_part_4", "$72.42");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32939", "3321", "fld_8336117", "cost_of_part_5", "$98.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32940", "3321", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32941", "3322", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32942", "3322", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32943", "3322", "fld_165241", "date_of_work", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32944", "3322", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32945", "3322", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32946", "3322", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32947", "3322", "fld_20888", "name_of_client", "Bill Krug (KEM Homes)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32948", "3322", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32949", "3322", "fld_291750", "date_completed", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32950", "3322", "fld_2572136", "description_of_work_completed", "Helped Bill with updating Vickie\\\'s UC Health account password.\r\nChrome would not prompt to save updated password. Manually edited saved password to new.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32951", "3322", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32952", "3322", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32953", "3322", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32954", "3323", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32955", "3323", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32956", "3323", "fld_165241", "date_of_work", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32957", "3323", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32958", "3323", "fld_7309777", "minutes_spent", "801");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32959", "3323", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32960", "3323", "fld_20888", "name_of_client", "Hicast ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32961", "3323", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32962", "3323", "fld_291750", "date_completed", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32963", "3323", "fld_2572136", "description_of_work_completed", "(1)Robert set cameras to wrong IP.\r\n-192.168.30-40\r\n\r\n4X Mac mini goes offline (1.8 Hours per trip)\r\n-took to office plugged into a monitor and reset to DHCP\r\n\r\n(3) Resetting camera IP\\\'s \r\n\r\n\r\n\r\n\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32964", "3323", "fld_5994139", "billing_notes", "(1) Robert put them on the camera\\\'s on the wrong Ip\\\'s same IP of USG AP\\\'s and the switch\\\'s he took down do to ip conflicts taking almost 3 hours to fix.\r\n(2.15 Hours)\r\n\r\n(2) Took to office plugged into a monitor and reset to DHCP. then delivered it back to Norco (7.2 total Hours)\r\n\r\n(3) The camera\\\'s IP\\\'s where not set on what they should and Robert couldn\\\'t even get into the mac mini to change so i changed everything redid the port forwarding contacted Greg/Robert and they said everything looks correct. (4 hours)\r\n\r\nTotal Hours: 13.35\r\nTotal Minutes: 801");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32965", "3323", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32966", "3323", "fld_2864175", "part1_description", "cat 6 shielded 3ft cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32967", "3323", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32968", "3324", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32969", "3324", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32970", "3324", "fld_165241", "date_of_work", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32971", "3324", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32972", "3324", "fld_7309777", "minutes_spent", "50");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32973", "3324", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32974", "3324", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32975", "3324", "fld_291750", "date_completed", "2021-03-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32976", "3324", "fld_2572136", "description_of_work_completed", "Tony was unable to access the E&T QuickBooks file.\r\nUpdated QuickBooks to latest version, still not able to access file.\r\nRepaired QuickBooks installation, still not able to access file.\r\nUnable to repair file using QuickBooks doctor.\r\nRan file repair on Server, completed repair process but still unsuccessful.\r\nDiscovered that Tony was trying to access the wrong version of the file.\r\nDirected towards correct file, everything started working again.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32977", "3324", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32978", "3324", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32979", "3324", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32980", "3325", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32981", "3325", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32982", "3325", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32983", "3325", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32984", "3325", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32985", "3325", "fld_8427909", "client_or_company", "Harris Constructors, Inc. / 970-506-2745");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32986", "3325", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32987", "3325", "fld_291750", "date_completed", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32988", "3325", "fld_2572136", "description_of_work_completed", "Assisted Randee Harris in updating her ABOUT US page on her website.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32989", "3325", "fld_5994139", "billing_notes", "Bill for 45 minutes.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32990", "3325", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32991", "3325", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32992", "3326", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32993", "3326", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32994", "3326", "fld_165241", "date_of_work", "2021-02-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32995", "3326", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32996", "3326", "fld_7309777", "minutes_spent", "105");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32997", "3326", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32998", "3326", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("32999", "3326", "fld_291750", "date_completed", "2021-03-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33000", "3326", "fld_2572136", "description_of_work_completed", "Updated staff page with the addition of three new employees. Staff photos required resizing and optimization.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33001", "3326", "fld_5994139", "billing_notes", "Worked with Lynette Creech.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33002", "3326", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33003", "3326", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33004", "3327", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33005", "3327", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33006", "3327", "fld_165241", "date_of_work", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33007", "3327", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33008", "3327", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33009", "3327", "fld_8427909", "client_or_company", "Roofing Restoration / 970-617-2008");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33010", "3327", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33011", "3327", "fld_291750", "date_completed", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33012", "3327", "fld_2572136", "description_of_work_completed", "Josh called as he no longer had access to his Outlook emails.\r\nHe was logging in using an old employees account, Clint.\r\nInstalled and configured TeamViewer host on Josh\\\'s DT.\r\nChanged Josh\\\'s local account to administrator, added his Outlook account to his local account.\r\nAssisted Josh with configuring his iPhone for his Outlook account.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33013", "3327", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33014", "3327", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33015", "3327", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33016", "3328", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33017", "3328", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33018", "3328", "fld_165241", "date_of_work", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33019", "3328", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33020", "3328", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33021", "3328", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33022", "3328", "fld_20888", "name_of_client", "Debbie Bakel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33023", "3328", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33024", "3328", "fld_291750", "date_completed", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33025", "3328", "fld_2572136", "description_of_work_completed", "Debbie\\\'s google account had nearly hit max capacity, 97%.\r\nHer Gmail account had 11+ GB of data but I could not find where he emails actually were.\r\nOnly able to view emails by selecting all mail, which showed 4k+ emails.\r\nDeleted all emails older than June 3rd, 2020.\r\nDebbie\\\'s google account is now under 35% usage.\r\nConfirmed that new emails will go directly to inbox as opposed to some hidden folder to prevent this issue from re-occurring in the future.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33026", "3328", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33027", "3328", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33028", "3328", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33029", "3329", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33030", "3329", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33031", "3329", "fld_165241", "date_of_work", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33032", "3329", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33033", "3329", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33034", "3329", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33035", "3329", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33036", "3329", "fld_291750", "date_completed", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33037", "3329", "fld_2572136", "description_of_work_completed", "Setup VPN for Sam, Eric, and showed them how to connect to VPN.\r\nMapped Data drive to Z: on conference laptop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33038", "3329", "fld_5994139", "billing_notes", "Giovanni has a personal laptop at home that we will be setting up a VPN for.\r\n\r\nShe will call in regarding getting TeamViewer installed, VPN, etc.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33039", "3329", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33040", "3329", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33041", "3330", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33042", "3330", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33043", "3330", "fld_165241", "date_of_work", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33044", "3330", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33045", "3330", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33046", "3330", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33047", "3330", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33048", "3330", "fld_291750", "date_completed", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33049", "3330", "fld_2572136", "description_of_work_completed", "Emails Where running slow\r\n\r\nDisabled spam filters in cPanel (he has spamexperts)\r\n ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33050", "3330", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33051", "3330", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33052", "3330", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33053", "3331", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33054", "3331", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33055", "3331", "fld_165241", "date_of_work", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33056", "3331", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33057", "3331", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33058", "3331", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33059", "3331", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33060", "3331", "fld_291750", "date_completed", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33061", "3331", "fld_2572136", "description_of_work_completed", "Set up PC (was MAREKM-DT) for new employee Dallas Martinez\r\nSet up Office 365 and AD account for dmartinez \r\nRemove existing Office on PC and install Office 365 (request from Gina)\r\nUpgrade VIsta to latest version\r\nUpgrade OS (Win 10 1909) to Win 10 2020\r\n(PC being sent to TX)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33062", "3331", "fld_5994139", "billing_notes", "New TX user Dallas Martinez\r\nSet up accounts and PC (existing PC)\r\ndd Office 365-\r\nadd 1 \\\"Microsoft 365 Standard\\\" License (increase to 14 from 13 licenses)\r\nresolved\r\n\r\n ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33063", "3331", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33064", "3331", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33065", "3331", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33066", "3331", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33067", "3331", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33068", "3332", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33069", "3332", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33070", "3332", "fld_165241", "date_of_work", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33071", "3332", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33072", "3332", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33073", "3332", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33074", "3332", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33075", "3332", "fld_291750", "date_completed", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33076", "3332", "fld_2572136", "description_of_work_completed", "Finish removing last of 3 ATC users from \\\"Exchange Plan 2\\\" license\r\nafter archiving email accounts to below 50GB\r\nB Devore, April W and Pam Heroux were unable to use Teams\r\n(Exchange license for large mailboxes has no Teams)\r\narchive old mails then switch license\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33077", "3332", "fld_5994139", "billing_notes", "License info sent to Liga already on this\r\nAll ATC Users now  OFF \\\'Exchange Plan 2\\\'\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33078", "3332", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33079", "3332", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33080", "3333", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33081", "3333", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33082", "3333", "fld_165241", "date_of_work", "2021-03-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33083", "3333", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33084", "3333", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33085", "3333", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33086", "3333", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33087", "3333", "fld_291750", "date_completed", "2021-03-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33088", "3333", "fld_2572136", "description_of_work_completed", "New user setup Gregory Nelson RPT President\r\nemail gregory.nelson@rapidprotool.com\r\n\r\nPC setup - TBD\r\ncredentials provided To Russell Clemens.\r\nemployee starts Monday\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33089", "3333", "fld_5994139", "billing_notes", "RPT new employee setup.\r\nset up AD and Office 365 user\r\nresolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33090", "3333", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33091", "3333", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33092", "3334", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33093", "3334", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33094", "3334", "fld_165241", "date_of_work", "2021-03-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33095", "3334", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33096", "3334", "fld_7309777", "minutes_spent", "1613");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33097", "3334", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33098", "3334", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33099", "3334", "fld_291750", "date_completed", "2021-03-16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33100", "3334", "fld_2572136", "description_of_work_completed", "NORCO Volleyball /970/667/5005\r\n\r\n\r\nTrip 1 (Dylan/Andy)\r\n-installed 3 WAP\\\'s\r\n- installed USG \r\n-patch 24 and 48 port POE switch\r\n- setup Unifi controller/ adopted devices\r\n- deployed 3cx phone server\r\n- setup Unifi\r\n -created wireless networks\r\n - created VPN Network LN2TP/PPTP\r\n\r\nTrip 2 (Dylan)\r\n(after security people came out)\r\nreplaced DAC Cable\\\'s with fiber \r\ninstalled 24 POE port camera switch\r\n\r\n\r\nTrip 3 (Dylan)\r\n-installed computers and printers\r\n-labeled Yealink Phones\r\n-assign phone extension with names. \r\n\r\nTrip 4 (Dylan) \r\n-added Printers to the server \r\n-Map Printers/network drives to the client computers\r\n\r\nTrip 5 (Dylan)\r\n-Supervised comcast installation at old building.\r\n\r\n\r\nTrip 6 (Dylan)\r\nReinstalled DAC cables \r\nGave network device static IP\\\'s\r\n-Unifi Devices\r\n-Servers\r\n-Cameras\r\n\r\nTrip 7  (Dylan)\r\n-Resolved Red Lights blinking on the phones\r\n-FRRI\\\'s Ubiquiti aircube AC died (troubleshooting network issues)\r\n-reset voicemail Pins (147258) because they changed to 4 digit.\r\n-updated 3cx system with new static public IP\r\n\r\nRemote 2.55 Hours\r\n-Changed Mary\\\'s ext. 2001\r\n-help with setting up voicemail.\r\n-phone walk through.\r\n-assisted with mapping different drives to staff computer.\r\n- corrected windows clock (1 hour off)\r\n\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33101", "3334", "fld_5994139", "billing_notes", " ----Billing/Internal Notes-----\r\n\r\nTrip 1 Friday Feb 26th 12:10PM-7:18PM\r\n-Total Time (hours) = 7.13 hours\r\n-Total Time (minutes) = 428 minutes\r\n\r\nSaturday Feb 27th 2:10PM-6:46PM\r\n-Total Time (hours) = 4.6 hours\r\n-Total Time (minutes) = 276 minutes\r\n\r\n\r\nSaturday March 6Th 8:52AM- 10:22AM\r\n- Total Time (hours) = 1.5 hours\r\n- Total Time (minutes) = 90 minutes\r\n\r\nTrip 5 Sunday Feb 28th 8:42AM- 10:35AM\r\n-Total Time (hours) = 1.88 hours\r\n-Total Time (minutes) = 113 minutes\r\n\r\nTrip 6\r\n-Total Time (hours) = 3.45 hours\r\n-Total Time (minutes) = 207 minutes\r\n\r\nTrip 7\r\n-Total Time (hours) = 2.31 hours\r\n-Total Time (minutes) = 139 minutes\r\n\r\n Remote Total Time\r\n-Total Time (hours) = 2.55 hours\r\n-Total Time (minutes) = 153 minutes\r\n\r\n\r\n Onsite Total Time\r\n-Total Time (hours) = 24.32 hours\r\n-Total Time (minutes) = 1459.2minutes\r\n\r\n\r\nTotal Time\r\n-Total Time (hours) = 26.87 hours\r\n-Total Time (minutes) = 1612.2 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33102", "3334", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33103", "3334", "fld_2864175", "part1_description", "unifi 24 port POE switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33104", "3334", "fld_8478853", "cost_of_part_1", "480");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33105", "3334", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33106", "3335", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33107", "3335", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33108", "3335", "fld_165241", "date_of_work", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33109", "3335", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33110", "3335", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33111", "3335", "fld_8427909", "client_or_company", "Pioneer Press / 970-330-4800");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33112", "3335", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33113", "3335", "fld_291750", "date_completed", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33114", "3335", "fld_2572136", "description_of_work_completed", "Callcentric SIP trunks could not complete registration due to DNS error.\r\nUnable to complete nslookup for FQDN: ppg.milpond.com\r\nTried to flush dns, unsuccessful.\r\nRan firewall test on 3CX server to automatically restart all services, connectivity restored.\r\nnslookup for ppg.milpond.com is now successful");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33115", "3335", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33116", "3335", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33117", "3335", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33118", "3336", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33119", "3336", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33120", "3336", "fld_165241", "date_of_work", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33121", "3336", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33122", "3336", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33123", "3336", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33124", "3336", "fld_20888", "name_of_client", "Adrienne Ziola");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33125", "3336", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33126", "3336", "fld_291750", "date_completed", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33127", "3336", "fld_2572136", "description_of_work_completed", "She called due to her Vipre indicating it was going to expire, which should not happen until October 2021.\r\nWalked her through reinstalling TeamViewer, looked up invoice and found record from October.\r\nFound Vipre key from October, which was different from her currently entered key.\r\nUpdated Vipre key to what it was originally supposed to be, she now has coverage until October 2021.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33128", "3336", "fld_5994139", "billing_notes", "NO NEW VIPRE KEY USED");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33129", "3336", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33130", "3336", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33131", "3337", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33132", "3337", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33133", "3337", "fld_165241", "date_of_work", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33134", "3337", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33135", "3337", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33136", "3337", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33137", "3337", "fld_20888", "name_of_client", "Interior Design Concepts");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33138", "3337", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33139", "3337", "fld_291750", "date_completed", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33140", "3337", "fld_2572136", "description_of_work_completed", "Received call due to new computers in the office not having any internet connectivity.\r\nNo static settings, no IP assigned to computer or gateway.\r\nWent on site and discovered that Linksys router was dead. Also discovered that UPS unit in ceiling had died as well.\r\nReplaced Linksys router with 5 port switch and replaced dead UPS with new unit.\r\nConfirmed internet connectivity was restored and that IP subnet change did not affect anything.\r\nSubnet changed from 192.168.1.x to 10.1.10.x");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33141", "3337", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33142", "3337", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33143", "3337", "fld_2864175", "part1_description", "5 Port TP Link Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33144", "3337", "fld_9190675", "part_2_description", "550VA 330 Watt UPS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33145", "3337", "fld_8478853", "cost_of_part_1", "$19.20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33146", "3337", "fld_592520", "cost_of_part_2", "$62.47");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33147", "3337", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33148", "3338", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33149", "3338", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33150", "3338", "fld_165241", "date_of_work", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33151", "3338", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33152", "3338", "fld_7309777", "minutes_spent", "69");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33153", "3338", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33154", "3338", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33155", "3338", "fld_291750", "date_completed", "2021-03-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33156", "3338", "fld_2572136", "description_of_work_completed", "Looked over all internet settings on managers computer\r\nconfirm 3cx app settings where correct.\r\n-Didn\\\'t find any issues");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33157", "3338", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33158", "3338", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33159", "3338", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33160", "3339", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33161", "3339", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33162", "3339", "fld_165241", "date_of_work", "2021-03-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33163", "3339", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33164", "3339", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33165", "3339", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33166", "3339", "fld_20888", "name_of_client", "McWebb Truss (Jim McCreery)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33167", "3339", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33168", "3339", "fld_291750", "date_completed", "2021-03-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33169", "3339", "fld_2572136", "description_of_work_completed", "ON SITE WORK\r\nNetwork setup somehow got split between two Unifi Controllers.\r\nRe-established all connectivity on Software controller, downloaded backup, uploaded backup to Cloud Key controller.\r\nUninstalled controller from Jim\\\'s Tachyon to prevent further conflict.\r\nChanged subnet from 192.168.0.x to 192.168.10.x to prevent IP conflicts when remoting in.\r\nInstalled new UAP for better wireless connectivity. Old access point is EOL. (02/21)\r\n\r\nREMOTE WORK\r\nRemoted into Jim\\\'s laptop and re-established VPN connection. (L2TP)\r\nRe-established RDP connection to Tachyon computer, unable to complete RDP connection to Server (needs restart)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33170", "3339", "fld_5994139", "billing_notes", "Closed ports 50000 and 50001 (old RDP connection)\r\nChanged registry entries for RDP port to 3389 on both Server and Tachyon.\r\nSet RDP to allow NAT side transversal on both Tachyon and Server.\r\nSet Windows firewall to allow RDP on both Server and Tachyon.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33171", "3339", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33172", "3339", "fld_2864175", "part1_description", "UAP Lite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33173", "3339", "fld_8478853", "cost_of_part_1", "$99.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33174", "3339", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33175", "3340", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33176", "3340", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33177", "3340", "fld_165241", "date_of_work", "2021-03-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33178", "3340", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33179", "3340", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33180", "3340", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33181", "3340", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33182", "3340", "fld_291750", "date_completed", "2021-03-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33183", "3340", "fld_2572136", "description_of_work_completed", "Installed Unifi Mesh AP Pro along with 48V POE adapter");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33184", "3340", "fld_5994139", "billing_notes", "resolved\r\nAssisted Dylan with installation");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33185", "3340", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33186", "3340", "fld_2864175", "part1_description", "Unifi Mesh AP Pro");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33187", "3340", "fld_8478853", "cost_of_part_1", "$192.73");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33188", "3340", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33189", "3341", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33190", "3341", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33191", "3341", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33192", "3341", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33193", "3341", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33194", "3341", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33195", "3341", "fld_20888", "name_of_client", "McWebb Truss (Jim McCreery)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33196", "3341", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33197", "3341", "fld_291750", "date_completed", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33198", "3341", "fld_2572136", "description_of_work_completed", "Setup VPN connection for Sam\\\'s laptop (L2TP)\r\nSetup RDP connection from Sam\\\'s laptop to MCW Server\r\nTested and verified");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33199", "3341", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33200", "3341", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33201", "3341", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33202", "3342", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33203", "3342", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33204", "3342", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33205", "3342", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33206", "3342", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33207", "3342", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33208", "3342", "fld_20888", "name_of_client", "McWebb Truss (Jim McCreery)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33209", "3342", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33210", "3342", "fld_291750", "date_completed", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33211", "3342", "fld_2572136", "description_of_work_completed", "Remapped DATA network drive Z: on Tachyon and Office computer.\r\nReconfigured RDP connection from Jim\\\'s home desktop to Server and Tachyon.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33212", "3342", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33213", "3342", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33214", "3342", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33215", "3343", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33216", "3343", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33217", "3343", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33218", "3343", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33219", "3343", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33220", "3343", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33221", "3343", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33222", "3343", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33223", "3343", "fld_2572136", "description_of_work_completed", "Staci called due to lack of internet connectivity and unable to access QuickBooks on server.\r\nStaci had factory reset the Unifi gateway, unable to reach Cloudkey.\r\nHad Staci restart Cloudkey and I was able to access it to download a backup.\r\nRestored Unifi network using backup, recreated VPN network, reassigned Public Static IP.\r\nConfirmed connectivity had been restored, QuickBooks problem resolved, likely due to network being set back to standard.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33224", "3343", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33225", "3343", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33226", "3343", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33227", "3344", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33228", "3344", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33229", "3344", "fld_165241", "date_of_work", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33230", "3344", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33231", "3344", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33232", "3344", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33233", "3344", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33234", "3344", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33235", "3344", "fld_2572136", "description_of_work_completed", "Computers were unable to use HDMI connection from conference room 2 table to TV.\r\nAble to connect via direct connection to TV.\r\nDiscovered disconnected HDMI cable under floor mat, reconnected and firmly secured.\r\nReplaced HDMI cable inside wall with longer HDMI cable, removed HDMI keystone behind TV and ran HDMI cable direct to TV. Tested and confirmed that HDMI now works from table to TV.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33236", "3344", "fld_5994139", "billing_notes", "HDMI issue resolved, still need to fix webcam and add Wifi to (2) printers.\r\nHDMI cable used in project already accounted for.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33237", "3344", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33238", "3344", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33239", "3345", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33240", "3345", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33241", "3345", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33242", "3345", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33243", "3345", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33244", "3345", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33245", "3345", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33246", "3345", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33247", "3345", "fld_2572136", "description_of_work_completed", "Mary\\\'s computer would briefly connect to network and then lose internet connectivity.\r\nOriginal thought was poor ethernet connection between computer and wall, no success.\r\nAdded new NIC PCI card to Mary\\\'s computer to potentially resolve a dying NIC motherboard, no success.\r\nDiscovered IP conflict between Mary\\\'s computer and Unifi Switch.\r\nChanged Mary\\\'s computer IP address from 192.168.1.7 to 192.168.1.40 to prevent future IP conflicts.\r\nVerified DHCP will not pass out IP in the 192.168.1.40 range.\r\nRemapped network drives to server on all other office computers.\r\nRemapped printer drivers on Cathy\\\'s computer to resolve printing issue.\r\nRan HDD scan on Admin Assistant computer, result is HDD failure. Recommended new computer (ION)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33248", "3345", "fld_5994139", "billing_notes", "resolved. Need to provide Mary with a Quote for a new ION, possibly along with Office and a data transfer.\r\n\r\nRemoved NIC PCI card as it was not part of solution or problem.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33249", "3345", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33250", "3345", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33251", "3346", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33252", "3346", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33253", "3346", "fld_165241", "date_of_work", "2021-03-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33254", "3346", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33255", "3346", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33256", "3346", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33257", "3346", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33258", "3346", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33259", "3346", "fld_2572136", "description_of_work_completed", "First visit (03-19-21) unable to replace CMOS battery as there were several active phone calls and shutting down the server would end all calls. Scheduled new time to come out and visit.\r\n\r\nSecond visit (03-20-21) replaced CMOS battery on Server without issue. No loss of BIOS settings or indication of UPS battery failure. Cleared poweredge screen of CMOS battery error and no further errors were detected.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33260", "3346", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33261", "3346", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33262", "3346", "fld_2864175", "part1_description", "1 x CR2032 CMOS Battery");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33263", "3346", "fld_8478853", "cost_of_part_1", "?");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33264", "3346", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33265", "3347", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33266", "3347", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33267", "3347", "fld_165241", "date_of_work", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33268", "3347", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33269", "3347", "fld_7309777", "minutes_spent", "144");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33270", "3347", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33271", "3347", "fld_20888", "name_of_client", "Mcwebb");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33272", "3347", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33273", "3347", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33274", "3347", "fld_2572136", "description_of_work_completed", "installed Unifi cloud key\r\ninstalled Unifi controller \r\nupdated Devices/Controller and Cloudkey.\r\nchanged subnet to 10.1 so server and VPN would work properly\r\ncable management\r\nreplace old broken ethernet cables. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33275", "3347", "fld_5994139", "billing_notes", "Total Time (hours) = 2.4 hours\r\nTotal Time (minutes) = 144 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33276", "3347", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33277", "3347", "fld_2864175", "part1_description", "Unifi Cloudkey ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33278", "3347", "fld_9190675", "part_2_description", "cat 6 patch cables");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33279", "3347", "fld_8478853", "cost_of_part_1", "132.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33280", "3347", "fld_592520", "cost_of_part_2", "32ft (total length )");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33281", "3347", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33282", "3348", "fld_8151635", "technician.opt1818302", "Andy Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33283", "3348", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33284", "3348", "fld_8151635", "technician", "{\"opt1818302\":\"Andy Pizer\",\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33285", "3348", "fld_165241", "date_of_work", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33286", "3348", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33287", "3348", "fld_7309777", "minutes_spent", "844");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33288", "3348", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33289", "3348", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33290", "3348", "fld_291750", "date_completed", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33291", "3348", "fld_2572136", "description_of_work_completed", "Trip 1 (Dylan)\r\nDynastic on what happen with the Unifi switch after upgrades\r\n-updated firmware on Unifi AP\\\'s and Cloud Key.\r\n\r\nTrip 2 (Dylan)\r\nReplaced edge router with USG\r\n\r\nTrip 3 (Dylan & Andy)\r\n\r\nreplaced 3CX server with MG 3CX rackmount server\r\n-restored backup\r\n-confirmed all extensions where online\r\n-updated security settings\r\n -added random PW for TeamViewer (6digit secure)\r\n   -only allowed remote connection from MG computers \r\n-changed 3cx server management portal PW\r\n-disabled remote extension access for all rooms and office phones.\r\n-made a backup clone on bench SSD for the office\r\n\r\nadopted USG to Unifi controller\r\n-updated firmware\r\n\r\nTrip 4 (Dylan)\r\n\r\nReplace m.2 SSD in 3cx server because it was failing\r\nupdated bench SSD backup clone\r\nclone again to internal backup SSD \r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33292", "3348", "fld_5994139", "billing_notes", "trip 1\r\nTotal Time (hours) = 1.35 hours\r\nTotal Time (minutes) = 81minutes\r\n\r\ntrip 2\r\nTotal Time (hours) = 2.47 hours\r\nTotal Time (minutes) = 148.2 minutes\r\n\r\ntrip 3\r\nin office (building the server) 4:06PM-8:12PM\r\nTotal Time (hours) = 4.1 hours\r\nTotal Time (minutes) = 246 minutes\r\n\r\nOnsite install 8:12PM-10:18PM\r\nTotal Time (hours) = 2.1 hours\r\nTotal Time (minutes) = 126 minutes\r\n\r\ntrip 4\r\n9:14AM-1:16PM\r\nTotal Time (hours) = 4.03 hours\r\nTotal Time (minutes) = 242 minutes\r\n\r\n\r\nTotal Time\r\n\r\nTotal Time (hours) = 14.03\r\nTotal Time (minutes) = 843.2\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33293", "3348", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33294", "3348", "fld_2864175", "part1_description", "USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33295", "3348", "fld_9190675", "part_2_description", "Rackmount 3CX Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33296", "3348", "fld_8951874", "part_3_description", "m.2 SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33297", "3348", "fld_8478853", "cost_of_part_1", "145.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33298", "3348", "fld_5448517", "cost_of_part_3", "65.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33299", "3348", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33300", "3349", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33301", "3349", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33302", "3349", "fld_165241", "date_of_work", "2021-02-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33303", "3349", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33304", "3349", "fld_7309777", "minutes_spent", "360");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33305", "3349", "fld_8427909", "client_or_company", "Henry\\\'s Pub / 970-613-1896");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33306", "3349", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33307", "3349", "fld_291750", "date_completed", "2021-03-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33308", "3349", "fld_2572136", "description_of_work_completed", "Final edits and updates to website pages and contact forms before launch. Set up api for Google Maps. Set up and installed Recaptcha v3 key for contact forms. Set up Google Analytics and installed analytics code.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33309", "3349", "fld_5994139", "billing_notes", "Site launched on March 10.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33310", "3349", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33311", "3349", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33312", "3350", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33313", "3350", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33314", "3350", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33315", "3350", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33316", "3350", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33317", "3350", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33318", "3350", "fld_20888", "name_of_client", "NORCO Volleyball");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33319", "3350", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33320", "3350", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33321", "3350", "fld_2572136", "description_of_work_completed", "Updated VPN for Tally Services so they can connect via RDP to NORCO Server.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33322", "3350", "fld_5994139", "billing_notes", "Noted that Unifi USG does not have a static IP set.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33323", "3350", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33324", "3350", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33325", "3351", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33326", "3351", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33327", "3351", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33328", "3351", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33329", "3351", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33330", "3351", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33331", "3351", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33332", "3351", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33333", "3351", "fld_2572136", "description_of_work_completed", "Setup phone for Dallas Martinez at Texas location for extension 4009.\r\nTested and confirmed phone calls work.\r\nInstalled 3CX app on Dallas\\\'s LT.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33334", "3351", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33335", "3351", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33336", "3351", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33337", "3352", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33338", "3352", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33339", "3352", "fld_165241", "date_of_work", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33340", "3352", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33341", "3352", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33342", "3352", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33343", "3352", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33344", "3352", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33345", "3352", "fld_2572136", "description_of_work_completed", "Uninstalled Mesh point, Unifi gateway, Cloudkey v2, 1500W UPS, 360W UPS, Old UAP (EOL).\r\n\r\nReconfigured Comcast modem to provide Wifi access to public, changed Comcast modem password to prevent anyone from hitting it without permission.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33346", "3352", "fld_5994139", "billing_notes", "Norco Guest (wifi password)\r\nD!@ (comcast modem password)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33347", "3352", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33348", "3352", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33349", "3353", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33350", "3353", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33351", "3353", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33352", "3353", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33353", "3353", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33354", "3353", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33355", "3353", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33356", "3353", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33357", "3353", "fld_2572136", "description_of_work_completed", "Reinstalled PS2 video cable to run webcam. 50ft PS2 cable would not provide connectivity. Tested and confirmed that webcam now works when connecting to Logitech Group Video Conferencing system.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33358", "3353", "fld_5994139", "billing_notes", "Might need to remount webcam, it almost looks crooked in the video.\r\nHDMI cable is still flickering, might need to order 50ft cable female to male and run direct to TV.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33359", "3353", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33360", "3353", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33361", "3354", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33362", "3354", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33363", "3354", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33364", "3354", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33365", "3354", "fld_7309777", "minutes_spent", "270");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33366", "3354", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33367", "3354", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33368", "3354", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33369", "3354", "fld_2572136", "description_of_work_completed", "Installed 9 access points (8 lite, 1 mesh pro).\r\nConfigured access points for static IP in range, 192.168.1.10 to 192.168.1.22 (13 access points in total, 12 lite, 1 mesh pro)\r\n\r\nFixed printer connectivity issue on Courtney\\\'s computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33370", "3354", "fld_5994139", "billing_notes", "FRII internet connectivity is definite problem at the moment.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33371", "3354", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33372", "3354", "fld_2864175", "part1_description", "8 UAP Lite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33373", "3354", "fld_9190675", "part_2_description", "1 UAP Mesh Pro");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33374", "3354", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33375", "3355", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33376", "3355", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33377", "3355", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33378", "3355", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33379", "3355", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33380", "3355", "fld_8427909", "client_or_company", "Freeman Architects / 970-667-3939");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33381", "3355", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33382", "3355", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33383", "3355", "fld_2572136", "description_of_work_completed", "Monica called due to a lack of WiFi network availability.\r\nFound in wall access point was disconnected.\r\nReset in wall access point, readopted, upgraded firmware, provisioned.\r\nUpgraded controller software and upgraded USG firmware.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33384", "3355", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33385", "3355", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33386", "3355", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33387", "3356", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33388", "3356", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33389", "3356", "fld_165241", "date_of_work", "2021-03-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33390", "3356", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33391", "3356", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33392", "3356", "fld_8427909", "client_or_company", "Bills Service & Repairs/Sam Bergstrom/970-310-3734");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33393", "3356", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33394", "3356", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33395", "3356", "fld_2572136", "description_of_work_completed", "Email wasn\\\'t working on the WIX website contact form at www.billsserviceandrepairs.com. Updated G Suite MX records and verified. Also reassigned domain.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33396", "3356", "fld_5994139", "billing_notes", "Email invoice to Samantha Bergstrom at baileybergstrom@yahoo.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33397", "3356", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33398", "3356", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33399", "3357", "fld_8151635", "technician.opt1099701", "Patrick Sullivan");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33400", "3357", "fld_8151635", "technician", "{\"opt1099701\":\"Patrick Sullivan\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33401", "3357", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33402", "3357", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33403", "3357", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33404", "3357", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33405", "3357", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33406", "3357", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33407", "3357", "fld_2572136", "description_of_work_completed", "Optimized, uploaded, and installed new 20th Anniversary High Plains logo in the website header. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33408", "3357", "fld_5994139", "billing_notes", "Requested by Pam Sunderland");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33409", "3357", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33410", "3357", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33411", "3358", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33412", "3358", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33413", "3358", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33414", "3358", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33415", "3358", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33416", "3358", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33417", "3358", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33418", "3358", "fld_291750", "date_completed", "2021-03-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33419", "3358", "fld_2572136", "description_of_work_completed", "1 hour total 3-22 to 3-26\r\n30 minutes - assist Greg troubleshoot server connectivity (IP conflict with managed router)\r\n15 minutes 3-25 connect Cody Sandau to shared drive (GEE) \r\n  Note - he is on WIndows 10 Home so couldn\\\'t add to domain. Recommended upgrade\r\n15 minutes - remove unused e-mail accounts: Drew Elser Mike Cook, Estimating\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33420", "3358", "fld_5994139", "billing_notes", "1 hour TOTAL 3-22 to 3-26\r\nUnifi issues + network share access + remove old emails (and reduce Office 365 licenses)\r\nresolved\r\n\r\nNOTE - Removed 2x Exchange Plan 1 licenses.\r\nGEE total is now: \r\n14x licenses Exchange Plan 1\r\n1x license for Office Business 365 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33421", "3358", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33422", "3358", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33423", "3359", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33424", "3359", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33425", "3359", "fld_165241", "date_of_work", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33426", "3359", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33427", "3359", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33428", "3359", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33429", "3359", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33430", "3359", "fld_291750", "date_completed", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33431", "3359", "fld_2572136", "description_of_work_completed", "John Clark\\\'s laptop would not connect to WiFi network.\r\nWould not receive IP, originally thought possibly IP conflict but not enough clients to create this. No Static IP set.\r\nUpgraded firmware of Unifi WAP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33432", "3359", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33433", "3359", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33434", "3359", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33435", "3360", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33436", "3360", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33437", "3360", "fld_165241", "date_of_work", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33438", "3360", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33439", "3360", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33440", "3360", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33441", "3360", "fld_20888", "name_of_client", "Don Custis");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33442", "3360", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33443", "3360", "fld_291750", "date_completed", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33444", "3360", "fld_2572136", "description_of_work_completed", "Uninstalled Quicken on Desktop and laptop.\r\nCleared out all old Quicken files, including old financial data as per request.\r\nCreated a small backup on the Desktop in 1MG folder just in case.\r\nPerformed light clean up of Desktop and Laptop, no issues detected with laptop.\r\nDesktop HDD is beginning to enter early stages of failure, recommended HDD replacement.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33445", "3360", "fld_5994139", "billing_notes", "Customer is located in Georgia but occasionally is out our way. He may try to bring his desktop with him next adventure out our way. We can replace the HDD at that time.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33446", "3360", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33447", "3360", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33448", "3361", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33449", "3361", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33450", "3361", "fld_165241", "date_of_work", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33451", "3361", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33452", "3361", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33453", "3361", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33454", "3361", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33455", "3361", "fld_291750", "date_completed", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33456", "3361", "fld_2572136", "description_of_work_completed", "Restored mapped drive connection between Admin Assistant computer and Server.\r\nConfigured Brooke\\\'s extension on Admin Assistant computer.\r\nCreated TCP/IP port for Front Office printer on Server, set to static IP 192.168.1.157");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33457", "3361", "fld_5994139", "billing_notes", "resolved unless printer IP changes somehow.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33458", "3361", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33459", "3361", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33460", "3362", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33461", "3362", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33462", "3362", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33463", "3362", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33464", "3362", "fld_7309777", "minutes_spent", "411");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33465", "3362", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33466", "3362", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33467", "3362", "fld_291750", "date_completed", "2021-03-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33468", "3362", "fld_2572136", "description_of_work_completed", "Picked up comcast 4G backup from old NORCO\r\nDelivered it to new Norco \r\nTested multiple areas for best 4g Connection.\r\nInstalled cat6 cable to Comcast Backup\r\nInstalled on top of upstairs cargo container Office\r\nWired into patch panel and connected USG\r\nConfigure USG to use Comcast Backup as failover if FRII went down.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33469", "3362", "fld_5994139", "billing_notes", "6.85 Hours\r\n411 Minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33470", "3362", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33471", "3362", "fld_2864175", "part1_description", "cat 6 Cable 30ft");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33472", "3362", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33473", "3363", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33474", "3363", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33475", "3363", "fld_165241", "date_of_work", "2021-03-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33476", "3363", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33477", "3363", "fld_7309777", "minutes_spent", "225");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33478", "3363", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33479", "3363", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33480", "3363", "fld_291750", "date_completed", "2021-03-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33481", "3363", "fld_2572136", "description_of_work_completed", "Installed WAP for a printer in the Inventory section as well as a second printer in the shipping area.\r\nDesignated WAPs as Mobile Printer WAP and Shipping Printer WAP.\r\nConfigured shipping printer for shipping computer and Winston\\\'s desktop. Tested and confirmed from both shipping and Winston\\\'s desktop.\r\nConfigured mobile printer for inventory computer and Winston\\\'s desktop. Tested and confirmed from both inventory and Winston\\\'s desktop.\r\n\r\nTested HDMI cables in conference room 2, best recommendation is to acquire a new table cable box.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33482", "3363", "fld_5994139", "billing_notes", "Printers resolved, conference room 2 ongoing.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33483", "3363", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33484", "3363", "fld_2864175", "part1_description", "Unifi WAP Lite (2)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33485", "3363", "fld_8478853", "cost_of_part_1", "$92.50 each");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33486", "3363", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33487", "3364", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33488", "3364", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33489", "3364", "fld_165241", "date_of_work", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33490", "3364", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33491", "3364", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33492", "3364", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33493", "3364", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33494", "3364", "fld_291750", "date_completed", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33495", "3364", "fld_2572136", "description_of_work_completed", "updated/provisioned grand stream ht801 VoIP gateway for fax line");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33496", "3364", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33497", "3364", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33498", "3364", "fld_2864175", "part1_description", "Grandstream GS-HT802 2 Port Analog Telephone Adapter VoIP Phone & Device, Black");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33499", "3364", "fld_8478853", "cost_of_part_1", "36.88");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33500", "3364", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33501", "3365", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33502", "3365", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33503", "3365", "fld_165241", "date_of_work", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33504", "3365", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33505", "3365", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33506", "3365", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33507", "3365", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33508", "3365", "fld_291750", "date_completed", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33509", "3365", "fld_2572136", "description_of_work_completed", "updated/provisioned grand stream ht801 VoIP gateway for fax line");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33510", "3365", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33511", "3365", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33512", "3365", "fld_2864175", "part1_description", "Grandstream GS-HT802 2 Port Analog Telephone Adapter VoIP Phone & Device, Black");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33513", "3365", "fld_8478853", "cost_of_part_1", "36.88");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33514", "3365", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33515", "3366", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33516", "3366", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33517", "3366", "fld_165241", "date_of_work", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33518", "3366", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33519", "3366", "fld_7309777", "minutes_spent", "17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33520", "3366", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33521", "3366", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33522", "3366", "fld_291750", "date_completed", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33523", "3366", "fld_2572136", "description_of_work_completed", "Helped Mario with VPN connection and RDP connection to Server.\r\nHelped to open up QuickBooks files on server so they appear in Company list in the future.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33524", "3366", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33525", "3366", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33526", "3366", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33527", "3367", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33528", "3367", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33529", "3367", "fld_165241", "date_of_work", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33530", "3367", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33531", "3367", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33532", "3367", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33533", "3367", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33534", "3367", "fld_291750", "date_completed", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33535", "3367", "fld_2572136", "description_of_work_completed", "Fixed HP Envy 4500 not working from Mary\\\'s computer. Needed updated drivers.\r\nMapped network drive for shared folder to Z: drive on Mary\\\'s laptop.\r\nReconfigured PPTP and L2TP VPN connections on Mary\\\'s laptop and home desktop.\r\nTested and confirmed VPN worked on home desktop, unable to test on laptop as it was at the office during work.\r\nReconfigured and tested RDP connection from Mary\\\'s laptop and desktop to Server.\r\nReconfigured L2TP VPN connection from Cathy\\\'s surface, unable to test as it was at the office during work.\r\nReconfigured RDP connection from Cathy\\\'s surface to Cathy\\\'s desktop. Tested and confirmed.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33536", "3367", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33537", "3367", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33538", "3367", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33539", "3368", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33540", "3368", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33541", "3368", "fld_165241", "date_of_work", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33542", "3368", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33543", "3368", "fld_7309777", "minutes_spent", "240");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33544", "3368", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33545", "3368", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33546", "3368", "fld_291750", "date_completed", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33547", "3368", "fld_2572136", "description_of_work_completed", "NOT ONSITE - BENCH WORK\r\n\r\nInstalled Windows 10 on new SSD, automatically activated from Dell.\r\nAdded Kevin\\\'s desktop (KEVINNEW) to Village Optical domain.\r\nTransferred Kevin\\\'s user data from old SSD to new.\r\nInstalled and configured Office 2016\r\nInstalled MaximEyes program\r\nInstalled Timeclock program");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33548", "3368", "fld_5994139", "billing_notes", "Chuck will finish Timeclock and MaximEyes setup once desktop is back in VO office.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33549", "3368", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33550", "3368", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33551", "3368", "fld_4069791", "office_pro_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33552", "3368", "fld_1712261", "email_account_1c", "N377W-Y7VQY-2Y4MT-BVJ7M-X4TK2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33553", "3368", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33554", "3368", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33555", "3368", "fld_8478853", "cost_of_part_1", "$56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33556", "3368", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33557", "3369", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33558", "3369", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33559", "3369", "fld_165241", "date_of_work", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33560", "3369", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33561", "3369", "fld_7309777", "minutes_spent", "28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33562", "3369", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33563", "3369", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33564", "3369", "fld_291750", "date_completed", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33565", "3369", "fld_2572136", "description_of_work_completed", "helped  printer tech with new printer installation.\r\nsetup scan user on server \r\nsetup scan to network folder on new printer \r\nshared printer out from server for other computers/devices ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33566", "3369", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33567", "3369", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33568", "3369", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33569", "3370", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33570", "3370", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33571", "3370", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33572", "3370", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33573", "3370", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33574", "3370", "fld_8427909", "client_or_company", "24 Hour Sign Language / 888-811-2424 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33575", "3370", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33576", "3370", "fld_291750", "date_completed", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33577", "3370", "fld_2572136", "description_of_work_completed", "KT Wright fix Broken Cylance install\r\n(remove - reboot - reinstall)\r\nbroken by WIndows update\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33578", "3370", "fld_5994139", "billing_notes", "anitvirus reinstall KT Wright\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33579", "3370", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33580", "3370", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33581", "3371", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33582", "3371", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33583", "3371", "fld_165241", "date_of_work", "2021-03-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33584", "3371", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33585", "3371", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33586", "3371", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33587", "3371", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33588", "3371", "fld_291750", "date_completed", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33589", "3371", "fld_2572136", "description_of_work_completed", "Broken Windows Update patch (x11 computers in Pell AL) 03-22 to 03-31-2021\r\nKB 5080002 breaks Printing on Kyocera (and other) printers. (CRASHES PC/ Blue Screen)\r\nATC Pell uses affected model\r\nUninstall KB5080002 and block on affected machines and block update until fix released\r\nsome PCs were unable to block and needed the patch reverted multipl times.\r\n(Fixed update released by MS end of March 2021)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33590", "3371", "fld_5994139", "billing_notes", "Ongoing issue with MS releasing several bad patches.\r\nTime tracker not put in until MS fixed issue\r\n(which they did finally ;-)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33591", "3371", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33592", "3371", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33593", "3372", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33594", "3372", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33595", "3372", "fld_165241", "date_of_work", "2021-03-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33596", "3372", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33597", "3372", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33598", "3372", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33599", "3372", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33600", "3372", "fld_291750", "date_completed", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33601", "3372", "fld_2572136", "description_of_work_completed", "Remove 4x unused Office 365 / AD accounts- (per Gina)\r\n•	Alfonzo Stoddard\r\n•	Alma Galvan\r\n•	Eddie Boaen\r\n•	Lisa Davis\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33602", "3372", "fld_5994139", "billing_notes", "Remove unused user accounts (request from Gina Cantu)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33603", "3372", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33604", "3372", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33605", "3373", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33606", "3373", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33607", "3373", "fld_165241", "date_of_work", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33608", "3373", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33609", "3373", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33610", "3373", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33611", "3373", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33612", "3373", "fld_291750", "date_completed", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33613", "3373", "fld_2572136", "description_of_work_completed", "Create admin user for RPT employee (Joe Hyder) to have admin (for Apps install)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33614", "3373", "fld_5994139", "billing_notes", "Joe Hyder needs an admin account to intall Mastercam updates on workstations\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33615", "3373", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33616", "3373", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33617", "3374", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33618", "3374", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33619", "3374", "fld_165241", "date_of_work", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33620", "3374", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33621", "3374", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33622", "3374", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33623", "3374", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33624", "3374", "fld_291750", "date_completed", "2021-03-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33625", "3374", "fld_2572136", "description_of_work_completed", "ATC phone issues 30 minutes total\r\n20 minutes troubleshoot Stephe Boyd (3016) ring issues\r\n(ring simultaneously was pushing calls to his Cell VM before they could be picked up)\r\n10 minutes - Ryan Berry set up with Teams Audio Conferencing add-on\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33626", "3374", "fld_5994139", "billing_notes", "30 minutes - Phone issue + MS Tems change\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33627", "3374", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33628", "3374", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33629", "3375", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33630", "3375", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33631", "3375", "fld_165241", "date_of_work", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33632", "3375", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33633", "3375", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33634", "3375", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33635", "3375", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33636", "3375", "fld_291750", "date_completed", "2021-03-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33637", "3375", "fld_2572136", "description_of_work_completed", "Drive Mapping issue (RL Hudson accounting) for new CEO\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33638", "3375", "fld_5994139", "billing_notes", "Drive map (RLH) for RPT\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33639", "3375", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33640", "3375", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33641", "3376", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33642", "3376", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33643", "3376", "fld_165241", "date_of_work", "2021-03-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33644", "3376", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33645", "3376", "fld_7309777", "minutes_spent", "180");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33646", "3376", "fld_8427909", "client_or_company", "Allwater Supply / Kip Anderson / 970-203-1426");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33647", "3376", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33648", "3376", "fld_291750", "date_completed", "2021-03-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33649", "3376", "fld_2572136", "description_of_work_completed", "3 hours - email Migration Kip anderson from hostedemail.com/enm.com to daydream\r\ntransfer domain from old registrar (enom) to new one (Godaddy)\r\nsite now 100% on daydreamit1.com\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33650", "3376", "fld_5994139", "billing_notes", "Transfer email/DNS and registration for allwaterllc.com\r\nto MG / Godaddy\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33651", "3376", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33652", "3376", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33653", "3377", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33654", "3377", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33655", "3377", "fld_165241", "date_of_work", "2021-03-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33656", "3377", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33657", "3377", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33658", "3377", "fld_8427909", "client_or_company", "Jim Welker / 970-663-1703");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33659", "3377", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33660", "3377", "fld_291750", "date_completed", "2021-03-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33661", "3377", "fld_2572136", "description_of_work_completed", "Assist Elaine (UCC) with connecting to Windows servers\r\n(unable to connect, apparently Jim W was at Corkat doind \\\'something\\\')\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33662", "3377", "fld_5994139", "billing_notes", "Assist Elaine (UCC) with connecting to Windows servers\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33663", "3377", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33664", "3377", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33665", "3378", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33666", "3378", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33667", "3378", "fld_165241", "date_of_work", "2021-03-31");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33668", "3378", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33669", "3378", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33670", "3378", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33671", "3378", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33672", "3378", "fld_291750", "date_completed", "2021-04-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33673", "3378", "fld_2572136", "description_of_work_completed", "Set Friday 4-2 (good friday) as holiday in 3CX for ATC\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33674", "3378", "fld_5994139", "billing_notes", "Holiday settings 3CX\r\n(closed Good Friday)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33675", "3378", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33676", "3378", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33677", "3379", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33678", "3379", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33679", "3379", "fld_165241", "date_of_work", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33680", "3379", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33681", "3379", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33682", "3379", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33683", "3379", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33684", "3379", "fld_291750", "date_completed", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33685", "3379", "fld_2572136", "description_of_work_completed", "New user account Mike therton (Office 365 + AD)\r\nNo PC yet\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33686", "3379", "fld_5994139", "billing_notes", "New user account for ATC\r\nMichael Atherton\r\n(+1 Office 365 basic license)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33687", "3379", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33688", "3379", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33689", "3379", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33690", "3379", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33691", "3379", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33692", "3380", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33693", "3380", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33694", "3380", "fld_165241", "date_of_work", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33695", "3380", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33696", "3380", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33697", "3380", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33698", "3380", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33699", "3380", "fld_2572136", "description_of_work_completed", "Assist Greg in adding KEvin Desktop to VO domain (remotely via VPN)\r\nassist Kevin Anderson with reinstalling Timeclock app and getting computer usable\r\nfind Chrome bookmarks file in old (infected) HDD\r\nOpen");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33700", "3380", "fld_5994139", "billing_notes", "Kevin Anderson new desktop assistance\r\nOpen\r\n\r\nNeed to reinstall infected SSD to old PC and boot (once) to recover chrome passwords");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33701", "3380", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33702", "3380", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33703", "3381", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33704", "3381", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33705", "3381", "fld_165241", "date_of_work", "2021-04-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33706", "3381", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33707", "3381", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33708", "3381", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33709", "3381", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33710", "3381", "fld_291750", "date_completed", "2021-04-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33711", "3381", "fld_2572136", "description_of_work_completed", "Backup, uninstall, reinstall 3CX server on Ashcroft to change FQDN (and IP)\r\nnew FQDN -    aprfc.co.3cx.us\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33712", "3381", "fld_5994139", "billing_notes", "shcroft 3CX reinstall to change FQDN\r\n(MG Office IP address change to new statics)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33713", "3381", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33714", "3381", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33715", "3382", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33716", "3382", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33717", "3382", "fld_165241", "date_of_work", "2021-04-02");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33718", "3382", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33719", "3382", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33720", "3382", "fld_8427909", "client_or_company", "Jim Welker / 970-663-1703");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33721", "3382", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33722", "3382", "fld_2572136", "description_of_work_completed", "1 hour at Corkat + 1 hour at Office fixing UCC Asterix server issues\r\nServer powered down + document network layout for Dan Grable \r\n(in advance of firewall upgrade)\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33723", "3382", "fld_5994139", "billing_notes", "Bring UCC services up and document curent setup in preparation for Firewall upgrade\r\nOpen");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33724", "3382", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33725", "3382", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33726", "3383", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33727", "3383", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33728", "3383", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33729", "3383", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33730", "3383", "fld_7309777", "minutes_spent", "22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33731", "3383", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33732", "3383", "fld_20888", "name_of_client", "M&J Dairy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33733", "3383", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33734", "3383", "fld_291750", "date_completed", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33735", "3383", "fld_2572136", "description_of_work_completed", "Remapped network drive from Front Desk to Server.\r\nSet primary DNS on Front Desk to server\\\'s IP (192.168.1.5)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33736", "3383", "fld_5994139", "billing_notes", "Joann could not remember the password to log into the Server, she will call back with password shortly.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33737", "3383", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33738", "3383", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33739", "3384", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33740", "3384", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33741", "3384", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33742", "3384", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33743", "3384", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33744", "3384", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33745", "3384", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33746", "3384", "fld_291750", "date_completed", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33747", "3384", "fld_2572136", "description_of_work_completed", "Discovered Trojan was quarantined by Vipre on both Tom\\\'s desktop as well as Sherly\\\'s.\r\nRan SAS on both Tom\\\'s computer and Sherly\\\'s. Sherly terminated her scan before completion but nothing was detected by the scan before termination, excluding typical cookies.\r\nSAS scan on Tom\\\'s computer came back clean.\r\nCheck Task Scheduler on both computers, nothing suspicious.\r\nChecked for suspicious hardware usage in task manager, nothing found.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33748", "3384", "fld_5994139", "billing_notes", "Recommend we change Tom\\\'s password, will follow up when performing second scan on Sherly\\\'s computer, 4.6.21.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33749", "3384", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33750", "3384", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33751", "3385", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33752", "3385", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33753", "3385", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33754", "3385", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33755", "3385", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33756", "3385", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33757", "3385", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33758", "3385", "fld_291750", "date_completed", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33759", "3385", "fld_2572136", "description_of_work_completed", "Robin\\\'s home phone would not make calls out.\r\nSBC was pointed to correct server but phone was not.\r\nUpdated and upgraded SBC controller.\r\nReprovisioned phone from 3CX server with correct settings.\r\nTested and confirmed that Robin can now make calls.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33760", "3385", "fld_5994139", "billing_notes", "SBC has now locked us out of any access. TeamViewer is now set to view only.\r\n\r\nWill require on site visit to resolve if we ever actually need access to the SBC in the future.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33761", "3385", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33762", "3385", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33763", "3386", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33764", "3386", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33765", "3386", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33766", "3386", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33767", "3386", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33768", "3386", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33769", "3386", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33770", "3386", "fld_291750", "date_completed", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33771", "3386", "fld_2572136", "description_of_work_completed", "Set default program for PDFs back to Adobe Acrobat Reader DC.\r\nSet default internet browser back to Google Chrome.\r\nUninstalled Wave browser.\r\nInstalled Calibre Ebook reader, configured for epub files.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33772", "3386", "fld_5994139", "billing_notes", "Jim gave the okay to come out and replace the old Barn AP when we have time. He would also like to get his fax machine up and running at that time.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33773", "3386", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33774", "3386", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33775", "3387", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33776", "3387", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33777", "3387", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33778", "3387", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33779", "3387", "fld_7309777", "minutes_spent", "48");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33780", "3387", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33781", "3387", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33782", "3387", "fld_291750", "date_completed", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33783", "3387", "fld_2572136", "description_of_work_completed", "checked call log looking for spam caller.\r\nit was coming up as anonymous caller most likely a *67 caller");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33784", "3387", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33785", "3387", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33786", "3387", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33787", "3388", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33788", "3388", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33789", "3388", "fld_165241", "date_of_work", "2021-04-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33790", "3388", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33791", "3388", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33792", "3388", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33793", "3388", "fld_20888", "name_of_client", "Columbine Inn");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33794", "3388", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33795", "3388", "fld_291750", "date_completed", "2021-04-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33796", "3388", "fld_2572136", "description_of_work_completed", "Replaced Edgerouter with Unifi Security Gateway, configured WAN and LAN for same settings as in Edgerouter.\r\nUpdated firmware on USG.\r\nUnable to get controller on Cloud Key to start, SSH connection to CK and downloaded backup.\r\nFactory reset Cloud Key, restored Unifi controller from original backup.\r\nUpdated firmware, and controller software on Cloud Key.\r\nUpdated firmware on 8 Port POE Unifi Switch.\r\nUpdated firmware on all Wireless Access Points.\r\nInstalled and configured teamviewer on front desk computer. (MAC)\r\nRan speed test on USG to confirm improved speeds.\r\nTested and confirmed that Wifi connectivity was functional, both admin network and guest.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33797", "3388", "fld_5994139", "billing_notes", "Customer did not have a Static IP set.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33798", "3388", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33799", "3388", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33800", "3388", "fld_8478853", "cost_of_part_1", "$140.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33801", "3388", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33802", "3389", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33803", "3389", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33804", "3389", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33805", "3389", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33806", "3389", "fld_7309777", "minutes_spent", "46");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33807", "3389", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33808", "3389", "fld_20888", "name_of_client", "Ken Adent");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33809", "3389", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33810", "3389", "fld_291750", "date_completed", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33811", "3389", "fld_2572136", "description_of_work_completed", "Updated Printer Drivers\r\ninstalled HP Smart for scanning \r\nupdated printer ports.\r\nconfirmed printing over usb and LAN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33812", "3389", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33813", "3389", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33814", "3389", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33815", "3390", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33816", "3390", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33817", "3390", "fld_165241", "date_of_work", "2021-04-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33818", "3390", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33819", "3390", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33820", "3390", "fld_8427909", "client_or_company", "Freeman Architects / 970-667-3939");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33821", "3390", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33822", "3390", "fld_291750", "date_completed", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33823", "3390", "fld_2572136", "description_of_work_completed", "2.5 hours 4-5 to 4-7 - Data recovery - fried M.2 drive FA-FRANK PC\r\nbitwise clone corrupted M.2 +\r\nrecover partition +\r\nrecover files & Check integrity\r\n\r\nNOTE - This drive had a large # of bad sectors (20000+). \r\nWhile files were recovered, there was significant data loss.\r\nresolved\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33824", "3390", "fld_5994139", "billing_notes", "FA FRANK PC M.2 drive data recovery\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33825", "3390", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33826", "3390", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33827", "3391", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33828", "3391", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33829", "3391", "fld_165241", "date_of_work", "2021-04-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33830", "3391", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33831", "3391", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33832", "3391", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33833", "3391", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33834", "3391", "fld_291750", "date_completed", "2021-04-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33835", "3391", "fld_2572136", "description_of_work_completed", "Forensic analysis & data recovery KEVIN-PC (VIllage) - 2 hours\r\nImage and scan compromised SSD (using Autopsy and Kali Linux)\r\nEvidence of original compromise 2-12-2021\r\n(reported by user on 2-16 and cleaned, bad guys were in PC for 4 days)\r\nrecover cached chrome data from c:Users<user>AppData\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33836", "3391", "fld_5994139", "billing_notes", "Village Opt KEVIN-PC forensic analysis and user data recovery\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33837", "3391", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33838", "3391", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33839", "3392", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33840", "3392", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33841", "3392", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33842", "3392", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33843", "3392", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33844", "3392", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33845", "3392", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33846", "3392", "fld_291750", "date_completed", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33847", "3392", "fld_2572136", "description_of_work_completed", "Barracuda add admin user for Gina Cantu \r\n(so she can see all ATC quarantine and assist field users herself)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33848", "3392", "fld_5994139", "billing_notes", "Add Barracuda user for Gina Cantu\r\n(to admin Quarantine)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33849", "3392", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33850", "3392", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33851", "3393", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33852", "3393", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33853", "3393", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33854", "3393", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33855", "3393", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33856", "3393", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33857", "3393", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33858", "3393", "fld_291750", "date_completed", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33859", "3393", "fld_2572136", "description_of_work_completed", "Kevin reports he cannot double-click Excel files to open.\r\nOffice 2016 Online repair fixed (Office known issue)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33860", "3393", "fld_5994139", "billing_notes", "4-7 Evening run Office 2016 online repair\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33861", "3393", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33862", "3393", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33863", "3394", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33864", "3394", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33865", "3394", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33866", "3394", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33867", "3394", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33868", "3394", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33869", "3394", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33870", "3394", "fld_291750", "date_completed", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33871", "3394", "fld_2572136", "description_of_work_completed", "Resolve ATC-TX Drive mapping and printer issues for Lisa Clay\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33872", "3394", "fld_5994139", "billing_notes", "ATC-TX minor issues reported by Lisa Clay\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33873", "3394", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33874", "3394", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33875", "3395", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33876", "3395", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33877", "3395", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33878", "3395", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33879", "3395", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33880", "3395", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33881", "3395", "fld_20888", "name_of_client", "Abarr Chirppractic");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33882", "3395", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33883", "3395", "fld_2572136", "description_of_work_completed", "TRoubleshoot Lytec Failure to start\r\nDatabase files for \\\'Lytec Shared Database\\\' missing (SQL Server)\r\nreferred to Application support and enquired after backups.\r\nongoing");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33884", "3395", "fld_5994139", "billing_notes", "Troubleshoot Application issue - Lytec\r\nDB files missing\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33885", "3395", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33886", "3395", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33887", "3396", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33888", "3396", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33889", "3396", "fld_165241", "date_of_work", "2021-04-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33890", "3396", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33891", "3396", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33892", "3396", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33893", "3396", "fld_20888", "name_of_client", "Ruth Youngstrum");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33894", "3396", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33895", "3396", "fld_291750", "date_completed", "2021-04-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33896", "3396", "fld_2572136", "description_of_work_completed", "suggested specs for computer to purchase at best buy.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33897", "3396", "fld_5994139", "billing_notes", "My Little Help");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33898", "3396", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33899", "3396", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33900", "3397", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33901", "3397", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33902", "3397", "fld_165241", "date_of_work", "2021-04-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33903", "3397", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33904", "3397", "fld_7309777", "minutes_spent", "7");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33905", "3397", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33906", "3397", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33907", "3397", "fld_291750", "date_completed", "2021-04-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33908", "3397", "fld_2572136", "description_of_work_completed", "remapped network drive to Andrea\\\'s computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33909", "3397", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33910", "3397", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33911", "3397", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33912", "3398", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33913", "3398", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33914", "3398", "fld_165241", "date_of_work", "2021-04-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33915", "3398", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33916", "3398", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33917", "3398", "fld_8427909", "client_or_company", "Village Optical / 970-223-0592");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33918", "3398", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33919", "3398", "fld_291750", "date_completed", "2021-04-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33920", "3398", "fld_2572136", "description_of_work_completed", "disabled sleep mode on kevin\\\'s computer \r\nswitch to high performance mode");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33921", "3398", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33922", "3398", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33923", "3398", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33924", "3399", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33925", "3399", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33926", "3399", "fld_165241", "date_of_work", "2021-04-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33927", "3399", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33928", "3399", "fld_7309777", "minutes_spent", "375");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33929", "3399", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33930", "3399", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33931", "3399", "fld_291750", "date_completed", "2021-04-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33932", "3399", "fld_2572136", "description_of_work_completed", "ATC - Backups - 6.25 hours 4-7 to 4-10, Update/Rework backup system (Synology NAS) \r\nUpdate firmware 3x Synology NAS boxes (2 in CO 1 in AL)\r\nreconfigure bare metal server backups to Synology\r\nreconfigure rsync (NAS to NAS) sync to be more redundant\r\nadd additional backup layer (NAS to USB) for ransomware protection\r\ntest full backup/sync cycle\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33933", "3399", "fld_5994139", "billing_notes", "Server backup system audit-rebuild ATC\r\n(reconfigure and add redundancy)\r\nServers were previously backing up to local NAS \r\nAdded sync so that NAS boxes also back-up each other (and also to USB) to provide additional disaster and ransomware protection.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33934", "3399", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33935", "3399", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33936", "3400", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33937", "3400", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33938", "3400", "fld_165241", "date_of_work", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33939", "3400", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33940", "3400", "fld_7309777", "minutes_spent", "240");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33941", "3400", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33942", "3400", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33943", "3400", "fld_291750", "date_completed", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33944", "3400", "fld_2572136", "description_of_work_completed", "Server maintenance ATC (4 hours AFTER HOURS Sat 4-10-2021)  Updates and expand AT-DC storage\r\nServer maint - AT-DC, AT-FILE, AT-TS1, AT-TS2, AT-VISTA, AT-IT and AT-PELLDC\r\nOffline AT-DC, move VM to larger RAID array and increase storage provisioning (less than 5% free space)-\r\nincrease C: from 130GB to 200GB\r\nincrease D: from 600GB to 1000GB\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33945", "3400", "fld_5994139", "billing_notes", "AT-DC - Increase storage - move VM to larger RAID +\r\n increase virtual hard drive size - C: and D:\r\n+ scheduled maint on all ATC servers\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33946", "3400", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33947", "3400", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33948", "3401", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33949", "3401", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33950", "3401", "fld_165241", "date_of_work", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33951", "3401", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33952", "3401", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33953", "3401", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33954", "3401", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33955", "3401", "fld_291750", "date_completed", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33956", "3401", "fld_2572136", "description_of_work_completed", "Tested WiFi connectivity throughout warehouse 1. Issues staying connected to WiFi in Inventory area, unable to connect when device is trying to connect through Mobile Printer WAP.\r\n\r\nPower cycled Mobile Printer WAP and connectivity appears to be restored.\r\n\r\nSignal strength throughout the entirety of warehouse does not go over -70dbm, within acceptable limits of WiFi.\r\n\r\nTook an initial look at printer issue with prints coming out poorly aligned. Likely a driver issue but unable to fully diagnose due to lack of permission.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33957", "3401", "fld_5994139", "billing_notes", "WiFi issue resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33958", "3401", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33959", "3401", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33960", "3402", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33961", "3402", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33962", "3402", "fld_165241", "date_of_work", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33963", "3402", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33964", "3402", "fld_7309777", "minutes_spent", "16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33965", "3402", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33966", "3402", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33967", "3402", "fld_291750", "date_completed", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33968", "3402", "fld_2572136", "description_of_work_completed", "installed 3cx client on Cathy\\\'s computer\r\nupdated Java");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33969", "3402", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33970", "3402", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33971", "3402", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33972", "3403", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33973", "3403", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33974", "3403", "fld_165241", "date_of_work", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33975", "3403", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33976", "3403", "fld_7309777", "minutes_spent", "24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33977", "3403", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33978", "3403", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33979", "3403", "fld_291750", "date_completed", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33980", "3403", "fld_2572136", "description_of_work_completed", "helped Alision with printing Callcentric LNP Form.\r\nadded extension in Callcentric.\r\nsetup another sip trunk for fax in 3cx server\r\n-created fax extension");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33981", "3403", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33982", "3403", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33983", "3403", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33984", "3404", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33985", "3404", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33986", "3404", "fld_165241", "date_of_work", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33987", "3404", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33988", "3404", "fld_7309777", "minutes_spent", "24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33989", "3404", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33990", "3404", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33991", "3404", "fld_291750", "date_completed", "2021-04-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33992", "3404", "fld_2572136", "description_of_work_completed", "Unifi Network update\r\n-AP\\\'s\r\n-Switch\\\'s \r\n-USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33993", "3404", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33994", "3404", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33995", "3404", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33996", "3405", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33997", "3405", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33998", "3405", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("33999", "3405", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34000", "3405", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34001", "3405", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34002", "3405", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34003", "3405", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34004", "3405", "fld_2572136", "description_of_work_completed", "HR Admin LT is now being used by Angel (was originally for Angel but was provided to HR admin temp)\r\nRenamed back to E&T Angel Guzman LT New.\r\nRemoved HR admin VPN connection.\r\nRestored Aguzman VPN connection.\r\nTested and confirmed that connection works.\r\nLeft instructions on desktop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34005", "3405", "fld_5994139", "billing_notes", "aguzman\r\n(10+3)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34006", "3405", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34007", "3405", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34008", "3406", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34009", "3406", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34010", "3406", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34011", "3406", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34012", "3406", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34013", "3406", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34014", "3406", "fld_20888", "name_of_client", "Rene Mortenson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34015", "3406", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34016", "3406", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34017", "3406", "fld_2572136", "description_of_work_completed", "TurboTax 2020 appeared to be corrupted.\r\nUnable to repair installation.\r\nUnable to automatically uninstall.\r\nManually deleted TurboTax 2020 folder, cleaned our registry entries with CCleaner.\r\nUninstalled and then reinstalled successfully, fully updated and confirmed to be working.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34018", "3406", "fld_5994139", "billing_notes", "Customer PAID");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34019", "3406", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34020", "3406", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34021", "3407", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34022", "3407", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34023", "3407", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34024", "3407", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34025", "3407", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34026", "3407", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34027", "3407", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34028", "3407", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34029", "3407", "fld_2572136", "description_of_work_completed", "Updated Outlook to include Teams add-on for creating Teams meetings using Outlook.\r\nStephen initially requested audio conferencing capabilities but he does not have the requisite license.\r\nManagement opted not to get a new license.\r\nConfirmed Teams Calendar function worked and that there was nothing else that Stephen needed assistance with.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34030", "3407", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34031", "3407", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34032", "3407", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34033", "3408", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34034", "3408", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34035", "3408", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34036", "3408", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34037", "3408", "fld_7309777", "minutes_spent", "28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34038", "3408", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34039", "3408", "fld_20888", "name_of_client", "Shad Droman");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34040", "3408", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34041", "3408", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34042", "3408", "fld_2572136", "description_of_work_completed", "Added domain to safe senders list\r\nhelp locate emails and photos.\r\ndownloaded CID photos that wouldn\\\'t open from roundcube");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34043", "3408", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34044", "3408", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34045", "3408", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34046", "3409", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34047", "3409", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34048", "3409", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34049", "3409", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34050", "3409", "fld_7309777", "minutes_spent", "118");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34051", "3409", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34052", "3409", "fld_20888", "name_of_client", "The Artisan Shop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34053", "3409", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34054", "3409", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34055", "3409", "fld_2572136", "description_of_work_completed", "Delivered New ION\\\'s \r\nInstalled ION\\\'s \r\n- Data transfer \r\n- Setup exchange emails\r\n- Setup 3cx Client\r\n- Cable Management");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34056", "3409", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34057", "3409", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34058", "3409", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34059", "3410", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34060", "3410", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34061", "3410", "fld_165241", "date_of_work", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34062", "3410", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34063", "3410", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34064", "3410", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34065", "3410", "fld_20888", "name_of_client", "Beck Architects");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34066", "3410", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34067", "3410", "fld_291750", "date_completed", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34068", "3410", "fld_2572136", "description_of_work_completed", "Sophie called as she was not able to connect to the internet nor could she connect to the server.\r\nNetwork drive indicated path could not be found.\r\nIPconfig command indicated neither Sophie\\\'s computer nor the server were being assigned an IP address.\r\nRebooted Rise Broadband modem, computers came online, IP addresses assigned, internet connectivity restored.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34069", "3410", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34070", "3410", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34071", "3410", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34072", "3411", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34073", "3411", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34074", "3411", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34075", "3411", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34076", "3411", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34077", "3411", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34078", "3411", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34079", "3411", "fld_291750", "date_completed", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34080", "3411", "fld_2572136", "description_of_work_completed", "ATC 3CX maintenance (fter hours)\r\nUpdate OS and 3CX on all servers ( CO, AL, TX)\r\nupdate firmware on all Yealink T27G phones\r\nreprovision ALL phones (CO, AL, TX)\r\nFix firewall rules (CO ) 3CX was failing full-cone NAT test\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34081", "3411", "fld_5994139", "billing_notes", "3CX maint. after hours ATC\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34082", "3411", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34083", "3411", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34084", "3412", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34085", "3412", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34086", "3412", "fld_165241", "date_of_work", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34087", "3412", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34088", "3412", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34089", "3412", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34090", "3412", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34091", "3412", "fld_291750", "date_completed", "2021-04-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34092", "3412", "fld_2572136", "description_of_work_completed", "New account (AD and Office 365)\r\nJulian Diaz (TX Field employee)\r\nNo PC assigned yet to set up\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34093", "3412", "fld_5994139", "billing_notes", "set up new account for ATC TX\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34094", "3412", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34095", "3412", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34096", "3413", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34097", "3413", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34098", "3413", "fld_165241", "date_of_work", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34099", "3413", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34100", "3413", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34101", "3413", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34102", "3413", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34103", "3413", "fld_291750", "date_completed", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34104", "3413", "fld_2572136", "description_of_work_completed", "E&T remove unused account and set up forwarding\r\nremove Lisa Crandall Office 365 account\r\nforward Alicia Miller emails to Tonia\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34105", "3413", "fld_5994139", "billing_notes", "E&T Account changes requested by Tonia\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34106", "3413", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34107", "3413", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34108", "3414", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34109", "3414", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34110", "3414", "fld_165241", "date_of_work", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34111", "3414", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34112", "3414", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34113", "3414", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34114", "3414", "fld_20888", "name_of_client", "MG / All 3CX customers");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34115", "3414", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34116", "3414", "fld_291750", "date_completed", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34117", "3414", "fld_2572136", "description_of_work_completed", "Update out of date Yealink templates and firmwares for ALL 3CX clients (except ATC on separate tracker)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34118", "3414", "fld_5994139", "billing_notes", "Yealink template and firmware updates available for 3CX\r\nupdated on all servers/phones\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34119", "3414", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34120", "3414", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34121", "3415", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34122", "3415", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34123", "3415", "fld_165241", "date_of_work", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34124", "3415", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34125", "3415", "fld_7309777", "minutes_spent", "63");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34126", "3415", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34127", "3415", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34128", "3415", "fld_291750", "date_completed", "2021-04-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34129", "3415", "fld_2572136", "description_of_work_completed", "ATC CO\r\nupdated backbone switch and restarted.\r\nupdated Unifi Devices");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34130", "3415", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34131", "3415", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34132", "3415", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34133", "3416", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34134", "3416", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34135", "3416", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34136", "3416", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34137", "3416", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34138", "3416", "fld_8427909", "client_or_company", "Roofing Restoration / 970-617-2008");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34139", "3416", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34140", "3416", "fld_2572136", "description_of_work_completed", "Rose called with an Outlook issue. Outlook is stuck synchronizing folders.\r\nDisabled all add-ons, no success.\r\nRan Outlook in safe mode, no success.\r\nRenamed OST file, had Outlook create it but sync issue still exists.\r\nRan Windows updates but had to stop service due to time constraint.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34141", "3416", "fld_5994139", "billing_notes", "Rose will be calling back in the afternoon when she has time for us to work on the computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34142", "3416", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34143", "3416", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34144", "3417", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34145", "3417", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34146", "3417", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34147", "3417", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34148", "3417", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34149", "3417", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34150", "3417", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34151", "3417", "fld_2572136", "description_of_work_completed", "Tom called with Outlook issues. Nearly all of his rules have become broken.\r\nRules consist of moving emails from inbox to specified folder. The specified folder variable has been blown out for all rules.\r\nDeleted send/receive file in attempt to repair rules, no success.\r\nDiscovered address book has no entries in it now.\r\nRan Outlook in safe mode, no success.\r\nStopped service due to time constraint.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34152", "3417", "fld_5994139", "billing_notes", "Can manually fix rules be setting the specified folder again but Tom has a large amount of rules, individually recreating them is no desired.\r\n\r\nTom will be calling back when he has time for us to work on his computer.\r\n\r\nNeed to repair PST file.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34153", "3417", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34154", "3417", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34155", "3418", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34156", "3418", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34157", "3418", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34158", "3418", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34159", "3418", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34160", "3418", "fld_8427909", "client_or_company", "Waxing the City (Lkwd) / 720-633-2446");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34161", "3418", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34162", "3418", "fld_291750", "date_completed", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34163", "3418", "fld_2572136", "description_of_work_completed", "WTC called about poor internet connectivity.\r\nThey have 2 AP, (1 ap lite, 1 ap LR (EOL)). The long range AP is disconnected and because it\\\'s EOL, cannot readopt into system.\r\n\r\nUnable to automatically update firmware on UAP Lite. SSH\\\'d into device, manually updated firmware.\r\nUpdated software controller.\r\nSet UAP Lite to static IP.\r\nSSH\\\'d into UAP LR, forced firmware update through.\r\nForced re-adoption of UAP LR to controller.\r\nSet UAP LR to static IP.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34164", "3418", "fld_5994139", "billing_notes", "UAP LR is EOL and so will eventually need to be replaced.\r\n\r\nUAP Lite is configured to use channel 11 on 2.4ghz and channel 116 on 5ghz. Transmit power is also manually set. Unsure why these settings are in place.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34165", "3418", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34166", "3418", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34167", "3419", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34168", "3419", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34169", "3419", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34170", "3419", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34171", "3419", "fld_7309777", "minutes_spent", "32");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34172", "3419", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34173", "3419", "fld_20888", "name_of_client", "Roseann Wheeler / 970-286-5379");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34174", "3419", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34175", "3419", "fld_291750", "date_completed", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34176", "3419", "fld_2572136", "description_of_work_completed", "RoseAnn got a new router and could no longer see their printer.\r\nPrinter was not connected to WiFi network.\r\nGuided RoseAnn through reconnecting the printer to their new WiFi network.\r\nReinstalled drivers for Canon printer on her laptop.\r\nSent test print page through and confirmed with RoseAnn that everything was working.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34177", "3419", "fld_5994139", "billing_notes", "roseannwheeler@comcast.net\r\n\r\n2515 Dotsero ct.\r\nLoveland, CO 80538");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34178", "3419", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34179", "3419", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34180", "3420", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34181", "3420", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34182", "3420", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34183", "3420", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34184", "3420", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34185", "3420", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34186", "3420", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34187", "3420", "fld_291750", "date_completed", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34188", "3420", "fld_2572136", "description_of_work_completed", "Pam tries to call Stephen Boyd and it goes to a random number with a woman who does not work for ATC.\r\nDiscovered Stephen had settings to always forward to a mobile number if he did not answer the phone.\r\nCould not confirm ownership of mobile number.\r\nChanged settings so that all unanswered phone calls go straight to voicemail.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34189", "3420", "fld_5994139", "billing_notes", "Gina will contact Stephen and confirm what the settings should be.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34190", "3420", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34191", "3420", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34192", "3421", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34193", "3421", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34194", "3421", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34195", "3421", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34196", "3421", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34197", "3421", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34198", "3421", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34199", "3421", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34200", "3421", "fld_2572136", "description_of_work_completed", "Kathy called looking to setup their new HR rep on Alicia Miller\\\'s old DT.\r\nRenamed desktop to E&T HR DT.\r\nReactivated HR domain account after confirmed that previous HR rep had now returned the company laptop provided to them.\r\nSetup HR domain account on E&T HR DT.\r\nSetup HR email account for HR user.\r\nPerformed light initial computer setup for HR user.\r\nConfirmed HR user\\\'s access to necessary folders on server as well as HR email.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34201", "3421", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34202", "3421", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34203", "3421", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34204", "3422", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34205", "3422", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34206", "3422", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34207", "3422", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34208", "3422", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34209", "3422", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34210", "3422", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34211", "3422", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34212", "3422", "fld_2572136", "description_of_work_completed", "Phones were not working, unable to send or receive any calls either external or internal.\r\n3CX server was not connected to internet but was powered on.\r\nPerformed a hard reboot and server came back online along with phone connectivity.\r\nFound a windows update that started on Friday at 6:30pm but did not appear to complete.\r\nLikely cause was a stuck Windows update. Update was completed after reboot.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34213", "3422", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34214", "3422", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34215", "3422", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34216", "3423", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34217", "3423", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34218", "3423", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34219", "3423", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34220", "3423", "fld_7309777", "minutes_spent", "100");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34221", "3423", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34222", "3423", "fld_20888", "name_of_client", "Kirk Wiggins");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34223", "3423", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34224", "3423", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34225", "3423", "fld_2572136", "description_of_work_completed", "Kirk\\\'s email got hacked again.\r\nAll his contacts were deleted but recovery was possible.\r\nNo forwarding settings or alias emails setup.\r\nRemoved Mary\\\'s email association from Kirk\\\'s account.\r\nSetup 2 factor authentication for Mary\\\'s account and Kirk\\\'s account.\r\nChanged Kirk\\\'s account password.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34226", "3423", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34227", "3423", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34228", "3423", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34229", "3424", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34230", "3424", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34231", "3424", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34232", "3424", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34233", "3424", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34234", "3424", "fld_8427909", "client_or_company", "MAC Electric / 970-669-2464");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34235", "3424", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34236", "3424", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34237", "3424", "fld_2572136", "description_of_work_completed", "Changed after hours phone calls to go to number 970-214-6374 for Shannon.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34238", "3424", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34239", "3424", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34240", "3424", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34241", "3425", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34242", "3425", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34243", "3425", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34244", "3425", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34245", "3425", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34246", "3425", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34247", "3425", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34248", "3425", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34249", "3425", "fld_2572136", "description_of_work_completed", "Rebooted virtual server as RDS VM was not online.\r\nConfirmed that Luisa was able to remote into desktop after reboot.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34250", "3425", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34251", "3425", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34252", "3425", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34253", "3426", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34254", "3426", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34255", "3426", "fld_165241", "date_of_work", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34256", "3426", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34257", "3426", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34258", "3426", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34259", "3426", "fld_20888", "name_of_client", "Ores Law");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34260", "3426", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34261", "3426", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34262", "3426", "fld_2572136", "description_of_work_completed", "Cloned 1TB HDD to 500GB SSD.\r\nRan SFC and DISM.\r\nFixed Quickbooks entitlement client.\r\nPerformed light cleanup.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34263", "3426", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34264", "3426", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34265", "3426", "fld_2864175", "part1_description", "500 GB SK Hynix SSD");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34266", "3426", "fld_8478853", "cost_of_part_1", "56.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34267", "3426", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34268", "3427", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34269", "3427", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34270", "3427", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34271", "3427", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34272", "3427", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34273", "3427", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34274", "3427", "fld_20888", "name_of_client", "Jackson Automotive");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34275", "3427", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34276", "3427", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34277", "3427", "fld_2572136", "description_of_work_completed", "Restored printer connectivity between Shop Preon 1 (USB connected to printer) and Shop Preon 2 and 3.\r\nAttempted to restore WiFi connectivity to Shop WAP (TP-Link Access Point), unable.\r\nUnable to connect to TP-Link even after factory reset. Diagnosed a failed TP-Link unit.\r\nAttempted to broadcast both customer WiFi and Shop WiFi from the single access point up front, unable.\r\nPFsense firewall does not permit multiple WiFi networks from a single access point.\r\n\r\nRecommended that we move forward with a full Unifi installation (USG, Cloudkey, 2 AP)\r\n\r\nUnable to restore shop WiFi due to hardware failure and software limitations.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34278", "3427", "fld_5994139", "billing_notes", "sent Quote for full Unifi installation");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34279", "3427", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34280", "3427", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34281", "3428", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34282", "3428", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34283", "3428", "fld_165241", "date_of_work", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34284", "3428", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34285", "3428", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34286", "3428", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34287", "3428", "fld_20888", "name_of_client", "Kirk Wiggins / 970-7441258");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34288", "3428", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34289", "3428", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34290", "3428", "fld_2572136", "description_of_work_completed", "Restored Outlook connectivity on Kirk\\\'s cell phone and computer (related to password change)\r\n-Used app password for Kirk\\\'s Outlook on his computer.\r\nRestored Outlook connectivity on Mary Lou\\\'s cell phone, Kindle, and computer (related to password change)\r\n-Used app password for Mary Lou\\\'s Kindle.\r\n\r\nConfirmed that all devices were receiving emails as expected and that 2 factor authentication was functional.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34291", "3428", "fld_5994139", "billing_notes", "resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34292", "3428", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34293", "3428", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34294", "3429", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34295", "3429", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34296", "3429", "fld_165241", "date_of_work", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34297", "3429", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34298", "3429", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34299", "3429", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34300", "3429", "fld_20888", "name_of_client", "Bobbi Volker");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34301", "3429", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34302", "3429", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34303", "3429", "fld_2572136", "description_of_work_completed", "Turbotax updated kept crashes without successfully updating program.\r\nRestarted computer and manually started intuit update service, then started update process.\r\nUpdated succeeded and Turbotax is functioning.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34304", "3429", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34305", "3429", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34306", "3429", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34307", "3430", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34308", "3430", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34309", "3430", "fld_165241", "date_of_work", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34310", "3430", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34311", "3430", "fld_7309777", "minutes_spent", "25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34312", "3430", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34313", "3430", "fld_20888", "name_of_client", "Kirk Wiggins / 970-7441258");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34314", "3430", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34315", "3430", "fld_291750", "date_completed", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34316", "3430", "fld_2572136", "description_of_work_completed", "Kirk was not receiving any emails.\r\nSent test email but email never came in.\r\nAble to receive email from Kirk.\r\nFound rule that would move all mail to an archived folder and then forward email onto a random gmail address.\r\nDeleted rule, tested and confirmed that email was running as desired.\r\nMoved all mail back to Inbox");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34317", "3430", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34318", "3430", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34319", "3430", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34320", "3431", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34321", "3431", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34322", "3431", "fld_165241", "date_of_work", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34323", "3431", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34324", "3431", "fld_7309777", "minutes_spent", "40");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34325", "3431", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34326", "3431", "fld_20888", "name_of_client", "Beck Architects");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34327", "3431", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34328", "3431", "fld_291750", "date_completed", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34329", "3431", "fld_2572136", "description_of_work_completed", "Performed light cleanup of Server.\r\nRan Vipre scan, nothing detected. Nothing has been detected in the past either, no concerns of infection.\r\nCylance found nothing malicious.\r\nHDD scan came back fine, no issues with OS drive and Data drive.\r\nRan CCleaner and removed 13GB of temp files/data. 180 registry entries as well.\r\nServer only has 8GB of RAM @ 1033mhz. Recommend upgrade to 16GB of RAM.\r\nDisabled notifications and found a lot of false advertising notifications regarding viruses, likely initial cause for concern.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34330", "3431", "fld_5994139", "billing_notes", "resolved unless they want more RAM");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34331", "3431", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34332", "3431", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34333", "3432", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34334", "3432", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34335", "3432", "fld_165241", "date_of_work", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34336", "3432", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34337", "3432", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34338", "3432", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34339", "3432", "fld_20888", "name_of_client", "Dan Jackson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34340", "3432", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34341", "3432", "fld_291750", "date_completed", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34342", "3432", "fld_2572136", "description_of_work_completed", "Restored Verus connection to shop printer, hosted from Shop computer 1.\r\nDiscussed potential Unifi setup, benefits and all.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34343", "3432", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34344", "3432", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34345", "3432", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34346", "3433", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34347", "3433", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34348", "3433", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34349", "3433", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34350", "3433", "fld_7309777", "minutes_spent", "18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34351", "3433", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34352", "3433", "fld_20888", "name_of_client", "M &J Dairy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34353", "3433", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34354", "3433", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34355", "3433", "fld_2572136", "description_of_work_completed", "Troubleshooted office computer without internet \r\n- the ethernet cable was broken and came unplug\r\n\r\nConfirmed the network drive where pw protected ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34356", "3433", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34357", "3433", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34358", "3433", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34359", "3434", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34360", "3434", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34361", "3434", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34362", "3434", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34363", "3434", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34364", "3434", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34365", "3434", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34366", "3434", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34367", "3434", "fld_2572136", "description_of_work_completed", "Remapped network drive on Sam\\\'s laptop and David\\\'s laptop. (Remapped using network name as opposed to IP)\r\n\r\nDavid indicated he had trouble using his VPN but was presently at the office so I could not effectively test it. Checked VPN settings on Unifi but did not find any issues. Instructed David to call us when he is at home and we will diagnose VPN issues if they still exist at that time.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34368", "3434", "fld_5994139", "billing_notes", "resolved unless David has further issues with VPN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34369", "3434", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34370", "3434", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34371", "3435", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34372", "3435", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34373", "3435", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34374", "3435", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34375", "3435", "fld_7309777", "minutes_spent", "375");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34376", "3435", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34377", "3435", "fld_20888", "name_of_client", "Bernard Boden");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34378", "3435", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34379", "3435", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34380", "3435", "fld_2572136", "description_of_work_completed", "Installed Unifi Security Gateway, (2) Pro Access Point, (2) 5 Port Switches, 40 feet CAT 6 Cabling.\r\nConfigured Unifi settings to provide service to origin house and client house.\r\nTested and confirmed network speeds are 75/5.\r\nTested and confirmed network connectivity on both sides.\r\nSetup remote access to Unifi Cloudkey to facilitate remote servicing of network.\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34381", "3435", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34382", "3435", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34383", "3435", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34384", "3435", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34385", "3435", "fld_2864175", "part1_description", "(1) Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34386", "3435", "fld_9190675", "part_2_description", "(2) Unifi Pro AP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34387", "3435", "fld_8951874", "part_3_description", "(2) 5 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34388", "3435", "fld_1621742", "part_4_description", "40 Feet CAT 6 Cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34389", "3435", "fld_8478853", "cost_of_part_1", "139.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34390", "3435", "fld_592520", "cost_of_part_2", "300.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34391", "3435", "fld_5448517", "cost_of_part_3", "38.40");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34392", "3435", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34393", "3436", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34394", "3436", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34395", "3436", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\",\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34396", "3436", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34397", "3436", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34398", "3436", "fld_7309777", "minutes_spent", "300");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34399", "3436", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34400", "3436", "fld_20888", "name_of_client", "315");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34401", "3436", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34402", "3436", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34403", "3436", "fld_2572136", "description_of_work_completed", "Installed Unifi Security Gateway, (2) Pro Access Point, (2) 5 Port Switches, 40 feet CAT 6 Cabling.\r\nConfigured Unifi settings to provide service to origin house and client house.\r\nTested and confirmed network speeds are 75/5.\r\nTested and confirmed network connectivity on both sides.\r\nSetup remote access to Unifi Cloudkey to facilitate remote servicing of network.\r\nResolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34404", "3436", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34405", "3436", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34406", "3436", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34407", "3436", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34408", "3436", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34409", "3436", "fld_9190675", "part_2_description", "(2) Unifi Pro AP ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34410", "3436", "fld_8951874", "part_3_description", "(2) 5 Port Switch ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34411", "3436", "fld_1621742", "part_4_description", "40 Feet CAT 6 Cable ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34412", "3436", "fld_8478853", "cost_of_part_1", "139.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34413", "3436", "fld_592520", "cost_of_part_2", "300.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34414", "3436", "fld_5448517", "cost_of_part_3", "38.40");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34415", "3436", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34416", "3437", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34417", "3437", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34418", "3437", "fld_165241", "date_of_work", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34419", "3437", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34420", "3437", "fld_7309777", "minutes_spent", "21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34421", "3437", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34422", "3437", "fld_20888", "name_of_client", "Carolyn Watson (Napa Valley Lambs) ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34423", "3437", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34424", "3437", "fld_291750", "date_completed", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34425", "3437", "fld_2572136", "description_of_work_completed", "QuickBooks wouldn\\\'t print.\r\n-updated Drivers\r\n-removed old printers\r\n-connected via USB for printing\r\n-updated java\r\n\r\nWifi Problems\r\n-Corrected randomly disconnecting \r\n-restarted modems.\r\n-set dns to google\\\'s\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34426", "3437", "fld_5994139", "billing_notes", "completed ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34427", "3437", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34428", "3437", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34429", "3438", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34430", "3438", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34431", "3438", "fld_165241", "date_of_work", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34432", "3438", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34433", "3438", "fld_7309777", "minutes_spent", "26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34434", "3438", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34435", "3438", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34436", "3438", "fld_291750", "date_completed", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34437", "3438", "fld_2572136", "description_of_work_completed", "Corrected random USG restart issue.\r\n\r\nUpdated  Unifi Firmware \r\n-USG\r\n-Switch\r\n-WAP\\\'s\r\n\r\nUpdated Unifi cloud key firmware\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34438", "3438", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34439", "3438", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34440", "3438", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34441", "3439", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34442", "3439", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34443", "3439", "fld_165241", "date_of_work", "2021-04-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34444", "3439", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34445", "3439", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34446", "3439", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34447", "3439", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34448", "3439", "fld_291750", "date_completed", "2021-04-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34449", "3439", "fld_2572136", "description_of_work_completed", "Performed light clean up of ABVI DVR PC.\r\nComputer has old hardware, recommended a replacement Preon for their use.\r\nPrimary use to to watch cameras through web interface of DVR.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34450", "3439", "fld_5994139", "billing_notes", "Performance on computer was improved but is still limited by hardware.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34451", "3439", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34452", "3439", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34453", "3440", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34454", "3440", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34455", "3440", "fld_165241", "date_of_work", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34456", "3440", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34457", "3440", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34458", "3440", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34459", "3440", "fld_20888", "name_of_client", "Morwai Dairy");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34460", "3440", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34461", "3440", "fld_291750", "date_completed", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34462", "3440", "fld_2572136", "description_of_work_completed", "Mike had a copy of Office 2016, student version licensed to orders@milpond.com\r\nUnsure how a copy licensed to us was installed on the computer.\r\nOffice 2016 would not update properly. Attempted quick repair with no success.\r\nAttempted online repair but installation broke and was fully removed instead.\r\nDownloaded, installed and configured Office 365 as Mike had an extra license available.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34463", "3440", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34464", "3440", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34465", "3440", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34466", "3441", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34467", "3441", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34468", "3441", "fld_165241", "date_of_work", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34469", "3441", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34470", "3441", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34471", "3441", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34472", "3441", "fld_20888", "name_of_client", "Nancy Manuel");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34473", "3441", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34474", "3441", "fld_291750", "date_completed", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34475", "3441", "fld_2572136", "description_of_work_completed", "Configured Vipre to scan every night at 2am, Full scan on Sundays.\r\nExplained how the lock screen worked, instructed Nancy on how to lock and unlock the computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34476", "3441", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34477", "3441", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34478", "3441", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34479", "3442", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34480", "3442", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34481", "3442", "fld_165241", "date_of_work", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34482", "3442", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34483", "3442", "fld_7309777", "minutes_spent", "300");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34484", "3442", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34485", "3442", "fld_20888", "name_of_client", "Noreen Flood");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34486", "3442", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34487", "3442", "fld_291750", "date_completed", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34488", "3442", "fld_2572136", "description_of_work_completed", "Installed USG, Cloudkey v1, (1) WAP, (2) 8 port switches, 10ft CAT5e cable\r\nConfigured Unifi network, LAN, WAN, and WiFi.\r\nSetup printers, (2), on Noreen\\\'s computer. Tidied up cable management.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34489", "3442", "fld_5994139", "billing_notes", "resolved.\r\nIf a VPN connection or RDP is desired, will need to configured LAN 2 port for Ann\\\'s office. Presently it has modem > USG and Ann\\\'s computer. Sufficient for all of Noreen\\\'s current needs.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34490", "3442", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34491", "3442", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34492", "3442", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34493", "3442", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34494", "3442", "fld_9190675", "part_2_description", "(2) 8 Port Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34495", "3442", "fld_8951874", "part_3_description", "Unifi WAP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34496", "3442", "fld_1621742", "part_4_description", "Unifi Cloudkey");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34497", "3442", "fld_5404555", "part_5_description", "10ft CAT5E Cable");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34498", "3442", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34499", "3443", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34500", "3443", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34501", "3443", "fld_165241", "date_of_work", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34502", "3443", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34503", "3443", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34504", "3443", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34505", "3443", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34506", "3443", "fld_291750", "date_completed", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34507", "3443", "fld_2572136", "description_of_work_completed", "Server was unable to open HEIC file type.\r\nHad to buy HEVC extension from Microsoft store.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34508", "3443", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34509", "3443", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34510", "3443", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34511", "3444", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34512", "3444", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34513", "3444", "fld_165241", "date_of_work", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34514", "3444", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34515", "3444", "fld_7309777", "minutes_spent", "9");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34516", "3444", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34517", "3444", "fld_20888", "name_of_client", "BEK ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34518", "3444", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34519", "3444", "fld_291750", "date_completed", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34520", "3444", "fld_2572136", "description_of_work_completed", "Outlook was giving reset password notification.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34521", "3444", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34522", "3444", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34523", "3444", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34524", "3445", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34525", "3445", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34526", "3445", "fld_165241", "date_of_work", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34527", "3445", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34528", "3445", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34529", "3445", "fld_8427909", "client_or_company", "Freeman Architects / 970-667-3939");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34530", "3445", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34531", "3445", "fld_291750", "date_completed", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34532", "3445", "fld_2572136", "description_of_work_completed", "Renewed Vipre on Monica\\\'s home computer.\r\nUpdated Vipre to latest version, ensured that patches and definitions were updated as well.\r\nPerformed light cleanup on Monica\\\'s home computer.\r\nNo issues detected.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34533", "3445", "fld_5994139", "billing_notes", "resolved\r\n\r\nVipre Key: 422DG-KTRJD-D4NZ2-BZ3AG-HQTLL ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34534", "3445", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34535", "3445", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34536", "3445", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34537", "3445", "fld_8555975", "license___", "422DG-KTRJD-D4NZ2-BZ3AG-HQTLL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34538", "3445", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34539", "3445", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34540", "3446", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34541", "3446", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34542", "3446", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34543", "3446", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34544", "3446", "fld_7309777", "minutes_spent", "35");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34545", "3446", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34546", "3446", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34547", "3446", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34548", "3446", "fld_2572136", "description_of_work_completed", "RPT New Employee Account - Office 365 / AD  Andrew Burns\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34549", "3446", "fld_5994139", "billing_notes", "new employee aburns setup on AD & Office 365 (no assigned PC)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34550", "3446", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34551", "3446", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34552", "3447", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34553", "3447", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34554", "3447", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34555", "3447", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34556", "3447", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34557", "3447", "fld_8427909", "client_or_company", "Allwater Supply / Kip Anderson / 970-203-1426");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34558", "3447", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34559", "3447", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34560", "3447", "fld_2572136", "description_of_work_completed", "Kip Anderson requested better SPAM filtering \r\nEnable SpamExperts for Allwaterllc.com domain and set up in DNS\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34561", "3447", "fld_5994139", "billing_notes", "enable Spamexperts on allwaterllc.com\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34562", "3447", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34563", "3447", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34564", "3448", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34565", "3448", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34566", "3448", "fld_165241", "date_of_work", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34567", "3448", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34568", "3448", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34569", "3448", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34570", "3448", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34571", "3448", "fld_291750", "date_completed", "2021-04-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34572", "3448", "fld_2572136", "description_of_work_completed", "Adjust SPAM filters \r\nwhitelist addresses requested by AprilW and block new SPAM campaign\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34573", "3448", "fld_5994139", "billing_notes", "SPAM filter administration\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34574", "3448", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34575", "3448", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34576", "3449", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34577", "3449", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34578", "3449", "fld_165241", "date_of_work", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34579", "3449", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34580", "3449", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34581", "3449", "fld_8427909", "client_or_company", "Waxing the City (Lkwd) / 720-633-2446");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34582", "3449", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34583", "3449", "fld_291750", "date_completed", "2021-04-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34584", "3449", "fld_2572136", "description_of_work_completed", "Phone forwarding change (x3) for WTC LAkewood 4-20\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34585", "3449", "fld_5994139", "billing_notes", "WTC had no one to cover the office for most of the day\r\nhad us keep forwarding phone differently until office was manned.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34586", "3449", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34587", "3449", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34588", "3450", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34589", "3450", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34590", "3450", "fld_165241", "date_of_work", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34591", "3450", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34592", "3450", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34593", "3450", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34594", "3450", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34595", "3450", "fld_291750", "date_completed", "2021-04-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34596", "3450", "fld_2572136", "description_of_work_completed", "Restrict Access to hr@eandtelectric.com (dist group) to Tony and HR admin only\r\n(request per Tony)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34597", "3450", "fld_5994139", "billing_notes", "Tony asked hr@ email access be restricted to he and the HR administrator only\r\nresolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34598", "3450", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34599", "3450", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34600", "3451", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34601", "3451", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34602", "3451", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34603", "3451", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34604", "3451", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34605", "3451", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34606", "3451", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34607", "3451", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34608", "3451", "fld_2572136", "description_of_work_completed", "Witwer law Sonicwall DDOS attacked overnight 4-22\r\n2.5 hours locking down and adjusting alerts to monitor more closely\r\n(alerts used 100% of smtp outbound on smtp2go so moved to different account)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34609", "3451", "fld_5994139", "billing_notes", "DDOS attack on WL sonicwall(midnight-8:00AM 4-22)  Analysis, mitigation and monitoring\r\nresolved\r\n\r\nNOTE - this attack was why our SMTP2GO quota was reached at 05:00AM on 4-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34610", "3451", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34611", "3451", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34612", "3452", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34613", "3452", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34614", "3452", "fld_165241", "date_of_work", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34615", "3452", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34616", "3452", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34617", "3452", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34618", "3452", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34619", "3452", "fld_291750", "date_completed", "2021-04-22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34620", "3452", "fld_2572136", "description_of_work_completed", "Troubleshoot Scnning issues ATC AL\r\nMicrosoft Outage affecting Scan-to-email\r\nresolved 12:00PM 4-22\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34621", "3452", "fld_5994139", "billing_notes", "Users in AL report scan to email difficulty\r\nMicrosoft in partial outage\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34622", "3452", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34623", "3452", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34624", "3453", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34625", "3453", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34626", "3453", "fld_165241", "date_of_work", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34627", "3453", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34628", "3453", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34629", "3453", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34630", "3453", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34631", "3453", "fld_291750", "date_completed", "2021-04-23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34632", "3453", "fld_2572136", "description_of_work_completed", "Whitelist Prinicpal Financial Group emails (per Lisa)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34633", "3453", "fld_5994139", "billing_notes", "Lisa CLay requested whitelist of Principal Financial Group domains and servers for emails.\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34634", "3453", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34635", "3453", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34636", "3454", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34637", "3454", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34638", "3454", "fld_165241", "date_of_work", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34639", "3454", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34640", "3454", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34641", "3454", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34642", "3454", "fld_20888", "name_of_client", "EVLT / Jeffrey Boring");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34643", "3454", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34644", "3454", "fld_291750", "date_completed", "2021-04-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34645", "3454", "fld_2572136", "description_of_work_completed", "Disable VPN / remote access for Kenzie (per Jeffrey)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34646", "3454", "fld_5994139", "billing_notes", "Disable VPN access for Kenzie (per Jeffrey Boring)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34647", "3454", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34648", "3454", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34649", "3455", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34650", "3455", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34651", "3455", "fld_165241", "date_of_work", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34652", "3455", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34653", "3455", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34654", "3455", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34655", "3455", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34656", "3455", "fld_291750", "date_completed", "2021-04-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34657", "3455", "fld_2572136", "description_of_work_completed", "Se up new employee & PC - Greta Sutter Project Manager Pell City AL\r\nOffice 365 - gsutter@advancetank.com\r\nAD ATgsutter (ATCpellNew!@)\r\nnew PC setup + OS updates + AD setup\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34658", "3455", "fld_5994139", "billing_notes", "New ATC employee AL - Greta Sutter\r\n(request from Lisa Clay)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34659", "3455", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34660", "3455", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34661", "3455", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34662", "3455", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34663", "3455", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34664", "3456", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34665", "3456", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34666", "3456", "fld_165241", "date_of_work", "2021-04-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34667", "3456", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34668", "3456", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34669", "3456", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34670", "3456", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34671", "3456", "fld_291750", "date_completed", "2021-04-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34672", "3456", "fld_2572136", "description_of_work_completed", "ATC Wellington getting new Printer-\r\nassign static IP (192.168.10.250) exclude IP from DHCP\r\nprovide IP info for printer install tech to CBeitz\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34673", "3456", "fld_5994139", "billing_notes", "new printer for ATC, CO network setup assistance\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34674", "3456", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34675", "3456", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34676", "3457", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34677", "3457", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34678", "3457", "fld_165241", "date_of_work", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34679", "3457", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34680", "3457", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34681", "3457", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34682", "3457", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34683", "3457", "fld_291750", "date_completed", "2021-04-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34684", "3457", "fld_2572136", "description_of_work_completed", "ATC Viewpoint Vista Install for J Turner LT\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34685", "3457", "fld_5994139", "billing_notes", "Vista Install for ATC J Turner laptop\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34686", "3457", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34687", "3457", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34688", "3458", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34689", "3458", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34690", "3458", "fld_165241", "date_of_work", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34691", "3458", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34692", "3458", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34693", "3458", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34694", "3458", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34695", "3458", "fld_291750", "date_completed", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34696", "3458", "fld_2572136", "description_of_work_completed", "RPT Nick Anton SPAM filter assistance\r\n(whitelist address and show user how to manage quarantine)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34697", "3458", "fld_5994139", "billing_notes", "RPT - SPAM filtering assistance, Nick Anton\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34698", "3458", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34699", "3458", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34700", "3459", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34701", "3459", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34702", "3459", "fld_165241", "date_of_work", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34703", "3459", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34704", "3459", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34705", "3459", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34706", "3459", "fld_20888", "name_of_client", "KEM Homes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34707", "3459", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34708", "3459", "fld_291750", "date_completed", "2021-04-29");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34709", "3459", "fld_2572136", "description_of_work_completed", "SPAM filtering - Assist Cindy O\\\'Neill with whitelisting blocked address \r\n       summitstonehealth.org\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34710", "3459", "fld_5994139", "billing_notes", "SPAM filter assistance Cindy O\\\'Neill\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34711", "3459", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34712", "3459", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34713", "3460", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34714", "3460", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34715", "3460", "fld_165241", "date_of_work", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34716", "3460", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34717", "3460", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34718", "3460", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34719", "3460", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34720", "3460", "fld_291750", "date_completed", "2021-04-30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34721", "3460", "fld_2572136", "description_of_work_completed", "ATC - Turn off Cell forwarding in 3CX for Mindi Walker(ext 2019)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34722", "3460", "fld_5994139", "billing_notes", "ATC CO 3CX switch to voicemail from \\\'forward to mobile\\\' \r\next 2019 Mindi Walker\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34723", "3460", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34724", "3460", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34725", "3461", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34726", "3461", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34727", "3461", "fld_165241", "date_of_work", "2021-05-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34728", "3461", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34729", "3461", "fld_7309777", "minutes_spent", "6");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34730", "3461", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34731", "3461", "fld_20888", "name_of_client", "Jane Clevenger");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34732", "3461", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34733", "3461", "fld_291750", "date_completed", "2021-05-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34734", "3461", "fld_2572136", "description_of_work_completed", "Added another Gmail account to google.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34735", "3461", "fld_5994139", "billing_notes", "completed ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34736", "3461", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34737", "3461", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34738", "3462", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34739", "3462", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34740", "3462", "fld_165241", "date_of_work", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34741", "3462", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34742", "3462", "fld_7309777", "minutes_spent", "38");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34743", "3462", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34744", "3462", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34745", "3462", "fld_291750", "date_completed", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34746", "3462", "fld_2572136", "description_of_work_completed", "Setup printer on Pam Mitchum and Sam Stetina\\\'s computers.\r\nFixed configuration with Scan to email, changed port to 465, and email to scans@advancetank.com\r\nUpdated password for scans email.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34747", "3462", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34748", "3462", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34749", "3462", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34750", "3463", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34751", "3463", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34752", "3463", "fld_165241", "date_of_work", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34753", "3463", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34754", "3463", "fld_7309777", "minutes_spent", "26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34755", "3463", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34756", "3463", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34757", "3463", "fld_2572136", "description_of_work_completed", "troubleshooting brother printer in back office computer\r\n-toner light keeps coming on\r\n  -replaced toner");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34758", "3463", "fld_5994139", "billing_notes", "not completed \r\ncall dropped I  a voicemail and waiting for a callback\r\n\r\nThey are also not using the correct toner.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34759", "3463", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34760", "3463", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34761", "3464", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34762", "3464", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34763", "3464", "fld_165241", "date_of_work", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34764", "3464", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34765", "3464", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34766", "3464", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34767", "3464", "fld_20888", "name_of_client", "Trish Phetteplace");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34768", "3464", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34769", "3464", "fld_291750", "date_completed", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34770", "3464", "fld_2572136", "description_of_work_completed", "Renewed Vipre subscription, did not perform light clean up.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34771", "3464", "fld_5994139", "billing_notes", "Vipre Key: 422DC-MTPR7-FK44U-FY7QS-ZLKDQ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34772", "3464", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34773", "3464", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34774", "3464", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34775", "3464", "fld_8555975", "license___", "422DC-MTPR7-FK44U-FY7QS-ZLKDQ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34776", "3464", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34777", "3464", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34778", "3465", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34779", "3465", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34780", "3465", "fld_165241", "date_of_work", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34781", "3465", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34782", "3465", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34783", "3465", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34784", "3465", "fld_20888", "name_of_client", "Madison Casey / 970-593-2028");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34785", "3465", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34786", "3465", "fld_291750", "date_completed", "2021-05-04");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34787", "3465", "fld_2572136", "description_of_work_completed", "Renewed Vipre, did not perform light cleanup");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34788", "3465", "fld_5994139", "billing_notes", "Vipre: 422DC-MTPR7-FK44U-FY7QS-ZLKDQ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34789", "3465", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34790", "3465", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34791", "3465", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34792", "3465", "fld_8555975", "license___", "422DC-MTPR7-FK44U-FY7QS-ZLKDQ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34793", "3465", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34794", "3465", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34795", "3466", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34796", "3466", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34797", "3466", "fld_165241", "date_of_work", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34798", "3466", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34799", "3466", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34800", "3466", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34801", "3466", "fld_20888", "name_of_client", "Jean Cory");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34802", "3466", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34803", "3466", "fld_291750", "date_completed", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34804", "3466", "fld_2572136", "description_of_work_completed", "Jean called regarding issues with her email.\r\nOutlook was unable to send any emails, connection to server disrupted.\r\nChanged SMTP outgoing port to 587, testing connection and confirmed emails were now sending and receiving.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34805", "3466", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34806", "3466", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34807", "3466", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34808", "3467", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34809", "3467", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34810", "3467", "fld_165241", "date_of_work", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34811", "3467", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34812", "3467", "fld_7309777", "minutes_spent", "26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34813", "3467", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34814", "3467", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34815", "3467", "fld_291750", "date_completed", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34816", "3467", "fld_2572136", "description_of_work_completed", "UNIFI Updates\r\n-WAP\\\'s\r\n-Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34817", "3467", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34818", "3467", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34819", "3467", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34820", "3468", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34821", "3468", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34822", "3468", "fld_165241", "date_of_work", "2021-05-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34823", "3468", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34824", "3468", "fld_7309777", "minutes_spent", "22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34825", "3468", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34826", "3468", "fld_20888", "name_of_client", "Dennis Knoop");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34827", "3468", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34828", "3468", "fld_291750", "date_completed", "2021-05-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34829", "3468", "fld_2572136", "description_of_work_completed", "renewed Vipre\r\n\r\nSetup IMAP Gmail account\r\n-enabled 2FA\r\n-Generated custom APP PW for outlook");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34830", "3468", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34831", "3468", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34832", "3468", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34833", "3468", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34834", "3468", "fld_8555975", "license___", "422D7-QRQTD-YHTCZ-JYKM4-NGNWN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34835", "3468", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34836", "3468", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34837", "3469", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34838", "3469", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34839", "3469", "fld_165241", "date_of_work", "2021-05-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34840", "3469", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34841", "3469", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34842", "3469", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34843", "3469", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34844", "3469", "fld_291750", "date_completed", "2021-05-03");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34845", "3469", "fld_2572136", "description_of_work_completed", "Troubleshoot Viewpoint Vista access for Greta Sutter (new) 90 minutes\r\nerror when logging on - password expired.\r\nactual issue - Viewpoint vista uses case sensitive user names (mismatch between Vista and AD)\r\nconvert Viewpoint username to lower case\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34846", "3469", "fld_5994139", "billing_notes", "Viewpoint Vista issue new employee\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34847", "3469", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34848", "3469", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34849", "3470", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34850", "3470", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34851", "3470", "fld_165241", "date_of_work", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34852", "3470", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34853", "3470", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34854", "3470", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34855", "3470", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34856", "3470", "fld_291750", "date_completed", "2021-05-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34857", "3470", "fld_2572136", "description_of_work_completed", "Set up 2 users / PCs for E&T Electric-\r\nreenable Brian Rieman AD account and email and set up on PC\r\nadd new user Justin Mowery and set up on PC\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34858", "3470", "fld_5994139", "billing_notes", " users / PCs setup\r\nBrian Rieman\r\nJustin Mowery\r\nresolved\r\n\r\nNote - E&T already had 1 available license so we only added 1 for Justin Mowery");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34859", "3470", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34860", "3470", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34861", "3470", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34862", "3470", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34863", "3470", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34864", "3471", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34865", "3471", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34866", "3471", "fld_165241", "date_of_work", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34867", "3471", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34868", "3471", "fld_7309777", "minutes_spent", "105");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34869", "3471", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34870", "3471", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34871", "3471", "fld_291750", "date_completed", "2021-05-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34872", "3471", "fld_2572136", "description_of_work_completed", "New SPAM/PHISHING campaign sneaking past Barracuda using - \r\nstolen creds + malicious Adobe Spark pages + malicious website\r\n(Fake Adobe cloud login)\r\nblock inbound messages +\r\ninform IT admin of \\\'tacticalsafetysolutions.com\\\' of account breach. (SPAM coming from them)\r\nreport  abuse to Adobe + Godaddy + Microsoft + Barracuda\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34873", "3471", "fld_5994139", "billing_notes", "Advanced PHISHING campaign sneking past barracuda.\r\nreport to relevant service providers and figure out how to block\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34874", "3471", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34875", "3471", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34876", "3472", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34877", "3472", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34878", "3472", "fld_165241", "date_of_work", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34879", "3472", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34880", "3472", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34881", "3472", "fld_8427909", "client_or_company", "24 Hour Sign Language / 888-811-2424 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34882", "3472", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34883", "3472", "fld_291750", "date_completed", "2021-05-05");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34884", "3472", "fld_2572136", "description_of_work_completed", "Check for improperly blocked emails (confirmation messages) reported by KT\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34885", "3472", "fld_5994139", "billing_notes", "SPAM quarantine release\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34886", "3472", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34887", "3472", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34888", "3473", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34889", "3473", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34890", "3473", "fld_165241", "date_of_work", "2021-05-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34891", "3473", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34892", "3473", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34893", "3473", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34894", "3473", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34895", "3473", "fld_291750", "date_completed", "2021-05-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34896", "3473", "fld_2572136", "description_of_work_completed", "Microsoft Dynamics NAV install for RPT 121 (Andrew Burns)\r\n(2 attempts to succeed + reboot in-between)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34897", "3473", "fld_5994139", "billing_notes", "Microsoft Dynamics NAV install\r\n(request from RLH)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34898", "3473", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34899", "3473", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34900", "3474", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34901", "3474", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34902", "3474", "fld_165241", "date_of_work", "2021-05-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34903", "3474", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34904", "3474", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34905", "3474", "fld_8427909", "client_or_company", "Jim Welker / 970-663-1703");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34906", "3474", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34907", "3474", "fld_291750", "date_completed", "2021-05-06");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34908", "3474", "fld_2572136", "description_of_work_completed", "Onsite Corkat troubleshoot no connection for UCC Windows servers - 1 hour\r\nserver locked up reboot + chkdsk + dism\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34909", "3474", "fld_5994139", "billing_notes", "Onsite, server locked up (UCC Corkat)\r\nrebooted and checked disk (OK)\r\nstill investigating root cause\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34910", "3474", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34911", "3474", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34912", "3475", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34913", "3475", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34914", "3475", "fld_165241", "date_of_work", "2021-05-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34915", "3475", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34916", "3475", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34917", "3475", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34918", "3475", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34919", "3475", "fld_291750", "date_completed", "2021-05-07");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34920", "3475", "fld_2572136", "description_of_work_completed", "User Name Change Carol VanBeber to Carol Templeman\r\nchange user names + display names in AD and office 365\r\nresetup accounts on PC + upgrade PC to Windows 20H2\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34921", "3475", "fld_5994139", "billing_notes", "User name change\r\nCarol VanBeber -> Carol Templeman\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34922", "3475", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34923", "3475", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34924", "3476", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34925", "3476", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34926", "3476", "fld_165241", "date_of_work", "2021-05-08");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34927", "3476", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34928", "3476", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34929", "3476", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34930", "3476", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34931", "3476", "fld_291750", "date_completed", "2021-05-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34932", "3476", "fld_2572136", "description_of_work_completed", "Monthly Maintenance on servers + troubleshoot Firewall alert\r\nTroubleshoot FIrewall alert - packets being dropped between physical server & VM\r\n(failed Windows update on physical + reboots pending for both)\r\nreboot both servers + reapply failed update, then apply all pending updates\r\nupdate Vipre Keys for both Physical & VM\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34933", "3476", "fld_5994139", "billing_notes", "OS update + reboots + Vipre Keys on 2x servers\r\n(plus troubleshoot weird firewall alert)\r\n\r\nNote - Physical server took 6 hours to reboot because it had to revert the failed update. Situation was not fully resolved until Sunday 10:00 AM\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34934", "3476", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34935", "3476", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34936", "3476", "fld_2945103", "vipre_subs", "2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34937", "3476", "fld_6682710", "license_1_", "422D7-QRQTD-YHTCZ-JYKM4-NGNWN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34938", "3476", "fld_2368984", "license_2_", "422D7-QRQTD-YHTCZ-JYKM4-NGNWN");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34939", "3476", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34940", "3476", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34941", "3477", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34942", "3477", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34943", "3477", "fld_165241", "date_of_work", "2021-05-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34944", "3477", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34945", "3477", "fld_7309777", "minutes_spent", "240");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34946", "3477", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34947", "3477", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34948", "3477", "fld_291750", "date_completed", "2021-05-09");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34949", "3477", "fld_2572136", "description_of_work_completed", "4 hours - Manual update of files for Microsoft Dynamics NAV client\r\n(request from RL Hudson) \r\nneeds to be completed on 5-9-2021 to time with server switchover \r\nalso apply pending OS updates / reboots prior to update\r\ncompleted on 31 workstations\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34950", "3477", "fld_5994139", "billing_notes", "NAV upgrade (RL Hudson request)\r\ncompleted to match server switchover on 5-9-2021\r\nresolved\r\n\r\nNOTE - This 4 hours is overtime ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34951", "3477", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34952", "3477", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34953", "3478", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34954", "3478", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34955", "3478", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34956", "3478", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34957", "3478", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34958", "3478", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34959", "3478", "fld_20888", "name_of_client", "Susan Kreutzer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34960", "3478", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34961", "3478", "fld_291750", "date_completed", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34962", "3478", "fld_2572136", "description_of_work_completed", "Renewed and updated Vipre");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34963", "3478", "fld_5994139", "billing_notes", "Vipre Key: 422D6-TLDXP-RARDF-R72RB-YQBSS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34964", "3478", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34965", "3478", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34966", "3478", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34967", "3478", "fld_8555975", "license___", "422D6-TLDXP-RARDF-R72RB-YQBSS");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34968", "3478", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34969", "3478", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34970", "3479", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34971", "3479", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34972", "3479", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34973", "3479", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34974", "3479", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34975", "3479", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34976", "3479", "fld_20888", "name_of_client", "Mary Lou Wiggins  970-744-0960");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34977", "3479", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34978", "3479", "fld_291750", "date_completed", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34979", "3479", "fld_2572136", "description_of_work_completed", "Mary had her password reset this morning by Dylan, due to password requirements.\r\nGreg assisted Mary with updating her password on her phone and Kindle.\r\nSet app password for Kindle, stored in setup info on Mary\\\'s computer.\r\nMicrosoft Authenticator app working as expected.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34980", "3479", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34981", "3479", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34982", "3479", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34983", "3480", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34984", "3480", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34985", "3480", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34986", "3480", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34987", "3480", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34988", "3480", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34989", "3480", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34990", "3480", "fld_291750", "date_completed", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34991", "3480", "fld_2572136", "description_of_work_completed", "RPT Microsoft Dynamics NAV upgrade - catch PCs that were off - 1 hour\r\nupadte NAV 4x PCs - RPT110, RPT125, RPT158, RPT-SURFACE\r\nWindows Updates & light cleanup RPT-SURFACE\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34992", "3480", "fld_5994139", "billing_notes", "RPT NAV upgrade on 4x PCs off during the weekend\r\n+ Windows updates & cleanup on RPT-SURFACE\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34993", "3480", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34994", "3480", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34995", "3481", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34996", "3481", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34997", "3481", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34998", "3481", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("34999", "3481", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35000", "3481", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35001", "3481", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35002", "3481", "fld_291750", "date_completed", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35003", "3481", "fld_2572136", "description_of_work_completed", "Adjust SPAM filters to block content (per Candy B)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35004", "3481", "fld_5994139", "billing_notes", "SPAM filter block request\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35005", "3481", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35006", "3481", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35007", "3482", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35008", "3482", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35009", "3482", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35010", "3482", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35011", "3482", "fld_7309777", "minutes_spent", "46");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35012", "3482", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35013", "3482", "fld_20888", "name_of_client", "frank grabenstatter");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35014", "3482", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35015", "3482", "fld_291750", "date_completed", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35016", "3482", "fld_2572136", "description_of_work_completed", "installed iCloud on laptop \r\nfixed syncing issues from iPhone to laptop \r\nconfigured iPhone to sync photos to computer wirelessly\r\ntested internet speed\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35017", "3482", "fld_5994139", "billing_notes", "my little help customer\r\n\r\n\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35018", "3482", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35019", "3482", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35020", "3483", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35021", "3483", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35022", "3483", "fld_165241", "date_of_work", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35023", "3483", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35024", "3483", "fld_7309777", "minutes_spent", "18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35025", "3483", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35026", "3483", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35027", "3483", "fld_291750", "date_completed", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35028", "3483", "fld_2572136", "description_of_work_completed", "Reset password for Sabrina\\\'s gmail account.\r\nAssisted her in entering password on desktop, laptop, and tablet.\r\nShowed Sabrina how to access google drive on desktop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35029", "3483", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35030", "3483", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35031", "3483", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35032", "3484", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35033", "3484", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35034", "3484", "fld_165241", "date_of_work", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35035", "3484", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35036", "3484", "fld_7309777", "minutes_spent", "90");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35037", "3484", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35038", "3484", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35039", "3484", "fld_291750", "date_completed", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35040", "3484", "fld_2572136", "description_of_work_completed", "Installed 5 port network switch between Cathy\\\'s wall outlet and her computer.\r\nConnected Cathy\\\'s printer to the 5 port network switch.\r\nRe-added Cathy\\\'s printer to the Server.\r\nAdded Cathy\\\'s printer Cathy\\\'s computer again. Confirmed print functionality.\r\nRan HDD scan on Janae\\\'s computer, Cathy\\\'s computer, and Courtney\\\'s computer.\r\nJanae and Cathy need a HDD replacement.\r\nCourtney needs a new computer as she is unable to complete work on the current setup.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35041", "3484", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35042", "3484", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35043", "3484", "fld_2864175", "part1_description", "5 Port TP Link Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35044", "3484", "fld_8478853", "cost_of_part_1", "15.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35045", "3484", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35046", "3485", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35047", "3485", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35048", "3485", "fld_165241", "date_of_work", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35049", "3485", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35050", "3485", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35051", "3485", "fld_8427909", "client_or_company", "NORCO Volleyball / 970-667-5005");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35052", "3485", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35053", "3485", "fld_291750", "date_completed", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35054", "3485", "fld_2572136", "description_of_work_completed", "Repaired Mary\\\'s Turbotax 2020 installation. Would not complete update.\r\nChanged Intuit Update service to manual start from delayed start.\r\nRestarted computer, manually started update service, confirmed that Turbotax successfully updated and opened.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35055", "3485", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35056", "3485", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35057", "3485", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35058", "3486", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35059", "3486", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35060", "3486", "fld_165241", "date_of_work", "2021-05-10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35061", "3486", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35062", "3486", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35063", "3486", "fld_8427909", "client_or_company", "Rocky Mountain Gateway / 970-577-0043 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35064", "3486", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35065", "3486", "fld_291750", "date_completed", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35066", "3486", "fld_2572136", "description_of_work_completed", "Troubleshoot and verify SSL installation. Installed TXT record into DNS. Installed and configured SSL plugin in WordPress.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35067", "3486", "fld_5994139", "billing_notes", "Work is complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35068", "3486", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35069", "3486", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35070", "3487", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35071", "3487", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35072", "3487", "fld_165241", "date_of_work", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35073", "3487", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35074", "3487", "fld_7309777", "minutes_spent", "8");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35075", "3487", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35076", "3487", "fld_20888", "name_of_client", "Sue Kreutzer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35077", "3487", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35078", "3487", "fld_291750", "date_completed", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35079", "3487", "fld_2572136", "description_of_work_completed", "disabled pops up for phishing websites  on google.\r\nStarted a vipre full scan.\r\nanswered tech questions about phishing and how vipre works.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35080", "3487", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35081", "3487", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35082", "3487", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35083", "3488", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35084", "3488", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35085", "3488", "fld_165241", "date_of_work", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35086", "3488", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35087", "3488", "fld_7309777", "minutes_spent", "23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35088", "3488", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35089", "3488", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35090", "3488", "fld_291750", "date_completed", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35091", "3488", "fld_2572136", "description_of_work_completed", "Updated Unifi Devices\r\n-WAP\\\'s \r\n-Switch\\\'s");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35092", "3488", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35093", "3488", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35094", "3488", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35095", "3489", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35096", "3489", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35097", "3489", "fld_165241", "date_of_work", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35098", "3489", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35099", "3489", "fld_7309777", "minutes_spent", "420");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35100", "3489", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35101", "3489", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35102", "3489", "fld_291750", "date_completed", "2021-05-12");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35103", "3489", "fld_2572136", "description_of_work_completed", "Transferred shared files from Jim\\\'s old file-share onto the new file-share.\r\nRemoved old file-share from network and brought back to office for decommissioning.\r\nMapped network drives to Jim\\\'s File-Share on Front Desk computer (New), Sabrina\\\'s desktop and Pam\\\'s LT.\r\nConfigured Canon printer on Sabrina\\\'s desktop and Front Desk computer.\r\nConfigured Label printer on Sabrina\\\'s desktop.\r\nFixed HPEC Logo picture on flower labels (188 labels)\r\n\r\nInstalled 5 port switch by Sabrina\\\'s desktop to facilitate connectivity between her computer, the label printer, and any other devices they wish to add.\r\n\r\nInstalled Cloud Key device in \\\"network room\\\". Migrated Unifi Controller off of Jim\\\'s computer and onto cloud key.\r\n\r\nInstalled new Unifi AP into the Barn due to previous access point being end of life and no longer functional.\r\nNew AP updated, adopted and configured.\r\n\r\nChanged subnet of HPEC network to 192.168.10.1/24. Will make enabling any remote access easier for future work.\r\n\r\nInstalled new ION desktop bundle into front desk area.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35104", "3489", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35105", "3489", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35106", "3489", "fld_3920513", "do_you_have_more_than_3_parts.opt1307829", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35107", "3489", "fld_3920513", "do_you_have_more_than_3_parts", "{\"opt1307829\":1}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35108", "3489", "fld_2864175", "part1_description", "5 Port TP Link Switch");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35109", "3489", "fld_9190675", "part_2_description", "Unifi Cloud Key");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35110", "3489", "fld_8951874", "part_3_description", "Unifi Access Point Lite");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35111", "3489", "fld_1621742", "part_4_description", "ION Bundle");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35112", "3489", "fld_5404555", "part_5_description", "27\\\" Monitor");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35113", "3489", "fld_8478853", "cost_of_part_1", "15.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35114", "3489", "fld_592520", "cost_of_part_2", "149.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35115", "3489", "fld_5448517", "cost_of_part_3", "99.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35116", "3489", "fld_9182980", "cost_of_part_4", "1249.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35117", "3489", "fld_8336117", "cost_of_part_5", "Andy?");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35118", "3489", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35119", "3490", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35120", "3490", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35121", "3490", "fld_165241", "date_of_work", "2021-05-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35122", "3490", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35123", "3490", "fld_7309777", "minutes_spent", "6");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35124", "3490", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35125", "3490", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35126", "3490", "fld_291750", "date_completed", "2021-05-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35127", "3490", "fld_2572136", "description_of_work_completed", "Address book wasn\\\'t showing contacts\r\n\r\nchecked the show contacts as address book in outlook settings.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35128", "3490", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35129", "3490", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35130", "3490", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35131", "3491", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35132", "3491", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35133", "3491", "fld_165241", "date_of_work", "2021-05-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35134", "3491", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35135", "3491", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35136", "3491", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35137", "3491", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35138", "3491", "fld_291750", "date_completed", "2021-05-13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35139", "3491", "fld_2572136", "description_of_work_completed", "Created Volunteer User account with limited privileges and no access to the File-Share.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35140", "3491", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35141", "3491", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35142", "3491", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35143", "3492", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35144", "3492", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35145", "3492", "fld_165241", "date_of_work", "2021-05-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35146", "3492", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35147", "3492", "fld_7309777", "minutes_spent", "38");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35148", "3492", "fld_8427909", "client_or_company", "MAC Electric / 970-669-2464");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35149", "3492", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35150", "3492", "fld_291750", "date_completed", "2021-05-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35151", "3492", "fld_2572136", "description_of_work_completed", "deployed HDMI plug in 3cx server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35152", "3492", "fld_5994139", "billing_notes", "completed ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35153", "3492", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35154", "3492", "fld_2864175", "part1_description", "HDMI plug adapter");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35155", "3492", "fld_8478853", "cost_of_part_1", "3.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35156", "3492", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35157", "3493", "fld_8151635", "technician.opt1818302", "Andy Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35158", "3493", "fld_8151635", "technician", "{\"opt1818302\":\"Andy Pizer\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35159", "3493", "fld_165241", "date_of_work", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35160", "3493", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35161", "3493", "fld_7309777", "minutes_spent", "480");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35162", "3493", "fld_8427909", "client_or_company", "Ashcroft Kennels / 970-221-5689");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35163", "3493", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35164", "3493", "fld_291750", "date_completed", "2021-05-11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35165", "3493", "fld_2572136", "description_of_work_completed", "Drew Pizer\r\n- Removed all equipment from the Utility wall\r\n- Installed 12U Rack on wall\r\n- Installed shelving top & Bottom\r\n- Installed all electronic equipment into the rack\r\n- Installed 3CX Server\r\n- Installed SFP RJ45 Module\r\n- Mechanically grounded all equipment to Ground Wire\r\n- Installed 1500W UPS surge protector (50 min.)\r\n- Replaced Ceiling WAP in office / Warranty\r\n- Replaced USG / Warranty\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35166", "3493", "fld_5994139", "billing_notes", "Andy Pizer / Drew Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35167", "3493", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35168", "3493", "fld_2864175", "part1_description", "12U Wall Rack");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35169", "3493", "fld_9190675", "part_2_description", "2 - SFP RJ45 Module");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35170", "3493", "fld_8951874", "part_3_description", "1500W UPS surge protector");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35171", "3493", "fld_8478853", "cost_of_part_1", "$132.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35172", "3493", "fld_592520", "cost_of_part_2", "$21.00 each (2)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35173", "3493", "fld_5448517", "cost_of_part_3", "$219.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35174", "3493", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35175", "3494", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35176", "3494", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35177", "3494", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35178", "3494", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35179", "3494", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35180", "3494", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35181", "3494", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35182", "3494", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35183", "3494", "fld_2572136", "description_of_work_completed", "Assisted Joyce in opening up her Company files on Quickbooks after updating Quickbooks to 2021.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35184", "3494", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35185", "3494", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35186", "3494", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35187", "3495", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35188", "3495", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35189", "3495", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35190", "3495", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35191", "3495", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35192", "3495", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35193", "3495", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35194", "3495", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35195", "3495", "fld_2572136", "description_of_work_completed", "Removed VMware program that was preventing Windows 10 from updating properly.\r\n\r\nSent computer through reboot to finish update.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35196", "3495", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35197", "3495", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35198", "3495", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35199", "3496", "fld_8151635", "technician.opt1272247", "Kenny Schmitt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35200", "3496", "fld_8151635", "technician", "{\"opt1272247\":\"Kenny Schmitt\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35201", "3496", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35202", "3496", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35203", "3496", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35204", "3496", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35205", "3496", "fld_20888", "name_of_client", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35206", "3496", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35207", "3496", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35208", "3496", "fld_2572136", "description_of_work_completed", "TEST");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35209", "3496", "fld_5994139", "billing_notes", "TEST ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35210", "3496", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35211", "3496", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35212", "3497", "fld_8151635", "technician.opt1272247", "Kenny Schmitt");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35213", "3497", "fld_8151635", "technician", "{\"opt1272247\":\"Kenny Schmitt\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35214", "3497", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35215", "3497", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35216", "3497", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35217", "3497", "fld_8427909", "client_or_company", " Jeanna Cavanagh / 970-556-2588");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35218", "3497", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35219", "3497", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35220", "3497", "fld_2572136", "description_of_work_completed", "Update to vipre security ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35221", "3497", "fld_5994139", "billing_notes", "N/A");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35222", "3497", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35223", "3497", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35224", "3497", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35225", "3497", "fld_8555975", "license___", "422KW-PYGEV-P7KV6-3QU64-JDJMU");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35226", "3497", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35227", "3497", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35228", "3498", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35229", "3498", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35230", "3498", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35231", "3498", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35232", "3498", "fld_7309777", "minutes_spent", "630");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35233", "3498", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35234", "3498", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35235", "3498", "fld_2572136", "description_of_work_completed", " • 4k 30/60fps 30min raw video - exterior                                                                      1.00                   \r\n • 4k video with custom automation \\\"waypoints\\\" - exterior                                            1.00                \r\n • 4k video with custom automation \\\"orbit\\\" - exterior                                                     1.00   \r\n • 4k video with custom automation \\\"orbit\\\" - exterior                                                     1.00                 \r\n • 4k video with custom automation \\\"course lock\\\" - exterior                                          1.00                   \r\n • Travel - Less than 5mi, Operation setup & teardown \r\n    Pilot Research & Observation time                                                                                           \r\n    Data Transfer\r\n                                                  \r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35236", "3498", "fld_5994139", "billing_notes", "time in minutes just there to get close to actual amount relative to $135/hr. actual hours worked is more like 8 including all flying research and rendering.\r\n\r\ntotal amount billed should be $1,419.75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35237", "3498", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35238", "3498", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35239", "3499", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35240", "3499", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35241", "3499", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35242", "3499", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35243", "3499", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35244", "3499", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35245", "3499", "fld_20888", "name_of_client", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35246", "3499", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35247", "3499", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35248", "3499", "fld_2572136", "description_of_work_completed", "OFFICE: Configured new Unifi Security Gateway (USG) and Unifi Cloudkey v1 in preparation for installation on site at Corekat.\r\n-Setup VPN connections in Unifi USG (L2TP with PPTP as backup)\r\n\r\nONSITE: Removed old Sonicwall installation and disconnected Edgewaters router as it is no longer in use.\r\n-Installed USG and CKv1, confirmed connectivity was restored to server.\r\n\r\nREMOTE: Setup VPN connection on Elaine\\\'s computer, reconfigured RDS connection.\r\n-Setup VPN on Jim\\\'s computer, reconfigured RDS connection.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35249", "3499", "fld_5994139", "billing_notes", "Scheduled time with Pat Clark to setup VPN connection and reconfigure RDS connection.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35250", "3499", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35251", "3499", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35252", "3499", "fld_9190675", "part_2_description", "Unifi Cloud Key v1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35253", "3499", "fld_8478853", "cost_of_part_1", "139.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35254", "3499", "fld_592520", "cost_of_part_2", "149.99");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35255", "3499", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35256", "3500", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35257", "3500", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35258", "3500", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35259", "3500", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35260", "3500", "fld_7309777", "minutes_spent", "22");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35261", "3500", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35262", "3500", "fld_20888", "name_of_client", "Arlen Amundson");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35263", "3500", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35264", "3500", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35265", "3500", "fld_2572136", "description_of_work_completed", "Switched comcast email from POP3 to IMAP\r\nConfirmed settings and syncing on iPad & iPhone");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35266", "3500", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35267", "3500", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35268", "3500", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35269", "3501", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35270", "3501", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35271", "3501", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35272", "3501", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35273", "3501", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35274", "3501", "fld_8427909", "client_or_company", "High Plains Environmental / 970-622-9676 ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35275", "3501", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35276", "3501", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35277", "3501", "fld_2572136", "description_of_work_completed", "install spreadsheet to media library. Copy and submit link to client for use in E-Book.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35278", "3501", "fld_5994139", "billing_notes", "work is complete, but will have updated spreadsheets in the future.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35279", "3501", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35280", "3501", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35281", "3502", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35282", "3502", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35283", "3502", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35284", "3502", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35285", "3502", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35286", "3502", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35287", "3502", "fld_20888", "name_of_client", "Debra Casale");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35288", "3502", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35289", "3502", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35290", "3502", "fld_2572136", "description_of_work_completed", "Debra had issues connecting to her upwork application. She mentioned that she had just performed an update to her Malwarebytes VPN application.\r\n\r\nUnable to make connection complete when VPN is enabled. Connection is possible only when VPN is disabled but you can enable to the connection once logged into Upwork application.\r\n\r\nSetup and configured TeamViewer for easy access in the future.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35291", "3502", "fld_5994139", "billing_notes", "resolved\r\n\r\nDebra Casale\r\nfreelancesolutioncolorado@gmail.com\r\n970-644-6033\r\n2343 Bismarck Ave.\r\nLoveland, CO\r\n80538");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35292", "3502", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35293", "3502", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35294", "3503", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35295", "3503", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35296", "3503", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35297", "3503", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35298", "3503", "fld_7309777", "minutes_spent", "76");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35299", "3503", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35300", "3503", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35301", "3503", "fld_291750", "date_completed", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35302", "3503", "fld_2572136", "description_of_work_completed", "UNFI upgrades\r\n\r\nATC TX \r\n-updated Java\r\n-updated unifi controller software\r\n\r\nATC AL\r\n-updated cloud key \r\n-updated Unifi firmware\r\n- updated WAP\\\'s\r\n\r\nATC CO\r\n-updated cloud key \r\n-updated Unifi firmware\r\n-updated WAP\\\'s\r\n-updated switch\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35303", "3503", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35304", "3503", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35305", "3503", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35306", "3504", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35307", "3504", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35308", "3504", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35309", "3504", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35310", "3504", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35311", "3504", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35312", "3504", "fld_20888", "name_of_client", "UCC");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35313", "3504", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35314", "3504", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35315", "3504", "fld_2572136", "description_of_work_completed", "Setup VPN and configured RDS connection on Pat Clark\\\'s computer.\r\nUnable to test RDS connection as UCC server is offline, 8am (5.18.21)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35316", "3504", "fld_5994139", "billing_notes", "May need to reset Accounting user");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35317", "3504", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35318", "3504", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35319", "3505", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35320", "3505", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35321", "3505", "fld_165241", "date_of_work", "2021-05-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35322", "3505", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35323", "3505", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35324", "3505", "fld_8427909", "client_or_company", "Waxing the City (Lkwd) / 720-633-2446");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35325", "3505", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35326", "3505", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35327", "3505", "fld_2572136", "description_of_work_completed", "Received a report that one, or both, of the backroom computers\\\' monitors was not working.\r\nUninstalled the graphics drivers from both back computers.\r\nReinstalled graphics driver version 18, tested to confirm functionality but could not confirm if monitor was actually working.\r\nUpdated graphics to most recent driver version.\r\nAble to get Back 2 to have proper resolution but could not confirm detection of the monitor.\r\nBack 1 was able to detect a monitor but could not get resolution to 1440p.\r\nBack 2 has nvidia graphics drivers installed and they must be installed in order to hit max resolution.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35328", "3505", "fld_5994139", "billing_notes", "I suspect that Back 1 does not have the monitor plugged into the graphics card, or possibly that something has happened to the graphics card.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35329", "3505", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35330", "3505", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35331", "3506", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35332", "3506", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35333", "3506", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35334", "3506", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35335", "3506", "fld_7309777", "minutes_spent", "19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35336", "3506", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35337", "3506", "fld_20888", "name_of_client", "Sue Kreutzer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35338", "3506", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35339", "3506", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35340", "3506", "fld_2572136", "description_of_work_completed", "disabled Closed captions in google\r\nopened music in YouTube and made it loop \r\nconfirmed Vipre was renewed (11 months left)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35341", "3506", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35342", "3506", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35343", "3506", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35344", "3507", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35345", "3507", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35346", "3507", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35347", "3507", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35348", "3507", "fld_7309777", "minutes_spent", "23");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35349", "3507", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35350", "3507", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35351", "3507", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35352", "3507", "fld_2572136", "description_of_work_completed", "Unifi Upgrades\r\n-updated Unifi controller to version 6.1.71 on DC Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35353", "3507", "fld_5994139", "billing_notes", "Completed \r\n3 WAPS are EOL");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35354", "3507", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35355", "3507", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35356", "3508", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35357", "3508", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35358", "3508", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35359", "3508", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35360", "3508", "fld_7309777", "minutes_spent", "13");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35361", "3508", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35362", "3508", "fld_20888", "name_of_client", "Jane Bucknoc");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35363", "3508", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35364", "3508", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35365", "3508", "fld_2572136", "description_of_work_completed", "answered tech questions\r\nrecommended computer specs for new computer purchase.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35366", "3508", "fld_5994139", "billing_notes", "My little Help\r\nEmail: janeannBucknocwings@gmail.com");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35367", "3508", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35368", "3508", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35369", "3509", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35370", "3509", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35371", "3509", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35372", "3509", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35373", "3509", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35374", "3509", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35375", "3509", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35376", "3509", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35377", "3509", "fld_2572136", "description_of_work_completed", "Allison called about poor phone quality.\r\nRebooted 3CX server.\r\nRebooted Unifi USG after updating firmware.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35378", "3509", "fld_5994139", "billing_notes", "Unable to effectively test call quality as both our external and internal calls apparently had good quality, according to Allison.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35379", "3509", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35380", "3509", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35381", "3510", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35382", "3510", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35383", "3510", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35384", "3510", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35385", "3510", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35386", "3510", "fld_8427909", "client_or_company", "Kathy Keeler / 970-622-8883");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35387", "3510", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35388", "3510", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35389", "3510", "fld_2572136", "description_of_work_completed", "Retheme and basic formatting for awanderingbotanist.com ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35390", "3510", "fld_5994139", "billing_notes", "The website is now cleaned of all erroneous widgets, plugins, themes, and obsolete code. A new theme installed, and planning on training Kathy to edit with the new theme.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35391", "3510", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35392", "3510", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35393", "3511", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35394", "3511", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35395", "3511", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35396", "3511", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35397", "3511", "fld_7309777", "minutes_spent", "18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35398", "3511", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35399", "3511", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35400", "3511", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35401", "3511", "fld_2572136", "description_of_work_completed", "Unifi Upgrades\r\n-USG\r\n-WAP");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35402", "3511", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35403", "3511", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35404", "3511", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35405", "3512", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35406", "3512", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35407", "3512", "fld_165241", "date_of_work", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35408", "3512", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35409", "3512", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35410", "3512", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35411", "3512", "fld_20888", "name_of_client", "Evi and Paul Opler");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35412", "3512", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35413", "3512", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35414", "3512", "fld_2572136", "description_of_work_completed", "Remoted into Paul\\\'s laptop as he though he might have an infection going on.\r\nRan Malwarebytes and located 47 entries of Riskware.Injector malware. Quarantined all entries, checked for any further detections, checked for any suspicious tasks, checked for suspicious downloads or browser extensions.\r\n\r\nRemoted into Evi\\\'s laptop and ran Malwarebytes. Found 12 detections but they were low level detections, Chrome update disabler. Vipre had found, quarantined and deleted 2 Trojan entries, \\\"THIS COMPUTER IS LOCKED\\\" html. Unable to find any further detections on Evi\\\'s computer, nothing suspicious in task manager, task scheduler or in her downloads/browser.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35415", "3512", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35416", "3512", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35417", "3512", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35418", "3513", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35419", "3513", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35420", "3513", "fld_165241", "date_of_work", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35421", "3513", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35422", "3513", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35423", "3513", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35424", "3513", "fld_20888", "name_of_client", "Elaine Downey / Estes Park Museum");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35425", "3513", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35426", "3513", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35427", "3513", "fld_2572136", "description_of_work_completed", "Installed the Dymo Label v.8 program on Elaine\\\'s new laptop.\r\nUnable to open labels due to error.\r\nInstalled Net Framework 2.0 on Elaine\\\'s new laptop. (necessary to run label software)\r\nInstalled the Office 2010 tools on Elaine\\\'s new laptop. (necessary to run label software)\r\n\r\nVerified that labels can now open and that everything looks similar to Elaine\\\'s old laptop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35428", "3513", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35429", "3513", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35430", "3513", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35431", "3514", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35432", "3514", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35433", "3514", "fld_165241", "date_of_work", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35434", "3514", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35435", "3514", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35436", "3514", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35437", "3514", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35438", "3514", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35439", "3514", "fld_2572136", "description_of_work_completed", "Greg and Drew\r\nInstalled new HDMI cable in secondary conference room.\r\nInstalled new ethernet cable in secondary conference room.\r\nReinstalled floor wire covering and then tidied up cable connections.\r\nTested tabletop connection through HDMI and video connectivity could not be established.\r\nStraight through connection works just fine, Winston will be getting a different tabletop device for replacement.\r\nDiscussed running new lines into warehouse, 2 centrally located and 1 near the southern entrance.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35440", "3514", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35441", "3514", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35442", "3514", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35443", "3515", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35444", "3515", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35445", "3515", "fld_165241", "date_of_work", "2021-05-14");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35446", "3515", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35447", "3515", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35448", "3515", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35449", "3515", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35450", "3515", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35451", "3515", "fld_2572136", "description_of_work_completed", "Troubleshoot Sonicwall Alerts- \r\nIssue causes by ext 3Drive Rotation drives fillnig up.\r\n(backup requests thousands of files and aborts. \r\nSonicwall sees as DOS on TCP 445)\r\ndisable monthly Cobian to make space on HDDs\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35452", "3515", "fld_5994139", "billing_notes", "Sonicwall alerts investigate and resolve\r\n(caused by failing backups)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35453", "3515", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35454", "3515", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35455", "3516", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35456", "3516", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35457", "3516", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35458", "3516", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35459", "3516", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35460", "3516", "fld_8427909", "client_or_company", "Jim Welker / 970-663-1703");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35461", "3516", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35462", "3516", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35463", "3516", "fld_2572136", "description_of_work_completed", "UCC Corkat 2x visits 5-17 to 5-19\r\nVisit 1 - reboot Windows Server and troubleshoot hang (hardware related - \r\nmotherboard or PSU)\r\nVisit 2 reinstall PBX (hacked) and reset Edgewater router password\r\nProvide remote access creds to Dan Grable so he can try to re-attach PBX to SIP trunks\r\nongoing\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35464", "3516", "fld_5994139", "billing_notes", "2 visits Corkat related to PBX hacking of UCC\r\n\r\nThis tracker includes onsite visits ONLY\r\nRemote work for this issue will be on a separate tracker\r\n\r\nongoing");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35465", "3516", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35466", "3516", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35467", "3517", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35468", "3517", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35469", "3517", "fld_165241", "date_of_work", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35470", "3517", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35471", "3517", "fld_7309777", "minutes_spent", "390");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35472", "3517", "fld_8427909", "client_or_company", "Jim Welker / 970-663-1703");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35473", "3517", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35474", "3517", "fld_291750", "date_completed", "2021-05-19");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35475", "3517", "fld_2572136", "description_of_work_completed", "6.5 hours TOTAL UCC PBX server hacked\r\n1 hour - lock down Corkat UCC network to prevent further compromise.\r\n1.5 hours - Image hacked HDDs + analyze where hack occurred\r\n(likely due to FreePBX Web interface CVE - https://www.cvedetails.com/cve/CVE-2014-7235/)\r\n4 hours (OVERTIME / AFTERHOURS) Re-image server from backups\r\nserver is up but Dan Grable still needs to re-connect SIP trunks to provider\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35476", "3517", "fld_5994139", "billing_notes", "Server rebuild for UCC PBX (hacked)\r\n6.5 hours TOTAL\r\n4 hours of that was AFTER HOURS RATES / OVERTIME.\r\n\r\nNOTE - 2 hours Onsite time at Corkat is on a separate time tracker\r\n\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35477", "3517", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35478", "3517", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35479", "3518", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35480", "3518", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35481", "3518", "fld_165241", "date_of_work", "2021-05-17");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35482", "3518", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35483", "3518", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35484", "3518", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35485", "3518", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35486", "3518", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35487", "3518", "fld_2572136", "description_of_work_completed", "RPT Bldg 3 Cleanroom-PC updates + monitor issue\r\nCleanroom-PC failed Windows updates (way out of date)\r\nprobably was off for a while?\r\nManually update using Windows Update Assistant\r\nresolve driver issue preventing monitor from being detected\r\nresolved\r\n ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35488", "3518", "fld_5994139", "billing_notes", "Windows Update + monitor issue Cleanroom-PC \r\n(building 3)\r\nresolved\r\n\r\nNote - recommended to them they replace this PC it is VERY obsolete (1.4GHz CPU and 4GB RAM)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35489", "3518", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35490", "3518", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35491", "3519", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35492", "3519", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35493", "3519", "fld_165241", "date_of_work", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35494", "3519", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35495", "3519", "fld_7309777", "minutes_spent", "60");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35496", "3519", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35497", "3519", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35498", "3519", "fld_291750", "date_completed", "2021-05-18");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35499", "3519", "fld_2572136", "description_of_work_completed", "SPAM / PHISHing emails block by requst and report SPAM campaign to providers\r\nblock Office 365 credential theft campaign \r\nreport campaign to ISPs, registrars and providers (Godaddy, DigitalOcean, etc.)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35500", "3519", "fld_5994139", "billing_notes", "Mitigate PHISHING attacks focused on WOBG Law.\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35501", "3519", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35502", "3519", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35503", "3520", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35504", "3520", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35505", "3520", "fld_165241", "date_of_work", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35506", "3520", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35507", "3520", "fld_7309777", "minutes_spent", "50");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35508", "3520", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35509", "3520", "fld_20888", "name_of_client", "Andrea Hall");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35510", "3520", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35511", "3520", "fld_291750", "date_completed", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35512", "3520", "fld_2572136", "description_of_work_completed", "HP Scan feature was broken.\r\nUninstalled HP Laserjet m477 printer and software.\r\nManually reinstalled HP printer, then reinstalled HP software. Something in the reinstallation failed, HP scan still does not work.\r\nUninstalled Printer, uninstalled software, ran CCleaner and removed registry entries.\r\nReinstalled HP software and tested HP scan. Outlook would not open.\r\nForced Outlook to quit, restarted computer.\r\nHP scan now works, tested and confirmed.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35513", "3520", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35514", "3520", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35515", "3520", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35516", "3521", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35517", "3521", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35518", "3521", "fld_165241", "date_of_work", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35519", "3521", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35520", "3521", "fld_7309777", "minutes_spent", "50");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35521", "3521", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35522", "3521", "fld_20888", "name_of_client", "Mary Banken");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35523", "3521", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35524", "3521", "fld_291750", "date_completed", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35525", "3521", "fld_2572136", "description_of_work_completed", "Outlook would crashes when previewing emails in the reader pane. Outlook would also randomly crash when opening certain emails.\r\nRepaired Office, no success.\r\nReinstalled Office, no success.\r\nRecreated OST file, no success.\r\nRan SFC and DISM, repaired corrupted files.\r\nDisabled hardware acceleration. Issue seems to have been resolved.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35526", "3521", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35527", "3521", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35528", "3521", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35529", "3522", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35530", "3522", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35531", "3522", "fld_165241", "date_of_work", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35532", "3522", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35533", "3522", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35534", "3522", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35535", "3522", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35536", "3522", "fld_291750", "date_completed", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35537", "3522", "fld_2572136", "description_of_work_completed", "New computer setup for Megan Lott.\r\nCreated domain name and Office 365 account (basic license)\r\nAdded new desktop to domain.\r\nCompleted initial computer setup.\r\nActivated and configured Office 2019 (licensing@advancetank.com is email address associated)\r\nInstalled Vista.\r\nInstalled 3CX and configured 3CX extension for Megan (extension 3010)\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35538", "3522", "fld_5994139", "billing_notes", "Need chuck\\\'s assistance to complete Vista install");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35539", "3522", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35540", "3522", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35541", "3523", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35542", "3523", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35543", "3523", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35544", "3523", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35545", "3523", "fld_7309777", "minutes_spent", "16");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35546", "3523", "fld_8427909", "client_or_company", "Witwer Law / 970-352-3161");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35547", "3523", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35548", "3523", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35549", "3523", "fld_2572136", "description_of_work_completed", "Reinstalled google Chrome and added bookmarks.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35550", "3523", "fld_5994139", "billing_notes", "Completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35551", "3523", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35552", "3523", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35553", "3524", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35554", "3524", "fld_8151635", "technician.opt1352554", "Drew Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35555", "3524", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\",\"opt1352554\":\"Drew Pizer\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35556", "3524", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35557", "3524", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35558", "3524", "fld_7309777", "minutes_spent", "241");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35559", "3524", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35560", "3524", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35561", "3524", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35562", "3524", "fld_2572136", "description_of_work_completed", "Diagnostic on phone Server \r\n\r\nReplaced phone server\r\n-set static IP\r\n- Firewall Check\r\n- Windows updates\r\n- confirmed phones are working\r\n\r\nUnifi Updates\r\n -WAP\\\'s\r\n -USG\r\n -Switch\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35563", "3524", "fld_5994139", "billing_notes", "12:38-4:39\r\n\r\n3CX Dashboard needs to be installed\r\n\r\nTotal Time (hours) = 4.02 hours\r\nTotal Time (minutes) = 241 minutes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35564", "3524", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35565", "3524", "fld_2864175", "part1_description", "3CX Phone Server");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35566", "3524", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35567", "3525", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35568", "3525", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35569", "3525", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35570", "3525", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35571", "3525", "fld_7309777", "minutes_spent", "40");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35572", "3525", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35573", "3525", "fld_20888", "name_of_client", "Testing MG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35574", "3525", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35575", "3525", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35576", "3525", "fld_2572136", "description_of_work_completed", "This is to test the form");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35577", "3525", "fld_5994139", "billing_notes", "All to test the form");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35578", "3525", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35579", "3525", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35580", "3525", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35581", "3525", "fld_8555975", "license___", "12345678");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35582", "3525", "fld_7842020", "cylance_installed.opt1358823", "Cylance Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35583", "3525", "fld_7842020", "cylance_installed", "{\"opt1358823\":\"Cylance Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35584", "3525", "fld_39256", "subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35585", "3525", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35586", "3525", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35587", "3525", "fld_3664993", "office_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35588", "3525", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35589", "3525", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35590", "3525", "fld_4069791", "office_pro_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35591", "3525", "fld_1712261", "email_account_1c", "12356789");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35592", "3525", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35593", "3525", "fld_993747", "add_files_or_pictures", "https://it.milpond.com/wp-content/uploads/2021/05/white.jpg");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35594", "3525", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35595", "3526", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35596", "3526", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35597", "3526", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35598", "3526", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35599", "3526", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35600", "3526", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35601", "3526", "fld_20888", "name_of_client", "MG Test");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35602", "3526", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35603", "3526", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35604", "3526", "fld_2572136", "description_of_work_completed", "Testing the form");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35605", "3526", "fld_5994139", "billing_notes", "Another test of the form");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35606", "3526", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35607", "3526", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35608", "3526", "fld_2945103", "vipre_subs", "2");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35609", "3526", "fld_6682710", "license_1_", "353452345245");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35610", "3526", "fld_2368984", "license_2_", "32423423423423");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35611", "3526", "fld_7842020", "cylance_installed.opt1358823", "Cylance Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35612", "3526", "fld_7842020", "cylance_installed", "{\"opt1358823\":\"Cylance Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35613", "3526", "fld_39256", "subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35614", "3526", "fld_8888670", "office_365_installed.opt1358823", "Office 365 Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35615", "3526", "fld_8888670", "office_365_installed", "{\"opt1358823\":\"Office 365 Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35616", "3526", "fld_3664993", "office_subs", "3");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35617", "3526", "fld_6342109", "office_20161019_pro_plus_installed.opt1358823", "Office 2016/19 Pro Plus Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35618", "3526", "fld_6342109", "office_20161019_pro_plus_installed", "{\"opt1358823\":\"Office 2016\\/19 Pro Plus Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35619", "3526", "fld_4069791", "office_pro_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35620", "3526", "fld_1712261", "email_account_1c", "12356789");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35621", "3526", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35622", "3526", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35623", "3527", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35624", "3527", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35625", "3527", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35626", "3527", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35627", "3527", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35628", "3527", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35629", "3527", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35630", "3527", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35631", "3527", "fld_2572136", "description_of_work_completed", "Attempted to fix John Clark\\\'s webcam as the audio is not working.\r\nUpdated all drivers using Dell\\\'s website.\r\nI can see the Microphone array in the device manager but no sound is ever detected by it.\r\nUninstalled Microphone array and reinstalled drivers, still no success with microphone.\r\nRecommended we get a USB microphone or external webcam to resolve the issue.\r\nDiagnosed a hardware issue with the audio portion of John\\\'s built-in webcam.\r\n\r\nLaptop is still under warranty by dell. Option to send it back to dell for repairs.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35632", "3527", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35633", "3527", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35634", "3527", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35635", "3528", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35636", "3528", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35637", "3528", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35638", "3528", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35639", "3528", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35640", "3528", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35641", "3528", "fld_20888", "name_of_client", "Greg Steiner");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35642", "3528", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35643", "3528", "fld_291750", "date_completed", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35644", "3528", "fld_2572136", "description_of_work_completed", "Renewed Vipre subscription for Greg.\r\nUpdated Vipre to latest software.\r\nFixed Microsoft account verification.\r\nPerformed light cleanup.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35645", "3528", "fld_5994139", "billing_notes", "Vipre Key: 422ML-TPB63-MGTGN-5QERD-LGWCW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35646", "3528", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35647", "3528", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35648", "3528", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35649", "3528", "fld_8555975", "license___", "422ML-TPB63-MGTGN-5QERD-LGWCW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35650", "3528", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35651", "3528", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35652", "3529", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35653", "3529", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35654", "3529", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35655", "3529", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35656", "3529", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35657", "3529", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35658", "3529", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35659", "3529", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35660", "3529", "fld_2572136", "description_of_work_completed", "Changed Megan Lott\\\'s extension from 3010 to 3013.\r\nChanged extension 3010 back to a vacant extension, ready for a future user.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35661", "3529", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35662", "3529", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35663", "3529", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35664", "3530", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35665", "3530", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35666", "3530", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35667", "3530", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35668", "3530", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35669", "3530", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35670", "3530", "fld_20888", "name_of_client", "James Kucera");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35671", "3530", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35672", "3530", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35673", "3530", "fld_2572136", "description_of_work_completed", "Renewed Vipre subscription.\r\nUpdated Vipre to latest version.\r\nPerformed light cleanup of computer.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35674", "3530", "fld_5994139", "billing_notes", "Vipre Key: 422ML-TPB63-MGTGN-5QERD-LGWCW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35675", "3530", "fld_402541", "vipre_installed.opt1358823", "Vipre Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35676", "3530", "fld_402541", "vipre_installed", "{\"opt1358823\":\"Vipre Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35677", "3530", "fld_2945103", "vipre_subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35678", "3530", "fld_8555975", "license___", "422ML-TPB63-MGTGN-5QERD-LGWCW");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35679", "3530", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35680", "3530", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35681", "3531", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35682", "3531", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35683", "3531", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35684", "3531", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35685", "3531", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35686", "3531", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35687", "3531", "fld_20888", "name_of_client", "Jackson Auto");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35688", "3531", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35689", "3531", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35690", "3531", "fld_2572136", "description_of_work_completed", "Changed ext 2000 Voicemail PW 147258\r\nReprovisioned Base");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35691", "3531", "fld_5994139", "billing_notes", "Resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35692", "3531", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35693", "3531", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35694", "3532", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35695", "3532", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35696", "3532", "fld_165241", "date_of_work", "2021-04-15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35697", "3532", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35698", "3532", "fld_7309777", "minutes_spent", "1650");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35699", "3532", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35700", "3532", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35701", "3532", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35702", "3532", "fld_2572136", "description_of_work_completed", "27.5 hours - AD Domain Controller Migration / upgrade ATC  2008R2 to 2019. 4-15-2021 to 5-24-2021\r\n4-10	Reconfigure VMWare Space (recover Exchange server space and increase space on AT-DC, AT-FILE and AT-TS1\r\n4-15 - 4-19     4.75 hours 	Create new VM and Install Server 2019 in VMWare 5.x and stress test for stability (not officially supported but works and is stable)\r\n4-24		6.25 hours	delete test VM, create Prod VM install OS, update and configure new Virtual machine for production 2019 server, Join to domain, install utilities and Antivirus\r\n4-30 		3.75 Hours*** 	Verify AD backups, upgrade AD schema for ATC Forest/Enterprise/Domain and test to verify no breakage across sites(PellDC)\r\n5-3 to 5-14 	1.5 hours 	testing and monitoring stability\r\n5-15		6.25 hours*** 	Verify AD backups, Add domain controller role to new server, promote, and test replication (all tests passed)\r\n5-17 to 5-21	1.0 hours		test and monitor replication stability\r\n5-23		4.0 hours***		tranfer FSMO roles to new server and test (AT-DC and AT-PellDC now backup DCs) force replication and verify\r\n5-24 		ALL TESTS PASSED new Primary Domain Controller is ACTIVE.\r\n\r\n***Overtime/After Hours work ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35703", "3532", "fld_5994139", "billing_notes", "ATC AD Domain Controller Migration 2008R2 to 2019\r\n27.5 hours TOTAL (4-15 to 5-24)\r\nNote -  job paused 5-01 to 5-13 for Andy vacation (to prevent from having to work during vacation if job goes wrong...)\r\nAs of  5-24 Server 2019 AT-CO-DC is Primary Domain Controller\r\n\r\nNOTE 2 - Need to leave domain config alone for a few weeks at least (maybe a month). Once we are confident in new server we can move file shares to new DC and demote and decommission old one.\r\n\r\nNOTE - 14 hours of the 27.5 was OVERTIME. (Will send separate email with that and UCC/RapidPro as you asked.)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35704", "3532", "fld_7842020", "cylance_installed.opt1358823", "Cylance Installed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35705", "3532", "fld_7842020", "cylance_installed", "{\"opt1358823\":\"Cylance Installed\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35706", "3532", "fld_39256", "subs", "1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35707", "3532", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35708", "3532", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35709", "3533", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35710", "3533", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35711", "3533", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35712", "3533", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35713", "3533", "fld_7309777", "minutes_spent", "120");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35714", "3533", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35715", "3533", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35716", "3533", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35717", "3533", "fld_2572136", "description_of_work_completed", "2 hours - RapidPro DNS replication broken between RL Hudson zones and RPT\r\n(unable to replicate rlhudson.com, rlhudson.lcl) NAV broken for users\r\nAssist RL Hudson (Russell Clemens) with troubleshooting and remote access to DC/DNS\r\nOnce he resolved, force replication to DC2 by deleting old zones, rebooting and forcing sync from AD\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35718", "3533", "fld_5994139", "billing_notes", "Rsolved RLHudson DNS replication (Windows AD)\r\nassist Russell Clemens troubleshooting RLH-RPT DNS issues\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35719", "3533", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35720", "3533", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35721", "3534", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35722", "3534", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35723", "3534", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35724", "3534", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35725", "3534", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35726", "3534", "fld_8427909", "client_or_company", "Waxing the City (Lkwd) / 720-633-2446");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35727", "3534", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35728", "3534", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35729", "3534", "fld_2572136", "description_of_work_completed", "Set up phone forwrding for friday 5-21 (client request)\r\n(set up in Callcentric add on 5-21, remove on 5-24)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35730", "3534", "fld_5994139", "billing_notes", "Phone fowarding request (temporary)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35731", "3534", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35732", "3534", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35733", "3535", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35734", "3535", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35735", "3535", "fld_165241", "date_of_work", "2021-05-21");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35736", "3535", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35737", "3535", "fld_7309777", "minutes_spent", "75");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35738", "3535", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35739", "3535", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35740", "3535", "fld_2572136", "description_of_work_completed", "AT-PELLDC Drive full ( <1GB free)\r\nmanualy delete old user files and obsolete data to try to free space\r\n.(Freed 6GB) \r\nrecommend killing replication of one of the shred drives to prevent instablity in AT-PELLDC\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35741", "3535", "fld_5994139", "billing_notes", "AT-PELLDC Drive D: filling up.\r\nFreed up some space. \r\nrecommend removing replication of one or more Wellington shared drives to free up at least 15%\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35742", "3535", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35743", "3535", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35744", "3536", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35745", "3536", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35746", "3536", "fld_165241", "date_of_work", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35747", "3536", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35748", "3536", "fld_7309777", "minutes_spent", "20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35749", "3536", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35750", "3536", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35751", "3536", "fld_291750", "date_completed", "2021-05-20");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35752", "3536", "fld_2572136", "description_of_work_completed", "ATC TX Brad Dvore Laptop Outlook still broken (Bad Office patch)\r\nautomatic update for OFfice broken so he still has the broken patch\r\n(was supposed to auto-download to all Office users, but some need manual install...)\r\nmanually updated Office 2016 to latest version \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35753", "3536", "fld_5994139", "billing_notes", "Brad Devore Outlook issue (broken verision, update needed)\r\nmanually updated Office 2016 to latest\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35754", "3536", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35755", "3536", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35756", "3537", "fld_8151635", "technician.opt1536273", "Dylan Morris");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35757", "3537", "fld_8151635", "technician", "{\"opt1536273\":\"Dylan Morris\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35758", "3537", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35759", "3537", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35760", "3537", "fld_7309777", "minutes_spent", "11");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35761", "3537", "fld_8427909", "client_or_company", "EMC European Motor Cars / S Phone: (970) 484-0040");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35762", "3537", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35763", "3537", "fld_291750", "date_completed", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35764", "3537", "fld_2572136", "description_of_work_completed", "Confirmed credit card machines where switched to internet processing.\r\nDeleted Credit Card dial up number");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35765", "3537", "fld_5994139", "billing_notes", "completed");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35766", "3537", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35767", "3537", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35768", "3538", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35769", "3538", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35770", "3538", "fld_165241", "date_of_work", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35771", "3538", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35772", "3538", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35773", "3538", "fld_8427909", "client_or_company", "Lakeside Mechanical /  970-203-0503");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35774", "3538", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35775", "3538", "fld_291750", "date_completed", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35776", "3538", "fld_2572136", "description_of_work_completed", "Terry called with concerns about his email and weird rules being created. (lakesidemech@msn.com)\r\nIndications are that his email account was compromised.\r\nDeleted all rules and restored archived emails.\r\nChanged his password and setup 2FA using Microsoft Authenticator app on Terry\\\'s iPhone.\r\nCompleted basic service on Terry\\\'s desktop.\r\nLogged into Lois\\\'s desktop and changed her email account password. (lakesidegeneral@msn.com)\r\nSetup 2FA using Microsoft Authenticator app on Lois\\\'s iPhone.\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35777", "3538", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35778", "3538", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35779", "3538", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35780", "3539", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35781", "3539", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35782", "3539", "fld_165241", "date_of_work", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35783", "3539", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35784", "3539", "fld_7309777", "minutes_spent", "5");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35785", "3539", "fld_8427909", "client_or_company", "Danhydra / 720-663-0673");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35786", "3539", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35787", "3539", "fld_291750", "date_completed", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35788", "3539", "fld_2572136", "description_of_work_completed", "Completed three basic services (book rate). $185 x 3\r\nOne Data transfer (book rate) $150\r\nOne new 500GB SSD $117.95");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35789", "3539", "fld_5994139", "billing_notes", "This timetracker is just a placeholder for the creation of an invoice with three basic services and a HDD replacement.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35790", "3539", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35791", "3539", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35792", "3540", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35793", "3540", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35794", "3540", "fld_165241", "date_of_work", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35795", "3540", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35796", "3540", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35797", "3540", "fld_8427909", "client_or_company", "Henry\\\'s Pub / 970-613-1896");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35798", "3540", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35799", "3540", "fld_291750", "date_completed", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35800", "3540", "fld_2572136", "description_of_work_completed", "Website updates: Update text on homepage and reservations page");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35801", "3540", "fld_5994139", "billing_notes", "These updates are complete.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35802", "3540", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35803", "3540", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35804", "3541", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35805", "3541", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35806", "3541", "fld_165241", "date_of_work", "2021-05-24");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35807", "3541", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35808", "3541", "fld_7309777", "minutes_spent", "150");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35809", "3541", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35810", "3541", "fld_20888", "name_of_client", "Optical Gallery (Denver)");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35811", "3541", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35812", "3541", "fld_291750", "date_completed", "2021-05-25");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35813", "3541", "fld_2572136", "description_of_work_completed", "2.5 Hours Bench Work Optical Gallery Server - SSD Failure\r\nReplace 1TB SSD, recover data from failing SSD and image\r\n(Clone successful, FS dirty, chkdsk succeeded)\r\nrecovery successful, no apparent data loss");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35814", "3541", "fld_5994139", "billing_notes", "SSD replacement and Data recovery / drive imaging\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35815", "3541", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35816", "3541", "fld_2864175", "part1_description", "1TB Hynix SSD, 2.5 SATAIII");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35817", "3541", "fld_8478853", "cost_of_part_1", "$105");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35818", "3541", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35819", "3542", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35820", "3542", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35821", "3542", "fld_165241", "date_of_work", "2021-05-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35822", "3542", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35823", "3542", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35824", "3542", "fld_8427909", "client_or_company", "Drohman Steel Detailing / 303-870-9499");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35825", "3542", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35826", "3542", "fld_291750", "date_completed", "2021-05-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35827", "3542", "fld_2572136", "description_of_work_completed", "Completed light cleanup of Shad\\\'s primary computer. Removed 20GB.\r\n\r\nUnfortunately there just isn\\\'t a lot of space, only 120GB drive. Recommended we do an upgrade to a 500GB SSD.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35828", "3542", "fld_5994139", "billing_notes", "Need to provide estimate for work.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35829", "3542", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35830", "3542", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35831", "3543", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35832", "3543", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35833", "3543", "fld_165241", "date_of_work", "2021-05-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35834", "3543", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35835", "3543", "fld_7309777", "minutes_spent", "105");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35836", "3543", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35837", "3543", "fld_20888", "name_of_client", "Delta/Kem");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35838", "3543", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35839", "3543", "fld_291750", "date_completed", "2021-05-26");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35840", "3543", "fld_2572136", "description_of_work_completed", "REMOTE\r\nSpoke with Cindy over the phone as she indicated that she still did not have internet after Comcast tech replaced modem on site.\r\nAble to connect to 3CX server, verified the phones were working but still unable to connect to any computer.\r\nPictures were taken and the data side router appeared to be non-functional\r\nON-SITE\r\nWent on site and verified that data side edgemax router had died.\r\nRemoved edgemax router and installed a USG and Cloudkey device.\r\nUpdated firmware on Cloudkey and updated Unifi controller software.\r\nUpdated firmware on USG and adopted into network.\r\nSetup LAN, WAN, and removed Wifi network due to lack of access point.\r\nConfirmed that remote access was enabled, verified that internet connectivity had been restored to Cindy\\\'s desktop.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35841", "3543", "fld_5994139", "billing_notes", "Drew went along with Greg for learning experience on-site with Unifi setup.\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35842", "3543", "fld_3228639", "parts_used", "Yes");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35843", "3543", "fld_2864175", "part1_description", "Unifi USG");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35844", "3543", "fld_9190675", "part_2_description", "Unifi Cloud Key v1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35845", "3543", "fld_8478853", "cost_of_part_1", "$129.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35846", "3543", "fld_592520", "cost_of_part_2", "$149.00");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35847", "3543", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35848", "3544", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35849", "3544", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35850", "3544", "fld_165241", "date_of_work", "2021-05-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35851", "3544", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35852", "3544", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35853", "3544", "fld_8427909", "client_or_company", "Kathy Keeler / 970-622-8883");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35854", "3544", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35855", "3544", "fld_291750", "date_completed", "2021-05-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35856", "3544", "fld_2572136", "description_of_work_completed", "WordPress training with Zoom Meeting");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35857", "3544", "fld_5994139", "billing_notes", "virtual wordpress training session");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35858", "3544", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35859", "3544", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35860", "3545", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35861", "3545", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35862", "3545", "fld_165241", "date_of_work", "2021-05-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35863", "3545", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35864", "3545", "fld_7309777", "minutes_spent", "180");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35865", "3545", "fld_8427909", "client_or_company", "Asher Architecture / 970-532-9970");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35866", "3545", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35867", "3545", "fld_291750", "date_completed", "2021-05-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35868", "3545", "fld_2572136", "description_of_work_completed", "David accidentally reset the USG on site, which broke all network connectivity.\r\nReprovisioned USG to network but unable to re-enter WAN Static IP settings.\r\nAttempted to restore network from backup, same issue with WAN settings.\r\nReset Cloudkey back to factory default, manually recreated Asher Architects network.\r\nCreated LAN on 192.168.4.1/24 network, limited DHCP to 100-254.\r\nCreated Guest network on 192.168.5.1/24.\r\nCreated VPN network on 192.168.6.1/24.\r\nCreated RADIUS server for VPN and created user accounts for David, Sam, and Eric.\r\nCreated Asher Arch wifi network.\r\nCreated Asher Guest wifi network.\r\nReadopted USG and Conference Room Access Point.\r\nVerified that network connectivity was re-established both LAN and WLAN.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35869", "3545", "fld_5994139", "billing_notes", "Sam and Eric will need their VPN credentials re-entered on their laptops. David\\\'s is good to go already.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35870", "3545", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35871", "3545", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35872", "3546", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35873", "3546", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35874", "3546", "fld_165241", "date_of_work", "2021-05-27");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35875", "3546", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35876", "3546", "fld_7309777", "minutes_spent", "210");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35877", "3546", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35878", "3546", "fld_20888", "name_of_client", "The Other Road Counseling");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35879", "3546", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35880", "3546", "fld_291750", "date_completed", "2021-05-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35881", "3546", "fld_2572136", "description_of_work_completed", "Website updates, creating new featured sections on homepage, custom linked icons, redoing the footer, creating and installing new custom bio images for Sam & Corrine");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35882", "3546", "fld_5994139", "billing_notes", "The website is being reviewed for launch, expected to launch Tuesday, 6-1");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35883", "3546", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35884", "3546", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35885", "3547", "fld_8151635", "technician.opt1113988", "Anthony Deyo");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35886", "3547", "fld_8151635", "technician", "{\"opt1113988\":\"Anthony Deyo\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35887", "3547", "fld_165241", "date_of_work", "2021-05-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35888", "3547", "fld_42616", "type_of_work", "Web/Graphics Dev");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35889", "3547", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35890", "3547", "fld_8427909", "client_or_company", "Henry\\\'s Pub / 970-613-1896");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35891", "3547", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35892", "3547", "fld_291750", "date_completed", "2021-05-28");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35893", "3547", "fld_2572136", "description_of_work_completed", "Website updates for the main menu, the gluten free menu, and the home page text. ");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35894", "3547", "fld_5994139", "billing_notes", "This work is complete.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35895", "3547", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35896", "3547", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35897", "3548", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35898", "3548", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35899", "3548", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35900", "3548", "fld_42616", "type_of_work", "On Site");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35901", "3548", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35902", "3548", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35903", "3548", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35904", "3548", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35905", "3548", "fld_2572136", "description_of_work_completed", "Educated Tom on various features in Gmail. Additionally, changed some settings in Chrome per Shirley\\\'s preference, such as no auto-fill suggestions.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35906", "3548", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35907", "3548", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35908", "3548", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35909", "3549", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35910", "3549", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35911", "3549", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35912", "3549", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35913", "3549", "fld_7309777", "minutes_spent", "30");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35914", "3549", "fld_8427909", "client_or_company", "New Client");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35915", "3549", "fld_20888", "name_of_client", "Jackson\\\'s Auto / 970-663-7931");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35916", "3549", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35917", "3549", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35918", "3549", "fld_2572136", "description_of_work_completed", "Shelley reports they are unble to check Voicemails from DECT phone.\r\ninvestigation shows RFC2833 errors\r\nswich DTMF to in-band and test (works)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35919", "3549", "fld_5994139", "billing_notes", "DTMF issues (unable to enter VM PIN)\r\nswitch ext 2000 to in-band DTMF \r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35920", "3549", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35921", "3549", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35922", "3550", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35923", "3550", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35924", "3550", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35925", "3550", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35926", "3550", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35927", "3550", "fld_8427909", "client_or_company", "Tom Pitts / 970-667-8690");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35928", "3550", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35929", "3550", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35930", "3550", "fld_2572136", "description_of_work_completed", "Created new email for Tom Pitts (tompitts@waterconsult.com) - Chuck did this\r\nConfigured Tom\\\'s Outlook for his new email account, tested and confirmed that account was functional.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35931", "3550", "fld_5994139", "billing_notes", "Tom indicated that he would like to change his default address in Outlook to tompitts@waterconsult.com but that he\\\'d call us when.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35932", "3550", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35933", "3550", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35934", "3551", "fld_8151635", "technician.opt1818302", "Andy Pizer");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35935", "3551", "fld_8151635", "technician", "{\"opt1818302\":\"Andy Pizer\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35936", "3551", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35937", "3551", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35938", "3551", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35939", "3551", "fld_8427909", "client_or_company", "MAC Electric / 970-669-2464");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35940", "3551", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35941", "3551", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35942", "3551", "fld_2572136", "description_of_work_completed", "- Cleaned OS / Basic\r\n- Installed Classic Shell\r\n- Set Classic Start Menu\r\n- Corrected Word to open old Documents");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35943", "3551", "fld_5994139", "billing_notes", "DOC Issue");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35944", "3551", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35945", "3551", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35946", "3552", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35947", "3552", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35948", "3552", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35949", "3552", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35950", "3552", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35951", "3552", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35952", "3552", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35953", "3552", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35954", "3552", "fld_2572136", "description_of_work_completed", "Gina was unable to make Access work properly when sourcing external data from Sharepoint.\r\nCorrect site information was entered but site could not be reached.\r\nUpdated Office through Windows updates, then tried to update Office through itself but received an error indicating a corrupted registry for Office.\r\nUninstalled and reinstalled Office. Ensured that Access was not able to open up the advancetank.com Sharepoint site and see the various lists that Gina created.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35955", "3552", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35956", "3552", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35957", "3552", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35958", "3553", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35959", "3553", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35960", "3553", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35961", "3553", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35962", "3553", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35963", "3553", "fld_8427909", "client_or_company", "Americas Best Value Inn / 970-493-9000");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35964", "3553", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35965", "3553", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35966", "3553", "fld_2572136", "description_of_work_completed", "Verified via Unifi dashboard that access point #3 was offline. Confirmed that the ethernet cable for AP3 was plugged into port 3 on the 8 Port Unifi Switch. No lights, no activity after trying to reconnect it.\r\nRequires on-site visit.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35967", "3553", "fld_5994139", "billing_notes", "resolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35968", "3553", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35969", "3553", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35970", "3554", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35971", "3554", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35972", "3554", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35973", "3554", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35974", "3554", "fld_7309777", "minutes_spent", "105");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35975", "3554", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35976", "3554", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35977", "3554", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35978", "3554", "fld_2572136", "description_of_work_completed", "New User setup Jordan Cribari\r\nNote - ATC requested we set up Justin Cribari then corrected after setup complete\r\nhad to set up user twice\r\nSet up Office 365 / Active Directory / PC (on Brian Schippert\\\'s old PC)\r\nInstall Teams, 3CX, etc...\r\nupdate PC to latest Windows 10 service pack\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35979", "3554", "fld_5994139", "billing_notes", "new user setup\r\n+ setup and update PC\r\n(Note - client provided incorrect user name, setup had to be done twice.)\r\n\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35980", "3554", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35981", "3554", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35982", "3555", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35983", "3555", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35984", "3555", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35985", "3555", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35986", "3555", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35987", "3555", "fld_8427909", "client_or_company", "Advance Tank & Construction / 970-568-3444");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35988", "3555", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35989", "3555", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35990", "3555", "fld_2572136", "description_of_work_completed", "SPAM / PHISHING campaigns\r\nBlock one malicious campaign using Google Groups to spread SPAM\r\n+ report to google \\\'abuse\\\' contact.\r\nShut down Office 365 PHISHING campaign.\r\n(report to registrar / web hosts and services hosting malicious pages)\r\nResult - accounts suspended & PHISHING fake logon page suspended by provider\r\n resolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35991", "3555", "fld_5994139", "billing_notes", "Report 2 malicious email campaigns to ISPs and service providers via \\\'abuse\\\' links.\r\n(Shut Down)\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35992", "3555", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35993", "3555", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35994", "3556", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35995", "3556", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35996", "3556", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35997", "3556", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35998", "3556", "fld_7309777", "minutes_spent", "10");
INSERT INTO `itwp_cf_form_entry_values` VALUES("35999", "3556", "fld_8427909", "client_or_company", "Rapid Production Tooling / 970-566-4185");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36000", "3556", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36001", "3556", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36002", "3556", "fld_2572136", "description_of_work_completed", "Shut down user account Nyree Garcia \r\n(per Gregory Nelson)\r\nremove AD and Office 365 accounts\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36003", "3556", "fld_5994139", "billing_notes", "Remove Employee user accounts Nyree Garcia\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36004", "3556", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36005", "3556", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36006", "3557", "fld_8151635", "technician.opt1916280", "Chuck Werbick");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36007", "3557", "fld_8151635", "technician", "{\"opt1916280\":\"Chuck Werbick\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36008", "3557", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36009", "3557", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36010", "3557", "fld_7309777", "minutes_spent", "15");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36011", "3557", "fld_8427909", "client_or_company", "E & T Electric LLC / 970-304-9188");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36012", "3557", "fld_8420674", "job_status", "Complete");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36013", "3557", "fld_291750", "date_completed", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36014", "3557", "fld_2572136", "description_of_work_completed", "Disable Account for Tonia Rogers (per Kathy Lambros)\r\nno longer with company\r\nreset passwords and provide delegate access to Tonia Emails for Kathy\r\nresolved");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36015", "3557", "fld_5994139", "billing_notes", "Disable Tonia Rogers accounts\r\n(employee turnover)\r\nresolved\r\n");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36016", "3557", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36017", "3557", "fld_8457113", "submit", "click");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36018", "3558", "fld_8151635", "technician.opt1441245", "Greg Yukish");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36019", "3558", "fld_8151635", "technician", "{\"opt1441245\":\"Greg Yukish\"}");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36020", "3558", "fld_165241", "date_of_work", "2021-06-01");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36021", "3558", "fld_42616", "type_of_work", "Remote");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36022", "3558", "fld_7309777", "minutes_spent", "45");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36023", "3558", "fld_8427909", "client_or_company", "Green Earth Environmental / 970-587-9853");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36024", "3558", "fld_8420674", "job_status", "Open");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36025", "3558", "fld_2572136", "description_of_work_completed", "Unable to see GEE/Clearwater\\\'s Cloud key on Unifi dashboard.\r\nSpoke with Cody to get Teamviewer on the server running again.\r\nAble to ping Cloud key and access login dashboard.\r\nUnable to log into Cloud key configuration menu.\r\nCloud key appears to be active but Unifi controller is not running.\r\nUnable to ssh into Cloud key.\r\nManually restored backup of GEE/CW Unifi network locally in office but saved credentials do not work for on-site GEE/CW Cloud key.\r\nRequires on-site visit to replace currently malfunctioning Cloud key as remote capabilities have been exhausted.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36026", "3558", "fld_5994139", "billing_notes", "Requires on-site visit.");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36027", "3558", "fld_3228639", "parts_used", "No");
INSERT INTO `itwp_cf_form_entry_values` VALUES("36028", "3558", "fld_8457113", "submit", "click");
INSERT INTO `itw